<?php
/*======
*
* User Activity
*
======*/
if( !function_exists( 'eventchamp_user_activity_output' ) ) {

	function eventchamp_user_activity_output( $atts, $content = null ) {

		/*====== Atts ======*/
		$atts = shortcode_atts(
			array(
				'content-type' => '',
				'post-type' => '',
				'count' => '',
				'offset' => '',
				'order' => '',
				'order-type' => '',
				'hide-expired-events' => '',
				'pagination' => '',
				'style' => '',
				'listing-column' => '',
				'listing-column-space' => '0',
				'event-listing-style' => '',
				'event-price' => '',
				'event-status' => '',
				'event-category' => '',
				'event-location' => '',
				'event-venue' => '',
				'event-organizer' => '',
				'event-date' => '',
				'event-start-time' => '',
				'event-end-date' => '',
				'event-end-time' => '',
				'event-ticket-amount' => '',
				'event-excerpt' => '',
				'speaker-listing-style' => '',
				'speaker-profession' => 'false',
				'speaker-company' => 'false',
				'speaker-short-biography' => '',
				'speaker-social-links' => '',
				'venue-location' => '',
				'venue-category' => '',
				'venue-excerpt' => '',
			), $atts
		);

		/*====== Organizer Status ======*/
		if( $atts["event-organizer"] == "true" ) {

			$organizer_status = "true";

		} else {

			$organizer_status = "false";

		}

		/*====== End Date Status ======*/
		if( $atts["event-end-date"] == "true" ) {

			$end_date_status = "true";

		} else {

			$end_date_status = "false";

		}

		/*====== End Time Status ======*/
		if( $atts["event-end-time"] == "true" ) {

			$end_time_status = "true";

		} else {

			$end_time_status = "false";

		}

		/*====== HTML Output ======*/
		$output = '';

		if( is_user_logged_in() ) {

			$current_user = wp_get_current_user();

			$user_liked_posts = get_user_option( "_liked_posts", $current_user->ID );
			$user_favorited_posts = get_user_option( "_favorited_posts", $current_user->ID );

			if( !empty( $user_liked_posts ) ) {

				$user_likes = array_reverse( $user_liked_posts, true );

			} else {

				$user_likes = "";

			}

			if( !empty( $user_favorited_posts ) ) {

				$user_favorites = array_reverse( $user_favorited_posts, true );

			} else {

				$user_favorites = "";

			}

			if( $atts["content-type"] == "likes" and !empty( $user_likes ) or $atts["content-type"] == "favorites" and !empty( $user_favorites ) ) {

				/*====== Main Query ======*/
				$arg = array(
					'post_status' => 'publish',
				);

				/*====== Post Type ======*/
				if( $atts["post-type"] == "all" ) {

					$extra_query = array(
						'post_type' => array( 'event', 'speaker', 'venue' ),
					);
					$arg = wp_parse_args( $arg, $extra_query );

				}

				if( $atts["post-type"] == "events" ) {

					$extra_query = array(
						'post_type' => 'event',
					);
					$arg = wp_parse_args( $arg, $extra_query );

				}

				if( $atts["post-type"] == "venues" ) {

					$extra_query = array(
						'post_type' => 'venue',
					);
					$arg = wp_parse_args( $arg, $extra_query );

				}

				if( $atts["post-type"] == "speakers" ) {

					$extra_query = array(
						'post_type' => 'speaker',
					);
					$arg = wp_parse_args( $arg, $extra_query );

				}

				/*====== Pagination ======*/
				$paged = is_front_page() ? get_query_var( 'page', 1 ) : get_query_var( 'paged', 1 );

				if( empty( $paged ) ) {

					$paged = 1;

				}

				if( !empty( $paged ) ) {

					$extra_query = array(
						'paged' => $paged,
					);
					$arg = wp_parse_args( $arg, $extra_query );

				}

				/*====== Order & Order By ======*/
				if( !empty( $atts["order"] ) ) {

					if( $atts["order"] == "ASC" ) {

						$order = "ASC";

					} else {

						$order = "DESC";

					}

				}

				if( !empty( $atts["order"] ) ) {

					$extra_query = array(
						'order' => $order,
					);
					$arg = wp_parse_args( $arg, $extra_query );

				}

				if( !empty( $atts["order-type"] ) ) {

					if( $atts["order-type"] == "popular-comment" ) {

						$order_by = "comment_count";

					} elseif( $atts["order-type"] == "id" ) {

						$order_by = "ID";

					} elseif( $atts["order-type"] == "popular" ) {

						$order_by = "comment_count";

					} elseif( $atts["order-type"] == "title" ) {

						$order_by = "title";

					} elseif( $atts["order-type"] == "menu_order" ) {

						$order_by = "menu_order";

					} elseif( $atts["order-type"] == "rand" ) {

						$order_by = "rand";

					} elseif( $atts["order-type"] == "none" ) {

						$order_by = "none";

					} elseif( $atts["order-type"] == "liked-favorited-date" ) {

						$order_by = "post__in";

					} else {

						$order_by = "date";

					}

				}

				if( !empty( $order_by ) ) {

					$extra_query = array(
						'orderby' => $order_by,
					);
					$arg = wp_parse_args( $arg, $extra_query );

				}

				/*====== Count ======*/
				if( !empty( $atts["count"] ) ) {

					$extra_query = array(
						'posts_per_page' => $atts["count"],
					);
					$arg = wp_parse_args( $arg, $extra_query );

				}

				/*====== Offset ======*/
				if( !empty( $atts["offset"] ) ) {

					$extra_query = array(
						'offset' => $atts["offset"],
					);
					$arg = wp_parse_args( $arg, $extra_query );

				}

				/*====== Remove Expired Events to Likes and Favorites ======*/
				if( $atts["hide-expired-events"] == "true" ) {

					$expired_events_ids = eventchamp_expired_event_ids();

					$user_favorites = array_intersect( $user_favorites, $expired_events_ids );
					$user_likes = array_intersect( $user_likes, $expired_events_ids );

				}

				/*====== Include Contents ======*/
				if( $atts["content-type"] == "favorites" and !empty( $user_favorites ) ) {

					if( !empty( $user_favorites ) ) {

						$extra_query = array(
							'post__in' => $user_favorites,
						);
						$arg = wp_parse_args( $arg, $extra_query );

					}

				} elseif( !empty( $user_likes ) ) {

					if( !empty( $user_likes ) ) {

						$extra_query = array(
							'post__in' => $user_likes,
						);
						$arg = wp_parse_args( $arg, $extra_query );

					}

				}

				/*====== HTML Output ======*/
				$output .= '<div class="gt-user-activity">';

					$wp_query = new WP_Query( $arg );

					if( !empty( $wp_query ) ) {

						if( $wp_query->have_posts() ) {

							if( $atts["style"] == "activity-style" ) {

								$output .= '<ul>';

									while( $wp_query->have_posts() ) {

										$wp_query->the_post();

										$output .= '<li>';
											$output .= '<a href="' . get_the_permalink() . '">';

												if( get_post_type( get_the_ID() ) == "event" ) {

													$output .= '<svg version="1.1" xmlns="https://www.w3.org/2000/svg" xmlns:xlink="https://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 59 59" xml:space="preserve"> <g> <path d="M51.179,40.429l-5.596,8.04l-3.949-3.241c-0.426-0.352-1.057-0.288-1.407,0.138c-0.351,0.427-0.289,1.058,0.139,1.407 l4.786,3.929c0.18,0.148,0.404,0.228,0.634,0.228c0.045,0,0.091-0.003,0.137-0.01c0.276-0.038,0.524-0.19,0.684-0.419l6.214-8.929 c0.315-0.453,0.204-1.076-0.25-1.392C52.116,39.861,51.494,39.975,51.179,40.429z"></path> <path d="M52,34.479V15V5c0-0.553-0.448-1-1-1h-5V1c0-0.553-0.448-1-1-1h-7c-0.552,0-1,0.447-1,1v3H15V1c0-0.553-0.448-1-1-1H7 C6.448,0,6,0.447,6,1v3H1C0.448,4,0,4.447,0,5v10v41c0,0.553,0.448,1,1,1h38.104c2.002,1.26,4.362,2,6.896,2 c7.168,0,13-5.832,13-13C59,40.997,56.154,36.651,52,34.479z M39,2h5v3v3h-5V5V2z M8,2h5v3v3H8V5V2z M2,6h4v3c0,0.553,0.448,1,1,1 h7c0.552,0,1-0.447,1-1V6h22v3c0,0.553,0.448,1,1,1h7c0.552,0,1-0.447,1-1V6h4v8H2V6z M2,55V16h48v17.636 c-0.196-0.063-0.396-0.114-0.596-0.169c-0.185-0.051-0.37-0.101-0.557-0.144c-0.169-0.038-0.34-0.071-0.511-0.102 c-0.244-0.045-0.489-0.082-0.735-0.113c-0.137-0.017-0.273-0.036-0.411-0.049C46.796,33.024,46.399,33,46,33 c-0.338,0-0.669,0.025-1,0.051V32v-2v-9h-9h-2h-7h-2h-7h-2H7v9v2v7v2v9h9h2h7h2h6.636c0.029,0.088,0.065,0.173,0.095,0.26 c0.084,0.243,0.167,0.487,0.266,0.724c0.055,0.133,0.12,0.26,0.18,0.39c0.115,0.254,0.232,0.507,0.363,0.753 c0.058,0.107,0.123,0.21,0.184,0.316c0.148,0.259,0.298,0.515,0.464,0.763c0.061,0.091,0.128,0.177,0.191,0.267 c0.176,0.25,0.356,0.498,0.551,0.736c0.072,0.088,0.15,0.17,0.224,0.256c0.155,0.18,0.303,0.364,0.468,0.536H2z M40.313,34.328 c-0.108,0.052-0.218,0.101-0.324,0.156c-0.188,0.098-0.37,0.206-0.552,0.313c-0.159,0.093-0.318,0.188-0.473,0.287 c-0.157,0.102-0.31,0.206-0.462,0.314c-0.173,0.122-0.341,0.25-0.508,0.38c-0.134,0.105-0.268,0.209-0.397,0.32 c-0.175,0.148-0.342,0.305-0.509,0.462c-0.115,0.109-0.234,0.214-0.345,0.326c-0.181,0.184-0.352,0.379-0.522,0.574 c-0.072,0.083-0.151,0.159-0.222,0.244V32h7v1.362c-0.017,0.004-0.033,0.01-0.049,0.014C42.029,33.599,41.147,33.92,40.313,34.328z M33.57,42.199c-0.035,0.115-0.058,0.233-0.09,0.349c-0.08,0.29-0.162,0.58-0.222,0.879c-0.047,0.231-0.073,0.467-0.107,0.701 c-0.027,0.189-0.065,0.375-0.085,0.567C33.023,45.126,33,45.562,33,46c0,0.361,0.02,0.726,0.053,1.092 c0.006,0.067,0.006,0.135,0.013,0.202c0.016,0.162,0.048,0.319,0.07,0.479c0,0,0,0.001,0,0.001 c0.011,0.076,0.015,0.151,0.027,0.226H27v-7h7v0.007c-0.01,0.024-0.016,0.049-0.026,0.073 C33.824,41.445,33.687,41.818,33.57,42.199z M9,41h7v7H9V41z M9,32h7v7H9V32z M43,30h-7v-7h7V30z M34,30h-7v-7h7V30z M34,39h-7v-7 h7V39z M18,32h7v7h-7V32z M25,30h-7v-7h7V30z M16,30H9v-7h7V30z M18,41h7v7h-7V41z M46,57c-2.258,0-4.359-0.686-6.107-1.858 c-0.341-0.228-0.663-0.476-0.972-0.736c-0.108-0.092-0.21-0.19-0.314-0.286c-0.197-0.179-0.388-0.363-0.57-0.554 c-0.117-0.123-0.23-0.248-0.341-0.375c-0.164-0.189-0.318-0.384-0.468-0.583c-0.096-0.127-0.195-0.25-0.286-0.381 c-0.221-0.321-0.429-0.651-0.615-0.993c-0.043-0.08-0.077-0.164-0.118-0.245c-0.146-0.286-0.282-0.576-0.403-0.874 c-0.052-0.13-0.097-0.263-0.145-0.395c-0.094-0.262-0.18-0.528-0.255-0.797c-0.017-0.062-0.032-0.124-0.048-0.186 c-0.113-0.44-0.196-0.877-0.255-1.312c-0.004-0.031-0.01-0.062-0.014-0.094C35.031,46.882,35,46.437,35,46 c0-0.379,0.019-0.755,0.058-1.128c0.003-0.031,0.011-0.061,0.014-0.092c0.038-0.341,0.088-0.681,0.158-1.016 c0.007-0.032,0.018-0.063,0.025-0.095c0.072-0.332,0.157-0.662,0.26-0.988c0.012-0.038,0.029-0.075,0.041-0.113 c0.103-0.312,0.217-0.622,0.349-0.926c0.124-0.286,0.258-0.567,0.405-0.84l0.099-0.171c0.04-0.072,0.087-0.14,0.129-0.211 c0.174-0.293,0.36-0.577,0.557-0.851c0.049-0.068,0.1-0.135,0.151-0.202c0.18-0.238,0.37-0.467,0.568-0.688 c0.069-0.077,0.138-0.155,0.209-0.23c0.196-0.208,0.402-0.405,0.613-0.596c0.075-0.068,0.148-0.138,0.225-0.204 c0.248-0.212,0.505-0.411,0.77-0.6c0.042-0.03,0.082-0.063,0.124-0.093c1.305-0.902,2.804-1.52,4.412-1.79l0.021-0.003 C44.778,35.064,45.381,35,46,35c0.389,0,0.776,0.021,1.16,0.063c0.06,0.006,0.118,0.02,0.178,0.027 c0.328,0.041,0.655,0.09,0.978,0.16c0.04,0.009,0.078,0.021,0.117,0.03c0.344,0.079,0.685,0.171,1.022,0.284 c0.023,0.008,0.045,0.017,0.068,0.025c0.345,0.118,0.685,0.253,1.022,0.406C54.347,37.729,57,41.557,57,46 C57,52.065,52.065,57,46,57z"></path> </g> <g> </g> <g> </g> <g> </g> <g> </g> <g> </g> <g> </g> <g> </g> <g> </g> <g> </g> <g> </g> <g> </g> <g> </g> <g> </g> <g> </g> <g> </g> </svg>';

													$output .= sprintf( esc_html__( '%1$s has liked %2$s event.', 'eventchamp-core' ), $current_user->display_name, get_the_title() );

												} elseif( get_post_type( get_the_ID() ) == "speaker" ) {

													$output .= '<svg viewBox="0 0 497 497.048" xmlns="http://www.w3.org/2000/svg"><path d="m359.015625 375.574219-102.992187-28.605469v-24.769531l21.703124 6.511719 11.464844.335937c25.824219 0 46.832032-21.007813 46.832032-46.832031 0-4.765625 1.128906-9.527344 3.257812-13.789063l9.695312-19.402343c10.589844-.496094 19.046876-9.269532 19.046876-19.976563 0-4.292969-1.414063-8.550781-4-12l-2.984376-3.976563c-10.976562-14.628906-17.015624-32.757812-17.015624-51.054687 0-8.390625-2.121094-16.449219-6.0625-23.589844l2.648437-2.648437c17.679687-17.679688 27.414063-41.183594 27.414063-66.191406 0-20.121094-6.648438-40.074219-18.71875-56.171876l-10.089844-13.414062-5.152344 1.289062c-41.816406 10.453126-85.191406 15.757813-128.925781 15.757813h-4.394531c-70.972657 0-128.71875 57.746094-128.71875 128.722656 0 21.824219 5.601562 43.4375 16.550781 63.085938l27.929687 41.511719c8.144532 12.089843 14.609375 25.25 19.222656 39.097656 5.503907 16.511718 8.296876 33.703125 8.296876 51.101562v6.402344l-102.992188 28.605469c-24.144531 6.714843-41.0078125 28.898437-41.0078125 53.960937v67.511719h400.0000005v-67.511719c0-25.0625-16.863282-47.246094-41.007813-53.960937zm-109.609375-13.839844 5.792969 1.609375-11.847657 47.398438-29.984374-24.980469zm98.832031-139.0625 2.976563 3.96875c.527344.703125.808594 1.535156.808594 2.40625 0 2.210937-1.792969 4-4 4h-8.945313l-14.101563 28.21875c-3.242187 6.460937-4.953124 13.710937-4.953124 20.949219 0 17-13.832032 30.832031-30.832032 30.832031h-7.992187l-78.878907-23.664063-4.59375 15.328126 42.296876 12.6875v31.371093l-40 26.664063-40-26.664063v-8.203125c0-7.589844-.625-15.132812-1.582032-22.621094l2.949219-2.953124c19.753906-19.753907 30.632813-46.015626 30.632813-73.945313v-8h-16c-8.824219 0-16-7.175781-16-16s7.175781-16 16-16h16v-18.382813c0-12.128906 4.167968-24.023437 11.746093-33.496093 10.238281-12.785157 25.496094-20.121094 41.871094-20.121094h49.414063c8.808593 0 17.089843 3.433594 23.3125 9.65625 6.226562 6.226563 9.65625 14.511719 9.65625 23.3125 0 21.738281 7.175781 43.273437 20.214843 60.65625zm-197.597656 139.0625 36.039063 24.027344-29.984376 24.980469-11.847656-47.398438zm-20.863281-120.292969-27.570313-40.9375c-9.277343-16.695312-14.183593-35.625-14.183593-54.734375 0-62.152343 50.570312-112.722656 112.71875-112.722656h4.394531c43.359375 0 86.382812-5.0625 127.664062-14.976563l3.703125 4.945313c10.007813 13.351563 15.519532 29.886719 15.519532 46.570313 0 20.726562-8.070313 40.214843-22.726563 54.878906l-1.351563 1.351562c-9.035156-8.222656-20.601562-12.769531-32.890624-12.769531h-49.414063c-21.265625 0-41.074219 9.519531-54.359375 26.128906-9.839844 12.296875-15.257812 27.734375-15.257812 43.488281v2.382813c-17.648438 0-32 14.351563-32 32 0 17.527344 14.167968 31.808594 31.648437 32-1.625 18.265625-8.824219 35.359375-20.734375 49.335937-1.152344-4.703124-2.488281-9.367187-4.027344-13.976562-5.070312-15.222656-12.191406-29.679688-21.132812-42.964844zm254.246094 239.605469h-368v-51.511719c0-17.894531 12.046874-33.75 29.296874-38.542968l84.105469-23.359376 17.933594 71.71875 52.664063-43.886718 52.664062 43.894531 17.9375-71.71875 84.101562 23.359375c17.25 4.785156 29.296876 20.632812 29.296876 38.535156zm0 0"/><path d="m463.214844 169.855469-11.3125 11.3125c18.136718 18.128906 28.121094 42.238281 28.121094 67.878906s-9.984376 49.753906-28.121094 67.882813l11.3125 11.308593c21.160156-21.148437 32.808594-49.269531 32.808594-79.191406 0-29.917969-11.648438-58.039063-32.808594-79.191406zm0 0"/><path d="m440.59375 192.480469-11.3125 11.3125c12.085938 12.085937 18.742188 28.160156 18.742188 45.253906 0 17.097656-6.65625 33.167969-18.742188 45.257813l11.3125 11.3125c15.101562-15.105469 23.429688-35.203126 23.429688-56.570313s-8.328126-41.460937-23.429688-56.566406zm0 0"/><path d="m417.96875 215.105469-11.3125 11.308593c6.039062 6.050782 9.367188 14.089844 9.367188 22.632813 0 8.546875-3.328126 16.585937-9.367188 22.632813l11.3125 11.3125c9.0625-9.070313 14.054688-21.121094 14.054688-33.945313s-4.992188-24.871094-14.054688-33.941406zm0 0"/></svg>';

													$output .= sprintf( esc_html__( '%1$s has liked %2$s speaker.', 'eventchamp-core' ), $current_user->display_name, get_the_title() );

												} elseif( get_post_type( get_the_ID() ) == "venue" ) {

													$output .= '<svg version="1.1" xmlns="https://www.w3.org/2000/svg" xmlns:xlink="https://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 55.017 55.017" xml:space="preserve"> <g> <path d="M51.688,23.013H40.789c-0.553,0-1,0.447-1,1s0.447,1,1,1h9.102l2.899,27H2.268l3.403-27h9.118c0.553,0,1-0.447,1-1 s-0.447-1-1-1H3.907L0,54.013h55.017L51.688,23.013z"></path> <path d="M26.654,38.968c-0.147,0.087-0.304,0.164-0.445,0.255c-0.22,0.142-0.435,0.291-0.646,0.445 c-0.445,0.327-0.541,0.953-0.215,1.398c0.196,0.267,0.5,0.408,0.808,0.408c0.205,0,0.412-0.063,0.591-0.193 c0.178-0.131,0.359-0.257,0.548-0.379c0.321-0.208,0.662-0.403,1.014-0.581c0.468-0.237,0.658-0.791,0.462-1.269 c0.008-0.008,0.018-0.014,0.025-0.022c1.809-1.916,7.905-9.096,10.429-21.058c0.512-2.426,0.627-4.754,0.342-6.919 c-0.86-6.575-4.945-10.051-11.813-10.051c-6.866,0-10.951,3.476-11.813,10.051c-0.284,2.166-0.169,4.494,0.343,6.919 C18.783,29.818,24.783,36.97,26.654,38.968z M17.924,11.314c0.733-5.592,3.949-8.311,9.831-8.311c5.883,0,9.098,2.719,9.83,8.311 c0.255,1.94,0.148,4.043-0.316,6.247C35,28.314,29.59,35.137,27.755,37.207c-1.837-2.072-7.246-8.898-9.514-19.646 C17.776,15.357,17.67,13.255,17.924,11.314z"></path> <path d="M27.755,19.925c4.051,0,7.346-3.295,7.346-7.346s-3.295-7.346-7.346-7.346s-7.346,3.295-7.346,7.346 S23.704,19.925,27.755,19.925z M27.755,7.234c2.947,0,5.346,2.398,5.346,5.346s-2.398,5.346-5.346,5.346s-5.346-2.398-5.346-5.346 S24.808,7.234,27.755,7.234z"></path> <path d="M31.428,37.17c-0.54,0.114-0.884,0.646-0.769,1.187c0.1,0.47,0.515,0.791,0.977,0.791c0.069,0,0.14-0.007,0.21-0.022 c0.586-0.124,1.221-0.229,1.886-0.313c0.548-0.067,0.938-0.567,0.869-1.115c-0.068-0.549-0.563-0.945-1.115-0.869 C32.763,36.918,32.07,37.033,31.428,37.17z"></path> <path d="M36.599,37.576c0.022,0.537,0.466,0.957,0.998,0.957c0.015,0,0.029,0,0.044-0.001l2.001-0.083 c0.551-0.025,0.979-0.493,0.953-1.044c-0.025-0.553-0.539-0.984-1.044-0.954l-1.996,0.083 C37.003,36.557,36.575,37.023,36.599,37.576z"></path> <path d="M22.433,42.177c-0.514,0.388-1.045,0.761-1.58,1.107c-0.463,0.301-0.595,0.92-0.294,1.384 c0.191,0.295,0.513,0.455,0.84,0.455c0.187,0,0.375-0.052,0.544-0.161c0.573-0.372,1.144-0.772,1.695-1.188 c0.44-0.333,0.528-0.96,0.196-1.401C23.501,41.936,22.876,41.844,22.433,42.177z"></path> <path d="M44.72,35.583c-0.338,0.237-0.777,0.409-1.346,0.526c-0.541,0.111-0.889,0.641-0.777,1.182 c0.098,0.473,0.514,0.798,0.979,0.798c0.067,0,0.135-0.007,0.203-0.021c0.842-0.174,1.526-0.452,2.096-0.853l0.134-0.098 c0.44-0.334,0.527-0.961,0.194-1.401c-0.334-0.44-0.96-0.526-1.401-0.194L44.72,35.583z"></path> <path d="M8.86,43.402c0.145-0.533-0.171-1.082-0.704-1.226c-0.529-0.149-1.082,0.169-1.226,0.704 c-0.126,0.464-0.201,0.938-0.225,1.405C6.7,44.4,6.697,44.516,6.697,44.638c0.001,0.196,0.01,0.392,0.029,0.587 c0.053,0.515,0.487,0.898,0.994,0.898c0.033,0,0.067-0.002,0.103-0.005c0.549-0.057,0.949-0.547,0.894-1.097 c-0.014-0.131-0.019-0.264-0.02-0.39c0-0.083,0.003-0.166,0.007-0.248C8.72,44.059,8.772,43.728,8.86,43.402z"></path> <path d="M44.698,27.81c-0.794-0.106-1.604-0.041-2.386,0.181c-0.532,0.149-0.841,0.702-0.69,1.233 c0.124,0.441,0.525,0.729,0.961,0.729c0.091,0,0.182-0.012,0.272-0.038c0.52-0.146,1.055-0.192,1.575-0.122 c0.562,0.07,1.052-0.311,1.125-0.857C45.629,28.387,45.245,27.884,44.698,27.81z"></path> <path d="M46.688,32.764c-0.163,0.527,0.133,1.088,0.66,1.25c0.099,0.031,0.197,0.045,0.295,0.045c0.428,0,0.823-0.275,0.955-0.705 c0.099-0.318,0.16-0.641,0.183-0.963c0.005-0.083,0.008-0.167,0.008-0.25c0-0.468-0.086-0.937-0.255-1.392 c-0.192-0.519-0.771-0.781-1.285-0.59c-0.519,0.192-0.782,0.768-0.59,1.285c0.086,0.232,0.13,0.467,0.13,0.696l-0.003,0.117 C46.774,32.423,46.742,32.589,46.688,32.764z"></path> <path d="M17.481,45.164c-0.586,0.275-1.183,0.53-1.774,0.759c-0.515,0.198-0.771,0.777-0.572,1.293 c0.153,0.396,0.531,0.64,0.933,0.64c0.12,0,0.242-0.021,0.36-0.067c0.635-0.245,1.275-0.519,1.903-0.813 c0.5-0.234,0.715-0.83,0.48-1.33C18.578,45.145,17.984,44.928,17.481,45.164z"></path> <path d="M10.201,41.001c0.161,0,0.325-0.039,0.478-0.122c0.288-0.157,0.595-0.255,0.911-0.289c0.135-0.016,0.273-0.016,0.406,0.002 c0.563,0.073,1.05-0.313,1.122-0.86c0.072-0.548-0.313-1.05-0.86-1.122c-0.298-0.039-0.601-0.041-0.891-0.008 c-0.574,0.063-1.128,0.239-1.646,0.521c-0.485,0.265-0.664,0.871-0.399,1.356C9.504,40.813,9.847,41.001,10.201,41.001z"></path> <path d="M9.993,48.842c0.216,0.056,0.436,0.098,0.654,0.124c0.256,0.031,0.512,0.047,0.769,0.047c0.313,0,0.627-0.022,0.94-0.062 c0.548-0.069,0.937-0.569,0.867-1.117s-0.567-0.934-1.117-0.867c-0.404,0.052-0.812,0.064-1.216,0.015 c-0.132-0.017-0.264-0.042-0.394-0.075c-0.535-0.143-1.08,0.181-1.22,0.716C9.139,48.158,9.459,48.704,9.993,48.842z"></path> </g> <g> </g> <g> </g> <g> </g> <g> </g> <g> </g> <g> </g> <g> </g> <g> </g> <g> </g> <g> </g> <g> </g> <g> </g> <g> </g> <g> </g> <g> </g> </svg>';

													$output .= sprintf( esc_html__( '%1$s has liked %2$s venue.', 'eventchamp-core' ), $current_user->display_name, get_the_title() );

												}

											$output .= '</a>';
										$output .= '</li>';

									}

								$output .= '</ul>';

							} else {

								$output .= '<div class="gt-columns gt-' . esc_attr( $atts["listing-column"] ) . ' gt-column-space' . esc_attr( $atts["listing-column-space"] ) . '">';

									while( $wp_query->have_posts() ) {

										$wp_query->the_post();

										$output .= '<div class="gt-col">';
											$output .= '<div class="gt-inner">';

												if( get_post_type( get_the_ID() ) == "event" ) {

													if( $atts["event-listing-style"] == "style-1" ) {

														$output .= eventchamp_event_list_style_1( $post_id = get_the_ID(), $image = "true", $category = esc_attr( $atts["event-category"] ), $start_date = esc_attr( $atts["event-date"] ), $end_date = esc_attr( $atts["event-end-date"] ), $location = esc_attr( $atts["event-location"] ), $excerpt = esc_attr( $atts["event-excerpt"] ), $status = esc_attr( $atts["event-status"] ), $price = esc_attr( $atts["event-price"] ), $venue = esc_attr( $atts["event-venue"] ), $ticket_amount = esc_attr( $atts["event-ticket-amount"] ), $start_time = esc_attr( $atts["event-start-time"] ), $end_time = esc_attr( $atts["event-end-time"] ), $organizer = esc_attr( $atts["event-organizer"] ) );

													} elseif( $atts["event-listing-style"] == "style-2" ) {

														$output .= eventchamp_event_list_style_3( $post_id = get_the_ID(), $image = "true", $category = esc_attr( $atts["event-category"] ), $start_date = esc_attr( $atts["event-date"] ), $end_date = esc_attr( $atts["event-end-date"] ), $location = esc_attr( $atts["event-location"] ), $excerpt = esc_attr( $atts["event-excerpt"] ), $status = esc_attr( $atts["event-status"] ), $price = esc_attr( $atts["event-price"] ), $venue = esc_attr( $atts["event-venue"] ), $ticket_amount = esc_attr( $atts["event-ticket-amount"] ), $start_time = esc_attr( $atts["event-start-time"] ), $end_time = esc_attr( $atts["event-end-time"] ), $organizer = esc_attr( $atts["event-organizer"] ) );


													} elseif( $atts["event-listing-style"] == "style-3" ) {

														$output .= eventchamp_event_list_style_4( $post_id = get_the_ID(), $image = "true", $category = esc_attr( $atts["event-category"] ), $start_date = esc_attr( $atts["event-date"] ), $end_date = esc_attr( $atts["event-end-date"] ), $location = esc_attr( $atts["event-location"] ), $excerpt = esc_attr( $atts["event-excerpt"] ), $status = esc_attr( $atts["event-status"] ), $price = esc_attr( $atts["event-price"] ), $venue = esc_attr( $atts["event-venue"] ), $ticket_amount = esc_attr( $atts["event-ticket-amount"] ), $start_time = esc_attr( $atts["event-start-time"] ), $end_time = esc_attr( $atts["event-end-time"] ), $organizer = esc_attr( $atts["event-organizer"] ) );

													}

												} elseif( get_post_type( get_the_ID() ) == "speaker" ) {

													if( $atts["speaker-listing-style"] == "style-1" ) {

														$output .= eventchamp_speaker_style_1( $post_id = get_the_ID(), $image = "true", $profession = esc_attr( $atts["speaker-profession"] ), $company = esc_attr( $atts["speaker-company"] ), $summary = esc_attr( $atts["speaker-short-biography"] ), $social = esc_attr( $atts["speaker-social-links"] ) );

													} elseif( $atts["speaker-listing-style"] == "style-2" ) {

														$output .= eventchamp_speaker_style_2( $post_id = get_the_ID(), $image = "true", $profession = esc_attr( $atts["speaker-profession"] ), $company = esc_attr( $atts["speaker-company"] ), $summary = esc_attr( $atts["speaker-short-biography"] ), $social = esc_attr( $atts["speaker-social-links"] ) );

													} elseif( $atts["speaker-listing-style"] == "style-3" ) {

														$output .= eventchamp_speaker_style_3( $post_id = get_the_ID(), $image = "true", $profession = esc_attr( $atts["speaker-profession"] ), $company = esc_attr( $atts["speaker-company"] ), $summary = esc_attr( $atts["speaker-short-biography"] ), $social = esc_attr( $atts["speaker-social-links"] ) );

													} elseif( $atts["speaker-listing-style"] == "style-4" ) {

														$output .= eventchamp_speaker_style_4( $post_id = get_the_ID(), $image = "true", $profession = esc_attr( $atts["speaker-profession"] ), $company = esc_attr( $atts["speaker-company"] ), $summary = esc_attr( $atts["speaker-short-biography"] ), $social = esc_attr( $atts["speaker-social-links"] ) );

													} elseif( $atts["speaker-listing-style"] == "style-5" ) {

														$output .= eventchamp_speaker_style_5( $post_id = get_the_ID(), $image = "true", $profession = esc_attr( $atts["speaker-profession"] ), $company = esc_attr( $atts["speaker-company"] ), $summary = esc_attr( $atts["speaker-short-biography"] ), $social = esc_attr( $atts["speaker-social-links"] ) );

													} elseif( $atts["speaker-listing-style"] == "style-6" ) {

														$output .= eventchamp_speaker_style_6( $post_id = get_the_ID(), $image = "true", $profession = esc_attr( $atts["speaker-profession"] ), $company = esc_attr( $atts["speaker-company"] ), $summary = esc_attr( $atts["speaker-short-biography"] ), $social = esc_attr( $atts["speaker-social-links"] ) );

													} elseif( $atts["speaker-listing-style"] == "style-7" ) {

														$output .= eventchamp_speaker_style_7( $post_id = get_the_ID(), $image = "true", $profession = esc_attr( $atts["speaker-profession"] ), $company = esc_attr( $atts["speaker-company"] ), $summary = esc_attr( $atts["speaker-short-biography"] ), $social = esc_attr( $atts["speaker-social-links"] ) );

													} elseif( $atts["speaker-listing-style"] == "style-8" ) {

														$output .= eventchamp_speaker_style_8( $post_id = get_the_ID(), $image = "true", $profession = esc_attr( $atts["speaker-profession"] ), $company = esc_attr( $atts["speaker-company"] ), $summary = esc_attr( $atts["speaker-short-biography"] ), $social = esc_attr( $atts["speaker-social-links"] ) );

													}

												} elseif( get_post_type( get_the_ID() ) == "venue" ) {

													$output .= eventchamp_venue_list_style_1( $post_id = get_the_ID(), $image = "true", $location = esc_attr( $atts["venue-location"] ), $category = esc_attr( $atts["venue-category"] ), $excerpt = esc_attr( $atts["venue-excerpt"] ) );

												}

											$output .= '</div>';
										$output .= '</div>';

									}

								$output .= '</div>';

							}

						}

					}
					wp_reset_postdata();

					if( $atts['pagination'] == 'true' ) {

						$output .= eventchamp_element_pagination( $paged = $paged, $query = $wp_query );

					}
				$output .= '</div>';

			} else {

				$output .= wpautop( esc_html__( 'Your list of activities seems empty.', 'eventchamp-core' ) );

			}

		}

		return $output;

	}
	add_shortcode( "eventchamp_user_activity", "eventchamp_user_activity_output" );

	if( function_exists( 'vc_map' ) ) {

		vc_map(
			array(
				"name" => esc_html__( 'User Activity', 'eventchamp-core' ),
				"base" => "eventchamp_user_activity",
				"category" => esc_html__( 'Eventchamp Theme', 'eventchamp-core' ),
				"icon" => get_template_directory_uri() . '/include/assets/img/icons/user-activity.jpg',
				"description" => esc_html__( 'List user activities', 'eventchamp-core' ),
				"params" => array(
					array(
						"type" => "dropdown",
						"param_name" => "content-type",
						"heading" => esc_html__( 'Content Type', 'eventchamp-core' ),
						"group" => esc_html__( 'General', 'eventchamp-core' ),
						'admin_label' => true,
						"save_always" => true,
						"value" => array(
							esc_html__( 'Likes', 'eventchamp-core' ) => 'likes',
							esc_html__( 'Favorites', 'eventchamp-core' ) => 'favorites',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "post-type",
						"heading" => esc_html__( 'Post Type', 'eventchamp-core' ),
						"group" => esc_html__( 'General', 'eventchamp-core' ),
						'admin_label' => true,
						"save_always" => true,
						"value" => array(
							esc_html__( 'All', 'eventchamp-core' ) => 'all',
							esc_html__( 'Events', 'eventchamp-core' ) => 'events',
							esc_html__( 'Venues', 'eventchamp-core' ) => 'venues',
							esc_html__( 'Speakers', 'eventchamp-core' ) => 'speakers',
						),
					),
					array(
						"type" => "textfield",
						"param_name" => "count",
						"heading" => esc_html__( 'Count', 'eventchamp-core' ),
						"description" => esc_html__( 'If you want to list all content, enter -1.', 'eventchamp-core' ),
						"group" => esc_html__( 'General', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "offset",
						"heading" => esc_html__( 'Offset', 'eventchamp-core' ),
						"group" => esc_html__( 'General', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "dropdown",
						"param_name" => "order",
						"heading" => esc_html__( 'Order', 'eventchamp-core' ),
						"group" => esc_html__( 'General', 'eventchamp-core' ),
						"save_always" => true,
						"value" => array(
							esc_html__( 'ASC', 'eventchamp-core' ) => 'ASC',
							esc_html__( 'DESC', 'eventchamp-core' ) => 'DESC',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "order-type",
						"heading" => esc_html__( 'Order Type', 'eventchamp-core' ),
						"group" => esc_html__( 'General', 'eventchamp-core' ),
						"save_always" => true,
						"value" => array(
							esc_html__( 'Liked and Favorited Date', 'eventchamp-core' ) => 'liked-favorited-date',
							esc_html__( 'Added Date', 'eventchamp-core' ) => 'added-date',
							esc_html__( 'Popular by Comment', 'eventchamp-core' ) => 'popular-comment',
							esc_html__( 'ID', 'eventchamp-core' ) => 'id',
							esc_html__( 'Title', 'eventchamp-core' ) => 'title',
							esc_html__( 'Menu Order', 'eventchamp-core' ) => 'menu_order',
							esc_html__( 'Random', 'eventchamp-core' ) => 'rand',
							esc_html__( 'None', 'eventchamp-core' ) => 'none',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "hide-expired-events",
						"heading" => esc_html__( 'Hide Expired Events', 'eventchamp-core' ),
						"group" => esc_html__( 'General', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "pagination",
						"heading" => esc_html__( 'Pagination', 'eventchamp-core' ),
						"group" => esc_html__( 'General', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "style",
						"heading" => esc_html__( 'Style', 'eventchamp-core' ),
						"description" => esc_html__( 'If you choose the custom style, you can use the event, venue and speaker design settings.', 'eventchamp-core' ),
						"group" => esc_html__( 'Design', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'Activity Style', 'eventchamp-core' ) => 'activity-style',
							esc_html__( 'Custom Style', 'eventchamp-core' ) => 'custom-style',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "listing-column",
						"heading" => esc_html__( 'Column', 'eventchamp-core' ),
						"group" => esc_html__( 'Design', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( '1 Column', 'eventchamp-core' ) => 'column-1',
							esc_html__( '2 Column', 'eventchamp-core' ) => 'column-2',
							esc_html__( '3 Column', 'eventchamp-core' ) => 'column-3',
							esc_html__( '4 Column', 'eventchamp-core' ) => 'column-4',
							esc_html__( '5 Column', 'eventchamp-core' ) => 'column-5',
							esc_html__( '6 Column', 'eventchamp-core' ) => 'column-6',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "listing-column-space",
						"heading" => esc_html__( 'Column Space', 'eventchamp-core' ),
						"group" => esc_html__( 'Design', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( '0', 'eventchamp-core' ) => '0',
							esc_html__( '5', 'eventchamp-core' ) => '5',
							esc_html__( '10', 'eventchamp-core' ) => '10',
							esc_html__( '15', 'eventchamp-core' ) => '15',
							esc_html__( '20', 'eventchamp-core' ) => '20',
							esc_html__( '25', 'eventchamp-core' ) => '25',
							esc_html__( '30', 'eventchamp-core' ) => '30',
							esc_html__( '35', 'eventchamp-core' ) => '35',
							esc_html__( '40', 'eventchamp-core' ) => '40',
							esc_html__( '45', 'eventchamp-core' ) => '45',
							esc_html__( '50', 'eventchamp-core' ) => '50',
							esc_html__( '55', 'eventchamp-core' ) => '55',
							esc_html__( '60', 'eventchamp-core' ) => '60',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "event-listing-style",
						"heading" => esc_html__( 'Listing Style', 'eventchamp-core' ),
						"group" => esc_html__( 'Event', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'Style 1', 'eventchamp-core' ) => 'style-1',
							esc_html__( 'Style 2', 'eventchamp-core' ) => 'style-2',
							esc_html__( 'Style 3', 'eventchamp-core' ) => 'style-3',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "event-price",
						"heading" => esc_html__( 'Price', 'eventchamp-core' ),
						"group" => esc_html__( 'Event', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "event-status",
						"heading" => esc_html__( 'Status', 'eventchamp-core' ),
						"group" => esc_html__( 'Event', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "event-category",
						"heading" => esc_html__( 'Category', 'eventchamp-core' ),
						"group" => esc_html__( 'Event', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "event-location",
						"heading" => esc_html__( 'Location', 'eventchamp-core' ),
						"group" => esc_html__( 'Event', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "event-venue",
						"heading" => esc_html__( 'Venue', 'eventchamp-core' ),
						"group" => esc_html__( 'Event', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "event-organizer",
						"heading" => esc_html__( 'Organizer', 'eventchamp-core' ),
						"group" => esc_html__( 'Event', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "event-date",
						"heading" => esc_html__( 'Start Date', 'eventchamp-core' ),
						"group" => esc_html__( 'Event', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "event-start-time",
						"heading" => esc_html__( 'Start Time', 'eventchamp-core' ),
						"group" => esc_html__( 'Event', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "event-end-date",
						"heading" => esc_html__( 'End Date', 'eventchamp-core' ),
						"group" => esc_html__( 'Event', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "event-end-time",
						"heading" => esc_html__( 'End Time', 'eventchamp-core' ),
						"group" => esc_html__( 'Event', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "event-ticket-amount",
						"heading" => esc_html__( 'Ticket Amount', 'eventchamp-core' ),
						"group" => esc_html__( 'Event', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "event-excerpt",
						"heading" => esc_html__( 'Excerpt', 'eventchamp-core' ),
						"group" => esc_html__( 'Event', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "speaker-listing-style",
						"heading" => esc_html__( 'Listing Style', 'eventchamp-core' ),
						"group" => esc_html__( 'Speaker', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'Style 1', 'eventchamp-core' ) => 'style-1',
							esc_html__( 'Style 2', 'eventchamp-core' ) => 'style-2',
							esc_html__( 'Style 3', 'eventchamp-core' ) => 'style-3',
							esc_html__( 'Style 4', 'eventchamp-core' ) => 'style-4',
							esc_html__( 'Style 5', 'eventchamp-core' ) => 'style-5',
							esc_html__( 'Style 6', 'eventchamp-core' ) => 'style-6',
							esc_html__( 'Style 7', 'eventchamp-core' ) => 'style-7',
							esc_html__( 'Style 8', 'eventchamp-core' ) => 'style-8',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "speaker-profession",
						"heading" => esc_html__( 'Profession', 'eventchamp-core' ),
						"group" => esc_html__( 'Speaker', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "speaker-company",
						"heading" => esc_html__( 'Company', 'eventchamp-core' ),
						"group" => esc_html__( 'Speaker', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "speaker-short-biography",
						"heading" => esc_html__( 'Short Biography', 'eventchamp-core' ),
						"group" => esc_html__( 'Speaker', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "speaker-social-links",
						"heading" => esc_html__( 'Social Links', 'eventchamp-core' ),
						"group" => esc_html__( 'Speaker', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "venue-location",
						"heading" => esc_html__( 'Location', 'eventchamp-core' ),
						"group" => esc_html__( 'Venue', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "venue-category",
						"heading" => esc_html__( 'Category', 'eventchamp-core' ),
						"group" => esc_html__( 'Venue', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "venue-excerpt",
						"heading" => esc_html__( 'Excerpt', 'eventchamp-core' ),
						"group" => esc_html__( 'Venue', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
				),
			)
		);

	}

}