<?php
/*======
*
* Icon List
*
======*/
if( !function_exists( 'eventchamp_icon_list_output' ) and !function_exists( 'eventchamp_icon_list_item_shortcode' ) ) {

	function eventchamp_icon_list_output( $atts, $content = null ) {

		/*====== Atts ======*/
		$atts = shortcode_atts(
			array(
				'style' => '',
			), $atts
		);

		$output = '';

		/*====== HTML Output ======*/
		$output .= '<div class="gt-icon-list gt-' . esc_attr( $atts["style"] ) . '">';
			$output .= '<ul>';
				$output .= do_shortcode( $content );
			$output .= '</ul>';
		$output .= '</div>';

		return $output;

	}
	add_shortcode( "eventchamp_icon_list", "eventchamp_icon_list_output" );

	function eventchamp_icon_list_item_shortcode( $atts, $content = null ) {

		/*====== Atts ======*/
		$atts = shortcode_atts(
			array(
				'text' => '',
				'icon' => '',
				'svg-icon' => '',
			), $atts
		);
		
		$output = '';

		/*====== HTML Output ======*/
		if( !empty( $atts["text"] ) ) {

			$output .= '<li>';

				if( !empty( $atts["icon"] ) ) {

					$output .= '<i class="' . esc_attr( $atts["icon"] ) . '"></i>';

				} elseif( !empty( $atts["svg-icon"] ) ) {

					$output .= rawurldecode( base64_decode( $atts["svg-icon"] ) );

				}

				if( !empty( $atts["text"] ) ) {

					$output .= '<div class="text">' . esc_attr( $atts["text"] ) . '</div>';

				}

			$output .= '</li>';

		}

		return $output;

	}
	add_shortcode( "eventchamp_icon_list_item", "eventchamp_icon_list_item_shortcode" );

	if( function_exists( 'vc_map' ) ) {

		vc_map(
			array(
				"name" => esc_html__( 'Icon List', 'eventchamp-core' ),
				"base" => "eventchamp_icon_list",
				"as_parent" => array( 'only' => 'eventchamp_icon_list_item' ),
				"js_view" => "VcColumnView",
				"content_element" => true,
				"category" => esc_html__( 'Eventchamp Theme', 'eventchamp-core' ),
				"icon" => get_template_directory_uri() . '/include/assets/img/icons/icon-list.jpg',
				"description" => esc_html__( 'Create a list with icons', 'eventchamp-core' ),
				"params" => array(
					array(
						"type" => "dropdown",
						"param_name" => "style",
						"heading" => esc_html__( 'Style', 'eventchamp-core' ),
						'admin_label' => true,
						'save_always' => true,
						"value" => array(
							esc_html__( 'Style 1', 'eventchamp-core' ) => 'style-1',
							esc_html__( 'Style 2', 'eventchamp-core' ) => 'style-2',
						),
					),
				)
			)
		);

	}

	if( function_exists( 'vc_map' ) ) {

		vc_map(
			array(
				"name" => esc_html__( 'Icon List Item', 'eventchamp-core' ),
				"base" => "eventchamp_icon_list_item",
				"as_child" => array( 'only' => 'eventchamp_icon_list' ),
				"content_element" => true,
				"category" => esc_html__( 'Eventchamp Theme', 'eventchamp-core' ),
				"icon" => get_template_directory_uri() . '/include/assets/img/icons/icon-list.jpg',
				"params" => array(
					array(
						"type" => "textfield",
						"param_name" => "text",
						"heading" => esc_html__( 'Text', 'eventchamp-core' ),
						"admin_label" => true,
						"save_always" => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "icon",
						"heading" => esc_html__( 'Font Icon', 'eventchamp-core' ),
						"description" => esc_html__( 'If you want to use SVG icon, enter blank it. Example: fab fa-wordpress-simple, fas fa-map-marker-alt. Icon list: https://goo.gl/vdPEsc', 'eventchamp-core' ),
						"save_always" => true,
					),
					array(
						"type" => "textarea_raw_html",
						"param_name" => "svg-icon",
						"heading" => esc_html__( 'SVG Icon', 'eventchamp-core' ),
						"save_always" => true,
					),
				)
			)
		);

	}

	if( class_exists( 'WPBakeryShortCodesContainer' ) ) {

		class WPBakeryShortCode_eventchamp_icon_list extends WPBakeryShortCodesContainer {}

	}

}