<?php
/*======
*
* Feature Box
*
======*/
if( !function_exists( 'eventchamp_feature_box_output' ) ) {

	function eventchamp_feature_box_output( $atts, $content = null ) {

		/*====== Output ======*/
		$atts = shortcode_atts(
			array(
				'style' => 'style-1',
				'alignment' => 'left',
				'title' => '',
				'subtitle' => '',
				'content' => '',
				'number' => '',
				'image' => '',
				'image-background-color' => '',
				'opacity-effect' => 'false',
				'icon' => '',
				'svg-icon' => '',
				'link-status' => 'false',
				'link' => '',
			), $atts
		);

		/*====== Content ======*/
		$atts['content'] = $content;

		/*====== Image Background Color ======*/
		if( !empty( $atts["image-background-color"] ) ) {

			$image_color = ' style="background-color:' . esc_attr( $atts["image-background-color"] ) . ';"';

		} else {

			$image_color = "";

		}

		/*====== HTML Output ======*/
		$output = "";

		if( $atts["style"] == "style-1" ) {

			$output .= '<div class="gt-feature-box gt-align-' . esc_attr( $atts["alignment"] ) . ' gt-' . esc_attr( $atts["style"] ) . ' gt-opacity-effect-' . esc_attr( $atts["opacity-effect"] ) . '">';

				if( !empty( $atts["image"] ) ) {

					$output .= '<div class="gt-img"' . $image_color . '>';
						$output .= wp_get_attachment_image( $atts["image"], 'eventchamp-feature-box-1' );
					$output .= '</div>';

				}

				if( !empty( $atts["subtitle"] ) or !empty( $atts["title"] ) or !empty( $atts["content"] ) or !empty( $atts["number"] ) ) {

					$output .= '<div class="gt-content">';

						if( !empty( $atts["subtitle"] ) ) {

							$output .= '<div class="gt-subtitle">' . esc_attr( $atts["subtitle"] ) . '</div>';

						}

						if( !empty( $atts["title"] ) ) {

							$output .= '<h3 class="gt-title">' . esc_attr( $atts["title"] ) . '</h3>';

						}

						if( !empty( $atts["content"] ) ) {

							$output .= '<div class="gt-excerpt">' . wpautop( $atts["content"] ) . '</div>';

						}

						if( !empty( $atts["number"] ) ) {

							$output .= '<div class="gt-number">' . esc_attr( $atts["number"] ) . '</div>';

						}

						if( $atts["link-status"] == "true" ) {

							if( !empty( $atts["link"] ) ) {

								$link = $atts["link"];
								$link = vc_build_link( $link );

								if( !empty( $link["target"] ) ) {

									$link_target = $link["target"];

								} else {

									$link_target = "_parent";

								}

								if( !empty( $link["url"] ) ) {

									$output .= '<a href="' . esc_url( $link["url"] ) . '" target="' . esc_attr( $link_target ) . '" class="gt-btn gt-btn-primary">' . esc_attr( $link["title"] ) . '</a>';

								}

							}

						}

					$output .= '</div>';

				}

			$output .= '</div>';

		} elseif( $atts["style"] == "style-2" ) {

			$output .= '<div class="gt-feature-box gt-align-' . esc_attr( $atts["alignment"] ) . ' gt-' . esc_attr( $atts["style"] ) . '">';

				if( !empty( $atts["icon"] ) ) {

					$output .= '<div class="gt-icon">';
						$output .= '<i class="' . esc_attr( $atts["icon"] ) . '"></i>';
					$output .= '</div>';

				} elseif( !empty( $atts["svg-icon"] ) ) {

					$output .= '<div class="gt-icon">';
						$output .= rawurldecode( base64_decode( $atts["svg-icon"] ) );
					$output .= '</div>';

				}

				if( !empty( $atts["subtitle"] ) or !empty( $atts["title"] ) or !empty( $atts["content"] ) or !empty( $atts["number"] ) ) {

					$output .= '<div class="gt-content">';

						if( !empty( $atts["subtitle"] ) ) {

							$output .= '<div class="gt-subtitle">' . esc_attr( $atts["subtitle"] ) . '</div>';

						}

						if( !empty( $atts["title"] ) ) {

							$output .= '<h3 class="gt-title">' . esc_attr( $atts["title"] ) . '</h3>';

						}

						if( !empty( $atts["content"] ) ) {

							$output .= '<div class="gt-excerpt">' . wpautop( $atts["content"] ) . '</div>';

						}

						if( !empty( $atts["number"] ) ) {

							$output .= '<div class="gt-number">' . esc_attr( $atts["number"] ) . '</div>';

						}

						if( $atts["link-status"] == "true" ) {

							if( !empty( $atts["link"] ) ) {

								$link = $atts["link"];
								$link = vc_build_link( $link );

								if( !empty( $link["target"] ) ) {

									$link_target = $link["target"];

								} else {

									$link_target = "_parent";

								}

								if( !empty( $link["url"] ) ) {

									$output .= '<a href="' . esc_url( $link["url"] ) . '" target="' . esc_attr( $link_target ) . '" class="gt-btn gt-btn-primary">' . esc_attr( $link["title"] ) . '</a>';

								}

							}

						}

					$output .= '</div>';

				}

			$output .= '</div>';

		}

		return $output;

	}
	add_shortcode( "eventchamp_feature_box", "eventchamp_feature_box_output" );

	if( function_exists( 'vc_map' ) ) {

		vc_map(
			array(
				"name" => esc_html__( 'Feature Box', 'eventchamp-core' ),
				"base" => "eventchamp_feature_box",
				"category" => esc_html__( 'Eventchamp Theme', 'eventchamp-core' ),
				"description" => esc_html__( 'A creative feature box', 'eventchamp-core' ),
				"icon" => get_template_directory_uri() . '/include/assets/img/icons/feature-box.jpg',
				"params" => array(
					array(
						"type" => "dropdown",
						"param_name" => "style",
						"heading" => esc_html__( 'Style', 'eventchamp-core' ),
						"admin_label" => true,
						"save_always" => true,
						"value" => array(
							esc_html__( 'Style 1', 'eventchamp-core' ) => 'style-1',
							esc_html__( 'Style 2', 'eventchamp-core' ) => 'style-2',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "alignment",
						"heading" => esc_html__( 'Align', 'eventchamp-core' ),
						"save_always" => true,
						"value" => array(
							esc_html__( 'Left', 'eventchamp-core' ) => 'left',
							esc_html__( 'Center', 'eventchamp-core' ) => 'center',
							esc_html__( 'Right', 'eventchamp-core' ) => 'right',
						),
					),
					array(
						"type" => "textfield",
						"param_name" => "title",
						"heading" => esc_html__( 'Title', 'eventchamp-core' ),
						"admin_label" => true,
						"save_always" => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "subtitle",
						"heading" => esc_html__( 'Subtitle', 'eventchamp-core' ),
						"save_always" => true,
					),
					array(
						"type" => "textarea_html",
						"param_name" => "content",
						"heading" => esc_html__( 'Text', 'eventchamp-core' ),
						"save_always" => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "number",
						"heading" => esc_html__( 'Number', 'eventchamp-core' ),
						"save_always" => true,
					),
					array(
						"type" => "attach_image",
						"param_name" => "image",
						"heading" => esc_html__( 'Image', 'eventchamp-core' ),
						"description" => esc_html__( 'For style 1. Recommended sizes: Style 1: 540x540', 'eventchamp-core' ),
						"save_always" => true,
					),
					array(
						"type" => "colorpicker",
						"param_name" => "image-background-color",
						"heading" => esc_html__( 'Image Background Color', 'eventchamp-core' ),
						"save_always" => true,
					),
					array(
						"type" => "dropdown",
						"param_name" => "opacity-effect",
						"heading" => esc_html__( 'Opacity Effect', 'eventchamp-core' ),
						"save_always" => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "textfield",
						"param_name" => "icon",
						"heading" => esc_html__( 'Font Icon', 'eventchamp-core' ),
						"description" => esc_html__( 'For style 2. If you want to use SVG icon, enter blank it. Example: fab fa-wordpress-simple, fas fa-map-marker-alt. Icon list: https://goo.gl/vdPEsc', 'eventchamp-core' ),
						"save_always" => true,
					),
					array(
						"type" => "textarea_raw_html",
						"param_name" => "svg-icon",
						"heading" => esc_html__( 'SVG Icon', 'eventchamp-core' ),
						"save_always" => true,
					),
					array(
						"type" => "dropdown",
						"param_name" => "link-status",
						"heading" => esc_html__( 'Link Status', 'eventchamp-core' ),
						"save_always" => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "vc_link",
						"param_name" => "link",
						"heading" => esc_html__( 'Link', 'eventchamp-core' ),
						"save_always" => true,
					),
				),
			)
		);

	}

}