<?php
/*======
*
* Events Slider
*
======*/
if( !function_exists( 'eventchamp_latest_events_slider_output' ) ) {

	function eventchamp_latest_events_slider_output( $atts, $content = null ) {

		$atts = shortcode_atts(
			array(
				'eventcount' => '',
				'eventids' => '',
				'excludeevents' => '',
				'offset' => '',
				'order' => '',
				'order-type' => '',
				'hide-expired' => '',
				'exclude-categories' => '',
				'exclude-locations' => '',
				'exclude-organizers' => '',
				'exclude-tags' => '',
				'include-categories' => '',
				'include-locations' => '',
				'include-organizers' => '',
				'include-tags' => '',
				'separator' => 'false',
				'separator-color' => '',
				'details-button' => 'true',
				'customtextdetailsbutton' => '',
				'buy-now-button' => 'true',
				'customtextbuynowbutton' => '',
				'category' => 'true',
				'startdate' => '',
				'enddate' => '',
				'location' => '',
				'venue' => '',
				'slider-height' => '100vh',
				'opacity' => 'true',
				'opacity-value' => '0.3',
				'opacity-color' => '0.3',
				'slider-column' => '1',
				'slider-space' => '0',
				'slider-autoplay' => 'false',
				'slider-autoplay-delay' => '15000',
				'slider-loop' => 'false',
				'slider-slide-speed' => '1000',
				'slider-centered-slides' => 'false',
				'slider-direction' => 'horizontal',
				'slider-effect' => 'slide',
				'slider-free-mode' => 'false',
				'navbuttons' => 'false',
				'navigation-style' => 'style-1',
				'dots' => 'false',
				'pagination-style' => 'style-1',
			), $atts
		);
		
		$output = '';

		/*====== Lazy Load ======*/
		$lazy_load = ot_get_option( 'lazy-load', 'off' );

		/*====== Separator ======*/
		if( empty( $atts["separator-color"] ) ) {

			$separator_color = "#FFFFFF";

		} else {

			$separator_color = esc_attr( $atts["separator-color"] );

		}

		/*====== Slider Height ======*/
		if( empty( $atts["slider-height"] ) ) {

			$atts["slider-height"] = "100vh";

		}

		/*====== Opacity ======*/
		if( empty( $atts["opacity"] ) ) {

			$atts["opacity"] = "true";

		}

		/*====== Opacity Value ======*/
		if( empty( $atts["opacity-value"] ) ) {

			$atts["opacity-value"] = "0.3";

		}

		/*====== Opacity Color ======*/
		if( empty( $atts["opacity-color"] ) ) {

			$opacity_color = "#000000";

		} else {

			$opacity_color = esc_attr( $atts["opacity-color"] );

		}

		/*====== Column ======*/
		if( empty( $atts["slider-column"] ) ) {

			$atts["slider-column"] = "1";

		}

		/*====== Column Space ======*/
		if( empty( $atts["slider-space"] ) ) {

			$atts["slider-space"] = "0";

		}

		/*====== Slider Autoplay Delay ======*/
		if( empty( $atts["slider-autoplay-delay"] ) ) {

			$atts["slider-autoplay-delay"] = "15000";

		}

		/*====== Slider Loop ======*/
		if( empty( $atts["slider-loop"] ) ) {

			$atts["slider-loop"] = "false";

		}

		/*====== Slider Slide Speed ======*/
		if( empty( $atts["slider-slide-speed"] ) ) {

			$atts["slider-slide-speed"] = "1000";

		}

		/*====== Centered Slides ======*/
		if( empty( $atts["slider-centered-slides"] ) ) {

			$atts["slider-centered-slides"] = "false";

		}

		/*====== Slider Direction ======*/
		if( empty( $atts["slider-direction"] ) ) {

			$atts["slider-direction"] = "horizontal";

		}

		/*====== Slider Effect ======*/
		if( empty( $atts["slider-effect"] ) ) {

			$atts["slider-effect"] = "slide";

		}

		/*====== Slider Free Mode ======*/
		if( empty( $atts["slider-free-mode"] ) ) {

			$atts["slider-free-mode"] = "false";

		}

		/*====== Expired Events Status ======*/
		if( !empty( $atts['hide-expired'] ) ) {

			$hideexpired = esc_attr( $atts["hide-expired"] );

		} else {

			$hideexpired = "false";

		}

		/*====== Exclude Categories ======*/
		$exclude_category_array = "";

		if( !empty( $atts['exclude-categories'] ) ) {

			$exclude_categories = $atts['exclude-categories'];
			$exclude_categories = explode( ',', $exclude_categories );

		} else {

			$exclude_categories = "";

		}

		if( !empty( $exclude_categories ) ) {

			$exclude_category_array = array(
				'taxonomy' => 'eventcat',
				'field' => 'term_id',
				'terms' => $exclude_categories,
				'operator' => 'NOT IN',
			);

		}

		/*====== Exclude Locations ======*/
		$exclude_location_array = "";

		if( !empty( $atts['exclude-locations'] ) ) {

			$exclude_locations = $atts['exclude-locations'];
			$exclude_locations = explode( ',', $exclude_locations );

		} else {

			$exclude_locations = "";

		}

		if( !empty( $exclude_locations ) ) {

			$exclude_location_array = array(
				'taxonomy' => 'location',
				'field' => 'term_id',
				'terms' => $exclude_locations,
				'operator' => 'NOT IN',
			);

		}

		/*====== Exclude Organizers ======*/
		$exclude_organizer_array = "";

		if( !empty( $atts['exclude-organizers'] ) ) {

			$exclude_organizers = $atts['exclude-organizers'];
			$exclude_organizers = explode( ',', $exclude_organizers );

		} else {

			$exclude_organizers = "";

		}

		if( !empty( $exclude_organizers ) ) {

			$exclude_organizer_array = array(
				'taxonomy' => 'organizer',
				'field' => 'term_id',
				'terms' => $exclude_organizers,
				'operator' => 'NOT IN',
			);

		}

		/*====== Exclude Tags ======*/
		$exclude_tag_array = "";

		if( !empty( $atts['exclude-tags'] ) ) {

			$exclude_tags = $atts['exclude-tags'];
			$exclude_tags = explode( ',', $exclude_tags );

		} else {

			$exclude_tags = "";

		}

		if( !empty( $exclude_tags ) ) {

			$exclude_tag_array = array(
				'taxonomy' => 'event_tags',
				'field' => 'term_id',
				'terms' => $exclude_tags,
				'operator' => 'NOT IN',
			);

		}

		/*====== Include Categories ======*/
		$include_category_array = "";

		if( !empty( $atts['include-categories'] ) ) {

			$include_categories = $atts['include-categories'];
			$include_categories = explode( ',', $include_categories );

		} else {

			$include_categories = "";

		}

		if( !empty( $include_categories ) ) {

			$include_category_array = array(
				'taxonomy' => 'eventcat',
				'field' => 'term_id',
				'terms' => $include_categories,
				'operator' => 'IN',
			);

		}

		/*====== Include Locations ======*/
		$include_location_array = "";

		if( !empty( $atts['include-locations'] ) ) {

			$include_locations = $atts['include-locations'];
			$include_locations = explode( ',', $include_locations );

		} else {

			$include_locations = "";

		}

		if( !empty( $include_locations ) ) {

			$include_location_array = array(
				'taxonomy' => 'location',
				'field' => 'term_id',
				'terms' => $include_locations,
				'operator' => 'IN',
			);

		}

		/*====== Include Organizers ======*/
		$include_organizers_array = "";

		if( !empty( $atts['include-organizers'] ) ) {

			$include_organizers = $atts['include-organizers'];
			$include_organizers = explode( ',', $include_organizers );

		} else {

			$include_organizers = "";

		}

		if( !empty( $include_organizers ) ) {

			$include_organizers_array = array(
				'taxonomy' => 'organizer',
				'field' => 'term_id',
				'terms' => $include_organizers,
				'operator' => 'IN',
			);

		}

		/*====== Include Tags ======*/
		$include_tags_array = "";

		if( !empty( $atts['include-tags'] ) ) {

			$include_tags = $atts['include-tags'];
			$include_tags = explode( ',', $include_tags );

		} else {

			$include_tags = "";

		}

		if( !empty( $include_tags ) ) {

			$include_tags_array = array(
				'taxonomy' => 'event_tags',
				'field' => 'term_id',
				'terms' => $include_tags,
				'operator' => 'IN',
			);

		}

		/*====== Main Query ======*/
		$arg = array(
			'post_status' => 'publish',
			'post_type' => 'event',
			'tax_query' => array (
				'relation' => 'AND',
				$include_location_array,
				$include_category_array,
				$include_organizers_array,
				$include_tags_array,
				$exclude_category_array,
				$exclude_location_array,
				$exclude_organizer_array,
				$exclude_tag_array,
			)
		);

		/*====== Order & Order By ======*/
		if( $atts["order"] == "ASC" ) {

			$order = "ASC";

		} else {

			$order = "DESC";

		}

		if( !empty( $order ) ) {

			$extra_query = array(
				'order' => $order,
			);
			$arg = wp_parse_args( $arg, $extra_query );

		}

		if( $atts["order-type"] == "popular-comment" ) {

			$order_by = "comment_count";

		} elseif( $atts["order-type"] == "id" ) {

			$order_by = "ID";

		} elseif( $atts["order-type"] == "popular" ) {

			$order_by = "comment_count";

		} elseif( $atts["order-type"] == "title" ) {

			$order_by = "title";

		} elseif( $atts["order-type"] == "menu_order" ) {

			$order_by = "menu_order";

		} elseif( $atts["order-type"] == "rand" ) {

			$order_by = "rand";

		} elseif( $atts["order-type"] == "none" ) {

			$order_by = "none";

		} elseif( $atts["order-type"] == "post__in" ) {

			$order_by = "post__in";

		} elseif( $atts["order-type"] == "event-date" ) {

			$order_by = "";

			$extra_query = array(
				'meta_query' => array(
					'relation' => 'AND',
					'event_start_date_clause' => array(
						'key' => 'event_start_date',
					), 
					'event_start_time_clause' => array(
						'key' => 'event_start_time',
					),
				),
				'orderby' => array(
					'event_start_date_clause' => $order,
					'event_start_time_clause' => $order,
				),
			);
			$arg = wp_parse_args( $arg, $extra_query );

		} elseif( $atts["order-type"] == "price" ) {

			$order_by = "";

			$extra_query = array(
				'meta_query' => array(
					'relation' => 'AND',
					'event_main_price_clause' => array(
						'key' => 'event-ticket-main-price',
						'type' => 'NUMERIC',
					),
				),
				'orderby' => array(
					'event_main_price_clause' => $order,
				),
			);
			$arg = wp_parse_args( $arg, $extra_query );

		} else {

			$order_by = "date";

		}

		if( !empty( $order_by ) ) {

			$extra_query = array(
				'orderby' => $order_by,
			);
			$arg = wp_parse_args( $arg, $extra_query );

		}

		/*====== Event Count ======*/
		if( !empty( $atts["eventcount"] ) ) {

			$extra_query = array(
				'posts_per_page' => $atts["eventcount"],
			);
			$arg = wp_parse_args( $arg, $extra_query );

		}

		/*====== Offset ======*/
		if( !empty( $atts["offset"] ) ) {

			$extra_query = array(
				'offset' => $atts["offset"],
			);
			$arg = wp_parse_args( $arg, $extra_query );

		}

		/*====== Include Events ======*/
		if( !empty( $atts['eventids'] ) ) {

			$eventids = $atts['eventids'];
			$include_events = explode( ',', $eventids );

		} else {

			$include_events = "";

		}

		if( !empty( $include_events ) ) {

			$extra_query = array(
				'post__in' => $include_events,
			);
			$arg = wp_parse_args( $arg, $extra_query );

		}

		/*====== Exclude Events ======*/
		$excludeevents = $atts['excludeevents'];

		if( $hideexpired == "false" ) {

			if( !empty( $atts['excludeevents'] ) ) {

				$exclude_events = $atts['excludeevents'];
				$exclude_events = explode( ',', $exclude_events );

			} else {

				$exclude_events = array();

			}

			if( !empty( $exclude_events ) ) {

				$extra_query = array(
					'post__not_in' => $exclude_events,
				);
				$arg = wp_parse_args( $arg, $extra_query );

			}

		}

		/*====== Add Expired Events in Exclude Events ======*/
		if( $hideexpired == "true" ) {

			$expired_ids = eventchamp_expired_event_ids();

		} else {

			$expired_ids = array();

		}

		if( !empty( $expired_ids ) ) {

			if( !empty( $excludeevents ) ) {

				$exclude_events = $excludeevents;
				$exclude_events = explode( ',', $exclude_events );

			} else {

				$exclude_events = array();

			}

			$excludeevents_with_expired = array_merge( $exclude_events, $expired_ids );

			$extra_query = array(
				'post__not_in' => $excludeevents_with_expired,
			);
			$arg = wp_parse_args( $arg, $extra_query );

		}

		/*====== HTML Output ======*/
		$wp_query = new WP_Query( $arg );

		if( !empty( $wp_query ) ) {

			if( $wp_query->have_posts() ) {

				$output .= '<div class="gt-events-slider" style="height:' . esc_attr( $atts["slider-height"] ) . ';">';
					$output .= '<div class="swiper-container gt-swiper-slider" data-gt-item="' . esc_attr( $atts["slider-column"] ) . '" data-gt-item-space="' . esc_attr( $atts["slider-space"] ) . '" data-gt-loop="' . esc_attr( $atts["slider-loop"] ) . '" data-gt-speed="' . esc_attr( $atts["slider-slide-speed"] ) . '" data-gt-direction="' . esc_attr( $atts["slider-direction"] ) . '" data-gt-effect="' . esc_attr( $atts["slider-effect"] ) . '" data-gt-centered-slides="' . esc_attr( $atts["slider-centered-slides"] ) . '" data-gt-free-mode="' . esc_attr( $atts["slider-free-mode"] ) . '">';
						$output .= '<div class="swiper-wrapper">';

							while( $wp_query->have_posts() ) {

								$wp_query->the_post();
								$event_tickets = get_post_meta( get_the_ID(), 'event_tickets', true );
								$event_start_date = get_post_meta( get_the_ID(), 'event_start_date', true );
								$event_end_date = get_post_meta( get_the_ID(), 'event_end_date', true );
								$event_venues = get_post_meta( get_the_ID(), 'event_venue', true );
								$event_cats = wp_get_post_terms( get_the_ID(), 'eventcat' );
								$event_locations = wp_get_post_terms( get_the_ID(), 'location' );

								if( $atts["slider-autoplay"] == "true" ) {

									$output .= '<div class="swiper-slide" data-swiper-autoplay="' . esc_attr( $atts["slider-autoplay-delay"] ) . '">';

								} else {

									$output .= '<div class="swiper-slide">';

								}

									if( has_post_thumbnail() ) {
										
										if( $lazy_load == "on" ) {

											$output .= '<div class="gt-slide-inner gt-lazy-load" data-background="' . esc_url( wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), 'eventchamp-event-slider' )[0] ) . '">';

										} else {

											$output .= '<div class="gt-slide-inner" style="background-image:url(' . esc_url( wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), 'eventchamp-event-slider' )[0] ) . ');">';

										}

									} else {

										$output .= '<div class="gt-slide-inner">';

									}

										if( $atts["opacity"] == "true" ) {

											$output .= '<div class="gt-opacity" style="opacity: ' . esc_attr( $atts["opacity-value"] ) . '; background-color: ' . esc_attr( $opacity_color ) . ';"></div>';

										}

										$output .= '<div class="container">';
											$output .= '<div class="gt-content">';

												if( $atts["category"] == "true" ) {

													if( !empty( $event_cats ) ) {

														$output .= '<ul class="gt-category">';

															foreach( $event_cats as $event_cat ) {

																if( !empty( $event_cat ) ) {

																	if( !empty( $event_cat->name ) ) {

																		$output .= '<li>';
																			$output .= '<a href="' . get_term_link( $event_cat->term_id ) . '?post_type=event">' . esc_attr( $event_cat->name ) . '</a>';
																		$output .= '</li>';

																	}

																}

															}

														$output .= '</ul>';

													}

												}

												$output .= '<div class="gt-title">' . get_the_title() . '</div>';

												if( !empty( $event_start_date ) or !empty( $event_end_date ) or !empty( $event_locations ) or !empty( $event_venues ) ) {

													if( $atts["startdate"] == "true" or $atts["enddate"] == "true" or $atts["location"] == "true" or $atts["venue"] == "true" ) {

														$output .= '<ul class="gt-information">';

															if( $atts["startdate"] == "true" and !empty( $event_start_date ) ) {

																$output .= '<li>';
																	$output .= '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><rect x="3" y="4" width="18" height="18" rx="2" ry="2"></rect><line x1="16" y1="2" x2="16" y2="6"></line><line x1="8" y1="2" x2="8" y2="6"></line><line x1="3" y1="10" x2="21" y2="10"></line></svg>';
																	$output .= '<span>' . eventchamp_global_date_converter( $event_start_date ) . '</span>';
																$output .= '</li>';

															}

															if( $atts["enddate"] == "true" and !empty( $event_end_date ) ) {

																$output .= '<li>';
																	$output .= '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><circle cx="12" cy="12" r="10"></circle><polyline points="12 6 12 12 16 14"></polyline></svg>';
																	$output .= '<span>' . eventchamp_global_date_converter( $event_end_date ) . '</span>';
																$output .= '</li>';

															}

															if( $atts["location"] == "true" and !empty( $event_locations ) ) {

																$output .= '<li>';
																	$output .= '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M21 10c0 7-9 13-9 13s-9-6-9-13a9 9 0 0 1 18 0z"></path><circle cx="12" cy="10" r="3"></circle></svg>';
																	$output .= '<ul>';

																		foreach( $event_locations as $loc ) {

																			if( !empty( $loc ) ) {

																				if( !empty( $loc->name ) ) {

																					$output .= '<li>';
																						$output .= '<a href="' . get_term_link( $loc->term_id ) . '?post_type=event">' . esc_attr( $loc->name ) . '</a>';
																					$output .= '</li>';

																				}

																			}

																		}

																	$output .= '</ul>';
																$output .= '</li>';

															}

															if( $atts["venue"] == "true" ) {

																if( !empty( $event_venues ) and is_array( $event_venues ) ) {

																	$output .= '<li>';
																		$output .= '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><polygon points="1 6 1 22 8 18 16 22 23 18 23 2 16 6 8 2 1 6"></polygon><line x1="8" y1="2" x2="8" y2="18"></line><line x1="16" y1="6" x2="16" y2="22"></line></svg>';
																		$output .= '<ul>';

																			foreach( $event_venues as $event_venue ) {

																				if( !empty( $event_venue ) ) {

																					$output .= '<li>';
																						$output .= '<a href="' . esc_url( get_the_permalink( $event_venue ) ) . '">' . get_the_title( $event_venue ) . '</a>';
																					$output .= '</li>';

																				}

																			}

																		$output .= '</ul>';
																	$output .= '</li>';

																}

															}
														$output .= '</ul>';
													}
												}

												if( $atts["details-button"] == "true" or $atts["buy-now-button"] == "true" ) {

													$output .= '<div class="buttons">';

														if( !empty( $atts["customtextdetailsbutton"] ) ) {

															$button1_text = esc_attr( $atts["customtextdetailsbutton"] );

														} else {

															$button1_text = esc_html__( 'Details', 'eventchamp-core' );

														}

														if( !empty( $atts["customtextbuynowbutton"] ) ) {

															$button2_text = esc_attr( $atts["customtextbuynowbutton"] );

														} else {

															$button2_text = esc_html__( 'Buy Ticket', 'eventchamp-core' );

														}

														if( $atts["details-button"] == "true" ) {

															$output .= '<a href="' . get_the_permalink() . '">';
																$output .= '<span>' . esc_attr( $button1_text ) . '</span>';
															$output .= '</a>';

														}

														if( $atts["buy-now-button"] == "true" and !empty( $event_tickets ) ) {

															$output .= '<a href="' . get_the_permalink() . '?section=tickets">';
																$output .= '<span>' . esc_attr( $button2_text ) . '</span>';
															$output .= '</a>';

														}

													$output .= '</div>';

												}

											$output .= '</div>';
										$output .= '</div>';
									$output .= '</div>';
								$output .= '</div>';

							}

						$output .= '</div>';

						if( $atts["separator"] == "style-1" ) {

							$output .= '<div class="gt-separator gt-style-1">';
								$output .= '<svg fill="' . esc_attr( $separator_color ) . '" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1480 51" preserveAspectRatio="none"><path d="M1480 51V8c-17 0-34 2.3-47 6.8l-29.4 10.3c-25.8 9-68.1 9-93.9 0l-29.4-10.3c-25.8-9-68.1-9-93.9 0L1157 25.1c-25.8 9-68.1 9-93.9 0l-29.4-10.3c-25.8-9-68.1-9-93.9 0l-29.4 10.3c-25.8 9-68.1 9-93.9 0L787 14.8c-25.8-9-68.1-9-93.9 0l-29.4 10.3c-25.8 9-68.1 9-93.9 0l-29.4-10.3c-25.8-9-68.1-9-93.9 0l-29.4 10.3c-25.8 9-68.1 9-93.9 0l-29.5-10.3c-25.8-9-68.1-9-93.9 0l-29.4 10.3c-25.8 9-68.1 9-93.9 0L47 14.8C34 10.3 17 8 0 8v43h1480z"></path></svg>';
							$output .= '</div>';

						} elseif( $atts["separator"] == "style-2" ) {

							$output .= '<div class="gt-separator gt-style-2">';
								$output .= '<svg fill="' . esc_attr( $separator_color ) . '" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1480 103.5" preserveAspectRatio="none"><path d="M1480 103.5V7.7c-6.8.2-13.5.6-20.3.7-45.5 1.1-90.4 6.9-134 20.1-23.9 7.2-47 16.8-70.6 24.8-14 4.7-28.2 8.7-42.4 12.8-23.7 6.8-47.9 9.9-72.4 11.3-17 1-34.3 2.7-51.2 1.1-26.2-2.4-52.3-6.5-78.1-11.2-30.8-5.7-60.1-17-89.3-28.2C865.3 17.4 806.6 7.1 746.3 7c-57.8-.1-115.1 5.7-170.4 24-22.1 7.3-43.6 16.1-65.7 23.6-38.6 13.1-78.2 21.1-118.9 23.7-66.6 4.2-130.7-7.7-192.7-31.8-40.5-15.8-81.9-28.1-125-33.8C49.3 9.4 24.7 7.1 0 7.7v95.8h1480z"/></svg>';
							$output .= '</div>';

						} elseif( $atts["separator"] == "style-3" ) {

							$output .= '<div class="gt-separator gt-style-3">';
								$output .= '<svg fill="' . esc_attr( $separator_color ) . '" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1480 142.3" preserveAspectRatio="none"><path d="M704.6 52.7C430.3 1.4 174.9 23 0 43.7v98.7h1480V43.7c-192.5 22.8-441.9 71.3-775.4 9z"/></svg>';
							$output .= '</div>';

						} elseif( $atts["separator"] == "style-4" ) {

							$output .= '<div class="gt-separator gt-style-4">';
								$output .= '<svg fill="' . esc_attr( $separator_color ) . '" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1480 117"  preserveAspectRatio="none"><path d="M0 24.5c246.7 46.3 493.3 69.4 740 69.4s493.3-23.1 740-69.4V117H0V24.5z"/></svg>';
							$output .= '</div>';

						} elseif( $atts["separator"] == "style-5" ) {

							$output .= '<div class="gt-separator gt-style-5">';
								$output .= '<svg fill="' . esc_attr( $separator_color ) . '" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1480 160"><path d="M0 160L1480 12v148z"/></svg>';
							$output .= '</div>';

						} elseif( $atts["separator"] == "style-6" ) {

							$output .= '<div class="gt-separator gt-style-6">';
								$output .= '<svg fill="' . esc_attr( $separator_color ) . '" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1480 60"><path d="M74 22.5C33.1 22.5 0 39.3 0 60h148c0-20.7-33.1-37.5-74-37.5zM222 22.5c-40.9 0-74 16.8-74 37.5h148c0-20.7-33.1-37.5-74-37.5zM370 22.5c-40.9 0-74 16.8-74 37.5h148c0-20.7-33.1-37.5-74-37.5zM518 22.5c-40.9 0-74 16.8-74 37.5h148c0-20.7-33.1-37.5-74-37.5zM666 22.5c-40.9 0-74 16.8-74 37.5h148c0-20.7-33.1-37.5-74-37.5zM814 22.5c-40.9 0-74 16.8-74 37.5h148c0-20.7-33.1-37.5-74-37.5zM962 22.5c-40.9 0-74 16.8-74 37.5h148c0-20.7-33.1-37.5-74-37.5zM1110 22.5c-40.9 0-74 16.8-74 37.5h148c0-20.7-33.1-37.5-74-37.5zM1258 22.5c-40.9 0-74 16.8-74 37.5h148c0-20.7-33.1-37.5-74-37.5zM1406 22.5c-40.9 0-74 16.8-74 37.5h148c0-20.7-33.1-37.5-74-37.5z"/></svg>';
							$output .= '</div>';

						} elseif( $atts["separator"] == "style-7" ) {

							$output .= '<div class="gt-separator gt-style-7">';
								$output .= '<svg fill="' . esc_attr( $separator_color ) . '" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1480 60"><path d="M43.5 22L0 60h87.1zM130.6 22L87.1 60h87zM217.6 22l-43.5 38h87.1zM304.7 22l-43.5 38h87zM391.8 22l-43.6 38h87.1zM478.8 22l-43.5 38h87.1zM565.9 22l-43.5 38h87zM652.9 22l-43.5 38h87.1zM740 22l-43.5 38h87zM827.1 22l-43.6 38h87.1zM914.1 22l-43.5 38h87zM1001.2 22l-43.6 38h87.1zM1088.2 22l-43.5 38h87.1zM1175.3 22l-43.5 38h87zM1262.4 22l-43.6 38h87.1zM1349.4 22l-43.5 38h87zM1436.5 22l-43.6 38h87.1z"/></svg>';
							$output .= '</div>';

						}

						if( $atts["dots"] == "true" ) {

							if( $atts["separator"] !== "false" ) {

								$output .= '<div class="swiper-pagination gt-slider-pagination gt-' . esc_attr( $atts["pagination-style"] ) . '"></div>';

							} else {

								$output .= '<div class="swiper-pagination gt-slider-pagination gt-' . esc_attr( $atts["pagination-style"] ) . '"></div>';

							}

						}

						if( $atts["navbuttons"] == "true" ) {

							$output .= '<div class="gt-slider-prev gt-slider-control gt-' . esc_attr( $atts["navigation-style"] ) . '">';
								$output .= '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><polyline points="15 18 9 12 15 6"></polyline></svg>';
							$output .= '</div>';
							$output .= '<div class="gt-slider-next gt-slider-control gt-' . esc_attr( $atts["navigation-style"] ) . '">';
								$output .= '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><polyline points="9 18 15 12 9 6"></polyline></svg>';
							$output .= '</div>';

						}

					$output .= '</div>';
				$output .= '</div>';

			}

		}
		wp_reset_postdata();

		return $output;

	}
	add_shortcode( "eventchamp_latest_events_slider", "eventchamp_latest_events_slider_output" );

	if( function_exists( 'vc_map' ) ) {

		vc_map(
			array(
				"name" => esc_html__( 'Events Slider', 'eventchamp-core' ),
				"base" => "eventchamp_latest_events_slider",
				"category" => esc_html__( 'Eventchamp Theme', 'eventchamp-core' ),
				"icon" => get_template_directory_uri() . '/include/assets/img/icons/events-slider.jpg',
				"description" => esc_html__( 'List the events with slider', 'eventchamp-core' ),
				"params" => array(
					array(
						"type" => "textfield",
						"param_name" => "eventcount",
						"heading" => esc_html__( 'Count', 'eventchamp-core' ),
						"group" => esc_html__( 'General', 'eventchamp-core' ),
						'admin_label' => true,
						'save_always' => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "eventids",
						"heading" => esc_html__( 'Include Events', 'eventchamp-core' ),
						"description" => esc_html__( 'Separate with commas. Example: 1, 2, 3 etc.', 'eventchamp-core' ),
						"group" => esc_html__( 'General', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "excludeevents",
						"heading" => esc_html__( 'Exclude Events', 'eventchamp-core' ),
						"description" => esc_html__( 'Separate with commas. Example: 1, 2, 3 etc.', 'eventchamp-core' ),
						"group" => esc_html__( 'General', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "offset",
						"heading" => esc_html__( 'Offset', 'eventchamp-core' ),
						"group" => esc_html__( 'General', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "dropdown",
						"heading" => esc_html__( 'Order', 'eventchamp-core' ),
						"param_name" => "order",
						"group" => esc_html__( 'General', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'ASC', 'eventchamp-core' ) => 'ASC',
							esc_html__( 'DESC', 'eventchamp-core' ) => 'DESC',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "order-type",
						"heading" => esc_html__( 'Order Type', 'eventchamp-core' ),
						"group" => esc_html__( 'General', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'Added Date', 'eventchamp-core' ) => 'added-date',
							esc_html__( 'Event Date', 'eventchamp-core' ) => 'event-date',
							esc_html__( 'Price', 'eventchamp-core' ) => 'price',
							esc_html__( 'Popular by Comment', 'eventchamp-core' ) => 'popular-comment',
							esc_html__( 'ID', 'eventchamp-core' ) => 'id',
							esc_html__( 'Title', 'eventchamp-core' ) => 'title',
							esc_html__( 'Menu Order', 'eventchamp-core' ) => 'menu_order',
							esc_html__( 'Random', 'eventchamp-core' ) => 'rand',
							esc_html__( 'By Include IDs', 'eventchamp-core' ) => 'post__in',
							esc_html__( 'None', 'eventchamp-core' ) => 'none',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "hide-expired",
						"heading" => esc_html__( 'Hide Expired Events', 'eventchamp-core' ),
						"group" => esc_html__( 'General', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "textfield",
						"param_name" => "exclude-categories",
						"heading" => esc_html__( 'Exclude Categories', 'eventchamp-core' ),
						"description" => esc_html__( 'Separate with commas. Example: 1, 2, 3 etc.', 'eventchamp-core' ),
						"group" => esc_html__( 'Taxonomies', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "exclude-locations",
						"heading" => esc_html__( 'Exclude Locations', 'eventchamp-core' ),
						"description" => esc_html__( 'Separate with commas. Example: 1, 2, 3 etc.', 'eventchamp-core' ),
						"group" => esc_html__( 'Taxonomies', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "exclude-organizers",
						"heading" => esc_html__( 'Exclude Organizers', 'eventchamp-core' ),
						"description" => esc_html__( 'Separate with commas. Example: 1, 2, 3 etc.', 'eventchamp-core' ),
						"group" => esc_html__( 'Taxonomies', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "exclude-tags",
						"heading" => esc_html__( 'Exclude Tags', 'eventchamp-core' ),
						"description" => esc_html__( 'Separate with commas. Example: 1, 2, 3 etc.', 'eventchamp-core' ),
						"group" => esc_html__( 'Taxonomies', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "include-categories",
						"heading" => esc_html__( 'Include Categories', 'eventchamp-core' ),
						"description" => esc_html__( 'Separate with commas. Example: 1, 2, 3 etc.', 'eventchamp-core' ),
						"group" => esc_html__( 'Taxonomies', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "include-locations",
						"heading" => esc_html__( 'Include Locations', 'eventchamp-core' ),
						"description" => esc_html__( 'Separate with commas. Example: 1, 2, 3 etc.', 'eventchamp-core' ),
						"group" => esc_html__( 'Taxonomies', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "include-organizers",
						"heading" => esc_html__( 'Include Organizers', 'eventchamp-core' ),
						"description" => esc_html__( 'Separate with commas. Example: 1, 2, 3 etc.', 'eventchamp-core' ),
						"group" => esc_html__( 'Taxonomies', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "include-tags",
						"heading" => esc_html__( 'Include Tag', 'eventchamp-core' ),
						"description" => esc_html__( 'Example: Event', 'eventchamp-core' ),
						"group" => esc_html__( 'Taxonomies', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "dropdown",
						"param_name" => "separator",
						"heading" => esc_html__( 'Separator', 'eventchamp-core' ),
						"group" => esc_html__( 'Design', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'False',
							esc_html__( 'Style 1', 'eventchamp-core' ) => 'style-1',
							esc_html__( 'Style 2', 'eventchamp-core' ) => 'style-2',
							esc_html__( 'Style 3', 'eventchamp-core' ) => 'style-3',
							esc_html__( 'Style 4', 'eventchamp-core' ) => 'style-4',
							esc_html__( 'Style 5', 'eventchamp-core' ) => 'style-5',
							esc_html__( 'Style 6', 'eventchamp-core' ) => 'style-6',
							esc_html__( 'Style 7', 'eventchamp-core' ) => 'style-7',
						),
					),
					array(
						"type" => "colorpicker",
						"param_name" => "separator-color",
						"heading" => esc_html__( 'Separator Color', 'eventchamp-core' ),
						"description" => esc_html__( 'Default: #FFFFFF', 'eventchamp-core' ),
						"group" => esc_html__( 'Design', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "dropdown",
						"param_name" => "details-button",
						"heading" => esc_html__( 'Details Button', 'eventchamp-core' ),
						"group" => esc_html__( 'Design', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "textfield",
						"param_name" => "customtextdetailsbutton",
						"heading" => esc_html__( 'Details Button Text', 'eventchamp-core' ),
						"description" => esc_html__( 'Default: Details', 'eventchamp-core' ),
						"group" => esc_html__( 'Design', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "dropdown",
						"param_name" => "buy-now-button",
						"heading" => esc_html__( 'Buy Now Button', 'eventchamp-core' ),
						"group" => esc_html__( 'Design', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "textfield",
						"param_name" => "customtextbuynowbutton",
						"heading" => esc_html__( 'Buy Now Button Text', 'eventchamp-core' ),
						"description" => esc_html__( 'Default: Buy Now', 'eventchamp-core' ),
						"group" => esc_html__( 'Design', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "dropdown",
						"param_name" => "category",
						"heading" => esc_html__( 'Category', 'eventchamp-core' ),
						"group" => esc_html__( 'Design', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "startdate",
						"heading" => esc_html__( 'Start Date', 'eventchamp-core' ),
						"group" => esc_html__( 'Design', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "enddate",
						"heading" => esc_html__( 'End Date', 'eventchamp-core' ),
						"group" => esc_html__( 'Design', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "location",
						"heading" => esc_html__( 'Location', 'eventchamp-core' ),
						"group" => esc_html__( 'Design', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "venue",
						"heading" => esc_html__( 'Venue', 'eventchamp-core' ),
						"group" => esc_html__( 'Design', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "textfield",
						"param_name" => "slider-height",
						"heading" => esc_html__( 'Slider Height', 'eventchamp-core' ),
						"description" => esc_html__( 'Example: 600px. If enter blank, it will have full height.', 'eventchamp-core' ),
						"group" => esc_html__( 'Design', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "dropdown",
						"param_name" => "opacity",
						"heading" => esc_html__( 'Opacity', 'eventchamp-core' ),
						"group" => esc_html__( 'Design', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "opacity-value",
						"heading" => esc_html__( 'Opacity Value', 'eventchamp-core' ),
						"description" => esc_html__( 'Default: 0.3', 'eventchamp-core' ),
						"group" => esc_html__( 'Design', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( '10', 'eventchamp-core' ) => '0.1',
							esc_html__( '20', 'eventchamp-core' ) => '0.2',
							esc_html__( '30', 'eventchamp-core' ) => '0.3',
							esc_html__( '40', 'eventchamp-core' ) => '0.4',
							esc_html__( '50', 'eventchamp-core' ) => '0.5',
							esc_html__( '60', 'eventchamp-core' ) => '0.6',
							esc_html__( '70', 'eventchamp-core' ) => '0.7',
							esc_html__( '80', 'eventchamp-core' ) => '0.8',
							esc_html__( '90', 'eventchamp-core' ) => '0.9',
							esc_html__( '100', 'eventchamp-core' ) => '1',
						),
					),
					array(
						"type" => "colorpicker",
						"param_name" => "opacity-color",
						"heading" => esc_html__( 'Opacity Color', 'eventchamp-core' ),
						"description" => esc_html__( 'Default: #000000', 'eventchamp-core' ),
						"group" => esc_html__( 'Design', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "dropdown",
						"param_name" => "slider-column",
						"heading" => esc_html__( 'Column', 'eventchamp-core' ),
						"group" => esc_html__( 'Slider', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( '1 Column', 'eventchamp-core' ) => '1',
							esc_html__( '2 Column', 'eventchamp-core' ) => '2',
							esc_html__( '3 Column', 'eventchamp-core' ) => '3',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "slider-space",
						"heading" => esc_html__( 'Column Space', 'eventchamp-core' ),
						"group" => esc_html__( 'Slider', 'eventchamp-core' ),
						"save_always" => true,
						"value" => array(
							esc_html__( '0', 'eventchamp-core' ) => '0',
							esc_html__( '1', 'eventchamp-core' ) => '1',
							esc_html__( '2', 'eventchamp-core' ) => '2',
							esc_html__( '3', 'eventchamp-core' ) => '3',
							esc_html__( '4', 'eventchamp-core' ) => '4',
							esc_html__( '5', 'eventchamp-core' ) => '5',
							esc_html__( '10', 'eventchamp-core' ) => '10',
							esc_html__( '15', 'eventchamp-core' ) => '15',
							esc_html__( '20', 'eventchamp-core' ) => '20',
							esc_html__( '25', 'eventchamp-core' ) => '25',
							esc_html__( '30', 'eventchamp-core' ) => '30',
							esc_html__( '45', 'eventchamp-core' ) => '45',
							esc_html__( '50', 'eventchamp-core' ) => '50',
							esc_html__( '55', 'eventchamp-core' ) => '55',
							esc_html__( '60', 'eventchamp-core' ) => '60',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "slider-autoplay",
						"heading" => esc_html__( 'Slider Autoplay', 'eventchamp-core' ),
						"group" => esc_html__( 'Slider', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "textfield",
						"param_name" => "slider-autoplay-delay",
						"heading" => esc_html__( 'Slider Autoplay Delay', 'eventchamp-core' ),
						"description" => esc_html__( 'Default: 15000', 'eventchamp-core' ),
						"group" => esc_html__( 'Slider', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "dropdown",
						"param_name" => "slider-loop",
						"heading" => esc_html__( 'Slider Loop', 'eventchamp-core' ),
						"group" => esc_html__( 'Slider', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "textfield",
						"param_name" => "slider-slide-speed",
						"heading" => esc_html__( 'Slide Speed', 'eventchamp-core' ),
						"description" => esc_html__( 'Duration of transition between the slides. Default: 1500', 'eventchamp-core' ),
						"group" => esc_html__( 'Slider', 'eventchamp-core' ),
						"save_always" => true,
					),
					array(
						"type" => "dropdown",
						"param_name" => "slider-centered-slides",
						"heading" => esc_html__( 'Centered Slides', 'eventchamp-core' ),
						"description" => esc_html__( 'If you choose true, then active slide will be centered, not always on the left side.', 'eventchamp-core' ),
						"group" => esc_html__( 'Slider', 'eventchamp-core' ),
						"save_always" => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "slider-direction",
						"heading" => esc_html__( 'Slider Direction', 'eventchamp-core' ),
						"group" => esc_html__( 'Slider', 'eventchamp-core' ),
						"save_always" => true,
						"value" => array(
							esc_html__( 'Horizontal', 'eventchamp-core' ) => 'horizontal',
							esc_html__( 'Vertical', 'eventchamp-core' ) => 'vertical',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "slider-effect",
						"heading" => esc_html__( 'Slider Effect', 'eventchamp-core' ),
						"group" => esc_html__( 'Slider', 'eventchamp-core' ),
						"save_always" => true,
						"value" => array(
							esc_html__( 'Slide', 'eventchamp-core' ) => 'slide',
							esc_html__( 'Fade', 'eventchamp-core' ) => 'fade',
							esc_html__( 'Cube', 'eventchamp-core' ) => 'cube',
							esc_html__( 'Coverflow', 'eventchamp-core' ) => 'coverflow',
							esc_html__( 'Flip', 'eventchamp-core' ) => 'flip',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "slider-free-mode",
						"heading" => esc_html__( 'Free Mode', 'eventchamp-core' ),
						"description" => esc_html__( 'If true then slides will not have fixed positions', 'eventchamp-core' ),
						"group" => esc_html__( 'Slider', 'eventchamp-core' ),
						"save_always" => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "navbuttons",
						"heading" => esc_html__( 'Navigation', 'eventchamp-core' ),
						"group" => esc_html__( 'Slider', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "navigation-style",
						"heading" => esc_html__( 'Navigation Style', 'eventchamp-core' ),
						"group" => esc_html__( 'Slider', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'Style 1', 'eventchamp-core' ) => 'style-1',
							esc_html__( 'Style 2', 'eventchamp-core' ) => 'style-2',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "dots",
						"heading" => esc_html__( 'Pagination', 'eventchamp-core' ),
						"group" => esc_html__( 'Slider', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "pagination-style",
						"heading" => esc_html__( 'Pagination Style', 'eventchamp-core' ),
						"group" => esc_html__( 'Slider', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'Style 1', 'eventchamp-core' ) => 'style-1',
							esc_html__( 'Style 2', 'eventchamp-core' ) => 'style-2',
						),
					),
				),
			)
		);

	}

}