<?php
/*======
*
* Event Search Results
*
======*/
if( !function_exists( 'eventchamp_events_search_results_output' ) ) {

	function eventchamp_events_search_results_output( $atts, $content = null ) {

		/*====== Atts ======*/
		$atts = shortcode_atts(
			array(
				'eventcount' => '',
				'eventids' => '',
				'excludeevents' => '',
				'offset' => '',
				'order' => '',
				'order-type' => '',
				'hideexpired' => '',
				'pagination' => '',
				'excludecategories' => '',
				'exclude-locations' => '',
				'exclude-organizers' => '',
				'exclude-tags' => '',
				'includecategories' => '',
				'include-locations' => '',
				'include-organizers' => '',
				'include-tags' => '',
				'style' => '',
				'column' => '',
				'column-space' => '0',
				'price' => '',
				'status' => '',
				'category' => '',
				'location' => '',
				'venue' => '',
				'organizer' => '',
				'date' => '',
				'start-time' => '',
				'end-date' => '',
				'end-time' => '',
				'ticket-amount' => '',
				'excerpt' => '',
			), $atts
		);

		/*====== Date Now ======*/
		$date_now = date( 'Y-m-d' );

		/*====== Expired Events Status ======*/
		if( !empty( $atts["hideexpired"] ) ) {

			$hideexpired = esc_attr( $atts["hideexpired"] );

		} else {

			$hideexpired = "";

		}

		/*====== Column ======*/
		if( !empty( $atts["column"] ) ) {

			$column = esc_attr( $atts["column"] );

		} else {

			$column = "column-1";

		}

		/*====== Price Status ======*/
		if( $atts["price"] == "true" ) {

			$price_status = "true";

		} else {

			$price_status = "false";

		}

		/*====== Status Status ======*/
		if( $atts["status"] == "true" ) {

			$status_status = "true";

		} else {

			$status_status = "false";

		}

		/*====== Category Status ======*/
		if( $atts["category"] == "true" ) {

			$category_status = "true";

		} else {

			$category_status = "false";

		}

		/*====== Location Status ======*/
		if( $atts["location"] == "true" ) {

			$location_status = "true";

		} else {

			$location_status = "false";

		}

		/*====== Venue Status ======*/
		if( $atts["venue"] == "true" ) {

			$venue_status = "true";

		} else {

			$venue_status = "false";

		}

		/*====== Organizer Status ======*/
		if( $atts["organizer"] == "true" ) {

			$organizer_status = "true";

		} else {

			$organizer_status = "false";

		}

		/*====== Start Date Status ======*/
		if( $atts["date"] == "true" ) {

			$date_status = "true";

		} else {

			$date_status = "false";

		}

		/*====== Start Time Status ======*/
		if( $atts["start-time"] == "true" ) {

			$start_time_status = "true";

		} else {

			$start_time_status = "false";

		}

		/*====== End Date Status ======*/
		if( $atts["end-date"] == "true" ) {

			$end_date_status = "true";

		} else {

			$end_date_status = "false";

		}

		/*====== End Time Status ======*/
		if( $atts["end-time"] == "true" ) {

			$end_time_status = "true";

		} else {

			$end_time_status = "false";

		}

		/*====== Ticket Amount Status ======*/
		if( $atts["ticket-amount"] == "true" ) {

			$ticket_amount_status = "true";

		} else {

			$ticket_amount_status = "false";

		}

		/*====== Excerpt Status ======*/
		if( $atts["excerpt"] == "true" ) {

			$excerpt_status = "true";

		} else {

			$excerpt_status = "false";

		}

		/*====== Search Results ======*/
		if( isset( $_GET['keyword'] ) or isset( $_GET['category'] ) or isset( $_GET['status'] ) or isset( $_GET['sort'] ) or isset( $_GET['tag'] ) or isset( $_GET['location'] ) or isset( $_GET['event-venue'] ) or isset( $_GET['event-speaker'] ) or isset( $_GET['startdate'] ) or isset( $_GET['enddate'] ) or isset( $_GET['price'] ) ) {

			if( isset( $_GET['keyword'] ) ) {

				$search_keyword = esc_sql( stripslashes( esc_js( $_GET["keyword"] ) ) );

			} else {

				$search_keyword = "";

			}

			if( isset( $_GET['category'] ) ) {

				$search_category = esc_js( esc_sql( esc_attr( $_GET["category"] ) ) );

			} else {

				$search_category = "";

			}

			if( isset( $_GET['status'] ) ) {

				$search_status = esc_js( esc_sql( esc_attr( $_GET["status"] ) ) );

			} else {

				$search_status = "";

			}

			if( isset( $_GET['sort'] ) ) {

				$search_sort = esc_js( esc_sql( esc_attr( $_GET["sort"] ) ) );

			} else {

				$search_sort = "";

			}

			if( isset( $_GET['tag'] ) ) {

				$search_tag = esc_js( esc_sql( esc_attr( $_GET["tag"] ) ) );

			} else {

				$search_tag = "";

			}

			if( isset( $_GET['location'] ) ) {

				$search_location = esc_js( esc_sql( esc_attr( $_GET["location"] ) ) );

			} else {

				$search_location = "";

			}

			if( isset( $_GET['event-venue'] ) ) {

				$search_venue = esc_js( esc_sql( esc_attr( $_GET["event-venue"] ) ) );

			} else {

				$search_venue = "";

			}

			if( isset( $_GET['event-speaker'] ) ) {

				$search_speaker = esc_js( esc_sql( esc_attr( $_GET["event-speaker"] ) ) );

			} else {

				$search_speaker = "";

			}

			if( isset( $_GET['organizer'] ) ) {

				$search_organizer = esc_js( esc_sql( esc_attr( $_GET["organizer"] ) ) );

			} else {

				$search_organizer = "";

			}

			if( isset( $_GET['startdate'] ) ) {

				if( !empty( $_GET['startdate'] ) ) {

					$search_startdate = esc_js( esc_sql( esc_attr( $_GET["startdate"] ) ) );
					$search_startdate = date( 'Y-m-d', strtotime( $search_startdate ) );
					$search_startdate_compare = ">=";

				} else {

					$search_startdate = "";
					$search_startdate_compare = "";

				}

			} else {

				$search_startdate = "";
				$search_startdate_compare = "";

			}

			if( isset( $_GET['enddate'] ) ) {

				if( !empty( $_GET['enddate'] ) ) {

					$search_enddate = esc_js( esc_sql( esc_attr( $_GET["enddate"] ) ) );
					$search_enddate = date( 'Y-m-d', strtotime( $search_enddate ) );
					$search_enddate_compare = "<=";

				} else {

					$search_enddate = "";
					$search_enddate_compare = "";

				}

			} else {

				$search_enddate = "";
				$search_enddate_compare = "";

			}
			
			if( $search_status == "upcoming" ) {

				$search_compare = ">";
				$search_compare2 = ">";

			} elseif( $search_status == "showing" ) {

				$search_compare = "<=";
				$search_compare2 = ">=";

			} elseif( $search_status == "expired" ) {

				$search_compare = "<";
				$search_compare2 = "<";

			} else {

				$search_compare = "<=";
				$search_compare2 = ">=";

			}

			$prices = array();

			if( isset( $_GET['price'] ) ) {

				$search_price = esc_js( esc_sql( esc_attr( $_GET["price"] ) ) );

				if( !empty( $search_price ) ) {

					$prices = explode( ';', $search_price );

				}

			}

		} else {

			$search_startdate = "";
			$search_startdate_compare = "";
			$search_enddate = "";
			$search_enddate_compare = "";
			$search_keyword = "";
			$search_category = "";
			$search_status = "";
			$search_sort = "";
			$search_location = "";
			$search_venue = "";
			$search_speaker = "";
			$search_organizer = "";
			$search_compare = "";
			$search_compare2 = "";
			$order = "";
			$order_by = "";
			$meta_key = "event_start_date";
			$search_tag = "";
			$prices = array();

		}

		/*====== Exclude Categories ======*/
		$exclude_category_array = "";

		if( !empty( $atts['excludecategories'] ) ) {

			$exclude_categories = $atts['excludecategories'];
			$exclude_categories = explode( ',', $exclude_categories );

		} else {

			$exclude_categories = "";

		}

		if( !empty( $exclude_categories ) ) {

			$exclude_category_array = array(
				'taxonomy' => 'eventcat',
				'field' => 'term_id',
				'terms' => $exclude_categories,
				'operator' => 'NOT IN',
			);

		}

		/*====== Exclude Locations ======*/
		$exclude_location_array = "";

		if( !empty( $atts['exclude-locations'] ) ) {

			$exclude_locations = $atts['exclude-locations'];
			$exclude_locations = explode( ',', $exclude_locations );

		} else {

			$exclude_locations = "";

		}

		if( !empty( $exclude_locations ) ) {

			$exclude_location_array = array(
				'taxonomy' => 'location',
				'field' => 'term_id',
				'terms' => $exclude_locations,
				'operator' => 'NOT IN',
			);

		}

		/*====== Exclude Organizers ======*/
		$exclude_organizer_array = "";

		if( !empty( $atts['exclude-organizers'] ) ) {

			$exclude_organizers = $atts['exclude-organizers'];
			$exclude_organizers = explode( ',', $exclude_organizers );

		} else {

			$exclude_organizers = "";

		}

		if( !empty( $exclude_organizers ) ) {

			$exclude_organizer_array = array(
				'taxonomy' => 'organizer',
				'field' => 'term_id',
				'terms' => $exclude_organizers,
				'operator' => 'NOT IN',
			);

		}

		/*====== Exclude Tags ======*/
		$exclude_tag_array = "";

		if( !empty( $atts['exclude-tags'] ) ) {

			$exclude_tags = $atts['exclude-tags'];
			$exclude_tags = explode( ',', $exclude_tags );

		} else {

			$exclude_tags = "";

		}

		if( !empty( $exclude_tags ) ) {

			$exclude_tag_array = array(
				'taxonomy' => 'event_tags',
				'field' => 'term_id',
				'terms' => $exclude_tags,
				'operator' => 'NOT IN',
			);

		}

		/*====== Include Categories ======*/
		$include_category_array = "";

		if( !empty( $search_category ) ) {

			$include_categories = explode( ',', $search_category );

			if( !empty( $include_categories ) ) {

				$include_category_array = array(
					'taxonomy' => 'eventcat',
					'field' => 'term_id',
					'terms' => $include_categories,
					'operator' => 'IN',
				);

			}

		} else {

			if( !empty( $atts['includecategories'] ) ) {

				$include_categories = $atts['includecategories'];
				$include_categories = explode( ',', $include_categories );

			} else {

				$include_categories = "";

			}

			if( !empty( $include_categories ) ) {

				$include_category_array = array(
					'taxonomy' => 'eventcat',
					'field' => 'term_id',
					'terms' => $include_categories,
					'operator' => 'IN',
				);

			}

		}

		/*====== Include Locations ======*/
		$include_location_array = "";

		if( !empty( $search_location ) ) {

			$include_locations = explode( ',', $search_location );

			if( !empty( $include_locations ) ) {

				$include_location_array = array(
					'taxonomy' => 'location',
					'field' => 'term_id',
					'terms' => $include_locations,
					'operator' => 'IN',
				);

			}

		} else {

			if( !empty( $atts['include-locations'] ) ) {

				$include_locations = $atts['include-locations'];
				$include_locations = explode( ',', $include_locations );

			} else {

				$include_locations = "";

			}

			if( !empty( $include_locations ) ) {

				$include_location_array = array(
					'taxonomy' => 'location',
					'field' => 'term_id',
					'terms' => $include_locations,
					'operator' => 'IN',
				);

			}

		}

		/*====== Include Organizers ======*/
		$include_organizers_array = "";

		if( !empty( $search_organizer ) ) {

			$include_organizers = explode( ',', $search_organizer );

			if( !empty( $include_organizers ) ) {

				$include_organizers_array = array(
					'taxonomy' => 'organizer',
					'field' => 'term_id',
					'terms' => $include_organizers,
					'operator' => 'IN',
				);

			}

		} else {

			if( !empty( $atts['include-organizers'] ) ) {

				$include_organizers = $atts['include-organizers'];
				$include_organizers = explode( ',', $include_organizers );

			} else {

				$include_organizers = "";

			}

			if( !empty( $include_organizers ) ) {

				$include_organizers_array = array(
					'taxonomy' => 'organizer',
					'field' => 'term_id',
					'terms' => $include_organizers,
					'operator' => 'IN',
				);

			}

		}

		/*====== Include Tags ======*/
		$include_tags_array = "";

		if( !empty( $search_tag ) ) {

			$include_tags = explode( ',', $search_tag );

			if( !empty( $include_tags ) ) {

				$include_tags_array = array(
					'taxonomy' => 'event_tags',
					'field' => 'name',
					'terms' => $include_tags,
					'operator' => 'IN',
				);

			}

		} else {

			if( !empty( $atts['include-tags'] ) ) {

				$include_tags = $atts['include-tags'];
				$include_tags = explode( ',', $include_tags );

			} else {

				$include_tags = "";

			}

			if( !empty( $include_tags ) ) {

				$include_tags_array = array(
					'taxonomy' => 'event_tags',
					'field' => 'term_id',
					'terms' => $include_tags,
					'operator' => 'IN',
				);

			}

		}

		/*====== Filtrable by Venue ======*/
		$venue_array = array();

		if( !empty( $search_venue ) ) {

			$venue_array = array(
				'key' => 'event_venue',
				'compare' => 'LIKE',
				'value' => ':' . esc_attr( $search_venue ) . ';',
			);

		}

		/*====== Filtrable by Speaker ======*/
		$speaker_array = array();

		if( !empty( $search_speaker ) ) {

			$speaker_array = array(
				'key' => 'event_speakers',
				'compare' => 'LIKE',
				'value' => ':' . esc_attr( $search_speaker ) . ';',
			);

		}

		/*====== Filter by Price ======*/
		$prices_array = array();

		if( !empty( $prices ) ) {

			if( !empty( $prices[0] ) and !empty( $prices[1] ) ) {

				$prices_array = array(
					array(
						'key' => 'event-ticket-main-price',
						'compare' => '>=',
						'value' => $prices[0],
						'type' => 'NUMERIC',
					),
					array(
						'key' => 'event-ticket-main-price',
						'compare' => '<=',
						'value' => $prices[1],
						'type' => 'NUMERIC',
					),
				);

			}

		}

		/*====== Filtrable by Start Date ======*/
		$start_date_array = array();

		if( !empty( $search_startdate ) ) {

			$start_date_array = array(
				'key' => 'event_start_date',
				'compare' => $search_startdate_compare,
				'value' => $search_startdate,
			);

		}

		/*====== Filtrable by End Date ======*/
		$end_date_array = array();

		if( !empty( $search_enddate ) ) {

			$end_date_array = array(
				'key' => 'event_end_date',
				'compare' => $search_enddate_compare,
				'value' => $search_enddate,
			);

		}

		/*====== Order by Price ======*/
		$order_event_price_array = array();

		if( $atts["order-type"] == "price" or $search_sort == "price-l-h" or $search_sort == "price-h-l" ) {

			$order_event_price_array = array(
				'relation' => 'AND',
				'event_main_price_clause' => array(
					'key' => 'event-ticket-main-price',
					'type' => 'NUMERIC',
				),
			);

 		}

		/*====== Order by Event Date ======*/
		$order_event_start_date_array = array();

		if( $atts["order-type"] == "event-date" or $search_sort == "start-date" ) {

			$order_event_start_date_array = array(
				'relation' => 'AND',
				'event_start_date_clause' => array(
					'key' => 'event_start_date',
				), 
				'event_start_time_clause' => array(
					'key' => 'event_start_time',
				),
			);

 		}

		/*====== Order by End Date ======*/
		$order_event_end_date_array = array();

		if( $search_sort == "end-date" ) {

			$order_event_end_date_array = array(
				'relation' => 'AND',
				'event_end_date_clause' => array(
					'key' => 'event_end_date',
				), 
				'event_end_time_clause' => array(
					'key' => 'event_end_time',
				),
			);

 		}

		/*====== Filtrable by Event Status ======*/
		$status_array = array();
		$status_array_2 = array();

		if( !empty( $search_status ) ) {

			if( $search_status == "expired" ) {

				$expire_date_now = date("Y-m-d H:i");
				$status_array = array(
					'key' => 'event_expire_date',
					'compare' => '<=',
					'value' => $expire_date_now,
				);

			} else {

				$status_array = array(
					'key' => 'event_start_date',
					'compare' => $search_compare,
					'value' => $date_now,
				);
				$status_array_2 = array(
					'key' => 'event_end_date',
					'compare' => $search_compare2,
					'value' => $date_now,
				);

			}

		}

		/*====== Main Query ======*/
		$arg = array(
			'post_status' => 'publish',
			'post_type' => 'event',
			'tax_query' => array (
				'relation' => 'AND',
				$include_location_array,
				$include_category_array,
				$include_organizers_array,
				$include_tags_array,
				$exclude_category_array,
				$exclude_location_array,
				$exclude_organizer_array,
				$exclude_tag_array,
			),
			'meta_query' => array(
				$status_array,
				$status_array_2,
				$start_date_array,
				$end_date_array,
				$venue_array,
				$speaker_array,
				$prices_array,
				$order_event_price_array,
				$order_event_start_date_array,
				$order_event_end_date_array,
			),
		);

		/*====== Pagination ======*/
		$paged = is_front_page() ? get_query_var( 'page', 1 ) : get_query_var( 'paged', 1 );

		if( empty( $paged ) ) {

			$paged = 1;

		}

		if( !empty( $paged ) ) {

			$extra_query = array(
				'paged' => $paged,
			);
			$arg = wp_parse_args( $arg, $extra_query );

		}

		/*====== Event Count ======*/
		if( !empty( $atts["eventcount"] ) ) {

			$extra_query = array(
				'posts_per_page' => $atts["eventcount"],
			);
			$arg = wp_parse_args( $arg, $extra_query );

		}

		/*====== Offset ======*/
		if( !empty( $atts["offset"] ) ) {

			$extra_query = array(
				'offset' => $atts["offset"],
			);
			$arg = wp_parse_args( $arg, $extra_query );

		}

		/*====== Event Keyword ======*/
		if( !empty( $search_keyword ) ) {

			$extra_query = array(
				's' => $search_keyword,
			);
			$arg = wp_parse_args( $arg, $extra_query );

		}

		/*====== Include Events ======*/
		if( !empty( $atts['eventids'] ) ) {

			$eventids = $atts['eventids'];
			$include_events = explode( ',', $eventids );

		} else {

			$include_events = "";

		}

		if( !empty( $include_events ) ) {

			$extra_query = array(
				'post__in' => $include_events,
			);
			$arg = wp_parse_args( $arg, $extra_query );

		}

		/*====== Exclude Events ======*/
		$excludeevents = $atts['excludeevents'];

		if( $hideexpired == "false" ) {

			if( !empty( $excludeevents ) ) {

				$exclude_events = $excludeevents;
				$exclude_events = explode( ',', $exclude_events );

			} else {

				$exclude_events = array();

			}

			if( !empty( $exclude_events ) ) {

				$extra_query = array(
					'post__not_in' => $exclude_events,
				);
				$arg = wp_parse_args( $arg, $extra_query );

			}

		}

		/*====== Add Expired Events in Exclude Events ======*/
		if( $hideexpired == "true" ) {

			$expired_ids = eventchamp_expired_event_ids();

		} else {

			$expired_ids = array();

		}

		if( !empty( $expired_ids ) ) {

			if( !empty( $excludeevents ) ) {

				$exclude_events = $excludeevents;
				$exclude_events = explode( ',', $exclude_events );

			} else {

				$exclude_events = array();

			}

			$excludeevents_with_expired = array_merge( $exclude_events, $expired_ids );

			$extra_query = array(
				'post__not_in' => $excludeevents_with_expired,
			);
			$arg = wp_parse_args( $arg, $extra_query );

		}

		/*====== Order & Order By ======*/
		if( empty( $order ) ) {

			if( $atts["order"] == "ASC" ) {

				$order = "ASC";

			} else {

				$order = "DESC";

			}

		}

		if( $search_sort == "name-za" or $search_sort == "end-date" ) {

			$order = "DESC";

		} elseif( $search_sort == "price-l-h" ) {

			$order = "ASC";

		} elseif( $search_sort == "price-h-l" ) {

			$order = "DESC";

		}

		if( !empty( $order ) ) {

			$extra_query = array(
				'order' => $order,
			);
			$arg = wp_parse_args( $arg, $extra_query );

		}

		if( empty( $order_by ) ) {

			if( $atts["order-type"] == "popular-comment" ) {

				$order_by = "comment_count";

			} elseif( $atts["order-type"] == "id" ) {

				$order_by = "ID";

			} elseif( $atts["order-type"] == "popular" ) {

				$order_by = "comment_count";

			} elseif( $atts["order-type"] == "title" or $search_sort == "name-az" or $search_sort == "name-za" ) {

				$order_by = "title";

			} elseif( $atts["order-type"] == "menu_order" ) {

				$order_by = "menu_order";

			} elseif( $atts["order-type"] == "rand" ) {

				$order_by = "rand";

			} elseif( $atts["order-type"] == "none" ) {

				$order_by = "none";

			} elseif( $atts["order-type"] == "post__in" ) {

				$order_by = "post__in";

			} elseif( $atts["order-type"] == "added-date" or $search_sort == "added-date" ) {

				$order_by = "date";

			}

		}

		if( !empty( $order_by ) ) {

			$extra_query = array(
				'orderby' => $order_by,
			);
			$arg = wp_parse_args( $arg, $extra_query );

		}

		/*====== Order by Price ======*/
		if( $atts["order-type"] == "price" or $search_sort == "price-l-h" or $search_sort == "price-h-l" ) {

			$extra_query = array(
				'orderby' => array(
					'event_main_price_clause' => $order,
				),
			);
			$arg = wp_parse_args( $arg, $extra_query );

 		}

		/*====== Order by Start Date ======*/
		if( $atts["order-type"] == "event-date" or $search_sort == "start-date" ) {

			$extra_query = array(
				'orderby' => array(
					'event_start_date_clause' => $order,
					'event_start_time_clause' => $order,
				),
			);
			$arg = wp_parse_args( $arg, $extra_query );

 		}

		/*====== Order by End Date ======*/
		if( $search_sort == "end-date" ) {

			$extra_query = array(
				'orderby' => array(
					'event_end_date_clause' => $order,
					'event_end_time_clause' => $order,
				),
			);
			$arg = wp_parse_args( $arg, $extra_query );

 		}

		/*====== HTML Output ======*/
		$output = "";

		$wp_query = new WP_Query( $arg );

		if( !empty( $wp_query ) ) {

			if( $wp_query->have_posts() ) {

				$output .= '<div class="gt-event-search-results">';
					$output .= '<div class="gt-columns gt-' . esc_attr( $column ) . ' gt-column-space-' . esc_attr( $atts["column-space"] ) . '">';

						while( $wp_query->have_posts() ) {

							$wp_query->the_post();

							if( $atts["style"] == "style2" ) {

								$output .= '<div class="gt-col">';
									$output .= '<div class="gt-inner">';
										$output .= eventchamp_event_list_style_3( $post_id = get_the_ID(), $image = "true", $category = esc_attr( $category_status ), $start_date = esc_attr( $date_status ), $end_date = esc_attr( $end_date_status ), $location = esc_attr( $location_status ), $excerpt = esc_attr( $excerpt_status ), $status = esc_attr( $status_status ), $price = esc_attr( $price_status ), $venue = esc_attr( $venue_status ), $ticket_amount = esc_attr( $ticket_amount_status ), $start_time = esc_attr( $start_time_status ), $end_time = esc_attr( $end_time_status ), $organizer = esc_attr( $organizer_status ) );
									$output .= '</div>';
								$output .= '</div>';

							} elseif( $atts["style"] == "style3" ) {

								$output .= '<div class="gt-col">';
									$output .= '<div class="gt-inner">';
										$output .= eventchamp_event_list_style_4( $post_id = get_the_ID(), $image = "true", $category = esc_attr( $category_status ), $start_date = esc_attr( $date_status ), $end_date = esc_attr( $end_date_status ), $location = esc_attr( $location_status ), $excerpt = esc_attr( $excerpt_status ), $status = esc_attr( $status_status ), $price = esc_attr( $price_status ), $venue = esc_attr( $venue_status ), $ticket_amount = esc_attr( $ticket_amount_status ), $start_time = esc_attr( $start_time_status ), $end_time = esc_attr( $end_time_status ), $organizer = esc_attr( $organizer_status ) );
									$output .= '</div>';
								$output .= '</div>';

							} elseif( $atts["style"] == "style4" ) {

								$output .= '<div class="gt-col">';
									$output .= '<div class="gt-inner">';
										$output .= eventchamp_event_list_style_2( $post_id = get_the_ID(), $image = "true", $category = esc_attr( $category_status ), $start_date = esc_attr( $date_status ), $end_date = esc_attr( $end_date_status ), $location = esc_attr( $location_status ), $status = esc_attr( $status_status ), $price = esc_attr( $price_status ), $venue = esc_attr( $venue_status ), $ticket_amount = esc_attr( $ticket_amount_status ), $start_time = esc_attr( $start_time_status ), $end_time = esc_attr( $end_time_status ), $organizer = esc_attr( $organizer_status ) );
									$output .= '</div>';
								$output .= '</div>';

							} else {

								$output .= '<div class="gt-col">';
									$output .= '<div class="gt-inner">';
										$output .= eventchamp_event_list_style_1( $post_id = get_the_ID(), $image = "true", $category = esc_attr( $category_status ), $start_date = esc_attr( $date_status ), $end_date = esc_attr( $end_date_status ), $location = esc_attr( $location_status ), $excerpt = esc_attr( $excerpt_status ), $status = esc_attr( $status_status ), $price = esc_attr( $price_status ), $venue = esc_attr( $venue_status ), $ticket_amount = esc_attr( $ticket_amount_status ), $start_time = esc_attr( $start_time_status ), $end_time = esc_attr( $end_time_status ), $organizer = esc_attr( $organizer_status ) );
									$output .= '</div>';
								$output .= '</div>';

							}
							
						}

					$output .= '</div>';

					if( $atts['pagination'] == 'true' ) {

						$output .= eventchamp_element_pagination( $paged = $paged, $query = $wp_query );

					}

				$output .= '</div>';

			} else {

				$output .= wpautop( esc_html__( 'There are no results that match your search.', 'eventchamp-core' ) );

			}

		}
		wp_reset_postdata();

		return $output;

	}
	add_shortcode( "eventchamp_events_search_results", "eventchamp_events_search_results_output" );

	if( function_exists( 'vc_map' ) ) {

		vc_map(
			array(
				"name" => esc_html__( 'Event Search Results', 'eventchamp-core' ),
				"base" => "eventchamp_events_search_results",
				"category" => esc_html__( 'Eventchamp Theme', 'eventchamp-core' ),
				"icon" => get_template_directory_uri() . '/include/assets/img/icons/event-search-results.jpg',
				"description" => esc_html__( 'Show the event search results', 'eventchamp-core' ),
				"params" => array(
				array(
					"type" => "textfield",
					"param_name" => "eventcount",
					"heading" => esc_html__( 'Count', 'eventchamp-core' ),
					"group" => esc_html__( 'General', 'eventchamp-core' ),
					'admin_label' => true,
					'save_always' => true,
				),
				array(
					"type" => "textfield",
					"param_name" => "eventids",
					"heading" => esc_html__( 'Include Events', 'eventchamp-core' ),
					"description" => esc_html__( 'Separate with commas. Example: 1, 2, 3 etc.', 'eventchamp-core' ),
					"group" => esc_html__( 'General', 'eventchamp-core' ),
					'save_always' => true,
				),
				array(
					"type" => "textfield",
					"param_name" => "excludeevents",
					"heading" => esc_html__( 'Exclude Events', 'eventchamp-core' ),
					"description" => esc_html__( 'Separate with commas. Example: 1, 2, 3 etc.', 'eventchamp-core' ),
					"group" => esc_html__( 'General', 'eventchamp-core' ),
					'save_always' => true,
				),
				array(
					"type" => "textfield",
					"param_name" => "offset",
					"heading" => esc_html__( 'Offset', 'eventchamp-core' ),
					"description" => esc_html__( 'You can enter an offset number.', 'eventchamp-core' ),
					"group" => esc_html__( 'General', 'eventchamp-core' ),
					'save_always' => true,
				),
				array(
					"type" => "dropdown",
					"param_name" => "order",
					"heading" => esc_html__( 'Default Order', 'eventchamp-core' ),
					"description" => esc_html__( 'If you do not choose an order type on the event search tool, this option will apply.', 'eventchamp-core' ),
					"group" => esc_html__( 'General', 'eventchamp-core' ),
					"save_always" => true,
					"value" => array(
						esc_html__( 'DESC', 'eventchamp-core' ) => 'DESC',
						esc_html__( 'ASC', 'eventchamp-core' ) => 'ASC',
					),
				),
				array(
					"type" => "dropdown",
					"param_name" => "order-type",
					"heading" => esc_html__( 'Default Order Type', 'eventchamp-core' ),
					"description" => esc_html__( 'If you do not choose an order type on search tool this option visible.', 'eventchamp-core' ),
					"group" => esc_html__( 'General', 'eventchamp-core' ),
					"save_always" => true,
					"value" => array(
						esc_html__( 'Added Date', 'eventchamp-core' ) => 'added-date',
						esc_html__( 'Event Date', 'eventchamp-core' ) => 'event-date',
						esc_html__( 'Price', 'eventchamp-core' ) => 'price',
						esc_html__( 'Popular by Comment', 'eventchamp-core' ) => 'popular-comment',
						esc_html__( 'ID', 'eventchamp-core' ) => 'id',
						esc_html__( 'Title', 'eventchamp-core' ) => 'title',
						esc_html__( 'Menu Order', 'eventchamp-core' ) => 'menu_order',
						esc_html__( 'Random', 'eventchamp-core' ) => 'rand',
						esc_html__( 'By Include IDs', 'eventchamp-core' ) => 'post__in',
						esc_html__( 'None', 'eventchamp-core' ) => 'none',
					),
				),
				array(
					"type" => "dropdown",
					"param_name" => "hideexpired",
					"heading" => esc_html__( 'Hide Expired Events', 'eventchamp-core' ),
					"group" => esc_html__( 'General', 'eventchamp-core' ),
					'save_always' => true,
					"value" => array(
						esc_html__( 'False', 'eventchamp-core' ) => 'false',
						esc_html__( 'True', 'eventchamp-core' ) => 'true',
					),
				),
				array(
					"type" => "dropdown",
					"param_name" => "pagination",
					"heading" => esc_html__( 'Pagination', 'eventchamp-core' ),
					"group" => esc_html__( 'General', 'eventchamp-core' ),
					'save_always' => true,
					"value" => array(
						esc_html__( 'False', 'eventchamp-core' ) => 'false',
						esc_html__( 'True', 'eventchamp-core' ) => 'true',
					),
				),
				array(
					"type" => "textfield",
					"param_name" => "excludecategories",
					"heading" => esc_html__( 'Exclude Categories', 'eventchamp-core' ),
					"description" => esc_html__( 'Separate with commas. Example: 1, 2, 3 etc.', 'eventchamp-core' ),
					"group" => esc_html__( 'Taxonomies', 'eventchamp-core' ),
					'save_always' => true,
				),
				array(
					"type" => "textfield",
					"param_name" => "exclude-locations",
					"heading" => esc_html__( 'Exclude Locations', 'eventchamp-core' ),
					"description" => esc_html__( 'Separate with commas. Example: 1, 2, 3 etc.', 'eventchamp-core' ),
					"group" => esc_html__( 'Taxonomies', 'eventchamp-core' ),
					'save_always' => true,
				),
				array(
					"type" => "textfield",
					"param_name" => "exclude-organizers",
					"heading" => esc_html__( 'Exclude Organizers', 'eventchamp-core' ),
					"description" => esc_html__( 'Separate with commas. Example: 1, 2, 3 etc.', 'eventchamp-core' ),
					"group" => esc_html__( 'Taxonomies', 'eventchamp-core' ),
					'save_always' => true,
				),
				array(
					"type" => "textfield",
					"param_name" => "exclude-tags",
					"heading" => esc_html__( 'Exclude Tags', 'eventchamp-core' ),
					"description" => esc_html__( 'Separate with commas. Example: 1, 2, 3 etc.', 'eventchamp-core' ),
					"group" => esc_html__( 'Taxonomies', 'eventchamp-core' ),
					'save_always' => true,
				),
				array(
					"type" => "textfield",
					"param_name" => "includecategories",
					"heading" => esc_html__( 'Include Categories', 'eventchamp-core' ),
					"description" => esc_html__( 'Separate with commas. Example: 1, 2, 3 etc.', 'eventchamp-core' ),
					"group" => esc_html__( 'Taxonomies', 'eventchamp-core' ),
					'save_always' => true,
				),
				array(
					"type" => "textfield",
					"param_name" => "include-locations",
					"heading" => esc_html__( 'Include Locations', 'eventchamp-core' ),
					"description" => esc_html__( 'Separate with commas. Example: 1, 2, 3 etc.', 'eventchamp-core' ),
					"group" => esc_html__( 'Taxonomies', 'eventchamp-core' ),
					'save_always' => true,
				),
				array(
					"type" => "textfield",
					"param_name" => "include-organizers",
					"heading" => esc_html__( 'Include Organizers', 'eventchamp-core' ),
					"description" => esc_html__( 'Separate with commas. Example: 1, 2, 3 etc.', 'eventchamp-core' ),
					"group" => esc_html__( 'Taxonomies', 'eventchamp-core' ),
					'save_always' => true,
				),
				array(
					"type" => "textfield",
					"param_name" => "include-tags",
					"heading" => esc_html__( 'Include Tag', 'eventchamp-core' ),
					"description" => esc_html__( 'Example: Event', 'eventchamp-core' ),
					"group" => esc_html__( 'Taxonomies', 'eventchamp-core' ),
					'save_always' => true,
				),
				array(
					"type" => "dropdown",
					"param_name" => "style",
					"heading" => esc_html__( 'Style', 'eventchamp-core' ),
					"group" => esc_html__( 'Design', 'eventchamp-core' ),
					'save_always' => true,
					"value" => array(
						esc_html__( 'Style 1', 'eventchamp-core' ) => 'style1',
						esc_html__( 'Style 2', 'eventchamp-core' ) => 'style2',
						esc_html__( 'Style 3', 'eventchamp-core' ) => 'style3',
						esc_html__( 'Style 4', 'eventchamp-core' ) => 'style4',
					),
				),
				array(
					"type" => "dropdown",
					"param_name" => "column",
					"heading" => esc_html__( 'Column', 'eventchamp-core' ),
					"group" => esc_html__( 'Design', 'eventchamp-core' ),
					'save_always' => true,
					"value" => array(
						esc_html__( '1 Column', 'eventchamp-core' ) => 'column-1',
						esc_html__( '2 Column', 'eventchamp-core' ) => 'column-2',
						esc_html__( '3 Column', 'eventchamp-core' ) => 'column-3',
						esc_html__( '4 Column', 'eventchamp-core' ) => 'column-4',
						esc_html__( '5 Column', 'eventchamp-core' ) => 'column-5',
						esc_html__( '6 Column', 'eventchamp-core' ) => 'column-6',
					),
				),
				array(
					"type" => "dropdown",
					"param_name" => "column-space",
					"heading" => esc_html__( 'Column Space', 'eventchamp-core' ),
					"group" => esc_html__( 'Design', 'eventchamp-core' ),
					'save_always' => true,
					"value" => array(
						esc_html__( '0', 'eventchamp-core' ) => '0',
						esc_html__( '5', 'eventchamp-core' ) => '5',
						esc_html__( '10', 'eventchamp-core' ) => '10',
						esc_html__( '15', 'eventchamp-core' ) => '15',
						esc_html__( '20', 'eventchamp-core' ) => '20',
						esc_html__( '25', 'eventchamp-core' ) => '25',
						esc_html__( '30', 'eventchamp-core' ) => '30',
						esc_html__( '35', 'eventchamp-core' ) => '35',
						esc_html__( '40', 'eventchamp-core' ) => '40',
						esc_html__( '45', 'eventchamp-core' ) => '45',
						esc_html__( '50', 'eventchamp-core' ) => '50',
						esc_html__( '55', 'eventchamp-core' ) => '55',
						esc_html__( '60', 'eventchamp-core' ) => '60',
					),
				),
				array(
					"type" => "dropdown",
					"param_name" => "price",
					"heading" => esc_html__( 'Price', 'eventchamp-core' ),
					"group" => esc_html__( 'Design', 'eventchamp-core' ),
					'save_always' => true,
					"value" => array(
						esc_html__( 'False', 'eventchamp-core' ) => 'false',
						esc_html__( 'True', 'eventchamp-core' ) => 'true',
					),
				),
				array(
					"type" => "dropdown",
					"param_name" => "status",
					"heading" => esc_html__( 'Status', 'eventchamp-core' ),
					"group" => esc_html__( 'Design', 'eventchamp-core' ),
					'save_always' => true,
					"value" => array(
						esc_html__( 'False', 'eventchamp-core' ) => 'false',
						esc_html__( 'True', 'eventchamp-core' ) => 'true',
					),
				),
				array(
					"type" => "dropdown",
					"param_name" => "category",
					"heading" => esc_html__( 'Category', 'eventchamp-core' ),
					"group" => esc_html__( 'Design', 'eventchamp-core' ),
					'save_always' => true,
					"value" => array(
						esc_html__( 'False', 'eventchamp-core' ) => 'false',
						esc_html__( 'True', 'eventchamp-core' ) => 'true',
					),
				),
				array(
					"type" => "dropdown",
					"param_name" => "location",
					"heading" => esc_html__( 'Location', 'eventchamp-core' ),
					"group" => esc_html__( 'Design', 'eventchamp-core' ),
					'save_always' => true,
					"value" => array(
						esc_html__( 'False', 'eventchamp-core' ) => 'false',
						esc_html__( 'True', 'eventchamp-core' ) => 'true',
					),
				),
				array(
					"type" => "dropdown",
					"param_name" => "venue",
					"heading" => esc_html__( 'Venue', 'eventchamp-core' ),
					"group" => esc_html__( 'Design', 'eventchamp-core' ),
					'save_always' => true,
					"value" => array(
						esc_html__( 'False', 'eventchamp-core' ) => 'false',
						esc_html__( 'True', 'eventchamp-core' ) => 'true',
					),
				),
				array(
					"type" => "dropdown",
					"param_name" => "organizer",
					"heading" => esc_html__( 'Organizer', 'eventchamp-core' ),
					"group" => esc_html__( 'Design', 'eventchamp-core' ),
					'save_always' => true,
					"value" => array(
						esc_html__( 'False', 'eventchamp-core' ) => 'false',
						esc_html__( 'True', 'eventchamp-core' ) => 'true',
					),
				),
				array(
					"type" => "dropdown",
					"param_name" => "date",
					"heading" => esc_html__( 'Start Date', 'eventchamp-core' ),
					"group" => esc_html__( 'Design', 'eventchamp-core' ),
					'save_always' => true,
					"value" => array(
						esc_html__( 'False', 'eventchamp-core' ) => 'false',
						esc_html__( 'True', 'eventchamp-core' ) => 'true',
					),
				),
				array(
					"type" => "dropdown",
					"param_name" => "start-time",
					"heading" => esc_html__( 'Start Time', 'eventchamp-core' ),
					"group" => esc_html__( 'Design', 'eventchamp-core' ),
					'save_always' => true,
					"value" => array(
						esc_html__( 'False', 'eventchamp-core' ) => 'false',
						esc_html__( 'True', 'eventchamp-core' ) => 'true',
					),
				),
				array(
					"type" => "dropdown",
					"param_name" => "end-date",
					"heading" => esc_html__( 'End Date', 'eventchamp-core' ),
					"group" => esc_html__( 'Design', 'eventchamp-core' ),
					'save_always' => true,
					"value" => array(
						esc_html__( 'False', 'eventchamp-core' ) => 'false',
						esc_html__( 'True', 'eventchamp-core' ) => 'true',
					),
				),
				array(
					"type" => "dropdown",
					"param_name" => "end-time",
					"heading" => esc_html__( 'End Time', 'eventchamp-core' ),
					"group" => esc_html__( 'Design', 'eventchamp-core' ),
					'save_always' => true,
					"value" => array(
						esc_html__( 'False', 'eventchamp-core' ) => 'false',
						esc_html__( 'True', 'eventchamp-core' ) => 'true',
					),
				),
				array(
					"type" => "dropdown",
					"param_name" => "ticket-amount",
					"heading" => esc_html__( 'Ticket Amount', 'eventchamp-core' ),
					"group" => esc_html__( 'Design', 'eventchamp-core' ),
					'save_always' => true,
					"value" => array(
						esc_html__( 'False', 'eventchamp-core' ) => 'false',
						esc_html__( 'True', 'eventchamp-core' ) => 'true',
					),
				),
				array(
					"type" => "dropdown",
					"param_name" => "excerpt",
					"heading" => esc_html__( 'Excerpt', 'eventchamp-core' ),
					"group" => esc_html__( 'Design', 'eventchamp-core' ),
					'save_always' => true,
					"value" => array(
						esc_html__( 'False', 'eventchamp-core' ) => 'false',
						esc_html__( 'True', 'eventchamp-core' ) => 'true',
					),
				),
				),
			)
		);

	}

}