<?php
/*======
*
* Countdown
*
======*/
if( !function_exists( 'eventchamp_countdown_output' ) ) {

	function eventchamp_countdown_output( $atts, $content = null ) {

		/*====== Atts ======*/
		$atts = shortcode_atts(
			array(
				'style' => '1',
				'date' => '',
				'day-text' => '',
				'hour-text' => '',
				'minute-text' => '',
				'second-text' => '',
			), $atts
		);

		/*====== Day Text ======*/
		$rand_id = rand( 0, 99999 );

		/*====== Day Text ======*/
		if( empty( $atts["day-text"] ) ) {

			$day_text = esc_html__( 'Days', 'eventchamp-core' );

		} else {

			$day_text = esc_attr( $atts["day-text"] );

		}

		/*====== Hour Text ======*/
		if( empty( $atts["hour-text"] ) ) {

			$hour_text = esc_html__( 'Hours', 'eventchamp-core' );

		} else {

			$hour_text = esc_attr( $atts["hour-text"] );

		}

		/*====== Minute Text ======*/
		if( empty( $atts["minute-text"] ) ) {

			$minute_text = esc_html__( 'Minutes', 'eventchamp-core' );

		} else {

			$minute_text = esc_attr( $atts["minute-text"] );

		}

		/*====== Second Text ======*/
		if( empty( $atts["second-text"] ) ) {

			$second_text = esc_html__( 'Seconds', 'eventchamp-core' );

		} else {

			$second_text = esc_attr( $atts["second-text"] );

		}

		/*====== HTML Output ======*/
		$output = '';

		if( !empty( $atts["date"] ) ) {

			$output .= '<div class="gt-countdown gt-style-' . esc_attr( $atts["style"] ) . '" id="gt-countdown-' . esc_attr( $rand_id ) . '">';

				$output .= '<ul>';
					$output .= '<li class="gt-day">';
						$output .= '<div class="gt-inner">';
							$output .= '<div class="gt-count"></div>';
							$output .= '<div class="gt-title">' . esc_attr( $day_text ) . '</div>';
						$output .= '</div>';
					$output .= '</li>';
					$output .= '<li class="gt-hour">';
						$output .= '<div class="gt-inner">';
							$output .= '<div class="gt-count"></div>';
							$output .= '<div class="gt-title">' . esc_attr( $hour_text ) . '</div>';
						$output .= '</div>';
					$output .= '</li>';
					$output .= '<li class="gt-minute">';
						$output .= '<div class="gt-inner">';
							$output .= '<div class="gt-count"></div>';
							$output .= '<div class="gt-title">' . esc_attr( $minute_text ) . '</div>';
						$output .= '</div>';
					$output .= '</li>';
					$output .= '<li class="gt-second">';
						$output .= '<div class="gt-inner">';
							$output .= '<div class="gt-count"></div>';
							$output .= '<div class="gt-title">' . esc_attr( $second_text ) . '</div>';
						$output .= '</div>';
					$output .= '</li>';
				$output .= '</ul>';

				$output .= "<script type='text/javascript'>
					jQuery(document).ready(function($){
						$('#gt-countdown-" . esc_attr( $rand_id ) . "').countdown('" . date( 'Y/m/d H:i:s', strtotime( $atts["date"] ) ) . "', function(event) {
							$('.gt-day .gt-count').html(event.strftime('%D'));
							$('.gt-hour .gt-count').html(event.strftime('%H'));
							$('.gt-minute .gt-count').html(event.strftime('%M'));
							$('.gt-second .gt-count').html(event.strftime('%S'));
						});
					});
				</script>";

			$output .= '</div>';

		}

		return $output;

	}
	add_shortcode( "eventchamp_countdown", "eventchamp_countdown_output" );

	if( function_exists( 'vc_map' ) ) {

		vc_map(
			array(
				"name" => esc_html__( 'Countdown', 'eventchamp-core' ),
				"base" => "eventchamp_countdown",
				"category" => esc_html__( 'Eventchamp Theme', 'eventchamp-core' ),
				"icon" => get_template_directory_uri() . '/include/assets/img/icons/countdown.jpg',
				"description" => esc_html__( 'A countdown block', 'eventchamp-core' ),
				"params" => array(
					array(
						"type" => "dropdown",
						"param_name" => "style",
						"heading" => esc_html__( 'Style', 'eventchamp-core' ),
						'save_always' => true,
						'admin_label' => true,
						"value" => array(
							esc_html__( 'Style 1', 'eventchamp-core' ) => '1',
							esc_html__( 'Style 2', 'eventchamp-core' ) => '2',
							esc_html__( 'Style 3', 'eventchamp-core' ) => '3',
							esc_html__( 'Style 4', 'eventchamp-core' ) => '4',
						),
					),
					array(
						"type" => "textfield",
						"param_name" => "date",
						"heading" => esc_html__( 'Date', 'eventchamp-core' ),
						"description" => esc_html__( 'Enter date with this format: 2020/09/23 10:24:00', 'eventchamp-core' ),
						'save_always' => true,
						'admin_label' => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "day-text",
						"heading" => esc_html__( 'Day Text', 'eventchamp-core' ),
						"description" => esc_html__( 'Default: Days.', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "hour-text",
						"heading" => esc_html__( 'Hour Text', 'eventchamp-core' ),
						"description" => esc_html__( 'Default: Hours.', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "minute-text",
						"heading" => esc_html__( 'Minute Text', 'eventchamp-core' ),
						"description" => esc_html__( 'Default: Minutes.', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "second-text",
						"heading" => esc_html__( 'Second Text', 'eventchamp-core' ),
						"description" => esc_html__( 'Default: Seconds.', 'eventchamp-core' ),
						'save_always' => true,
					),
				),
			)
		);

	}

}