<?php
/*======
*
* Button
*
======*/
if( !function_exists( 'eventchamp_button_output' ) ) {

	function eventchamp_button_output( $atts, $content = null ) {

		/*====== Atts ======*/
		$atts = shortcode_atts(
			array(
				'style' => '1',
				'align' => 'left',
				'buttonlink' => '',
				'icon' => '',
				'svg-icon' => '',
				'inline' => '',
				'margin' => '',
			), $atts
		);

		/*====== HTML Output ======*/
		$output = '';

		if( !empty( $atts["buttonlink"] ) ) {

			$href = vc_build_link( $atts["buttonlink"] );

			if( !empty( $href["target"] ) ) {

				$target = $href["target"];

			} else {

				$target = "_parent";

			}

			if( !empty( $href["url"] ) ) {

				$output .= '<div class="gt-button gt-style-' . esc_attr( $atts["style"] ) . ' gt-align-' . esc_attr( $atts["align"] ) . ' gt-inline-' . esc_attr( $atts["inline"] ) . ' gt-margin-' . esc_attr( $atts["margin"] ) . '">';

					$output .= '<a href="' . esc_url( $href["url"] ) . '" target="' . esc_attr( $target ) . '">';

						if( !empty( $atts["icon"] ) ) {

							$output .= '<i class="' . esc_attr( $atts["icon"] ) . '"></i>';

						} elseif( !empty( $atts["svg-icon"] ) ) {

							$output .= rawurldecode( base64_decode( $atts["svg-icon"] ) );

						}

						$output .= '<span>' . esc_attr( $href["title"] ) . '</span>';
					$output .= '</a>';
				$output .= '</div>';

			}

		}

		return $output;

	}
	add_shortcode( "eventchamp_button", "eventchamp_button_output" );

	if( function_exists( 'vc_map' ) ) {

		vc_map(
			array(
				"name" => esc_html__( 'Button', 'eventchamp-core' ),
				"base" => "eventchamp_button",
				"category" => esc_html__( 'Eventchamp Theme', 'eventchamp-core' ),
				"icon" => get_template_directory_uri() . '/include/assets/img/icons/button.jpg',
				"description" => esc_html__( 'Create a button', 'eventchamp-core' ),
				"params" => array(
					array(
						"type" => "dropdown",
						"param_name" => "style",
						"heading" => esc_html__( 'Style', 'eventchamp-core' ),
						"admin_label" => true,
						"save_always" => true,
						"value" => array(
							esc_html__( 'Style 1', 'eventchamp-core' ) => '1',
							esc_html__( 'Style 2', 'eventchamp-core' ) => '2',
							esc_html__( 'Style 3', 'eventchamp-core' ) => '3',
							esc_html__( 'Style 4', 'eventchamp-core' ) => '4',
							esc_html__( 'Style 5', 'eventchamp-core' ) => '5',
							esc_html__( 'Style 6', 'eventchamp-core' ) => '6',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "align",
						"heading" => esc_html__( 'Align', 'eventchamp-core' ),
						"save_always" => true,
						"value" => array(
							esc_html__( 'Left', 'eventchamp-core' ) => 'left',
							esc_html__( 'Center', 'eventchamp-core' ) => 'center',
							esc_html__( 'Right', 'eventchamp-core' ) => 'right',
						),
					),
					array(
						"type" => "vc_link",
						"param_name" => "buttonlink",
						"heading" => esc_html__( 'Button Link', 'eventchamp-core' ),
						"save_always" => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "icon",
						"heading" => esc_html__( 'Icon', 'eventchamp-core' ),
						"description" => esc_html__( 'If you want to use SVG icon, enter blank it. Example: fab fa-wordpress-simple, fas fa-map-marker-alt. Icon list: https://goo.gl/vdPEsc', 'eventchamp-core' ),
						"save_always" => true,
					),
					array(
						"type" => "textarea_raw_html",
						"param_name" => "svg-icon",
						"heading" => esc_html__( 'SVG Icon', 'eventchamp-core' ),
						"save_always" => true,
					),
					array(
						"type" => "dropdown",
						"param_name" => "inline",
						"heading" => esc_html__( 'Inline', 'eventchamp-core' ),
						"save_always" => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "margin",
						"heading" => esc_html__( 'Margin', 'eventchamp-core' ),
						"save_always" => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
				),
			)
		);

	}

}