<?php
/*======
*
* Banner Box
*
======*/
if( !function_exists( 'eventchamp_banner_output' ) ) {

	function eventchamp_banner_output( $atts, $content = null ) {

		/*====== Atts ======*/
		$atts = shortcode_atts(
			array(
				'bannertitleone' => '',
				'bannertitletwo' => '',
				'link' => '',
				'bannerbg' => '',
			), $atts
		);

		/*====== Lazy Load ======*/
		$lazy_load = ot_get_option( 'lazy-load', 'off' );

		/*====== HTML Output ======*/
		$output = "";

		if( !empty( $atts["bannertitleone"] ) or !empty( $atts["bannertitletwo"] ) ) {

			if( !empty( $atts["link"] ) ) {

				$href = $atts["link"];
				$href = vc_build_link( $href );

				if( !empty( $href["target"] ) ) {

					$target = $href["target"];

				} else {

					$target = "_parent";

				}

			}

			if( !empty( $atts["bannerbg"] ) ) {

				$bannerbg = esc_attr( $atts["bannerbg"] );

			} else {

				$bannerbg = "";

			}

			if( $lazy_load == "on" ) {

				$output .= '<div class="gt-banner-box gt-lazy-load" data-bg="' . esc_url( wp_get_attachment_url( esc_attr( $bannerbg ), 'full', true, true ) ) . '">';

			} else {

				$output .= '<div class="gt-banner-box" style="background-image:url(' . esc_url( wp_get_attachment_url( esc_attr( $bannerbg ), 'full', true, true ) ) . ');">';

			}

				if( !empty( $atts["link"] ) ) {

					$output .= '<a href="' . esc_url( $href["url"] ) . '" target="' . esc_attr( $target ) . '">';

				}

					$output .= '<div class="gt-content">';

						if( !empty( $atts["bannertitleone"] ) ) {

							$output .= '<span class="primary">' . esc_attr( $atts["bannertitleone"] ) . '</span>';

						}

						if( !empty( $atts["bannertitletwo"] ) ) {

							$output .= '<span class="secondary">' . esc_attr( $atts["bannertitletwo"] ) . '</span>';

						}

					$output .= '</div>';

				if( !empty( $atts["link"] ) ) {

					$output .= '</a>';

				}

			$output .= '</div>';

		}

		return $output;

	}
	add_shortcode( "eventchamp_banner", "eventchamp_banner_output" );

	if( function_exists( 'vc_map' ) ) {

		vc_map(
			array(
				"name" => esc_html__( 'Banner Box', 'eventchamp-core' ),
				"base" => "eventchamp_banner",
				"category" => esc_html__( 'Eventchamp Theme', 'eventchamp-core' ),
				"icon" => get_template_directory_uri() . '/include/assets/img/icons/banner-box.jpg',
				"description" => esc_html__( 'Create creative banner boxes', 'eventchamp-core' ),
				"params" => array(
					array(
						"type" => "textfield",
						"param_name" => "bannertitleone",
						"heading" => esc_html__( 'Primary Title', 'eventchamp-core' ),
						"admin_label" => true,
						"save_always" => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "bannertitletwo",
						"heading" => esc_html__( 'Secondary Title', 'eventchamp-core' ),
						"admin_label" => true,
						"save_always" => true,
					),
					array(
						"type" => "vc_link",
						"param_name" => "link",
						"heading" => esc_html__( 'Link', 'eventchamp-core' ),
						"save_always" => true,
					),
					array(
						"type" => "attach_image",
						"param_name" => "bannerbg",
						"heading" => esc_html__( 'Image', 'eventchamp-core' ),
						"save_always" => true,
					),
				),
			)
		);

	}

}