<?php
/*======
*
* App Box
*
======*/
if( !function_exists( 'eventchamp_app_box_output' ) ) {

	function eventchamp_app_box_output( $atts, $content = null ) {

		/*====== Atts ======*/
		$atts = shortcode_atts(
			array(
				'applestore' => '',
				'googleplay' => '',
				'windowstore' => '',
				'amazon' => '',
			), $atts
		);

		/*====== HTML Output ======*/
		$output = '';

		if( !empty( $atts["applestore"] ) or !empty( $atts["googleplay"] ) or !empty( $atts["windowstore"] ) or !empty( $atts["amazon"] ) ) {

			$output .= '<div class="gt-app-box">';

				if( !empty( $atts["applestore"] ) ) {

					$href = $atts["applestore"];
					$href = vc_build_link( $href );

					if( !empty( $href["target"] ) ) {

						$target = $href["target"];

					} else {
						
						$target = "_parent";

					}

					if( !empty( $href["url"] ) ) {

						$output .= '<div class="gt-item gt-applestore">';
							$output .= '<a href="' . esc_url( $href["url"] ) . '" target="' . esc_attr( $target ) . '">';
								$output .= '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 384 512"><path fill="currentColor" d="M318.7 268.7c-.2-36.7 16.4-64.4 50-84.8-18.8-26.9-47.2-41.7-84.7-44.6-35.5-2.8-74.3 20.7-88.5 20.7-15 0-49.4-19.7-76.4-19.7C63.3 141.2 4 184.8 4 273.5q0 39.3 14.4 81.2c12.8 36.7 59 126.7 107.2 125.2 25.2-.6 43-17.9 75.8-17.9 31.8 0 48.3 17.9 76.4 17.9 48.6-.7 90.4-82.5 102.6-119.3-65.2-30.7-61.7-90-61.7-91.9zm-56.6-164.2c27.3-32.4 24.8-61.9 24-72.5-24.1 1.4-52 16.4-67.9 34.9-17.5 19.8-27.8 44.3-25.6 71.9 26.1 2 49.9-11.4 69.5-34.3z"></path></svg>';
								$output .= '<div class="gt-inner">';
									$output .= '<span class="gt-name">' . esc_html__( 'Download via', 'eventchamp-core' ) . '</span>';
									$output .= '<span class="gt-app-name">' . esc_html__( 'Apple Store', 'eventchamp-core' ) . '</span>';
								$output .= '</div>';
							$output .= '</a>';
						$output .= '</div>';

					}

				}

				if( !empty( $atts["googleplay"] ) ) {

					$href = $atts["googleplay"];
					$href = vc_build_link( $href );

					if( !empty( $href["target"] ) ) {

						$target = $href["target"];

					} else {

						$target = "_parent";

					}

					if( !empty( $href["url"] ) ) {

						$output .= '<div class="gt-item gt-googleplay">';
							$output .= '<a href="' . esc_url( $href["url"] ) . '" target="' . esc_attr( $target ) . '">';
								$output .= '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path fill="currentColor" d="M325.3 234.3L104.6 13l280.8 161.2-60.1 60.1zM47 0C34 6.8 25.3 19.2 25.3 35.3v441.3c0 16.1 8.7 28.5 21.7 35.3l256.6-256L47 0zm425.2 225.6l-58.9-34.1-65.7 64.5 65.7 64.5 60.1-34.1c18-14.3 18-46.5-1.2-60.8zM104.6 499l280.8-161.2-60.1-60.1L104.6 499z"></path></svg>';
								$output .= '<div class="gt-inner">';
									$output .= '<span class="gt-name">' . esc_html__( 'Download via', 'eventchamp-core' ) . '</span>';
									$output .= '<span class="gt-app-name">' . esc_html__( 'Google Play', 'eventchamp-core' ) . '</span>';
								$output .= '</div>';
							$output .= '</a>';
						$output .= '</div>';

					}

				}

				if( !empty( $atts["windowstore"] ) ) {

					$href = $atts["windowstore"];
					$href = vc_build_link( $href );

					if( !empty( $href["target"] ) ) {

						$target = $href["target"];

					} else {

						$target = "_parent";

					}

					if( !empty( $href["url"] ) ) {

						$output .= '<div class="gt-item gt-windowstore">';
							$output .= '<a href="' . esc_url( $href["url"] ) . '" target="' . esc_attr( $target ) . '">';
								$output .= '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path fill="currentColor" d="M0 93.7l183.6-25.3v177.4H0V93.7zm0 324.6l183.6 25.3V268.4H0v149.9zm203.8 28L448 480V268.4H203.8v177.9zm0-380.6v180.1H448V32L203.8 65.7z"></path></svg>';
								$output .= '<div class="gt-inner">';
									$output .= '<span class="gt-name">' . esc_html__( 'Download via', 'eventchamp-core' ) . '</span>';
									$output .= '<span class="gt-app-name">' . esc_html__( 'Windows', 'eventchamp-core' ) . '</span>';
								$output .= '</div>';
							$output .= '</a>';
						$output .= '</div>';

					}

				}

				if( !empty( $atts["amazon"] ) ) {

					$href = $atts["amazon"];
					$href = vc_build_link( $href );

					if( !empty( $href["target"] ) ) {

						$target = $href["target"];

					} else {

						$target = "_parent";

					}

					if( !empty( $href["url"] ) ) {

						$output .= '<div class="gt-item gt-amazon">';
							$output .= '<a href="' . esc_url( $href["url"] ) . '" target="' . esc_attr( $target ) . '">';
								$output .= '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path fill="currentColor" d="M257.2 162.7c-48.7 1.8-169.5 15.5-169.5 117.5 0 109.5 138.3 114 183.5 43.2 6.5 10.2 35.4 37.5 45.3 46.8l56.8-56S341 288.9 341 261.4V114.3C341 89 316.5 32 228.7 32 140.7 32 94 87 94 136.3l73.5 6.8c16.3-49.5 54.2-49.5 54.2-49.5 40.7-.1 35.5 29.8 35.5 69.1zm0 86.8c0 80-84.2 68-84.2 17.2 0-47.2 50.5-56.7 84.2-57.8v40.6zm136 163.5c-7.7 10-70 67-174.5 67S34.2 408.5 9.7 379c-6.8-7.7 1-11.3 5.5-8.3C88.5 415.2 203 488.5 387.7 401c7.5-3.7 13.3 2 5.5 12zm39.8 2.2c-6.5 15.8-16 26.8-21.2 31-5.5 4.5-9.5 2.7-6.5-3.8s19.3-46.5 12.7-55c-6.5-8.3-37-4.3-48-3.2-10.8 1-13 2-14-.3-2.3-5.7 21.7-15.5 37.5-17.5 15.7-1.8 41-.8 46 5.7 3.7 5.1 0 27.1-6.5 43.1z"></path></svg>';
								$output .= '<div class="gt-inner">';
									$output .= '<span class="gt-name">' . esc_html__( 'Download via', 'eventchamp-core' ) . '</span>';
									$output .= '<span class="gt-app-name">' . esc_html__( 'Amazon', 'eventchamp-core' ) . '</span>';
								$output .= '</div>';
							$output .= '</a>';
						$output .= '</div>';

					}

				}

			$output .= '</div>';

		}

		return $output;

	}
	add_shortcode( "eventchamp_app_box", "eventchamp_app_box_output" );

	if( function_exists( 'vc_map' ) ) {

		vc_map(
			array(
				"name" => esc_html__( 'App Box', 'eventchamp-core' ),
				"base" => "eventchamp_app_box",
				"category" => esc_html__( 'Eventchamp Theme', 'eventchamp-core' ),
				"icon" => get_template_directory_uri() . '/include/assets/img/icons/app-box.jpg',
				"description" => esc_html__( 'List the app websites', 'eventchamp-core' ),
				"params" => array(
					array(
						"type" => "vc_link",
						"param_name" => "applestore",
						"heading" => esc_html__( 'Apple Store', 'eventchamp-core' ),
						"description" => esc_html__( 'Enter the website URL.', 'eventchamp-core' ),
						"save_always" => true,
					),
					array(
						"type" => "vc_link",
						"param_name" => "googleplay",
						"heading" => esc_html__( 'Google Play', 'eventchamp-core' ),
						"description" => esc_html__( 'Enter the website URL.', 'eventchamp-core' ),
						"save_always" => true,
					),
					array(
						"type" => "vc_link",
						"param_name" => "windowstore",
						"heading" => esc_html__( 'Windows Store', 'eventchamp-core' ),
						"description" => esc_html__( 'Enter the website URL.', 'eventchamp-core' ),
						"save_always" => true,
					),
					array(
						"type" => "vc_link",
						"param_name" => "amazon",
						"heading" => esc_html__( 'Amazon', 'eventchamp-core' ),
						"description" => esc_html__( 'Enter the website URL.', 'eventchamp-core' ),
						"save_always" => true,
					),
				),
			)
		);

	}

}