<?php
if( class_exists( 'OT_Loader' ) ) {

	/*======
	*
	* Decode Fix
	*
	======*/
	if ( ! function_exists( 'ot_decode' ) ) {

		/**
		 * Helper function to return decoded arrays.
		 *
		 * @param  string $value Encoded serialized array.
		 *
		 * @return array
		 *
		 * @access public
		 * @since  2.0.13
		 */
		function ot_decode( $value ) {

			$fallback = array();
			$decoded  = base64_decode( $value ); // phpcs:ignore

			// Search for an array.
			preg_match( '/a:\d+:{.*?}/', $decoded, $array_matches, PREG_OFFSET_CAPTURE, 0 );

			// Search for an object.
			preg_match( '/O:\d+:"[a-z0-9_]+":\d+:{.*?}/i', $decoded, $obj_matches, PREG_OFFSET_CAPTURE, 0 );

			// Prevent object injection or non arrays.
			if ( $obj_matches || ! $array_matches ) {
				return $fallback;
			}

			// Convert the options to an array.
			$decoded = maybe_unserialize( $decoded );

			if ( is_array( $decoded ) ) {
				return $decoded;
			}

			return $fallback;
		}

	}



	/*======
	*
	* Fonts for Theme Options
	*
	======*/
	if( !class_exists( 'eventchamp_customizer_settings' ) ) {

		class eventchamp_customizer_settings {

			/*====== CSS Echo ======*/
			public function eventchamp_css_echo( $setting_id = "", $selector = "", $where = "", $default = "" ) {

				$css = '';
				$id_control = ot_get_option( $setting_id );

				if( !empty( $setting_id ) ) {

					//Background Fully
					if ( $where == 'background-all' ) {

						if ( !empty( $id_control ) ) {

							$setting_id = ot_get_option( $setting_id, array() );

							if( $setting_id['background-color'] | $setting_id['background-repeat'] | $setting_id['background-attachment'] | $setting_id['background-position'] | $setting_id['background-image'] ) {

								if( !empty( $setting_id['background-color'] ) ) {

									$css .= $selector;
									$css .= "{background-color: " . esc_attr( $setting_id['background-color'] ) . ";}";

								}

								if( !empty( $setting_id['background-repeat'] ) ) {

									$css .= $selector;
									$css .= "{background-repeat: " . esc_attr( $setting_id['background-repeat'] ) . ";}";

								}

								if( !empty( $setting_id['background-attachment'] ) ) {

									$css .= $selector;
									$css .= "{background-attachment: " . esc_attr( $setting_id['background-attachment'] ) . ";}";

								}

								if( !empty( $setting_id['background-position'] ) ) {

									$css .= $selector;
									$css .= "{background-position: " . esc_attr( $setting_id['background-position'] ) . ";}";

								}

								if( !empty( $setting_id['background-image'] ) ) {
									$css .= $selector;
									$css .= "{background-image: url(" . esc_url( $setting_id['background-image'] ) . ");}";
								}

								if( !empty( $setting_id['background-size'] ) ) {
									$css .= $selector;
									$css .= "{background-size: " . esc_attr( $setting_id['background-size'] ) . ";}";
								}

							}

						}

					} elseif ( $where == 'background' ) {

						if ( !empty( $id_control ) ) {

							$css .= $selector;
							$css .= '{background:' . ot_get_option( $setting_id ) . ';}';

						}

					} elseif ( $where == 'background-color' ) {

						if ( !empty( $id_control ) ) {

							$css .= $selector;
							$css .= '{background-color:' . esc_attr( ot_get_option( $setting_id ) ) . ';}';

						}

					} elseif ( $where == 'background-image' ) {

						if ( !empty( $id_control ) ) {

							$css .= $selector;
							$css .= '{background-image:url(' . esc_url( ot_get_option( $setting_id ) ) . ');}';

						}

					} elseif ( $where == 'border-color' ) {

						if ( !empty( $id_control ) ) {

							$css .= $selector;
							$css .= '{border-color:' . esc_attr( ot_get_option( $setting_id ) ) . ';}';

						}

					} elseif ( $where == 'border-top-color' ) {

						if ( !empty( $id_control ) ) {

							$css .= $selector;
							$css .= '{border-top-color:' . esc_attr( ot_get_option( $setting_id ) ) . ';}';

						}

					} elseif ( $where == 'border-bottom-color' ) {

						if ( !empty( $id_control ) ) {

							$css .= $selector;
							$css .= '{border-bottom-color:' . esc_attr( ot_get_option( $setting_id ) ) . ';}';

						}

					} elseif ( $where == 'color' ) {

						if ( !empty( $id_control ) ) {

							$css .= $selector;
							$css .= '{color:' . esc_attr( ot_get_option( $setting_id ) ) . ';}';

						}

					} elseif ( $where == 'fill' ) {

						if ( !empty( $id_control ) ) {

							$css .= $selector;
							$css .= '{fill:' . esc_attr( ot_get_option( $setting_id ) ) . ';}';

						}

					} elseif ( $where == 'stroke' ) {

						if ( !empty( $id_control ) ) {

							$css .= $selector;
							$css .= '{stroke:' . esc_attr( ot_get_option( $setting_id ) ) . ';}';

						}

					} elseif ( $where == 'max-height' ) {

						if ( !empty( $id_control ) ) {

							$css .= $selector;
							$css .= '{max-height:' . esc_attr( ot_get_option( $setting_id ) ) . ';}';

						}

					} elseif ( $where == 'margin' ) {

						if ( !empty( $id_control ) ) {

							$css .= $selector;
							$css .= '{margin:' . esc_attr( ot_get_option( $setting_id ) ) . ';}';

						}

					} elseif ( $where == 'top-margin' ) {

						if ( !empty( $id_control ) ) {

							$css .= $selector;
							$css .= '{margin-top:' . esc_attr( ot_get_option( $setting_id ) ) . ';}';

						}

					} elseif ( $where == 'bottom-margin' ) {

						if ( !empty( $id_control ) ) {

							$css .= $selector;
							$css .= '{margin-bottom:' . esc_attr( ot_get_option( $setting_id ) ) . ';}';

						}

					} elseif ( $where == 'left-margin' ) {

						if ( !empty( $id_control ) ) {

							$css .= $selector;
							$css .= '{margin-left:' . esc_attr( ot_get_option( $setting_id ) ) . ';}';

						}

					} elseif ( $where == 'right-margin' ) {

						if ( !empty( $id_control ) ) {

							$css .= $selector;
							$css .= '{margin-right:' . esc_attr( ot_get_option( $setting_id ) ) . ';}';

						}

					} elseif ( $where == 'padding' ) {

						if ( !empty( $id_control ) ) {

							$css .= $selector;
							$css .= '{padding:' . esc_attr( ot_get_option( $setting_id ) ) . ';}';

						}

					} elseif ( $where == 'top-padding' ) {

						if ( !empty( $id_control ) ) {

							$css .= $selector;
							$css .= '{padding-top:' . esc_attr( ot_get_option( $setting_id ) ) . ';}';

						}

					} elseif ( $where == 'bottom-padding' ) {

						if ( !empty( $id_control ) ) {

							$css .= $selector;
							$css .= '{padding-bottom:' . esc_attr( ot_get_option( $setting_id ) ) . ';}';

						}

					} elseif ( $where == 'left-padding' ) {

						if ( !empty( $id_control ) ) {

							$css .= $selector;
							$css .= '{padding-left:' . esc_attr( ot_get_option( $setting_id ) ) . ';}';

						}

					} elseif ( $where == 'right-padding' ) {

						if ( !empty( $id_control ) ) {

							$css .= $selector;
							$css .= '{padding-right:' . esc_attr( ot_get_option( $setting_id ) ) . ';}';

						}

					} elseif ( $where == 'opacity' ) {

						if ( !empty( $id_control ) ) {

							$css .= $selector;
							$css .= '{opacity:' . esc_attr( ot_get_option( $setting_id ) ) . ';}';

						}

					} elseif ( $where == 'gradient' ) {

						if ( !empty( $id_control ) ) {

							$css .= $selector;
							$css .= '{' . ot_get_option( $setting_id ) . '}';

						}

					} elseif ( $where == 'css-codes' ) {

						if ( !empty( $id_control ) ) {

							$css .= $selector;
							$css .= ot_get_option( $setting_id );

						}

					}

				}

				return $css;

			}

		}
		add_filter( 'ot_recognized_font_families', array( 'eventchamp_customizer_settings', 'eventchamp_font_google_api' ), 9999999 );

	}



	/*======
	*
	* Theme Company for Theme Options
	*
	======*/
	if( !function_exists( 'eventchamp_upload_name' ) ) {

		function eventchamp_upload_name() {

			return esc_html__( 'Send to Theme Options', 'eventchamp-core' );

		}
		add_filter( 'ot_upload_text', 'eventchamp_upload_name', 10, 2 );

	}



	/*======
	*
	* Adding Theme Options from Menu
	*
	======*/
	if( !function_exists( 'eventchamp_theme_options_logo' ) ) {

		function eventchamp_theme_options_logo() {

			$theme_version = wp_get_theme();

			$output = "";
			$output .= '<span class="theme-name">';
				$output .= '<strong>' . esc_attr( $theme_version->get( 'Name' ) ) . '</strong>';
			$output .= '</span>';
			$output .= '<span> ' . esc_attr( $theme_version->get( 'Version' ) ) . '</span>';

			return $output;

		}
		add_filter( 'ot_header_logo_link', 'eventchamp_theme_options_logo' );

	}



	/*======
	*
	* Theme Company for Theme Options
	*
	======*/
	if( !function_exists( 'eventchamp_options_name' ) ) {

		function eventchamp_options_name() {

			$html = esc_html__( 'Created by Gloria Themes', 'eventchamp-core' );

			return $html;

		}
		add_filter( 'ot_header_version_text', 'eventchamp_options_name', 10, 2 );

	}



	/*======
	*
	* Sidebar Creation for Theme Options
	*
	======*/
	if( !function_exists( 'eventchamp_sidebar_creation' ) ) {

		function eventchamp_sidebar_creation() {

			$sidebars = ot_get_option( 'custom_sidebars' );

			if( !empty( $sidebars ) ) {

				foreach( $sidebars as $sidebar ) {

					if( !empty( $sidebar ) ) {

						register_sidebar(
							array(
								'id' => 'sidebar-' . esc_attr( $sidebar['id'] ),
								'name' => esc_attr( $sidebar['title'] ),
								'before_widget' => '<div id="%1$s" class="gt-widget %2$s">',
								'after_widget' => '</div>',
								'before_title' => '<div class="gt-widget-title">',
								'after_title' => '</div>',
							)
						);

					}

				}

			}

		}
		add_action( 'after_setup_theme', 'eventchamp_sidebar_creation' );

	}

	if ( !function_exists( 'ot_type_sidebar_select_category' ) ) {

		function ot_type_sidebar_select_category( $args = array() ) {

			extract( $args );

			$has_desc = $field_desc ? true : false;
			$args = array(
				'type' => 'post',
				'child_of' => 0,
				'parent' => '',
				'orderby' => 'name',
				'order' => 'ASC',
				'hide_empty' => 0,
				'hierarchical' => 0,
				'taxonomy' => 'category',
				'pad_counts' => false
			);
			$categories = get_terms( 'category', array( 'hide_empty' => false ) );

			if( !empty( $categories ) ) {

				foreach ( $categories as $category ) {

					if( !empty( $categories ) ) {

						$field_id = 'sidebar_select_' . esc_attr( $category->term_id );
						$field_name = 'option_tree[sidebar_select_' . esc_attr( $category->term_id ) .']';
						$field_value = ot_get_option( $field_id );

						echo '<div class="format-setting type-sidebar-select has-desc">';
							echo '<div class="description">' . esc_html__( 'You can a select sidebar for the', 'eventchamp-core' ) . ' "' . esc_attr( $category->name ) . '."</div>';
							echo '<div class="format-setting-inner">';
								echo '<select name="' . esc_attr( $field_name ) . '" id="' . esc_attr( $field_id ) . '" class="option-tree-ui-select ' . esc_attr( $field_class ) . '">';
									$sidebars = $GLOBALS['wp_registered_sidebars'];

									if ( !empty( $sidebars ) ) {

										echo '<option value="">-- ' . esc_html__( 'Choose One', 'eventchamp-core' ) . ' --</option>';
										foreach ( $sidebars as $sidebar ) {

											if ( !empty( $sidebar ) ) {

												echo '<option value="' . esc_attr( $sidebar['id'] ) . '"' . selected( $field_value, $sidebar['id'], false ) . '>' . esc_attr( $sidebar['name'] ) . '</option>';

											}

										}

									} else {

										echo '<option value="">' . esc_html__( 'No Sidebars Found', 'eventchamp-core' ) . '</option>';

									}
								echo '</select>';
							echo '</div>';
						echo '</div>';

					}

				}

			}

		}

	}



	/*======
	*
	* Image Selector for Radio Button
	*
	======*/
	if ( !function_exists( 'eventchamp_radio_image_selector' ) ) {

		function eventchamp_radio_image_selector( $array, $field_id ) {

			if ( $field_id == 'sidebar_position' or $field_id == 'post_sidebar_position' or $field_id == 'woocommerce_sidebar_position' or $field_id == 'woocommerce_product_sidebar_position' or $field_id == 'attachment_sidebar_position' or $field_id == 'category_sidebar_position' or $field_id == 'search_sidebar_position' or $field_id == 'archive_sidebar_position' or $field_id == 'author_sidebar_position' or $field_id == 'tag_sidebar_position' or $field_id == 'page_sidebar_position' or $field_id == 'layout_select_meta_box_text' or $field_id == 'event_sidebar_position' or $field_id == 'event_single_sidebar_position' or $field_id == 'venue_sidebar_position' or $field_id == 'venue_single_sidebar_position' or $field_id == 'speaker_sidebar_position' or $field_id == 'speaker_single_sidebar_position' ) {

				$array = array(
					array(
						'value' => 'left',
						'label' => esc_html__( 'Left Sidebar', 'eventchamp-core' ),
						'src' => get_template_directory_uri() . '/include/assets/img/admin/left-sidebar.jpg',
					),
					array(
						'value' => 'nosidebar',
						'label' => esc_html__( 'No Sidebar', 'eventchamp-core' ),
						'src' => get_template_directory_uri() . '/include/assets/img/admin/none-sidebar.jpg',
					),
					array(
						'value' => 'right',
						'label' => esc_html__( 'Right Sidebar', 'eventchamp-core' ),
						'src' => get_template_directory_uri() . '/include/assets/img/admin/right-sidebar.jpg',
					),
				);

			}

			if ( $field_id == 'blog_category_post_list_style' or $field_id == 'tag_tag_post_list_style' or $field_id == 'author_author_post_list_style' or $field_id == 'search_search_post_list_style' or $field_id == 'archive_archive_post_list_style' ) {

				$array = array(
					array(
						'value' => 'style1',
						'label' => esc_html__( 'Style 1', 'eventchamp-core' ),
						'src' => get_template_directory_uri() . '/include/assets/img/admin/post-style-1.jpg',
					),
					array(
						'value' => 'style2',
						'label' => esc_html__( 'Style 2', 'eventchamp-core' ),
						'src' => get_template_directory_uri() . '/include/assets/img/admin/post-style-2.jpg',
					),
				);

			}

			if ( $field_id == 'event-system' ) {

				$array = array(
					array(
						'value' => 'eventchamp',
						'label' => esc_html__( 'Eventchamp', 'eventchamp-core' ),
						'src' => get_template_directory_uri() . '/include/assets/img/admin/eventchamp-logo.jpg',
					),
					array(
						'value' => 'the-events-calendar',
						'description' => esc_html__( 'The Events Calendar', 'eventchamp-core' ),
						'label' => esc_html__( 'The Events Calendar', 'eventchamp-core' ),
						'src' => get_template_directory_uri() . '/include/assets/img/admin/the-events-calendar-logo.jpg',
					),
					array(
						'value' => 'eventon',
						'label' => esc_html__( 'EventON', 'eventchamp-core' ),
						'src' => get_template_directory_uri() . '/include/assets/img/admin/eventon-logo.jpg',
					),
					array(
						'value' => 'custom',
						'label' => esc_html__( 'Custom & Other Plugins', 'eventchamp-core' ),
						'src' => get_template_directory_uri() . '/include/assets/img/admin/custom.jpg',
					),
				);

			}
			
			return $array;

		}
		add_filter( 'ot_radio_images', 'eventchamp_radio_image_selector', 10, 2 );

	}



	/*======
	*
	* Get Post Types for Theme Settings
	*
	======*/
	if( !function_exists( 'eventchamp_get_post_types_settings' ) ) {

		function eventchamp_get_post_types_settings() {

			$post_types = get_post_types();
			$array = array();

			if( !empty( $post_types ) ) {

				foreach( $post_types as $type ) {

					if( !empty( $type ) ) {

						$array[] = array( "value" => $type, "label" => ucfirst( $type ) );


					}

				}

			}

			return $array;

		}

	}

}