<?php
/*======
*
* WooCommerce Support for Theme
*
======*/
if( class_exists( 'woocommerce' ) ) {

	if( !function_exists( 'eventchamp_woocommerce_support' ) ) {

		function eventchamp_woocommerce_support() {

			add_theme_support( 'woocommerce' );

		}
		add_action( 'after_setup_theme', 'eventchamp_woocommerce_support' );

	}

}



/*======
*
* Filters
*
======*/
if( class_exists( 'woocommerce' ) ) {

	remove_action( 'woocommerce_before_shop_loop_item_title', 'woocommerce_show_product_loop_sale_flash', 10 );
	remove_action( 'woocommerce_before_single_product_summary', 'woocommerce_show_product_sale_flash', 10 );
	remove_action( 'woocommerce_before_main_content', 'woocommerce_output_content_wrapper', 10 );
	remove_action( 'woocommerce_after_main_content', 'woocommerce_output_content_wrapper_end', 10 );
	add_filter( 'woocommerce_product_description_heading', '__return_null' );
	add_filter( 'woocommerce_product_additional_information_heading', '__return_null' );

}



/*======
*
* Eventchamp WooCommerce Scripts
*
======*/
if( !function_exists( 'eventchamp_woocommerce_styles' ) ) {

	function eventchamp_woocommerce_styles() {

		if( class_exists( 'woocommerce' ) ) {

			/*====== CSS ======*/
			wp_enqueue_style( 'eventchamp-woocommerce', get_template_directory_uri() . '/include/assets/css/gt-woocommerce.min.css' );

			/*====== RTL ======*/
			$rtl = ot_get_option( 'rtl', 'off' );

			if( $rtl == 'on' ) {

				wp_enqueue_style( 'eventchamp-woocommerce-rtl', get_template_directory_uri() . '/include/assets/css/gt-woocommerce-rtl.min.css' );

			}

		}

	}
	add_action( 'wp_enqueue_scripts', 'eventchamp_woocommerce_styles' );

}


/*======
*
* Page Title
*
======*/
if( !function_exists( 'loquet_hide_woocommerce_page_title' ) ) {

	function loquet_hide_woocommerce_page_title() {

		return false;

	}
	add_filter( 'woocommerce_show_page_title', 'loquet_hide_woocommerce_page_title' );

}