<?php
/*======
*
* Event Listing Styles
*
======*/
	/*====== Event Style 1 ======*/
	if( !function_exists( 'eventchamp_the_events_calendar_event_style_1' ) ) {

		function eventchamp_the_events_calendar_event_style_1( $post_id = "", $image = "", $category = "", $start_date = "", $end_date = "", $venue = "", $organizer = "", $excerpt = "", $image_size = "" ) {

			$output  = "";

			if( !empty( $post_id ) ) {

				$output .= '<div class="gt-event-style-1">';

					if( has_post_thumbnail( $post_id ) ) {

						$output .= '<div class="gt-image">';
							$output .= '<a href="' . get_the_permalink( esc_attr( $post_id ) ) . '">';
								$output .= get_the_post_thumbnail( esc_attr( $post_id ), esc_attr( $image_size ) );
							$output .= '</a>';
						$output .= '</div>';

					}

					$output .= '<div class="gt-title">';
						$output .= '<a href="' . get_the_permalink( esc_attr( $post_id ) ) . '">';
							$output .= get_the_title( esc_attr( $post_id ) );
						$output .= '</a>';
					$output .= '</div>';

					if( $category == "true" or $start_date == "true" or $end_date == "true" or $venue == "true" or $organizer == "true" ) {

						$output .= '<div class="gt-details">';

							if( $category == "true" ) {

								if( !empty( eventchamp_get_post_terms( $post_id = esc_attr( $post_id ), $taxonomy = "tribe_events_cat", $post_type = "events" ) ) ) {

									$output .= '<div class="gt-category">';
										$output .= eventchamp_get_post_terms( $post_id = esc_attr( $post_id ), $taxonomy = "tribe_events_cat", $post_type = "events" );
									$output .= '</div>';

								}

							}

							if( $start_date == "true" ) {

								if( !empty( tribe_get_start_date( $event = esc_attr( $post_id ) ) ) ) {

									$output .= '<div class="gt-date gt-start-date">';
										$output .= '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><rect x="3" y="4" width="18" height="18" rx="2" ry="2"></rect><line x1="16" y1="2" x2="16" y2="6"></line><line x1="8" y1="2" x2="8" y2="6"></line><line x1="3" y1="10" x2="21" y2="10"></line></svg>';
										$output .= tribe_get_start_date( $event = esc_attr( $post_id ) );
									$output .= '</div>';

								}

							}

							if( $end_date == "true" ) {

								if( !empty( tribe_get_end_date( $event = esc_attr( $post_id ) ) ) ) {

									$output .= '<div class="gt-date gt-end-date">';
										$output .= '<svg version="1.1" fill="currentColor" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 216.374 216.374" style="enable-background:new 0 0 216.374 216.374;" xml:space="preserve"> <g> <path d="M207.374,30.135h-25.438V13.432c0-4.971-4.029-9-9-9s-9,4.029-9,9v16.703H52.438V13.432c0-4.971-4.029-9-9-9s-9,4.029-9,9 v16.703H9c-4.971,0-9,4.029-9,9v163.808c0,4.971,4.029,9,9,9h198.374c4.971,0,9-4.029,9-9V39.135 C216.374,34.164,212.345,30.135,207.374,30.135z M198.374,48.135v19.997H18V48.135H198.374z M18,193.942V86.132h180.374v107.811H18 z"/> <path d="M145.534,109.813c-3.115-3.873-8.781-4.488-12.653-1.373L108.187,128.3L83.494,108.44 c-3.875-3.115-9.539-2.499-12.653,1.373c-3.115,3.874-2.5,9.539,1.373,12.654l21.613,17.382l-21.613,17.382 c-3.873,3.115-4.488,8.78-1.373,12.654c1.778,2.211,4.387,3.359,7.019,3.359c1.979,0,3.972-0.649,5.634-1.986l24.693-19.859 l24.693,19.859c1.663,1.337,3.655,1.986,5.634,1.986c2.632,0,5.241-1.149,7.019-3.359c3.115-3.874,2.5-9.539-1.373-12.654 l-21.613-17.382l21.613-17.382C148.034,119.353,148.649,113.688,145.534,109.813z"/> </g> <g> </g> <g> </g> <g> </g> <g> </g> <g> </g> <g> </g> <g> </g> <g> </g> <g> </g> <g> </g> <g> </g> <g> </g> <g> </g> <g> </g> <g> </g> </svg>';
										$output .= tribe_get_end_date( $event = esc_attr( $post_id ) );
									$output .= '</div>';

								}

							}

							if( $venue == "true" ) {

								if( !empty( tribe_get_venue( $event = esc_attr( $post_id ) ) ) ) {

									$output .= '<div class="gt-venue">';
										$output .= '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><polygon points="1 6 1 22 8 18 16 22 23 18 23 2 16 6 8 2 1 6"></polygon><line x1="8" y1="2" x2="8" y2="18"></line><line x1="16" y1="6" x2="16" y2="22"></line></svg>';
										$output .= tribe_get_venue( $event = esc_attr( $post_id ) );
									$output .= '</div>';

								}

							}

							if( $organizer == "true" ) {

								if( !empty( tribe_get_organizer( $event = esc_attr( $post_id ) ) ) ) {

									$output .= '<div class="gt-organizer">';
										$output .= '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M21 10c0 7-9 13-9 13s-9-6-9-13a9 9 0 0 1 18 0z"></path><circle cx="12" cy="10" r="3"></circle></svg>';
										$output .= tribe_get_organizer( $event = esc_attr( $post_id ) );
									$output .= '</div>';

								}

							}

						$output .= '</div>';

					}

					if( $excerpt == "true" ) {

						if( !empty( get_the_excerpt( esc_attr( $post_id ) ) ) ) {

							$output .= '<div class="gt-text">';
								$output .= wpautop( get_the_excerpt( esc_attr( $post_id ) ) );
							$output .= '</div>';

						}

					}

				$output .= '</div>';
			}

			return $output;

		}

	}


	/*====== Event Style 2 ======*/
	if( !function_exists( 'eventchamp_the_events_calendar_event_style_2' ) ) {

		function eventchamp_the_events_calendar_event_style_2( $post_id = "", $image = "", $category = "", $start_date = "", $end_date = "", $venue = "", $organizer = "", $excerpt = "", $image_size = "" ) {

			$output  = "";

			if( !empty( $post_id ) ) {

				$output .= '<div class="gt-event-style-3">';

					if( has_post_thumbnail( $post_id ) ) {

						$output .= '<div class="gt-image">';
							$output .= '<a href="' . get_the_permalink( esc_attr( $post_id ) ) . '">';
								$output .= get_the_post_thumbnail( esc_attr( $post_id ), esc_attr( $image_size ) );
							$output .= '</a>';
						$output .= '</div>';

					}

					$output .= '<div class="gt-content">';
						$output .= '<div class="gt-title">';
							$output .= '<a href="' . get_the_permalink( esc_attr( $post_id ) ) . '">';
								$output .= get_the_title( esc_attr( $post_id ) );
							$output .= '</a>';
						$output .= '</div>';

						if( $category == "true" or $start_date == "true" or $end_date == "true" ) {

							$output .= '<div class="gt-details">';

								if( $category == "true" ) {

									if( !empty( eventchamp_get_post_terms( $post_id = esc_attr( $post_id ), $taxonomy = "tribe_events_cat", $post_type = "events" ) ) ) {

										$output .= '<div class="gt-category">';
											$output .= eventchamp_get_post_terms( $post_id = esc_attr( $post_id ), $taxonomy = "tribe_events_cat", $post_type = "events" );
										$output .= '</div>';

									}

								}

								if( $start_date == "true" ) {

									if( !empty( tribe_get_start_date( $event = esc_attr( $post_id ) ) ) ) {

										$output .= '<div class="gt-date gt-start-date">';
											$output .= '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><rect x="3" y="4" width="18" height="18" rx="2" ry="2"></rect><line x1="16" y1="2" x2="16" y2="6"></line><line x1="8" y1="2" x2="8" y2="6"></line><line x1="3" y1="10" x2="21" y2="10"></line></svg>';
											$output .= tribe_get_start_date( $event = esc_attr( $post_id ) );
										$output .= '</div>';

									}

								}

								if( $end_date == "true" ) {

									if( !empty( tribe_get_end_date( $event = esc_attr( $post_id ) ) ) ) {

										$output .= '<div class="gt-date gt-end-date">';
											$output .= '<svg version="1.1" fill="currentColor" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 216.374 216.374" style="enable-background:new 0 0 216.374 216.374;" xml:space="preserve"> <g> <path d="M207.374,30.135h-25.438V13.432c0-4.971-4.029-9-9-9s-9,4.029-9,9v16.703H52.438V13.432c0-4.971-4.029-9-9-9s-9,4.029-9,9 v16.703H9c-4.971,0-9,4.029-9,9v163.808c0,4.971,4.029,9,9,9h198.374c4.971,0,9-4.029,9-9V39.135 C216.374,34.164,212.345,30.135,207.374,30.135z M198.374,48.135v19.997H18V48.135H198.374z M18,193.942V86.132h180.374v107.811H18 z"/> <path d="M145.534,109.813c-3.115-3.873-8.781-4.488-12.653-1.373L108.187,128.3L83.494,108.44 c-3.875-3.115-9.539-2.499-12.653,1.373c-3.115,3.874-2.5,9.539,1.373,12.654l21.613,17.382l-21.613,17.382 c-3.873,3.115-4.488,8.78-1.373,12.654c1.778,2.211,4.387,3.359,7.019,3.359c1.979,0,3.972-0.649,5.634-1.986l24.693-19.859 l24.693,19.859c1.663,1.337,3.655,1.986,5.634,1.986c2.632,0,5.241-1.149,7.019-3.359c3.115-3.874,2.5-9.539-1.373-12.654 l-21.613-17.382l21.613-17.382C148.034,119.353,148.649,113.688,145.534,109.813z"/> </g> <g> </g> <g> </g> <g> </g> <g> </g> <g> </g> <g> </g> <g> </g> <g> </g> <g> </g> <g> </g> <g> </g> <g> </g> <g> </g> <g> </g> <g> </g> </svg>';
											$output .= tribe_get_end_date( $event = esc_attr( $post_id ) );
										$output .= '</div>';

									}

								}

							$output .= '</div>';

						}

						if( $excerpt == "true" ) {

							if( !empty( get_the_excerpt( esc_attr( $post_id ) ) ) ) {

								$output .= '<div class="gt-text">';
									$output .= wpautop( get_the_excerpt( esc_attr( $post_id ) ) );
								$output .= '</div>';

							}

						}

						if( $venue == "true" or $organizer == "true" ) {

							$output .= '<div class="gt-details">';

								if( $venue == "true" ) {

									if( !empty( tribe_get_venue( $event = esc_attr( $post_id ) ) ) ) {

										$output .= '<div class="gt-venue">';
											$output .= '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><polygon points="1 6 1 22 8 18 16 22 23 18 23 2 16 6 8 2 1 6"></polygon><line x1="8" y1="2" x2="8" y2="18"></line><line x1="16" y1="6" x2="16" y2="22"></line></svg>';
											$output .= tribe_get_venue( $event = esc_attr( $post_id ) );
										$output .= '</div>';

									}

								}

								if( $organizer == "true" ) {

									if( !empty( tribe_get_organizer( $event = esc_attr( $post_id ) ) ) ) {

										$output .= '<div class="gt-organizer">';
											$output .= '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M21 10c0 7-9 13-9 13s-9-6-9-13a9 9 0 0 1 18 0z"></path><circle cx="12" cy="10" r="3"></circle></svg>';
											$output .= tribe_get_organizer( $event = esc_attr( $post_id ) );
										$output .= '</div>';

									}

								}

							$output .= '</div>';

						}

					$output .= '</div>';
				$output .= '</div>';
			}

			return $output;

		}

	}


	/*====== Event Style 3 ======*/
	if( !function_exists( 'eventchamp_the_events_calendar_event_style_3' ) ) {

		function eventchamp_the_events_calendar_event_style_3( $post_id = "", $image = "", $category = "", $start_date = "", $end_date = "", $venue = "", $organizer = "", $excerpt = "", $image_size = "" ) {

			$output  = "";

			if( !empty( $post_id ) ) {

				$output .= '<div class="gt-event-style-4">';

					if( has_post_thumbnail( $post_id ) ) {

						$output .= '<div class="gt-image">';
							$output .= '<a href="' . get_the_permalink( esc_attr( $post_id ) ) . '">';
								$output .= get_the_post_thumbnail( esc_attr( $post_id ), esc_attr( $image_size ) );
							$output .= '</a>';
						$output .= '</div>';

					}

					$output .= '<div class="gt-content">';
						$output .= '<div class="gt-title">';
							$output .= '<a href="' . get_the_permalink( esc_attr( $post_id ) ) . '">';
								$output .= get_the_title( esc_attr( $post_id ) );
							$output .= '</a>';
						$output .= '</div>';

						if( $category == "true" or $start_date == "true" or $end_date == "true" ) {

							$output .= '<div class="gt-details">';

								if( $category == "true" ) {

									if( !empty( eventchamp_get_post_terms( $post_id = esc_attr( $post_id ), $taxonomy = "tribe_events_cat", $post_type = "events" ) ) ) {

										$output .= '<div class="gt-category">';
											$output .= eventchamp_get_post_terms( $post_id = esc_attr( $post_id ), $taxonomy = "tribe_events_cat", $post_type = "events" );
										$output .= '</div>';

									}

								}

								if( $start_date == "true" ) {

									if( !empty( tribe_get_start_date( $event = esc_attr( $post_id ) ) ) ) {

										$output .= '<div class="gt-date gt-start-date">';
											$output .= '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><rect x="3" y="4" width="18" height="18" rx="2" ry="2"></rect><line x1="16" y1="2" x2="16" y2="6"></line><line x1="8" y1="2" x2="8" y2="6"></line><line x1="3" y1="10" x2="21" y2="10"></line></svg>';
											$output .= tribe_get_start_date( $event = esc_attr( $post_id ) );
										$output .= '</div>';

									}

								}

								if( $end_date == "true" ) {

									if( !empty( tribe_get_end_date( $event = esc_attr( $post_id ) ) ) ) {

										$output .= '<div class="gt-date gt-end-date">';
											$output .= '<svg version="1.1" fill="currentColor" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 216.374 216.374" style="enable-background:new 0 0 216.374 216.374;" xml:space="preserve"> <g> <path d="M207.374,30.135h-25.438V13.432c0-4.971-4.029-9-9-9s-9,4.029-9,9v16.703H52.438V13.432c0-4.971-4.029-9-9-9s-9,4.029-9,9 v16.703H9c-4.971,0-9,4.029-9,9v163.808c0,4.971,4.029,9,9,9h198.374c4.971,0,9-4.029,9-9V39.135 C216.374,34.164,212.345,30.135,207.374,30.135z M198.374,48.135v19.997H18V48.135H198.374z M18,193.942V86.132h180.374v107.811H18 z"/> <path d="M145.534,109.813c-3.115-3.873-8.781-4.488-12.653-1.373L108.187,128.3L83.494,108.44 c-3.875-3.115-9.539-2.499-12.653,1.373c-3.115,3.874-2.5,9.539,1.373,12.654l21.613,17.382l-21.613,17.382 c-3.873,3.115-4.488,8.78-1.373,12.654c1.778,2.211,4.387,3.359,7.019,3.359c1.979,0,3.972-0.649,5.634-1.986l24.693-19.859 l24.693,19.859c1.663,1.337,3.655,1.986,5.634,1.986c2.632,0,5.241-1.149,7.019-3.359c3.115-3.874,2.5-9.539-1.373-12.654 l-21.613-17.382l21.613-17.382C148.034,119.353,148.649,113.688,145.534,109.813z"/> </g> <g> </g> <g> </g> <g> </g> <g> </g> <g> </g> <g> </g> <g> </g> <g> </g> <g> </g> <g> </g> <g> </g> <g> </g> <g> </g> <g> </g> <g> </g> </svg>';
											$output .= tribe_get_end_date( $event = esc_attr( $post_id ) );
										$output .= '</div>';

									}

								}

							$output .= '</div>';

						}

						if( $excerpt == "true" ) {

							if( !empty( get_the_excerpt( esc_attr( $post_id ) ) ) ) {

								$output .= '<div class="gt-text">';
									$output .= wpautop( get_the_excerpt( esc_attr( $post_id ) ) );
								$output .= '</div>';

							}

						}

						if( $venue == "true" or $organizer == "true" ) {

							$output .= '<div class="gt-details">';

								if( $venue == "true" ) {

									if( !empty( tribe_get_venue( $event = esc_attr( $post_id ) ) ) ) {

										$output .= '<div class="gt-venue">';
											$output .= '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><polygon points="1 6 1 22 8 18 16 22 23 18 23 2 16 6 8 2 1 6"></polygon><line x1="8" y1="2" x2="8" y2="18"></line><line x1="16" y1="6" x2="16" y2="22"></line></svg>';
											$output .= tribe_get_venue( $event = esc_attr( $post_id ) );
										$output .= '</div>';

									}

								}

								if( $organizer == "true" ) {

									if( !empty( tribe_get_organizer( $event = esc_attr( $post_id ) ) ) ) {

										$output .= '<div class="gt-organizer">';
											$output .= '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M21 10c0 7-9 13-9 13s-9-6-9-13a9 9 0 0 1 18 0z"></path><circle cx="12" cy="10" r="3"></circle></svg>';
											$output .= tribe_get_organizer( $event = esc_attr( $post_id ) );
										$output .= '</div>';

									}

								}

							$output .= '</div>';

						}

					$output .= '</div>';
				$output .= '</div>';
			}

			return $output;

		}

	}