<?php
/*======
*
* Events Calendar
*
======*/
if( !function_exists( 'eventchamp_event_calendar_output' ) ) {

	function eventchamp_event_calendar_output( $atts, $content = null ) {

		/*====== Atts ======*/
		$atts = shortcode_atts(
			array(
				'style' => '',
				'contenttype' => '',
				'include-events' => '',
				'exclude-events' => '',
				'hide-expired' => '',
				'first-day' => '',
				'selectable' => '',
				'repeater-events' => '',
				'nav-links' => '',
				'nav-links-prev' => 'false',
				'nav-links-next' => 'false',
				'nav-links-today' => 'false',
				'nav-links-title' => 'false',
				'editable' => '',
				'current-dates' => '',
				'default-date' => '',
				'title-format' => '',
				'height' => '',
				'content-height' => '',
				'exclude-categories' => '',
				'exclude-locations' => '',
				'exclude-organizers' => '',
				'exclude-tags' => '',
				'include-categories' => '',
				'include-locations' => '',
				'include-organizers' => '',
				'include-tags' => '',
			), $atts
		);

		/*====== Nav Links ======*/
		if( empty( $atts["style"] ) ) {

			$atts["style"] = "style-1";

		}

		/*====== Selectable ======*/
		if( empty( $atts["selectable"] ) ) {

			$atts["selectable"] = "false";

		}

		/*====== Selectable ======*/
		if( empty( $atts["repeater-events"] ) ) {

			$atts["repeater-events"] = "false";

		}

		/*====== Nav Links ======*/
		if( empty( $atts["nav-links"] ) ) {

			$atts["nav-links"] = "false";

		}

		/*====== Editable ======*/
		if( empty( $atts["editable"] ) ) {

			$atts["editable"] = "false";

		}

		/*====== Current Dates ======*/
		if( empty( $atts["current-dates"] ) ) {

			$atts["current-dates"] = "false";

		}

		/*====== Default Date ======*/
		if( empty( $atts["default-date"] ) ) {

			$atts["default-date"] = date("Y-m-d");

		}

		/*====== Title Format ======*/
		if( empty( $atts["title-format"] ) ) {

			$atts["title-format"] = "MMMM YYYY";

		}

		/*====== Height ======*/
		if( empty( $atts["height"] ) ) {

			$atts["height"] = "1000";

		}

		/*====== Content Height ======*/
		if( empty( $atts["content-height"] ) ) {

			$atts["content-height"] = "auto";

		}

		/*====== Expired Events Status ======*/
		if( !empty( $atts['hide-expired'] ) ) {

			$hide_expired = esc_attr( $atts["hide-expired"] );

		} else {

			$hide_expired = "false";

		}

		/*====== Nav Links Prev ======*/
		if( $atts['nav-links-prev'] == "true" ) {

			$nav_links_prev = "prev,";

		} else {

			$nav_links_prev = "";

		}

		/*====== Nav Links Next ======*/
		if( $atts['nav-links-next'] == "true" ) {

			$nav_links_next = "next,";

		} else {

			$nav_links_next = "";

		}

		/*====== Nav Links Today ======*/
		if( $atts['nav-links-today'] == "true" ) {

			$nav_links_today = "today";

		} else {

			$nav_links_today = "";

		}

		/*====== Nav Links Title ======*/
		if( $atts['nav-links-title'] == "true" ) {

			$nav_links_title = "title";

		} else {

			$nav_links_title = "";

		}

		/*====== Exclude Categories ======*/
		$exclude_category_array = "";

		if( !empty( $atts['exclude-categories'] ) ) {

			$exclude_categories = $atts['exclude-categories'];
			$exclude_categories = explode( ',', $exclude_categories );

		} else {

			$exclude_categories = "";

		}

		if( !empty( $exclude_categories ) ) {

			$exclude_category_array = array(
				'taxonomy' => 'eventcat',
				'field' => 'term_id',
				'terms' => $exclude_categories,
				'operator' => 'NOT IN',
			);

		}

		/*====== Exclude Locations ======*/
		$exclude_location_array = "";

		if( !empty( $atts['exclude-locations'] ) ) {

			$exclude_locations = $atts['exclude-locations'];
			$exclude_locations = explode( ',', $exclude_locations );

		} else {

			$exclude_locations = "";

		}

		if( !empty( $exclude_locations ) ) {

			$exclude_location_array = array(
				'taxonomy' => 'location',
				'field' => 'term_id',
				'terms' => $exclude_locations,
				'operator' => 'NOT IN',
			);

		}

		/*====== Exclude Organizers ======*/
		$exclude_organizer_array = "";

		if( !empty( $atts['exclude-organizers'] ) ) {

			$exclude_organizers = $atts['exclude-organizers'];
			$exclude_organizers = explode( ',', $exclude_organizers );

		} else {

			$exclude_organizers = "";

		}

		if( !empty( $exclude_organizers ) ) {

			$exclude_organizer_array = array(
				'taxonomy' => 'organizer',
				'field' => 'term_id',
				'terms' => $exclude_organizers,
				'operator' => 'NOT IN',
			);

		}

		/*====== Exclude Tags ======*/
		$exclude_tag_array = "";

		if( !empty( $atts['exclude-tags'] ) ) {

			$exclude_tags = $atts['exclude-tags'];
			$exclude_tags = explode( ',', $exclude_tags );

		} else {

			$exclude_tags = "";

		}

		if( !empty( $exclude_tags ) ) {

			$exclude_tag_array = array(
				'taxonomy' => 'event_tags',
				'field' => 'term_id',
				'terms' => $exclude_tags,
				'operator' => 'NOT IN',
			);

		}

		/*====== Include Categories ======*/
		$include_category_array = "";

		if( !empty( $atts['include-categories'] ) ) {

			$include_categories = $atts['include-categories'];
			$include_categories = explode( ',', $include_categories );

		} else {

			$include_categories = "";

		}

		if( !empty( $include_categories ) ) {

			$include_category_array = array(
				'taxonomy' => 'eventcat',
				'field' => 'term_id',
				'terms' => $include_categories,
				'operator' => 'IN',
			);

		}

		/*====== Include Locations ======*/
		$include_location_array = "";

		if( !empty( $atts['include-locations'] ) ) {

			$include_locations = $atts['include-locations'];
			$include_locations = explode( ',', $include_locations );

		} else {

			$include_locations = "";

		}

		if( !empty( $include_locations ) ) {

			$include_location_array = array(
				'taxonomy' => 'location',
				'field' => 'term_id',
				'terms' => $include_locations,
				'operator' => 'IN',
			);

		}

		/*====== Include Organizers ======*/
		$include_organizers_array = "";

		if( !empty( $atts['include-organizers'] ) ) {

			$include_organizers = $atts['include-organizers'];
			$include_organizers = explode( ',', $include_organizers );

		} else {

			$include_organizers = "";

		}

		if( !empty( $include_organizers ) ) {

			$include_organizers_array = array(
				'taxonomy' => 'organizer',
				'field' => 'term_id',
				'terms' => $include_organizers,
				'operator' => 'IN',
			);

		}

		/*====== Include Tags ======*/
		$include_tags_array = "";

		if( !empty( $atts['include-tags'] ) ) {

			$include_tags = $atts['include-tags'];
			$include_tags = explode( ',', $include_tags );

		} else {

			$include_tags = "";

		}

		if( !empty( $include_tags ) ) {

			$include_tags_array = array(
				'taxonomy' => 'event_tags',
				'field' => 'term_id',
				'terms' => $include_tags,
				'operator' => 'IN',
			);

		}

		/*====== Main Query ======*/
		$arg = array(
			'posts_per_page' => -1,
			'post_status' => 'publish',
			'post_type' => 'event',
			'tax_query' => array (
				'relation' => 'AND',
				$include_location_array,
				$include_category_array,
				$include_organizers_array,
				$include_tags_array,
				$exclude_category_array,
				$exclude_location_array,
				$exclude_organizer_array,
				$exclude_tag_array,
			)
		);

		/*====== Include Events ======*/
		if( !empty( $atts['include-events'] ) ) {

			$event_ids = $atts['include-events'];
			$include_events = explode( ',', $event_ids );

		} else {

			$include_events = "";

		}

		if( !empty( $include_events ) ) {

			$extra_query = array(
				'post__in' => $include_events,
			);
			$arg = wp_parse_args( $arg, $extra_query );

		}

		/*====== Exclude Events ======*/
		if( $hide_expired == "false" ) {

			if( !empty( $atts['exclude-events'] ) ) {

				$exclude_events = $atts['exclude-events'];
				$exclude_events = explode( ',', $exclude_events );

			} else {

				$exclude_events = array();

			}

			if( !empty( $exclude_events ) ) {

				$extra_query = array(
					'post__not_in' => $exclude_events,
				);
				$arg = wp_parse_args( $arg, $extra_query );

			}

		}

		/*====== Add Expired Events in Exclude Events ======*/
		if( $hide_expired == "true" ) {

			$expired_ids = eventchamp_expired_event_ids();

		} else {

			$expired_ids = array();

		}

		if( !empty( $expired_ids ) ) {

			if( !empty( $exclude_events ) ) {

				$exclude_events_expired = $exclude_events;
				$exclude_events_expired = explode( ',', $exclude_events_expired );

			} else {

				$exclude_events_expired = array();

			}

			$excludeevents_with_expired = array_merge( $exclude_events_expired, $expired_ids );

			$extra_query = array(
				'post__not_in' => $excludeevents_with_expired,
			);
			$arg = wp_parse_args( $arg, $extra_query );

		}

		/*====== HTML Output ======*/
		$output = '';
		$items = '';

		$wp_query = new WP_Query( $arg );

		if( !empty( $wp_query ) ) {

			if( $wp_query->have_posts() ) {

				while( $wp_query->have_posts() ) {

					$wp_query->the_post();
					$event_start_date = get_post_meta( get_the_ID(), 'event_start_date', true );

					if( empty( $event_start_date ) ) {

						$event_start_date = "";

					}

					$event_start_time = get_post_meta( get_the_ID(), 'event_start_time', true );

					if( !empty( $event_start_time ) ) {

						$event_start_time = "T" . $event_start_time;

					} else {

						$event_start_time = "";		

					}

					$event_end_date = get_post_meta( get_the_ID(), 'event_end_date', true );

					if( empty( $event_end_date ) ) {

						$event_end_date = "";

					}

					$event_end_time = get_post_meta( get_the_ID(), 'event_end_time', true );

					if( !empty( $event_end_time ) ) {

						$event_end_time = "T" . $event_end_time;

					} else {

						$event_end_time = "";

					}

					$items .= '{
								id: ' . get_the_ID() . ',
								title: "' . str_replace( '"', '', get_post_field( 'post_title', get_the_ID(), 'display' ) ) . '",
								url: "' . get_the_permalink() . '",
								start: "' . $event_start_date . $event_start_time . '",
								end: "' . $event_end_date . $event_end_time . '",
							},';

					/*====== Repeater Events ======*/
					if( $atts["repeater-events"] == "true" ) {

						$repeat_dates = get_post_meta( get_the_ID(), 'event_repeat_dates', true );

						if( !empty( $repeat_dates ) ) {

							foreach( $repeat_dates as $repeat_date ) {

								if( !empty( $repeat_date ) ) {

									$repeat_start_date = esc_attr( $repeat_date["event_repeat_start_date"] );
									$repeat_start_time = esc_attr( $repeat_date["event_repeat_start_time"] );
									$repeat_end_date = esc_attr( $repeat_date["event_repeat_end_date"] );
									$repeat_end_time = esc_attr( $repeat_date["event_repeat_end_time"] );
									$repeat_expire_date = esc_attr( $repeat_date["event_repeat_expire_date"] );

									if( !empty( $repeat_start_time ) ) {

										$repeat_start_time_t = "T" . $repeat_start_time;

									} else {

										$repeat_start_time_t = "";		

									}

									if( !empty( $repeat_end_time ) ) {

										$repeat_end_time_t = "T" . $repeat_end_time;

									} else {

										$repeat_end_time_t = "";		

									}

									$items .= '{
												id: ' . get_the_ID() . ',
												title: "' . str_replace( '"', '', get_post_field( 'post_title', get_the_ID(), 'display' ) ) . '",
												url: "' . get_the_permalink() . '",
												start: "' . $repeat_start_date . $repeat_start_time_t . '",
												end: "' . $repeat_end_date . $repeat_end_time_t . '",
											},';

								}

							}

						}

					}

				}

				/*====== First Day ======*/
				if( !empty( $atts["first-day"] ) ) {

					$first_day = $atts["first-day"];

				} else {

					$first_day = 0;

				}

				/*====== Content Type ======*/
				if( $atts["contenttype"] == "calendar" ) {

					$type = 'month';
					$def = '';

				} elseif( $atts["contenttype"] == "calendarlistweek" ) {

					$type = 'month,listWeek';
					$def = '';

				} elseif( $atts["contenttype"] == "calendarlistday" ) {

					$type = 'month,listDay';
					$def = '';

				} elseif( $atts["contenttype"] == "fully" ) {

					$type = 'month,agendaWeek,agendaDay,listWeek';
					$def = '';

				} elseif( $atts["contenttype"] == "listweek" ) {

					$type = 'listWeek';
					$def = 'defaultView: "listWeek",';

				} elseif( $atts["contenttype"] == "listyear" ) {

					$type = 'listYear';
					$def = 'defaultView: "listYear",';

				} elseif( $atts["contenttype"] == "listmonth" ) {

					$type = 'listMonth';
					$def = 'defaultView: "listMonth",';

				} elseif( $atts["contenttype"] == "listday" ) {

					$type = 'listDay';
					$def = 'defaultView: "listDay",';

				} else {

					$type = 'month';
					$def = '';

				}

				/*====== Locale ======*/
				$local = get_locale();

				if( !empty( $local ) ) {

					$local_code = substr( $local, 0, 2 );

				} else {

					$local_code = "en";

				}

				/*====== RTL ======*/
				$rtl = ot_get_option( 'rtl', 'off' );

				if( $rtl == 'on' ) {

					$rtl_status = "true";

				} else {

					$rtl_status = "false";

				}

				/*====== Inline Script ======*/
				wp_add_inline_script( 'eventchamp', 'jQuery(document).ready(function($){
					$(".gt-events-calendar .gt-calendar").fullCalendar({
						header: {
							left: "' . esc_attr( $nav_links_prev ) . esc_attr( $nav_links_next ) . esc_attr( $nav_links_today ) . '",
							center: "' . esc_attr( $nav_links_title ) . '",
							right: "' . esc_attr( $type ) .  '",
						},
						' . $def . '
						navLinks: ' . esc_attr( $atts["nav-links"] ) . ',
						editable: ' . esc_attr( $atts["editable"] ) . ',
						showNonCurrentDates: "' . esc_attr( $atts["current-dates"] ) . '",
						defaultDate: "' . esc_attr( $atts["default-date"] ) . '",
						eventLimit: true,
						firstDay: ' . esc_attr( $first_day ) . ',
						locale: "' . esc_attr( $local_code ) . '",
						titleFormat: "' . esc_attr( $atts["title-format"] ) . '",
						events: [' . $items . '],
						themeSystem: "standard",
						selectable: ' . esc_attr( $atts["selectable"] ) . ',
						height: ' . esc_attr( $atts["height"] ) . ',
						contentHeight: "' . esc_attr( $atts["content-height"] ) . '",
						allDayText: "' . esc_html__( 'Dia Todo', 'eventchamp-core' ) . '",
						noEventsMessage: "' . esc_html__( 'No events to display.', 'eventchamp-core' ) . '",
						isRTL: ' . esc_attr( $rtl_status ) . ',
						buttonText: {
							today: "' . esc_html__( 'Today', 'eventchamp-core' ) . '",
							month: "' . esc_html__( 'Mês', 'eventchamp-core' ) . '",
							week: "' . esc_html__( 'Semana', 'eventchamp-core' ) . '",
							day: "' . esc_html__( 'Dia', 'eventchamp-core' ) . '",
							list: "' . esc_html__( 'Lista', 'eventchamp-core' ) . '",
						}
					});
				});' );

				/*====== Creating FullCalendar ======*/
				$output .= '<div class="gt-events-calendar gt-' . esc_attr( $atts["style"] ) . '">';
					$output .= '<div class="gt-calendar"></div>';
				$output .= '</div>';

			} else {

				$output .= wpautop( esc_html__( 'It looks like there are no events.', 'eventchamp-core' ) );

			}

		}
		wp_reset_postdata();

		return $output;

	}
	add_shortcode( "eventchamp_event_calendar", "eventchamp_event_calendar_output" );

	if( function_exists( 'vc_map' ) ) {

		vc_map(
			array(
				"name" => esc_html__( 'Events Calendar', 'eventchamp-core' ),
				"base" => "eventchamp_event_calendar",
				"category" => esc_html__( 'Eventchamp Theme', 'eventchamp-core' ),
				"icon" => get_template_directory_uri() . '/include/assets/img/icons/events-calendar.jpg',
				"description" => esc_html__( 'List events on the calendar', 'eventchamp-core' ),
				"params" => array(
					array(
						"type" => "dropdown",
						"param_name" => "style",
						"heading" => esc_html__( 'Style', 'eventchamp-core' ),
						"group" => esc_html__( 'General', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'Style 1', 'eventchamp-core' ) => 'style-1',
							esc_html__( 'Style 2', 'eventchamp-core' ) => 'style-2',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "contenttype",
						"heading" => esc_html__( 'Calendar Type', 'eventchamp-core' ),
						"group" => esc_html__( 'General', 'eventchamp-core' ),
						'admin_label' => true,
						'save_always' => true,
						"value" => array(
							esc_html__( 'Calendar', 'eventchamp-core' ) => 'calendar',
							esc_html__( 'Calendar + List Week', 'eventchamp-core' ) => 'calendarlistweek',
							esc_html__( 'Calendar + List Day', 'eventchamp-core' ) => 'calendarlistday',
							esc_html__( 'Fully', 'eventchamp-core' ) => 'fully',
							esc_html__( 'List Year', 'eventchamp-core' ) => 'listyear',
							esc_html__( 'List Month', 'eventchamp-core' ) => 'listmonth',
							esc_html__( 'List Week', 'eventchamp-core' ) => 'listweek',
							esc_html__( 'List Day', 'eventchamp-core' ) => 'listday',
							esc_html__( 'External Dragging', 'eventchamp-core' ) => 'externaldragging',
						),
					),
					array(
						"type" => "textfield",
						"param_name" => "include-events",
						"heading" => esc_html__( 'Include Events', 'eventchamp-core' ),
						"description" => esc_html__( 'Separate with commas. Example: 1, 2, 3 etc.', 'eventchamp-core' ),
						"group" => esc_html__( 'General', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "exclude-events",
						"heading" => esc_html__( 'Exclude Events', 'eventchamp-core' ),
						"description" => esc_html__( 'Separate with commas. Example: 1, 2, 3 etc.', 'eventchamp-core' ),
						"group" => esc_html__( 'General', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "dropdown",
						"param_name" => "hide-expired",
						"heading" => esc_html__( 'Hide Expired Events', 'eventchamp-core' ),
						"group" => esc_html__( 'General', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "repeater-events",
						"heading" => esc_html__( 'Repeater Events', 'eventchamp-core' ),
						"description" => esc_html__( 'Make this feature true if you want to show the repeat dates of events.', 'eventchamp-core' ),
						"group" => esc_html__( 'General', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "textfield",
						"param_name" => "first-day",
						"heading" => esc_html__( 'First Day of Week', 'eventchamp-core' ),
						"description" => esc_html__( 'Sunday = 0, Monday = 1, Tuesday = 2, etc. Default: 0', 'eventchamp-core' ),
						"group" => esc_html__( 'General', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "dropdown",
						"param_name" => "selectable",
						"heading" => esc_html__( 'Selectable', 'eventchamp-core' ),
						"group" => esc_html__( 'General', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "nav-links",
						"heading" => esc_html__( 'Nav Links', 'eventchamp-core' ),
						"group" => esc_html__( 'General', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "nav-links-prev",
						"heading" => esc_html__( 'Prev Button', 'eventchamp-core' ),
						"group" => esc_html__( 'General', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "nav-links-next",
						"heading" => esc_html__( 'Next Button', 'eventchamp-core' ),
						"group" => esc_html__( 'General', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "nav-links-today",
						"heading" => esc_html__( 'Today Button', 'eventchamp-core' ),
						"group" => esc_html__( 'General', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "nav-links-title",
						"heading" => esc_html__( 'Title', 'eventchamp-core' ),
						"group" => esc_html__( 'General', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "editable",
						"heading" => esc_html__( 'Editable', 'eventchamp-core' ),
						"group" => esc_html__( 'General', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "current-dates",
						"heading" => esc_html__( 'Show Non Current Dates', 'eventchamp-core' ),
						"group" => esc_html__( 'General', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "textfield",
						"param_name" => "default-date",
						"heading" => esc_html__( 'Default Date', 'eventchamp-core' ),
						"description" => esc_html__( 'The initial date displayed when the calendar first loads. When not specified, this value defaults to the current date. Format: 2022-02-21', 'eventchamp-core' ),
						"group" => esc_html__( 'General', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "title-format",
						"heading" => esc_html__( 'Date Format for the Title', 'eventchamp-core' ),
						"description" => esc_html__( 'Default: MMMM YYYY', 'eventchamp-core' ),
						"group" => esc_html__( 'General', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "height",
						"heading" => esc_html__( 'Calendar Height', 'eventchamp-core' ),
						"description" => esc_html__( 'Default: 1000', 'eventchamp-core' ),
						"group" => esc_html__( 'General', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "exclude-categories",
						"heading" => esc_html__( 'Exclude Categories', 'eventchamp-core' ),
						"description" => esc_html__( 'Separate with commas. Example: 1, 2, 3 etc.', 'eventchamp-core' ),
						"group" => esc_html__( 'Taxonomies', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "exclude-locations",
						"heading" => esc_html__( 'Exclude Locations', 'eventchamp-core' ),
						"description" => esc_html__( 'Separate with commas. Example: 1, 2, 3 etc.', 'eventchamp-core' ),
						"group" => esc_html__( 'Taxonomies', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "exclude-organizers",
						"heading" => esc_html__( 'Exclude Organizers', 'eventchamp-core' ),
						"description" => esc_html__( 'Separate with commas. Example: 1, 2, 3 etc.', 'eventchamp-core' ),
						"group" => esc_html__( 'Taxonomies', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "exclude-tags",
						"heading" => esc_html__( 'Exclude Tags', 'eventchamp-core' ),
						"description" => esc_html__( 'Separate with commas. Example: 1, 2, 3 etc.', 'eventchamp-core' ),
						"group" => esc_html__( 'Taxonomies', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "include-categories",
						"heading" => esc_html__( 'Include Categories', 'eventchamp-core' ),
						"description" => esc_html__( 'Separate with commas. Example: 1, 2, 3 etc.', 'eventchamp-core' ),
						"group" => esc_html__( 'Taxonomies', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "include-locations",
						"heading" => esc_html__( 'Include Locations', 'eventchamp-core' ),
						"description" => esc_html__( 'Separate with commas. Example: 1, 2, 3 etc.', 'eventchamp-core' ),
						"group" => esc_html__( 'Taxonomies', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "include-organizers",
						"heading" => esc_html__( 'Include Organizers', 'eventchamp-core' ),
						"description" => esc_html__( 'Separate with commas. Example: 1, 2, 3 etc.', 'eventchamp-core' ),
						"group" => esc_html__( 'Taxonomies', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "include-tags",
						"heading" => esc_html__( 'Include Tag', 'eventchamp-core' ),
						"description" => esc_html__( 'Separate with commas. Example: 1, 2, 3 etc.', 'eventchamp-core' ),
						"group" => esc_html__( 'Taxonomies', 'eventchamp-core' ),
						'save_always' => true,
					),
				),
			)
		);
	}

}