<?php
/*======
*
* Event Listing
*
======*/
if( !function_exists( 'eventchamp_the_events_calendar_events_output' ) ) {

	function eventchamp_the_events_calendar_events_output( $atts, $content = null ) {

		/*====== Atts ======*/
		$atts = shortcode_atts(
			array(
				'include-events' => '',
				'exclude-events' => '',
				'count' => '',
				'offset' => '',
				'order' => '',
				'order-type' => '',
				'include-categories' => '',
				'exclude-categories' => '',
				'include-tags' => '',
				'exclude-tags' => '',
				'type' => '',
				'style' => '',
				'column' => '',
				'column-space' => '',
				'image-size' => '',
				'category' => '',
				'start-date' => '',
				'end-date' => '',
				'venue' => '',
				'organizer' => '',
				'excerpt' => '',
				'carousel-column' => '',
				'carousel-column-space' => '',
				'carousel-autoplay' => '',
				'carousel-autoplay-delay' => '15000',
				'carousel-loop' => '',
				'carousel-slide-speed' => '1000',
				'carousel-centered-slides' => '',
				'carousel-direction' => '',
				'carousel-effect' => '',
				'carousel-free-mode' => '',
				'carousel-navigation' => '',
				'carousel-all-events-button' => '',
				'categorized-all-events-tab' => '',
				'categorized-all-events-button' => '',
				'categorized-category-align' => '',
				'categorized-taxonomy-order' => '',
				'categorized-taxonomy-order-type' => '',
				'categorized-empty-taxonomies' => '',
				'categorized-childless' => '',
			), $atts
		);

		/*====== Slider Autoplay Delay ======*/
		if( empty( $atts["carousel-autoplay-delay"] ) ) {

			$atts["carousel-autoplay-delay"] = "15000";

		}

		/*====== Slider Slide Speed ======*/
		if( empty( $atts["carousel-slide-speed"] ) ) {

			$atts["carousel-slide-speed"] = "1000";

		}

		/*====== Taxonomy Order ======*/
		if( empty( $atts["categorized-taxonomy-order"] ) ) {

			$atts["categorized-taxonomy-order"] = "ASC";

		}

		/*====== Taxonomy Order Type ======*/
		if( empty( $atts["categorized-taxonomy-order-type"] ) ) {

			$atts["categorized-taxonomy-order-type"] = "name";

		}

		/*====== Empty Categories ======*/
		if( $atts['categorized-empty-taxonomies'] == 'false' ) {

			$empty_taxonomies = false;

		} else {

			$empty_taxonomies = true;

		}

		/*====== Childless ======*/
		if( $atts['categorized-childless'] == 'false' ) {

			$childless = false;

		} else {

			$childless = true;

		}

		/*====== Include Categories ======*/
		$include_categories_array = "";

		if( !empty( $atts['include-categories'] ) ) {

			$include_categories_array = array(
				'taxonomy' => 'tribe_events_cat',
				'field' => 'term_id',
				'terms' => $atts['include-categories'],
				'operator' => 'IN',
			);

		}

		/*====== Exclude Categories ======*/
		$exclude_categories_array = "";

		if( !empty( $atts['exclude-categories'] ) ) {

			$exclude_categories_array = array(
				'taxonomy' => 'tribe_events_cat',
				'field' => 'term_id',
				'terms' => $atts['exclude-categories'],
				'operator' => 'NOT IN',
			);

		}

		/*====== Include Tags ======*/
		$include_tags_array = "";

		if( !empty( $atts['include-tags'] ) ) {

			$include_tags_array = array(
				'taxonomy' => 'post_tag',
				'field' => 'term_id',
				'terms' => $atts['include-tags'],
				'operator' => 'IN',
			);

		}

		/*====== Exclude Tags ======*/
		$exclude_tags_array = "";

		if( !empty( $atts['exclude-tags'] ) ) {

			$exclude_tags_array = array(
				'taxonomy' => 'post_tag',
				'field' => 'term_id',
				'terms' => $atts['exclude-tags'],
				'operator' => 'NOT IN',
			);

		}

		/*====== Main Query ======*/
		$query = array(
			'posts_per_page' => $atts['count'],
			'offset' => $atts['offset'],
			'order' => $atts['order'],
			'eventDisplay' => $atts['order-type'],
			'tax_query' => array(
				'relation' => 'AND',
				$include_categories_array,
				$exclude_categories_array,
				$include_tags_array,
				$exclude_tags_array,
			),
		);

		/*====== Include Posts ======*/
		if( !empty( $atts['include-events'] ) ) {

			$include_events = $atts['include-events'];
			$include_events = explode( ',', $include_events );

		} else {

			$include_events = "";

		}

		if( !empty( $include_events ) ) {

			$extra_query = array(
				'post__in' => $include_events,
			);
			$query = wp_parse_args( $query, $extra_query );

		}

		/*====== Exclude Posts ======*/
		if( !empty( $atts['exclude-events'] ) ) {

			$exclude_events = $atts['exclude-events'];
			$exclude_events = explode( ',', $exclude_events );

		} else {

			$exclude_events = "";

		}

		if( !empty( $exclude_events ) ) {

			$extra_query = array(
				'post__not_in' => $exclude_events,
			);
			$query = wp_parse_args( $query, $extra_query );

		}

		/*====== Get Events ======*/
		$events = tribe_get_events( $query );

		/*====== Get Terms ======*/
		$event_cat_terms = get_terms(
			array(
				'taxonomy' => 'tribe_events_cat',
				'order' => $atts["categorized-taxonomy-order"],
				'orderby' => $atts["categorized-taxonomy-order-type"],
				'exclude' => $atts['exclude-categories'],
				'include' => $atts['include-categories'],
				'hide_empty' => $empty_taxonomies,
				'childless' => $childless,
			)
		);

		/*====== HTML Output ======*/
		$output = "";

		if( !empty( $events ) ) {

			if( $atts["type"] == "grid" or $atts["type"] == "carousel" ) {

				if( $atts["type"] == "grid" ) {

					$output .= '<div class="gt-event-listing">';
						$output .= '<div class="gt-columns gt-column-' . esc_attr( $atts["column"] ) . ' gt-column-space-' . esc_attr( $atts["column-space"] ) . '">';

				} else {

					$output .= '<div class="gt-events-carousel">';
						$output .= '<div class="swiper-container gt-swiper-slider" data-gt-item="' . esc_attr( $atts["carousel-column"] ) . '" data-gt-item-space="' . esc_attr( $atts["carousel-column-space"] ) . '" data-gt-loop="' . esc_attr( $atts["carousel-loop"] ) . '" data-gt-speed="' . esc_attr( $atts["carousel-slide-speed"] ) . '" data-gt-direction="' . esc_attr( $atts["carousel-direction"] ) . '" data-gt-effect="' . esc_attr( $atts["carousel-effect"] ) . '" data-gt-centered-slides="' . esc_attr( $atts["carousel-centered-slides"] ) . '" data-gt-free-mode="' . esc_attr( $atts["carousel-free-mode"] ) . '">';
							$output .= '<div class="swiper-wrapper">';

				}

					foreach( $events as $event_item ) {

						if( !empty( $event_item ) ) {

							if( $atts["type"] == "grid" ) {

								 $output .= '<div class="gt-col">';
									 $output .= '<div class="gt-inner">';

							} else {

								if( $atts["carousel-autoplay"] == "true" ) {

									$output .= '<div class="swiper-slide" data-swiper-autoplay="' . esc_attr( $atts["carousel-autoplay-delay"] ) . '">';

								} else {

									$output .= '<div class="swiper-slide">';

								}

							}

								if( $atts["style"] == "style-1" ) {

									$output .= eventchamp_the_events_calendar_event_style_1( $post_id = esc_attr( $event_item->ID ), $image = "true", $category = esc_attr( $atts["category"] ), $start_date = esc_attr( $atts["start-date"] ), $end_date = esc_attr( $atts["end-date"] ), $venue = esc_attr( $atts["venue"] ), $organizer = esc_attr( $atts["organizer"] ), $excerpt = esc_attr( $atts["excerpt"] ), $image_size = esc_attr( $atts["image-size"] ) );

								} elseif( $atts["style"] == "style-2" ) {

									$output .= eventchamp_the_events_calendar_event_style_2( $post_id = esc_attr( $event_item->ID ), $image = "true", $category = esc_attr( $atts["category"] ), $start_date = esc_attr( $atts["start-date"] ), $end_date = esc_attr( $atts["end-date"] ), $venue = esc_attr( $atts["venue"] ), $organizer = esc_attr( $atts["organizer"] ), $excerpt = esc_attr( $atts["excerpt"] ), $image_size = esc_attr( $atts["image-size"] ) );


								} elseif( $atts["style"] == "style-3" ) {

									$output .= eventchamp_the_events_calendar_event_style_3( $post_id = esc_attr( $event_item->ID ), $image = "true", $category = esc_attr( $atts["category"] ), $start_date = esc_attr( $atts["start-date"] ), $end_date = esc_attr( $atts["end-date"] ), $venue = esc_attr( $atts["venue"] ), $organizer = esc_attr( $atts["organizer"] ), $excerpt = esc_attr( $atts["excerpt"] ), $image_size = esc_attr( $atts["image-size"] ) );

								}

							if( $atts["type"] == "grid" ) {

									$output .= '</div>';
								$output .= '</div>';

							} else {

								$output .= '</div>';

							}


						}

					}

				if( $atts["type"] == "grid" ) {

						$output .= '</div>';
					$output .= '</div>';

				} else {

							$output .= '</div>';

							if( $atts["carousel-navigation"] == "true" or $atts["carousel-all-events-button"] == "true" ) {

								$output .= '<div class="gt-pagination">';

									if( $atts["carousel-navigation"] == "true" ) {

										$output .= '<div class="gt-carousel-prev">';
											$output .= '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><polyline points="15 18 9 12 15 6"></polyline></svg>';
										$output .= '</div>';

									}

									if( $atts["carousel-all-events-button"] == "true" ) {

										$output .= '<div>';
											$output .= '<a href="' . esc_url( tribe_events_get_url() ) . '" class="gt-all-button">' . esc_html__( 'All Events', 'eventchamp-core' ) . '</a>';
										$output .= '</div>';

									}

									if( $atts["carousel-navigation"] == "true" ) {

										$output .= '<div class="gt-carousel-next">';
											$output .= '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><polyline points="9 18 15 12 9 6"></polyline></svg>';
										$output .= '</div>';

									}

								$output .= '</div>';

							}

						$output .= '</div>';
					$output .= '</div>';

				}

			} elseif( $atts["type"] == "categorized" ) {

				$output .= '<div class="gt-categorized-contents gt-tab-panel">';
					$output .= '<ul class="nav gt-nav gt-' . esc_attr( $atts["categorized-category-align"] ) . '" role="tablist">';

						if( $atts["categorized-all-events-tab"] == "true" ) {

							$output .= '<li>';
								$output .= '<a href="#categorized-events-all" aria-controls="categorized-events-all" role="tab" data-toggle="tab" class="active">' . esc_html__( 'All', 'eventchamp-core' ) . '</a>';
							$output .= '</li>';

						}

						$i = 0;

						foreach( $event_cat_terms as $event_cat_term ) {

							if( !empty( $event_cat_term ) ) {

								$i++;

								$output .= '<li>';
									$output .= '<a href="#categorized-events-' . esc_attr( $event_cat_term->slug ) . '-' . esc_attr( $i ) . '" aria-controls="categorized-events-' . esc_attr( $event_cat_term->slug ) . '" role="tab" data-toggle="tab"' . ( $i == '1' && $atts["categorized-all-events-tab"] == "false" ? ' class="active"' : '' )  . '>' . esc_attr( $event_cat_term->name ) . '</a>';
								$output .= '</li>';

							}

						}

					$output .= '</ul>';
					$output .= '<div class="tab-content">';

						if( $atts["categorized-all-events-tab"] == "true" ) {

							$output .= '<div role="tabpanel" class="tab-pane fade active show" aria-labelledby="categorized-events-all" id="categorized-events-all">';
								$output .= '<div class="gt-columns gt-column-' . esc_attr( $atts["column"] ) . ' gt-column-space-' . esc_attr( $atts["column-space"] ) . '">';

									foreach( $events as $event_item ) {

										if( !empty( $event_item ) ) {

											$output .= '<div class="gt-col">';
												$output .= '<div class="gt-inner">';

													if( $atts["style"] == "style-1" ) {

														$output .= eventchamp_the_events_calendar_event_style_1( $post_id = esc_attr( $event_item->ID ), $image = "true", $category = esc_attr( $atts["category"] ), $start_date = esc_attr( $atts["start-date"] ), $end_date = esc_attr( $atts["end-date"] ), $venue = esc_attr( $atts["venue"] ), $organizer = esc_attr( $atts["organizer"] ), $excerpt = esc_attr( $atts["excerpt"] ), $image_size = esc_attr( $atts["image-size"] ) );

													} elseif( $atts["style"] == "style-2" ) {

														$output .= eventchamp_the_events_calendar_event_style_2( $post_id = esc_attr( $event_item->ID ), $image = "true", $category = esc_attr( $atts["category"] ), $start_date = esc_attr( $atts["start-date"] ), $end_date = esc_attr( $atts["end-date"] ), $venue = esc_attr( $atts["venue"] ), $organizer = esc_attr( $atts["organizer"] ), $excerpt = esc_attr( $atts["excerpt"] ), $image_size = esc_attr( $atts["image-size"] ) );


													} elseif( $atts["style"] == "style-3" ) {

														$output .= eventchamp_the_events_calendar_event_style_3( $post_id = esc_attr( $event_item->ID ), $image = "true", $category = esc_attr( $atts["category"] ), $start_date = esc_attr( $atts["start-date"] ), $end_date = esc_attr( $atts["end-date"] ), $venue = esc_attr( $atts["venue"] ), $organizer = esc_attr( $atts["organizer"] ), $excerpt = esc_attr( $atts["excerpt"] ), $image_size = esc_attr( $atts["image-size"] ) );

													}

												$output .= '</div>';
											$output .= '</div>';

										}

									}

								$output .= '</div>';

								if( $atts["categorized-all-events-button"] == "true" ) {

									$output .= '<div class="gt-pagination">';
										$output .= '<a href="' . esc_url( tribe_events_get_url() ) . '" class="gt-all-button">';
											$output .= esc_html__( 'All Events', 'eventchamp-core' );
										$output .= '</a>';
									$output .= '</div>';

								}
							$output .= '</div>';

						}

						$i = 0;

						foreach( $event_cat_terms as $event_cat_term ) {

							if( !empty( $event_cat_term ) ) {

								/*====== Main Query ======*/
								$tab_query = array(
									'posts_per_page' => $atts['count'],
									'offset' => $atts['offset'],
									'order' => $atts['order'],
									'eventDisplay' => $atts['order-type'],
									'tax_query' => array(
										'relation' => 'AND',
										array(
											'taxonomy' => 'tribe_events_cat',
											'field' => 'term_id',
											'terms' => $event_cat_term,
											'operator' => 'IN',
										),
										$include_tags_array,
										$exclude_tags_array,
									),
								);

								/*====== Include Posts ======*/
								if( !empty( $atts['include-events'] ) ) {

									$include_events = $atts['include-events'];
									$include_events = explode( ',', $include_events );

								} else {

									$include_events = "";

								}

								if( !empty( $include_events ) ) {

									$extra_query = array(
										'post__in' => $include_events,
									);
									$tab_query = wp_parse_args( $tab_query, $extra_query );

								}

								/*====== Exclude Posts ======*/
								if( !empty( $atts['exclude-events'] ) ) {

									$exclude_events = $atts['exclude-events'];
									$exclude_events = explode( ',', $exclude_events );

								} else {

									$exclude_events = "";

								}

								if( !empty( $exclude_events ) ) {

									$extra_query = array(
										'post__not_in' => $exclude_events,
									);
									$tab_query = wp_parse_args( $tab_query, $extra_query );

								}

								/*====== Get Events ======*/
								$tab_events = tribe_get_events( $tab_query );

								if( !empty( $tab_events ) ) {

									$i++;

									$output .= '<div role="tabpanel" class="tab-pane fade' . ( $i == "1" && $atts["categorized-all-events-tab"] == "false" ? ' active show' : '' )  . '" id="categorized-events-' . esc_attr( $event_cat_term->slug ) . '-' . esc_attr( $i ) . '" aria-labelledby="categorized-events-' . esc_attr( $event_cat_term->slug ) . '">';

										$output .= '<div class="gt-columns gt-column-' . esc_attr( $atts["column"] ) . ' gt-column-space-' . esc_attr( $atts["column-space"] ) . '">';

											foreach( $tab_events as $tab_event_item ) {

												if( !empty( $tab_event_item ) ) {

													$output .= '<div class="gt-col">';
														$output .= '<div class="gt-inner">';

															if( $atts["style"] == "style-1" ) {

																$output .= eventchamp_the_events_calendar_event_style_1( $post_id = esc_attr( $tab_event_item->ID ), $image = "true", $category = esc_attr( $atts["category"] ), $start_date = esc_attr( $atts["start-date"] ), $end_date = esc_attr( $atts["end-date"] ), $venue = esc_attr( $atts["venue"] ), $organizer = esc_attr( $atts["organizer"] ), $excerpt = esc_attr( $atts["excerpt"] ), $image_size = esc_attr( $atts["image-size"] ) );

															} elseif( $atts["style"] == "style-2" ) {

																$output .= eventchamp_the_events_calendar_event_style_2( $post_id = esc_attr( $tab_event_item->ID ), $image = "true", $category = esc_attr( $atts["category"] ), $start_date = esc_attr( $atts["start-date"] ), $end_date = esc_attr( $atts["end-date"] ), $venue = esc_attr( $atts["venue"] ), $organizer = esc_attr( $atts["organizer"] ), $excerpt = esc_attr( $atts["excerpt"] ), $image_size = esc_attr( $atts["image-size"] ) );


															} elseif( $atts["style"] == "style-3" ) {

																$output .= eventchamp_the_events_calendar_event_style_3( $post_id = esc_attr( $tab_event_item->ID ), $image = "true", $category = esc_attr( $atts["category"] ), $start_date = esc_attr( $atts["start-date"] ), $end_date = esc_attr( $atts["end-date"] ), $venue = esc_attr( $atts["venue"] ), $organizer = esc_attr( $atts["organizer"] ), $excerpt = esc_attr( $atts["excerpt"] ), $image_size = esc_attr( $atts["image-size"] ) );

															}

														$output .= '</div>';
													$output .= '</div>';

												}

											}

										$output .= '</div>';

										if( $atts["categorized-all-events-button"] == "true" ) {

											$output .= '<div class="gt-pagination">';
												$output .= '<a href="' . esc_url( tribe_events_get_url() ) . '" class="gt-all-button">';
													$output .= sprintf( esc_html__( 'All %1$s Events', 'eventchamp-core' ), esc_attr( $event_cat_term->name ) );
												$output .= '</a>';
											$output .= '</div>';

										}
									$output .= '</div>';

								}

							}

						}

					$output .= '</div>';

				$output .= '</div>';

			}

		}

		return $output;

	}
	add_shortcode( "eventchamp_the_events_calendar_events", "eventchamp_the_events_calendar_events_output" );

	if( function_exists( 'vc_map' ) ) {

		vc_map(
			array(
				"name" => esc_html__( 'The Events Calendar: Events', 'eventchamp-core' ),
				"base" => "eventchamp_the_events_calendar_events",
				"category" => esc_html__( 'Eventchamp Theme', 'eventchamp-core' ),
				"icon" => get_template_directory_uri() . '/include/assets/img/icons/event-listing.jpg',
				"description" => esc_html__( 'List the events of The Events Calendar', 'eventchamp-core' ),
				"params" => array(
					array(
						"type" => "textfield",
						"param_name" => "include-events",
						"heading" => esc_html__( 'Include Events', 'eventchamp-core' ),
						"description" => esc_html__( 'Separate with commas. Example: 1, 2, 3 etc.', 'eventchamp-core' ),
						"group" => esc_html__( 'General', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "exclude-events",
						"heading" => esc_html__( 'Exclude Events', 'eventchamp-core' ),
						"description" => esc_html__( 'Separate with commas. Example: 1, 2, 3 etc.', 'eventchamp-core' ),
						"group" => esc_html__( 'General', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "count",
						"heading" => esc_html__( 'Count', 'eventchamp-core' ),
						"group" => esc_html__( 'General', 'eventchamp-core' ),
						'admin_label' => true,
						'save_always' => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "offset",
						"heading" => esc_html__( 'Offset', 'eventchamp-core' ),
						"group" => esc_html__( 'General', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "dropdown",
						"param_name" => "order",
						"heading" => esc_html__( 'Order', 'eventchamp-core' ),
						"group" => esc_html__( 'General', 'eventchamp-core' ),
						"save_always" => true,
						"value" => array(
							esc_html__( 'ASC', 'eventchamp-core' ) => 'ASC',
							esc_html__( 'DESC', 'eventchamp-core' ) => 'DESC',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "order-type",
						"heading" => esc_html__( 'Order Type', 'eventchamp-core' ),
						"group" => esc_html__( 'General', 'eventchamp-core' ),
						'admin_label' => true,
						"save_always" => true,
						"value" => array(
							esc_html__( 'All', 'eventchamp-core' ) => 'all',
							esc_html__( 'List', 'eventchamp-core' ) => 'list',
							esc_html__( 'Past', 'eventchamp-core' ) => 'past',
						),
					),
					array(
						"type" => "textfield",
						"param_name" => "include-categories",
						"heading" => esc_html__( 'Include Categories', 'eventchamp-core' ),
						"description" => esc_html__( 'Separate with commas. Example: 1, 2, 3 etc.', 'eventchamp-core' ),
						"group" => esc_html__( 'Taxonomies', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "exclude-categories",
						"heading" => esc_html__( 'Exclude Categories', 'eventchamp-core' ),
						"description" => esc_html__( 'Separate with commas. Example: 1, 2, 3 etc.', 'eventchamp-core' ),
						"group" => esc_html__( 'Taxonomies', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "include-tags",
						"heading" => esc_html__( 'Include Tags', 'eventchamp-core' ),
						"description" => esc_html__( 'Separate with commas. Example: 1, 2, 3 etc.', 'eventchamp-core' ),
						"group" => esc_html__( 'Taxonomies', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "exclude-tags",
						"heading" => esc_html__( 'Exclude Tags', 'eventchamp-core' ),
						"description" => esc_html__( 'Example: Event.', 'eventchamp-core' ),
						"group" => esc_html__( 'Taxonomies', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "dropdown",
						"param_name" => "type",
						"heading" => esc_html__( 'Type', 'eventchamp-core' ),
						"group" => esc_html__( 'Design', 'eventchamp-core' ),
						'admin_label' => true,
						'save_always' => true,
						"value" => array(
							esc_html__( 'Grid', 'eventchamp-core' ) => 'grid',
							esc_html__( 'Carousel', 'eventchamp-core' ) => 'carousel',
							esc_html__( 'Categorized', 'eventchamp-core' ) => 'categorized',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "style",
						"heading" => esc_html__( 'Style', 'eventchamp-core' ),
						"group" => esc_html__( 'Design', 'eventchamp-core' ),
						'admin_label' => true,
						'save_always' => true,
						"value" => array(
							esc_html__( 'Style 1', 'eventchamp-core' ) => 'style-1',
							esc_html__( 'Style 2', 'eventchamp-core' ) => 'style-2',
							esc_html__( 'Style 3', 'eventchamp-core' ) => 'style-3',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "column",
						"heading" => esc_html__( 'Column', 'eventchamp-core' ),
						"group" => esc_html__( 'Design', 'eventchamp-core' ),
						'admin_label' => true,
						'save_always' => true,
						"value" => array(
							esc_html__( '1 Column', 'eventchamp-core' ) => '1',
							esc_html__( '2 Column', 'eventchamp-core' ) => '2',
							esc_html__( '3 Column', 'eventchamp-core' ) => '3',
							esc_html__( '4 Column', 'eventchamp-core' ) => '4',
							esc_html__( '5 Column', 'eventchamp-core' ) => '5',
							esc_html__( '6 Column', 'eventchamp-core' ) => '6',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "column-space",
						"heading" => esc_html__( 'Column Space', 'eventchamp-core' ),
						"group" => esc_html__( 'Design', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( '0', 'eventchamp-core' ) => '0',
							esc_html__( '5', 'eventchamp-core' ) => '5',
							esc_html__( '10', 'eventchamp-core' ) => '10',
							esc_html__( '15', 'eventchamp-core' ) => '15',
							esc_html__( '20', 'eventchamp-core' ) => '20',
							esc_html__( '25', 'eventchamp-core' ) => '25',
							esc_html__( '30', 'eventchamp-core' ) => '30',
							esc_html__( '35', 'eventchamp-core' ) => '35',
							esc_html__( '40', 'eventchamp-core' ) => '40',
							esc_html__( '45', 'eventchamp-core' ) => '45',
							esc_html__( '50', 'eventchamp-core' ) => '50',
							esc_html__( '55', 'eventchamp-core' ) => '55',
							esc_html__( '60', 'eventchamp-core' ) => '60',
						),
					),
					array(
						"type" => "textfield",
						"param_name" => "image-size",
						"heading" => esc_html__( 'Image Size', 'eventchamp-core' ),
						"description" => esc_html__( 'Enter an image size. Example: thumbnail, medium, large, full or other sizes defined by theme.', 'eventchamp-core' ),
						"group" => esc_html__( 'Design', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "dropdown",
						"param_name" => "category",
						"heading" => esc_html__( 'Category', 'eventchamp-core' ),
						"group" => esc_html__( 'Design', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "start-date",
						"heading" => esc_html__( 'Data inicial', 'eventchamp-core' ),
						"group" => esc_html__( 'Design', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "end-date",
						"heading" => esc_html__( 'End Date', 'eventchamp-core' ),
						"group" => esc_html__( 'Design', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "venue",
						"heading" => esc_html__( 'Venue', 'eventchamp-core' ),
						"group" => esc_html__( 'Design', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "organizer",
						"heading" => esc_html__( 'Organizer', 'eventchamp-core' ),
						"group" => esc_html__( 'Design', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "excerpt",
						"heading" => esc_html__( 'Excerpt', 'eventchamp-core' ),
						"group" => esc_html__( 'Design', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "carousel-column",
						"heading" => esc_html__( 'Column', 'eventchamp-core' ),
						"group" => esc_html__( 'Carousel', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( '1 Column', 'eventchamp-core' ) => '1',
							esc_html__( '2 Column', 'eventchamp-core' ) => '2',
							esc_html__( '3 Column', 'eventchamp-core' ) => '3',
							esc_html__( '4 Column', 'eventchamp-core' ) => '4',
							esc_html__( '5 Column', 'eventchamp-core' ) => '5',
							esc_html__( '6 Column', 'eventchamp-core' ) => '6',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "carousel-column-space",
						"heading" => esc_html__( 'Column Space', 'eventchamp-core' ),
						"group" => esc_html__( 'Carousel', 'eventchamp-core' ),
						"save_always" => true,
						"value" => array(
							esc_html__( '0', 'eventchamp-core' ) => '0',
							esc_html__( '1', 'eventchamp-core' ) => '1',
							esc_html__( '2', 'eventchamp-core' ) => '2',
							esc_html__( '3', 'eventchamp-core' ) => '3',
							esc_html__( '4', 'eventchamp-core' ) => '4',
							esc_html__( '5', 'eventchamp-core' ) => '5',
							esc_html__( '10', 'eventchamp-core' ) => '10',
							esc_html__( '15', 'eventchamp-core' ) => '15',
							esc_html__( '20', 'eventchamp-core' ) => '20',
							esc_html__( '25', 'eventchamp-core' ) => '25',
							esc_html__( '30', 'eventchamp-core' ) => '30',
							esc_html__( '45', 'eventchamp-core' ) => '45',
							esc_html__( '50', 'eventchamp-core' ) => '50',
							esc_html__( '55', 'eventchamp-core' ) => '55',
							esc_html__( '60', 'eventchamp-core' ) => '60',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "carousel-autoplay",
						"heading" => esc_html__( 'Autoplay', 'eventchamp-core' ),
						"group" => esc_html__( 'Carousel', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "textfield",
						"param_name" => "carousel-autoplay-delay",
						"heading" => esc_html__( 'Autoplay Delay', 'eventchamp-core' ),
						"description" => esc_html__( 'Default: 1000', 'eventchamp-core' ),
						"group" => esc_html__( 'Carousel', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "dropdown",
						"param_name" => "carousel-loop",
						"heading" => esc_html__( 'Loop', 'eventchamp-core' ),
						"group" => esc_html__( 'Carousel', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "textfield",
						"param_name" => "carousel-slide-speed",
						"heading" => esc_html__( 'Slide Speed', 'eventchamp-core' ),
						"description" => esc_html__( 'Duration of transition between the slides. Default: 1500', 'eventchamp-core' ),
						"group" => esc_html__( 'Carousel', 'eventchamp-core' ),
						"save_always" => true,
					),
					array(
						"type" => "dropdown",
						"param_name" => "carousel-centered-slides",
						"heading" => esc_html__( 'Centered Slides', 'eventchamp-core' ),
						"description" => esc_html__( 'If you choose true, then active slide will be centered, not always on the left side.', 'eventchamp-core' ),
						"group" => esc_html__( 'Carousel', 'eventchamp-core' ),
						"save_always" => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "carousel-direction",
						"heading" => esc_html__( 'Direction', 'eventchamp-core' ),
						"group" => esc_html__( 'Carousel', 'eventchamp-core' ),
						"save_always" => true,
						"value" => array(
							esc_html__( 'Horizontal', 'eventchamp-core' ) => 'horizontal',
							esc_html__( 'Vertical', 'eventchamp-core' ) => 'vertical',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "carousel-effect",
						"heading" => esc_html__( 'Effect', 'eventchamp-core' ),
						"group" => esc_html__( 'Carousel', 'eventchamp-core' ),
						"save_always" => true,
						"value" => array(
							esc_html__( 'Slide', 'eventchamp-core' ) => 'slide',
							esc_html__( 'Fade', 'eventchamp-core' ) => 'fade',
							esc_html__( 'Cube', 'eventchamp-core' ) => 'cube',
							esc_html__( 'Coverflow', 'eventchamp-core' ) => 'coverflow',
							esc_html__( 'Flip', 'eventchamp-core' ) => 'flip',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "carousel-free-mode",
						"heading" => esc_html__( 'Free Mode', 'eventchamp-core' ),
						"description" => esc_html__( 'If true then slides will not have fixed positions', 'eventchamp-core' ),
						"group" => esc_html__( 'Carousel', 'eventchamp-core' ),
						"save_always" => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "carousel-navigation",
						"heading" => esc_html__( 'Navigation', 'eventchamp-core' ),
						"group" => esc_html__( 'Carousel', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "carousel-all-events-button",
						"heading" => esc_html__( 'All Events Button', 'eventchamp-core' ),
						"group" => esc_html__( 'Carousel', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "categorized-all-events-tab",
						"heading" => esc_html__( 'All Events Tab', 'eventchamp-core' ),
						"group" => esc_html__( 'Categorized', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "categorized-all-events-button",
						"heading" => esc_html__( 'All Events Button', 'eventchamp-core' ),
						"group" => esc_html__( 'Categorized', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "categorized-category-align",
						"heading" => esc_html__( 'Category Align', 'eventchamp-core' ),
						"group" => esc_html__( 'Categorized', 'eventchamp-core' ),
						"save_always" => true,
						"value" => array(
							esc_html__( 'Left', 'eventchamp-core' ) => 'left',
							esc_html__( 'Center', 'eventchamp-core' ) => 'center',
							esc_html__( 'Right', 'eventchamp-core' ) => 'right',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "categorized-taxonomy-order",
						"heading" => esc_html__( 'Taxonomy Order', 'eventchamp-core' ),
						"group" => esc_html__( 'Categorized', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'ASC', 'eventchamp-core' ) => 'ASC',
							esc_html__( 'DESC', 'eventchamp-core' ) => 'DESC',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "categorized-taxonomy-order-type",
						"heading" => esc_html__( 'Taxonomy Order Type', 'eventchamp-core' ),
						"group" => esc_html__( 'Categorized', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'Name', 'eventchamp-core' ) => 'name',
							esc_html__( 'Slug', 'eventchamp-core' ) => 'slug',
							esc_html__( 'Term Group', 'eventchamp-core' ) => 'term_group',
							esc_html__( 'Term ID', 'eventchamp-core' ) => 'term_id',
							esc_html__( 'ID', 'eventchamp-core' ) => 'id',
							esc_html__( 'Description', 'eventchamp-core' ) => 'description',
							esc_html__( 'Parent', 'eventchamp-core' ) => 'parent',
							esc_html__( 'Count', 'eventchamp-core' ) => 'count',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "categorized-empty-taxonomies",
						"heading" => esc_html__( 'Empty Taxonomies', 'eventchamp-core' ),
						"description" => esc_html__( 'If you choose true option empty taxonomies will be hide.', 'eventchamp-core' ),
						"group" => esc_html__( 'Categorized', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "categorized-childless",
						"heading" => esc_html__( 'Childless', 'eventchamp-core' ),
						"group" => esc_html__( 'Categorized', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
						),
					),
				),
			)
		);

	}

}