<?php
/*======
*
* Get An Event Content
*
======*/
if( !function_exists( 'eventchamp_event_content_output' ) ) {

	function eventchamp_event_content_output( $atts, $content = null ) {

		/*====== Atts ======*/
		$atts = shortcode_atts(
			array(
				'eventid' => '',
				'contenttype' => 'speaker',
				'speaker-style' => '1',
				'speaker-column' => '1',
				'speaker-column-space' => '0',
				'speaker-profession' => 'true',
				'speaker-company' => 'false',
				'speaker-summary' => 'true',
				'speaker-social-links' => 'true',
				'schedule-style' => '1',
				'schedule-collapsed' => 'true',
				'ticket-style' => '1',
				'price-list-column' => '1',
				'ticket-column-space' => '0',
				'sponsor-style' => '1',
				'sponsor-column' => '1',
				'sponsor-column-space' => '0',
				'photo-column' => '1',
				'photo-column-space' => '0',
				'map-style' => '1',
				'map-height' => '',
				'map-zoom' => '',
			), $atts
		);

		/*====== HTML Output ======*/
		$output = "";

		if( !empty( $atts["contenttype"] ) and !empty( $atts["eventid"] ) ) {

			$output .= '<div class="gt-get-event-content">';

				if( $atts["contenttype"] == "speaker" ) {

					$output .= eventchamp_event_speakers( $post_id = esc_attr( $atts["eventid"] ), $column = esc_attr( $atts["speaker-column"] ), $column_space = esc_attr( $atts["speaker-column-space"] ), $style = esc_attr( 'style-' . $atts["speaker-style"] ), $image = "true", $profession = esc_attr( $atts["speaker-profession"] ), $company = esc_attr( $atts["speaker-company"] ), $short_bio = esc_attr( $atts["speaker-summary"] ), $social = esc_attr( $atts["speaker-social-links"] ) );

				} elseif( $atts["contenttype"] == "schedule" ) {

					$output .= eventchamp_schedule( $post_id = esc_attr( $atts["eventid"] ), $first_open = "false", $all_open = "false", $extra_style = esc_attr( 'style-' . $atts["schedule-style"] ), $extra_all_open = esc_attr( $atts["schedule-collapsed"] ) );

				} elseif( $atts["contenttype"] == "ticket" ) {

					$output .= eventchamp_event_tickets( $post_id = esc_attr( $atts["eventid"] ), $extra_style = esc_attr( 'style-' . $atts["ticket-style"] ), $extra_column = esc_attr( $atts["price-list-column"] ), $extra_column_space = esc_attr( $atts["ticket-column-space"] ) );

				} elseif( $atts["contenttype"] == "sponsor" ) {

					$output .= eventchamp_event_sponsors( $id = esc_attr( $atts["eventid"] ), $type = "type-1", $column = esc_attr( $atts["sponsor-column"] ), $style = esc_attr( 'style-' . $atts["sponsor-style"] ), $padding = esc_attr( $atts["sponsor-column-space"] ) );

				} elseif( $atts["contenttype"] == "photo" ) {

					$output .= eventchamp_event_photos( $id = esc_attr( $atts["eventid"] ), $extra_column = esc_attr( $atts["photo-column"] ), $extra_column_space = esc_attr( $atts["photo-column-space"] ) );

				} elseif( $atts["contenttype"] == "map" ) {

					$output .= eventchamp_event_map( $id = esc_attr( $atts["eventid"] ), $map_height = esc_attr( $atts["map-height"] ), $extra_style = esc_attr( $atts["map-style"] ), $extra_zoom = esc_attr( $atts["map-zoom"] ) );

				} elseif( $atts["contenttype"] == "faq" ) {

					$output .= eventchamp_event_faq( $post_id = esc_attr( $atts["eventid"] ), $first_open = "false" );

				}

			$output .= '</div>';

		}

		return $output;

	}
	add_shortcode( "eventchamp_event_content", "eventchamp_event_content_output" );

	if( function_exists( 'vc_map' ) ) {

		vc_map(
			array(
				"name" => esc_html__( 'Get an Event Content', 'eventchamp-core' ),
				"base" => "eventchamp_event_content",
				"category" => esc_html__( 'Eventchamp Theme', 'eventchamp-core' ),
				"icon" => get_template_directory_uri() . '/include/assets/img/icons/get-event-content.jpg',
				"description" => esc_html__( 'Show the contents of an event.', 'eventchamp-core' ),
				"params" => array(
					array(
						"type" => "textfield",
						"param_name" => "eventid",
						"heading" => esc_html__( 'Event ID', 'eventchamp-core' ),
						"description" => esc_html__( 'The content will get from this event ID.', 'eventchamp-core' ),
						"group" => esc_html__( 'General', 'eventchamp-core' ),
						"admin_label" => true,
						'save_always' => true,
					),
					array(
						"type" => "dropdown",
						"param_name" => "contenttype",
						"heading" => esc_html__( 'Content Type', 'eventchamp-core' ),
						"description" => esc_html__( 'Which content do you want to get?', 'eventchamp-core' ),
						"group" => esc_html__( 'General', 'eventchamp-core' ),
						"admin_label" => true,
						'save_always' => true,
						"value" => array(
							esc_html__( 'Speakers', 'eventchamp-core' ) => 'speaker',
							esc_html__( 'Schedule', 'eventchamp-core' ) => 'schedule',
							esc_html__( 'Tickets', 'eventchamp-core' ) => 'ticket',
							esc_html__( 'Sponsors', 'eventchamp-core' ) => 'sponsor',
							esc_html__( 'Photos', 'eventchamp-core' ) => 'photo',
							esc_html__( 'Map', 'eventchamp-core' ) => 'map',
							esc_html__( 'FAQ', 'eventchamp-core' ) => 'faq',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "speaker-style",
						"heading" => esc_html__( 'Speaker Listing Style', 'eventchamp-core' ),
						"group" => esc_html__( 'Speakers', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'Style 1', 'eventchamp-core' ) => '1',
							esc_html__( 'Style 2', 'eventchamp-core' ) => '2',
							esc_html__( 'Style 3', 'eventchamp-core' ) => '3',
							esc_html__( 'Style 4', 'eventchamp-core' ) => '4',
							esc_html__( 'Style 5', 'eventchamp-core' ) => '5',
							esc_html__( 'Style 6', 'eventchamp-core' ) => '6',
							esc_html__( 'Style 7', 'eventchamp-core' ) => '7',
							esc_html__( 'Style 8', 'eventchamp-core' ) => '8',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "speaker-column",
						"heading" => esc_html__( 'Speaker Column', 'eventchamp-core' ),
						"group" => esc_html__( 'Speakers', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( '1 Column', 'eventchamp-core' ) => '1',
							esc_html__( '2 Column', 'eventchamp-core' ) => '2',
							esc_html__( '3 Column', 'eventchamp-core' ) => '3',
							esc_html__( '4 Column', 'eventchamp-core' ) => '4',
							esc_html__( '5 Column', 'eventchamp-core' ) => '5',
							esc_html__( '6 Column', 'eventchamp-core' ) => '6',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "speaker-column-space",
						"heading" => esc_html__( 'Speaker Column Space', 'eventchamp-core' ),
						"group" => esc_html__( 'Speakers', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( '0', 'eventchamp-core' ) => '0',
							esc_html__( '5', 'eventchamp-core' ) => '5',
							esc_html__( '10', 'eventchamp-core' ) => '10',
							esc_html__( '15', 'eventchamp-core' ) => '15',
							esc_html__( '20', 'eventchamp-core' ) => '20',
							esc_html__( '25', 'eventchamp-core' ) => '25',
							esc_html__( '30', 'eventchamp-core' ) => '30',
							esc_html__( '35', 'eventchamp-core' ) => '35',
							esc_html__( '40', 'eventchamp-core' ) => '40',
							esc_html__( '45', 'eventchamp-core' ) => '45',
							esc_html__( '50', 'eventchamp-core' ) => '50',
							esc_html__( '55', 'eventchamp-core' ) => '55',
							esc_html__( '60', 'eventchamp-core' ) => '60',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "speaker-profession",
						"heading" => esc_html__( 'Speaker Profession', 'eventchamp-core' ),
						"group" => esc_html__( 'Speakers', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "speaker-company",
						"heading" => esc_html__( 'Speaker Company', 'eventchamp-core' ),
						"group" => esc_html__( 'Speakers', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "speaker-summary",
						"heading" => esc_html__( 'Speaker Summary', 'eventchamp-core' ),
						"group" => esc_html__( 'Speakers', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "speaker-social-links",
						"heading" => esc_html__( 'Speaker Social Links', 'eventchamp-core' ),
						"group" => esc_html__( 'Speakers', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "schedule-style",
						"heading" => esc_html__( 'Schedule Style', 'eventchamp-core' ),
						"group" => esc_html__( 'Schedule', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'Style 1', 'eventchamp-core' ) => '1',
							esc_html__( 'Style 2', 'eventchamp-core' ) => '2',
							esc_html__( 'Style 3', 'eventchamp-core' ) => '3',
							esc_html__( 'Style 4', 'eventchamp-core' ) => '4',
							esc_html__( 'Style 5', 'eventchamp-core' ) => '5',
							esc_html__( 'Style 6', 'eventchamp-core' ) => '6',
							esc_html__( 'Style 7', 'eventchamp-core' ) => '7',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "schedule-collapsed",
						"heading" => esc_html__( 'Schedule Items Collapsed for Dropdown', 'eventchamp-core' ),
						"description" => esc_html__( 'Choose opening status of the schedule items for the dropdown version (Style 1, Style 2 and Style 3).', 'eventchamp-core' ),
						"group" => esc_html__( 'Schedule', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "ticket-style",
						"heading" => esc_html__( 'Ticket Style', 'eventchamp-core' ),
						"group" => esc_html__( 'Tickets', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'Style 1', 'eventchamp-core' ) => '1',
							esc_html__( 'Style 2', 'eventchamp-core' ) => '2',
							esc_html__( 'Style 3', 'eventchamp-core' ) => '3',
							esc_html__( 'Style 4', 'eventchamp-core' ) => '4',
							esc_html__( 'Style 5', 'eventchamp-core' ) => '5',
							esc_html__( 'Style 6', 'eventchamp-core' ) => '6',
							esc_html__( 'Style 7', 'eventchamp-core' ) => '7',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "price-list-column",
						"heading" => esc_html__( 'Ticket Column', 'eventchamp-core' ),
						"group" => esc_html__( 'Tickets', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( '1 Column', 'eventchamp-core' ) => '1',
							esc_html__( '2 Column', 'eventchamp-core' ) => '2',
							esc_html__( '3 Column', 'eventchamp-core' ) => '3',
							esc_html__( '4 Column', 'eventchamp-core' ) => '4',
							esc_html__( '5 Column', 'eventchamp-core' ) => '5',
							esc_html__( '6 Column', 'eventchamp-core' ) => '6',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "ticket-column-space",
						"heading" => esc_html__( 'Ticket Column Space', 'eventchamp-core' ),
						"group" => esc_html__( 'Tickets', 'eventchamp-core' ),
						"save_always" => true,
						"value" => array(
							esc_html__( '0', 'eventchamp-core' ) => '0',
							esc_html__( '5', 'eventchamp-core' ) => '5',
							esc_html__( '10', 'eventchamp-core' ) => '10',
							esc_html__( '15', 'eventchamp-core' ) => '15',
							esc_html__( '20', 'eventchamp-core' ) => '20',
							esc_html__( '25', 'eventchamp-core' ) => '25',
							esc_html__( '30', 'eventchamp-core' ) => '30',
							esc_html__( '35', 'eventchamp-core' ) => '35',
							esc_html__( '40', 'eventchamp-core' ) => '40',
							esc_html__( '45', 'eventchamp-core' ) => '45',
							esc_html__( '50', 'eventchamp-core' ) => '50',
							esc_html__( '55', 'eventchamp-core' ) => '55',
							esc_html__( '60', 'eventchamp-core' ) => '60',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "sponsor-style",
						"heading" => esc_html__( 'Sponsor Style', 'eventchamp-core' ),
						"group" => esc_html__( 'Sponsors', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'Style 1', 'eventchamp-core' ) => '1',
							esc_html__( 'Style 2', 'eventchamp-core' ) => '2',
							esc_html__( 'Style 3', 'eventchamp-core' ) => '3',
							esc_html__( 'Style 4', 'eventchamp-core' ) => '4',
							esc_html__( 'Style 5', 'eventchamp-core' ) => '5',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "sponsor-column",
						"heading" => esc_html__( 'Sponsor Column', 'eventchamp-core' ),
						"group" => esc_html__( 'Sponsors', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( '1 Column', 'eventchamp-core' ) => '1',
							esc_html__( '2 Column', 'eventchamp-core' ) => '2',
							esc_html__( '3 Column', 'eventchamp-core' ) => '3',
							esc_html__( '4 Column', 'eventchamp-core' ) => '4',
							esc_html__( '5 Column', 'eventchamp-core' ) => '5',
							esc_html__( '6 Column', 'eventchamp-core' ) => '6',
							esc_html__( '7 Column', 'eventchamp-core' ) => '7',
							esc_html__( '8 Column', 'eventchamp-core' ) => '8',
							esc_html__( '9 Column', 'eventchamp-core' ) => '9',
							esc_html__( '10 Column', 'eventchamp-core' ) => '10',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "sponsor-column-space",
						"heading" => esc_html__( 'Sponsor Column Space', 'eventchamp-core' ),
						"group" => esc_html__( 'Sponsors', 'eventchamp-core' ),
						"save_always" => true,
						"value" => array(
							esc_html__( '0', 'eventchamp-core' ) => '0',
							esc_html__( '5', 'eventchamp-core' ) => '5',
							esc_html__( '10', 'eventchamp-core' ) => '10',
							esc_html__( '15', 'eventchamp-core' ) => '15',
							esc_html__( '20', 'eventchamp-core' ) => '20',
							esc_html__( '25', 'eventchamp-core' ) => '25',
							esc_html__( '30', 'eventchamp-core' ) => '30',
							esc_html__( '35', 'eventchamp-core' ) => '35',
							esc_html__( '40', 'eventchamp-core' ) => '40',
							esc_html__( '45', 'eventchamp-core' ) => '45',
							esc_html__( '50', 'eventchamp-core' ) => '50',
							esc_html__( '55', 'eventchamp-core' ) => '55',
							esc_html__( '60', 'eventchamp-core' ) => '60',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "photo-column",
						"heading" => esc_html__( 'Photo Column', 'eventchamp-core' ),
						"group" => esc_html__( 'Photos', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( '1 Column', 'eventchamp-core' ) => '1',
							esc_html__( '2 Column', 'eventchamp-core' ) => '2',
							esc_html__( '3 Column', 'eventchamp-core' ) => '3',
							esc_html__( '4 Column', 'eventchamp-core' ) => '4',
							esc_html__( '5 Column', 'eventchamp-core' ) => '5',
							esc_html__( '6 Column', 'eventchamp-core' ) => '6',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "photo-column-space",
						"heading" => esc_html__( 'Photo Column Space', 'eventchamp-core' ),
						"group" => esc_html__( 'Photos', 'eventchamp-core' ),
						"save_always" => true,
						"value" => array(
							esc_html__( '0', 'eventchamp-core' ) => '0',
							esc_html__( '5', 'eventchamp-core' ) => '5',
							esc_html__( '10', 'eventchamp-core' ) => '10',
							esc_html__( '15', 'eventchamp-core' ) => '15',
							esc_html__( '20', 'eventchamp-core' ) => '20',
							esc_html__( '25', 'eventchamp-core' ) => '25',
							esc_html__( '30', 'eventchamp-core' ) => '30',
							esc_html__( '35', 'eventchamp-core' ) => '35',
							esc_html__( '40', 'eventchamp-core' ) => '40',
							esc_html__( '45', 'eventchamp-core' ) => '45',
							esc_html__( '50', 'eventchamp-core' ) => '50',
							esc_html__( '55', 'eventchamp-core' ) => '55',
							esc_html__( '60', 'eventchamp-core' ) => '60',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "map-style",
						"heading" => esc_html__( 'Map Style', 'eventchamp-core' ),
						"group" => esc_html__( 'Map', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'Style 1', 'eventchamp-core' ) => '1',
							esc_html__( 'Style 2', 'eventchamp-core' ) => '2',
							esc_html__( 'Style 3', 'eventchamp-core' ) => '3',
							esc_html__( 'Style 4', 'eventchamp-core' ) => '4',
							esc_html__( 'Style 5', 'eventchamp-core' ) => '5',
							esc_html__( 'Style 6', 'eventchamp-core' ) => '6',
							esc_html__( 'Style 7', 'eventchamp-core' ) => '7',
							esc_html__( 'Style 8', 'eventchamp-core' ) => '8',
							esc_html__( 'Style 9', 'eventchamp-core' ) => '9',
							esc_html__( 'Style 10', 'eventchamp-core' ) => '10',
							esc_html__( 'Style 11', 'eventchamp-core' ) => '11',
							esc_html__( 'Style 12', 'eventchamp-core' ) => '12',
							esc_html__( 'Style 13', 'eventchamp-core' ) => '13',
							esc_html__( 'Style 14', 'eventchamp-core' ) => '14',
						),
					),
					array(
						"type" => "textfield",
						"param_name" => "map-height",
						"heading" => esc_html__( 'Map Height', 'eventchamp-core' ),
						"description" => esc_html__( 'If enter blank it, the standart height will be apply.', 'eventchamp-core' ),
						"group" => esc_html__( 'Map', 'eventchamp-core' ),
						"save_always" => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "map-zoom",
						"heading" => esc_html__( 'Map Zoom', 'eventchamp-core' ),
						"description" => esc_html__( 'If enter blank it, the standart zoom will be apply.', 'eventchamp-core' ),
						"group" => esc_html__( 'Map', 'eventchamp-core' ),
						"save_always" => true,
					),
				),
			)
		);

	}

}