<?php
/*======
*
* FAQ
*
======*/
if( !function_exists( 'eventchamp_faq_output' ) ) {

	function eventchamp_faq_output( $atts, $content = null ) {

		/*====== Atts ======*/
		$atts = shortcode_atts(
			array(
				'first-open' => '',
				'all-open' => '',
				'items' => '',
			), $atts
		);

		/*====== Items ======*/
		$items = vc_param_group_parse_atts( $atts['items'] );

		/*====== HTML Output ======*/
		$output = "";
		$i = 0;

		if( !empty( $items ) ) {

			$output .= '<div class="gt-dropdown">';
				$output .= '<div class="gt-panel-group" id="faq-accardion" role="tablist" aria-multiselectable="true">';

					foreach( $items as $item ) {

						if( !empty( $item ) ) {

							$i++;
							$faq_rand_id = rand( 0, 999999 );

							if( !empty( $item["title"] ) and !empty( $item["content"] ) ) {

								$output .= '<div class="gt-panel">';

									if( !empty( $item["title"] ) ) {

										$output .= '<div class="gt-panel-heading" role="tab" id="#faq-heading-' . esc_attr( $faq_rand_id ) . '">';
											$output .= '<a role="button" data-toggle="collapse" data-parent="#faq-accardion" href="#faq-collapse-' . esc_attr( $faq_rand_id ) . '" aria-expanded="true" aria-controls="faq-collapse-' . esc_attr( $faq_rand_id ) . '">';
												$output .= esc_attr( $item["title"] );
												$output .= '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><polyline points="6 9 12 15 18 9"></polyline></svg>';
											$output .= '</a>';
										$output .= '</div>';

									}

									if( !empty( $item["content"] ) ) {

										if( $i == "1" and $atts["first-open"] == "true" ) {

											$output .= '<div id="faq-collapse-' . esc_attr( $faq_rand_id ) . '" class="gt-panel-collapse collapse show" role="tabpanel" aria-labelledby="faq-heading-' . esc_attr( $faq_rand_id ) . '">';

										} else {

											if( $atts["all-open"] == "on" ) {

												$output .= '<div id="faq-collapse-' . esc_attr( $faq_rand_id ) . '" class="gt-panel-collapse collapse show" role="tabpanel" aria-labelledby="faq-heading-' . esc_attr( $faq_rand_id ) . '">';

											} else {

												$output .= '<div id="faq-collapse-' . esc_attr( $faq_rand_id ) . '" class="gt-panel-collapse collapse" role="tabpanel" aria-labelledby="faq-heading-' . esc_attr( $faq_rand_id ) . '">';

											}

										}

											$output .= '<div class="gt-panel-body">';
												$output .= do_shortcode( wpautop( $item["content"] ) );
											$output .= '</div>';
										$output .= '</div>';

									}

								$output .= '</div>';
							}

						}

					}

				$output .= '</div>';
			$output .= '</div>';

			return $output;

		}

	}
	add_shortcode( "eventchamp_faq", "eventchamp_faq_output" );

	if( function_exists( 'vc_map' ) ) {

		vc_map(
			array(
				"name" => esc_html__( 'FAQ', 'eventchamp-core' ),
				"base" => "eventchamp_faq",
				"category" => esc_html__( 'Eventchamp Theme', 'eventchamp-core' ),
				"icon" => get_template_directory_uri() . '/include/assets/img/icons/faq.jpg',
				"description" => esc_html__( 'A modern FAQ list', 'eventchamp-core' ),
				"params" => array(
					array(
						"type" => "dropdown",
						"param_name" => "first-open",
						"heading" => esc_html__( 'First Open', 'eventchamp-core' ),
						"description" => esc_html__( 'Will first item comes open automatically?', 'eventchamp-core' ),
						"save_always" => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "all-open",
						"heading" => esc_html__( 'All Open', 'eventchamp-core' ),
						"description" => esc_html__( 'All item comes open automatically?', 'eventchamp-core' ),
						"save_always" => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						'type' => 'param_group',
						'param_name' => 'items',
						"heading" => esc_html__( 'Items', 'eventchamp-core' ),
						"save_always" => true,
						'params' => array(
							array(
								"type" => "textfield",
								"param_name" => "title",
								"heading" => esc_html__( 'Title', 'eventchamp-core' ),
								"admin_label" => true,
								"save_always" => true,
							),
							array(
								"type" => "textarea",
								"param_name" => "content",
								"heading" => esc_html__( 'Text', 'eventchamp-core' ),
								"save_always" => true,
							),
						)
					),
				),
			)
		);

	}

}