<?php
/*======
*
* Event Search Tool
*
======*/
if( !function_exists( 'eventchamp_event_search_output' ) ) {

	function eventchamp_event_search_output( $atts, $content = null ) {

		/*====== Atts ======*/
		$atts = shortcode_atts(
			array(
				'style' => 'white',
				'column' => 'column-1',
				'column-space' => '0',
				'dark-background' => '',
				'live-search-select' => '',
				'title' => '',
				'custom-title' => '',
				'startdate' => '',
				'enddate' => '',
				'keyword' => '',
				'custom-keyword-text' => '',
				'category' => '',
				'location' => '',
				'venues' => 'false',
				'venue-count' => '',
				'include-venues' => '',
				'exclude-venues' => '',
				'venue-order' => 'ASC',
				'venue-order-type' => 'added-date',
				'speakers' => 'false',
				'speaker-count' => '',
				'include-speakers' => '',
				'exclude-speakers' => '',
				'speaker-order' => 'ASC',
				'speaker-order-type' => 'added-date',
				'organizer' => 'false',
				'status' => '',
				'upcoming-status' => '',
				'showing-status' => '',
				'expired-status' => '',
				'tag' => '',
				'custom-tag-text' => '',
				'sort' => '',
				'sort-start-date' => '',
				'sort-end-date' => '',
				'sort-added-date' => '',
				'sort-name-a-z' => '',
				'sort-name-z-a' => '',
				'sort-price-l-h' => '',
				'sort-price-h-l' => '',
				'price-slider' => 'false',
				'price-slider-grid' => 'false',
				'price-slider-min-price' => '0',
				'price-slider-max-price' => '999',
				'price-slider-from' => '0',
				'price-slider-to' => '299',
				'price-slider-step' => '1',
				'price-slider-min-max' => 'false',
				'price-slider-from-to' => 'false',
				'price-slider-prefix' => '',
				'price-slider-postfix' => '',
				'exclude-categories' => '',
				'exclude-locations' => '',
				'exclude-organizers' => '',
				'include-categories' => '',
				'include-locations' => '',
				'include-organizers' => '',
				'taxonomy-order' => 'ASC',
				'taxonomy-order-type' => 'name',
				'empty-taxonomies' => '',
				'childless' => '',
				'hide-children' => '',
				'slider-images' => '',
				'slider-column' => '1',
				'slider-space' => '0',
				'slider-height' => '100vh',
				'slider-autoplay' => 'false',
				'slider-autoplay-delay' => '15000',
				'slider-loop' => 'false',
				'slider-slide-speed' => '1000',
				'slider-centered-slides' => 'false',
				'slider-direction' => 'horizontal',
				'slider-effect' => 'slide',
				'slider-free-mode' => 'false',
			), $atts
		);

		/*====== Lazy Load ======*/
		$lazy_load = ot_get_option( 'lazy-load', 'off' );

		/*====== Live Search ======*/
		if( empty( $atts["live-search-select"] ) ) {

			$atts["live-search-select"] = "false";

		}

		/*====== Price Slider ======*/
		if( empty( $atts["price-slider"] ) ) {

			$atts["price-slider"] = "false";

		}

		/*====== Price Slider Grid ======*/
		if( empty( $atts["price-slider-grid"] ) ) {

			$atts["price-slider-grid"] = "false";

		}

		/*====== Price Slider Min Price ======*/
		if( empty( $atts["price-slider-min-price"] ) ) {

			$atts["price-slider-min-price"] = "0";

		}

		/*====== Price Slider Max Price ======*/
		if( empty( $atts["price-slider-max-price"] ) ) {

			$atts["price-slider-max-price"] = "999";

		}

		/*====== Price Slider From ======*/
		if( empty( $atts["price-slider-from"] ) ) {

			$atts["price-slider-from"] = "0";

		}

		/*====== Price Slider To ======*/
		if( empty( $atts["price-slider-to"] ) ) {

			$atts["price-slider-to"] = "299";

		}

		/*====== Price Slider Step ======*/
		if( empty( $atts["price-slider-step"] ) ) {

			$atts["price-slider-step"] = "1";

		}

		/*====== Hide Price Slider Min Max ======*/
		if( empty( $atts["price-slider-min-max"] ) ) {

			$atts["price-slider-min-max"] = "false";

		}

		/*====== Hide Price Slider From To ======*/
		if( empty( $atts["price-slider-from-to"] ) ) {

			$atts["price-slider-from-to"] = "false";

		}

		/*====== Column ======*/
		if( empty( $atts["slider-column"] ) ) {

			$atts["slider-column"] = "1";

		}

		/*====== Column Space ======*/
		if( empty( $atts["slider-space"] ) ) {

			$atts["slider-space"] = "0";

		}

		/*====== Slider Height ======*/
		if( empty( $atts["slider-height"] ) ) {

			$atts["slider-height"] = "100vh";

		}

		/*====== Slider Autoplay Delay ======*/
		if( empty( $atts["slider-autoplay-delay"] ) ) {

			$atts["slider-autoplay-delay"] = "15000";

		}

		/*====== Slider Loop ======*/
		if( empty( $atts["slider-loop"] ) ) {

			$atts["slider-loop"] = "false";

		}

		/*====== Slider Slide Speed ======*/
		if( empty( $atts["slider-slide-speed"] ) ) {

			$atts["slider-slide-speed"] = "1000";

		}

		/*====== Centered Slides ======*/
		if( empty( $atts["slider-centered-slides"] ) ) {

			$atts["slider-centered-slides"] = "false";

		}

		/*====== Slider Direction ======*/
		if( empty( $atts["slider-direction"] ) ) {

			$atts["slider-direction"] = "horizontal";

		}

		/*====== Slider Effect ======*/
		if( empty( $atts["slider-effect"] ) ) {

			$atts["slider-effect"] = "slide";

		}

		/*====== Slider Free Mode ======*/
		if( empty( $atts["slider-free-mode"] ) ) {

			$atts["slider-free-mode"] = "false";

		}

		/*====== Taxonomy Order ======*/
		if( empty( $atts["taxonomy-order"] ) ) {

			$atts["taxonomy-order"] = "ASC";

		}

		/*====== Taxonomy Order Type ======*/
		if( empty( $atts["taxonomy-order-type"] ) ) {

			$atts["taxonomy-order-type"] = "name";

		}

		/*====== Empty Categories ======*/
		if( $atts['empty-taxonomies'] == 'false' ) {

			$empty_taxonomies = false;

		} else {

			$empty_taxonomies = true;

		}

		/*====== Childless ======*/
		if( $atts['childless'] == 'false' ) {

			$childless = false;

		} else {

			$childless = true;

		}

		/*====== Hide Children ======*/
		if( $atts['hide-children'] == 'false' ) {

			$hide_children = '';

		} else {

			$hide_children = 0;

		}

		/*====== Dark Background ======*/
		if( !empty( $atts["dark-background"] ) ) {

			$dark_bg = $atts["dark-background"];
			$dark_bg = esc_url( wp_get_attachment_url( $dark_bg, 'full', true, true ) );

		} else {

			$dark_bg = '';

		}

		/*====== Include Categories ======*/
		if( !empty( $atts['include-categories'] ) ) {

			$include_categories = $atts['include-categories'];
			$include_categories = explode( ',', $include_categories );

		} else {

			$include_categories = "";

		}

		/*====== Include Locations ======*/
		if( !empty( $atts['include-locations'] ) ) {

			$include_locations = $atts['include-locations'];
			$include_locations = explode( ',', $include_locations );

		} else {

			$include_locations = "";

		}

		/*====== Include Organizers ======*/
		if( !empty( $atts['include-organizers'] ) ) {

			$include_organizers = $atts['include-organizers'];
			$include_organizers = explode( ',', $include_organizers );

		} else {

			$include_organizers = "";

		}

		/*====== Exclude Categories ======*/
		if( !empty( $atts['exclude-categories'] ) ) {

			$exclude_categories = $atts['exclude-categories'];
			$exclude_categories = explode( ',', $exclude_categories );

		} else {

			$exclude_categories = "";

		}

		/*====== Exclude Locations ======*/
		if( !empty( $atts['exclude-locations'] ) ) {

			$exclude_locations = $atts['exclude-locations'];
			$exclude_locations = explode( ',', $exclude_locations );

		} else {

			$exclude_locations = "";

		}

		/*====== Exclude Organizers ======*/
		if( !empty( $atts['exclude-organizers'] ) ) {

			$exclude_organizers = $atts['exclude-organizers'];
			$exclude_organizers = explode( ',', $exclude_organizers );

		} else {

			$exclude_organizers = "";

		}

		/*====== Keep Options ======*/
		$keep_options = ot_get_option( 'event-keep-search-options', 'on' );

		/*====== HTML Output ======*/
		$output = "";

		$event_search_result_page = ot_get_option( 'event_search_result_page' );

		if( $atts["style"] == "dark" ) {

			if( $lazy_load == "on" ) {

				$output .= '<div class="gt-event-search-tool gt-dark gt-style-2 gt-lazy-load" data-bg="' . $dark_bg . '">';

			} else {

				$output .= '<div class="gt-event-search-tool gt-dark gt-style-2" style="background-image:url(' . $dark_bg . ');">';

			}

		} elseif( $atts["style"] == "style-3" ) {

			$output .= '<div class="gt-event-search-tool gt-style-3" style="height:' . esc_attr( $atts["slider-height"] ) . ';">';
				$output .= '<div class="swiper-container gt-swiper-slider" data-gt-item-space="' . esc_attr( $atts["slider-space"] ) . '" data-gt-item-column="' . esc_attr( $atts["slider-column"] ) . '" data-gt-loop="' . esc_attr( $atts["slider-loop"] ) . '" data-gt-speed="' . esc_attr( $atts["slider-slide-speed"] ) . '" data-gt-direction="' . esc_attr( $atts["slider-direction"] ) . '" data-gt-effect="' . esc_attr( $atts["slider-effect"] ) . '" data-gt-centered-slides="' . esc_attr( $atts["slider-centered-slides"] ) . '" data-gt-free-mode="' . esc_attr( $atts["slider-free-mode"] ) . '">';
					$output .= '<div class="swiper-wrapper">';

						$slider_images = explode( ',', $atts["slider-images"] );

						if( !empty( $slider_images ) ) {

							foreach( $slider_images as $slider_image ) {

								if( !empty( $slider_image ) ) {

									$image_url = wp_get_attachment_image_src( esc_attr( $slider_image ), "eventchamp-event-slider" );

									if( $atts["slider-autoplay"] == "true" ) {

										$output .= '<div class="swiper-slide" data-swiper-autoplay="' . esc_attr( $atts["slider-autoplay-delay"] ) . '">';

									} else {

										$output .= '<div class="swiper-slide">';

									}

										if( $lazy_load == "on" ) {

											$output .= '<div class="gt-image gt-lazy-load" data-background="' . esc_url( $image_url[0] ) . '"></div>';

										} else {

											$output .= '<div class="gt-image" style="background-image:url(' . esc_url( $image_url[0] ) . ');"></div>';

										}

									$output .= '</div>';

								}

							}

						}

					$output .= '</div>';
				$output .= '</div>';

		} elseif( $atts["style"] == "style-4" ) {

			$output .= '<div class="gt-event-search-tool gt-style-4">';

		} elseif( $atts["style"] == "style-5" ) {

			$output .= '<div class="gt-event-search-tool gt-style-5">';

		} else {

			$output .= '<div class="gt-event-search-tool gt-white gt-style-1">';

		}

			$output .= '<div class="gt-form container">';

				if( !empty( $event_search_result_page ) ) {

					$output .= '<form method="get" action="' . get_the_permalink( $event_search_result_page ) . '">';
						$output .= '<div class="search-content">';
							$output .= '<div class="gt-columns gt-column-' . esc_attr( $atts["column"] ) . ' gt-columns-center gt-column-space-' . esc_attr( $atts["column-space"] ) . '">';

								if( $atts["title"] == "true" )  {

									$output .= '<div class="gt-col">';
										$output .= '<div class="gt-inner">';

											if( !empty( $atts["custom-title"] ) ) {

												$output .= '<div class="title">' . esc_attr( $atts["custom-title"] ) . '</div>';

											} else {

												$output .= '<div class="title">' . esc_html__( 'Event Search', 'eventchamp-core' ) . ':</div>';

											}

										$output .= '</div>';
									$output .= '</div>';

								}

								if( $atts["keyword"] == "true" ) {

									$output .= '<div class="gt-col">';
										$output .= '<div class="gt-inner">';

											$search_keyword = "";

											if( $keep_options == "on" ) {

												if( isset( $_GET['keyword'] ) ) {

													$search_keyword = stripslashes( esc_attr( $_GET["keyword"] ) );

												}
											}

											$keyword_placeholder = esc_html__( 'e.g. event, meetup', 'eventchamp-core' );

											if( !empty( $atts["custom-keyword-text"] ) ) {

												$keyword_placeholder = esc_attr( $atts["custom-keyword-text"] );

											}

											$output .= '<input name="keyword" type="text" placeholder="' . esc_attr( $keyword_placeholder ) . '" value="' . esc_attr( $search_keyword ) . '">';

										$output .= '</div>';
									$output .= '</div>';

								} else {

									$output .= '<div class="gt-col d-none">';
										$output .= '<div class="gt-inner">';
											$output .= '<input name="keyword" type="hidden">';
										$output .= '</div>';
									$output .= '</div>';

								}

								if( $atts["category"] == "true" ) {

									$output .= '<div class="gt-col">';
										$output .= '<div class="gt-inner">';
											$output .= '<select name="category" class="gt-select" data-live-search="' . esc_attr( $atts["live-search-select"] ) . '">';
												$output .= '<option value="">' . esc_html__( 'Category', 'eventchamp-core' ) . '</option>';
												$eventcat_terms = get_terms(
													array(
														'taxonomy' => 'eventcat',
														'order' => $atts["taxonomy-order"],
														'orderby' => $atts["taxonomy-order-type"],
														'hide_empty' => $empty_taxonomies,
														'childless' => $childless,
														'include' => $include_categories,
														'exclude' => $exclude_categories,
														'parent' => 0,
													)
												);

												if( ! empty( $eventcat_terms ) && ! is_wp_error( $eventcat_terms ) ) {

													foreach ( $eventcat_terms as $eventcat_term ) {

														if( !empty( $eventcat_term ) ) {

															if( $atts['hide-children'] == 'false' ) {

																$eventcat_sub_terms = get_terms(
																	array(
																		'taxonomy' => 'eventcat',
																		'order' => $atts["taxonomy-order"],
																		'orderby' => $atts["taxonomy-order-type"],
																		'hide_empty' => $empty_taxonomies,
																		'childless' => $childless,
																		'exclude' => $exclude_categories,
																		'parent' => $eventcat_term->term_id,
																	)
																);

															} else {

																$eventcat_sub_terms = "";

															}

															if( empty( $eventcat_sub_terms ) ) {

																$search_category = "";

																if( $keep_options == "on" ) {

																	if( isset( $_GET['category'] ) ) {

																		$search_category = esc_js( esc_sql( esc_attr( $_GET["category"] ) ) );

																	}
																}

																if( $search_category == $eventcat_term->term_id or get_queried_object_id() == $eventcat_term->term_id ) {

																	$output .= '<option value="' . esc_attr( $eventcat_term->term_id ) . '" selected>' . esc_attr( $eventcat_term->name ) . '</option>';

																} else {

																	$output .= '<option value="' . esc_attr( $eventcat_term->term_id ) . '">' . esc_attr( $eventcat_term->name ) . '</option>';

																}

															}

															if( $atts['hide-children'] == 'false' ) {

																if( ! empty( $eventcat_sub_terms ) && ! is_wp_error( $eventcat_sub_terms ) ) {

																	$output .= '<optgroup label="' . esc_attr( $eventcat_term->name ) . '">';

																		foreach ( $eventcat_sub_terms as $eventcat_sub_term ) {

																			if( !empty( $eventcat_sub_term ) ) {

																				$search_sub_category = "";

																				if( $keep_options == "on" ) {

																					if( isset( $_GET['category'] ) ) {

																						$search_sub_category = esc_js( esc_sql( esc_attr( $_GET["category"] ) ) );

																					}

																				}

																				if( $search_sub_category == $eventcat_sub_term->term_id or get_queried_object_id() == $eventcat_sub_term->term_id ) {

																					$output .= '<option class="gt-sub-option gt-inner-sub-option" value="' . esc_attr( $eventcat_sub_term->term_id ) . '" selected>' . esc_attr( $eventcat_sub_term->name ) . '</option>';

																				} else {

																					$output .= '<option class="gt-sub-option gt-inner-sub-option" value="' . esc_attr( $eventcat_sub_term->term_id ) . '">' . esc_attr( $eventcat_sub_term->name ) . '</option>';

																				}

																			}

																		}

																	$output .= '</optgroup>';

																}

															}

														}

													}

												}

											$output .= '</select>';
										$output .= '</div>';
									$output .= '</div>';

								}

								if( $atts["location"] == "true" ) {

									$output .= '<div class="gt-col">';
										$output .= '<div class="gt-inner">';
											$output .= '<select name="location" class="gt-select" data-live-search="' . esc_attr( $atts["live-search-select"] ) . '">';
												$output .= '<option value="">' . esc_html__( 'Location', 'eventchamp-core' ) . '</option>';
												$location_terms = get_terms(
													array(
														'taxonomy' => 'location',
														'order' => $atts["taxonomy-order"],
														'orderby' => $atts["taxonomy-order-type"],
														'hide_empty' => $empty_taxonomies,
														'childless' => $childless,
														'include' => $include_locations,
														'exclude' => $exclude_locations,
														'parent' => 0,
													)
												);

												if( ! empty( $location_terms ) && ! is_wp_error( $location_terms ) ) {

													foreach ( $location_terms as $location_term ) {

														if( !empty( $location_term ) ) {

															if( $atts['hide-children'] == 'false' ) {

																$location_sub_terms = get_terms(
																	array(
																		'taxonomy' => 'location',
																		'order' => $atts["taxonomy-order"],
																		'orderby' => $atts["taxonomy-order-type"],
																		'hide_empty' => $empty_taxonomies,
																		'childless' => $childless,
																		'exclude' => $exclude_locations,
																		'parent' => $location_term->term_id,
																	)
																);

															} else {

																$location_sub_terms = "";

															}

															if( empty( $location_sub_terms ) ) {

																$search_location = "";

																if( $keep_options == "on" ) {

																	if( isset( $_GET['location'] ) ) {

																		$search_location = esc_js( esc_sql( esc_attr( $_GET["location"] ) ) );

																	}
																}

																if( $search_location == $location_term->term_id or get_queried_object_id() == $location_term->term_id ) {

																	$output .= '<option value="' . esc_attr( $location_term->term_id ) . '" selected>' . esc_attr( $location_term->name ) . '</option>';

																} else {

																	$output .= '<option value="' . esc_attr( $location_term->term_id ) . '">' . esc_attr( $location_term->name ) . '</option>';

																}

															}

															if( $atts['hide-children'] == 'false' ) {

																if( ! empty( $location_sub_terms ) && ! is_wp_error( $location_sub_terms ) ) {

																	$output .= '<optgroup label="' . esc_attr( $location_term->name ) . '">';

																		foreach ( $location_sub_terms as $location_sub_term ) {

																			if( !empty( $location_sub_term ) ) {

																				$search_location = "";

																				if( $keep_options == "on" ) {

																					if( isset( $_GET['location'] ) ) {

																						$search_location = esc_js( esc_sql( esc_attr( $_GET["location"] ) ) );

																					}
																				}

																				if( $search_location == $location_sub_term->term_id or get_queried_object_id() == $location_sub_term->term_id ) {

																					$output .= '<option class="gt-sub-option" value="' . esc_attr( $location_sub_term->term_id ) . '" selected>' . esc_attr( $location_sub_term->name ) . '</option>';

																				} else {

																					$output .= '<option class="gt-sub-option" value="' . esc_attr( $location_sub_term->term_id ) . '">' . esc_attr( $location_sub_term->name ) . '</option>';

																				}

																			}

																		}

																	$output .= '</optgroup>';

																}

															}

														}

													}

												}

											$output .= '</select>';
										$output .= '</div>';
									$output .= '</div>';

								}

								if( $atts["venues"] == "true" ) {

									$output .= '<div class="gt-col">';
										$output .= '<div class="gt-inner">';
											$output .= '<select name="event-venue" class="gt-select" data-live-search="' . esc_attr( $atts["live-search-select"] ) . '">';
												$output .= '<option value="">' . esc_html__( 'Venue', 'eventchamp-core' ) . '</option>';

												/*====== Venue Query ======*/
												$venue_query_arg = array(
													'posts_per_page' => esc_attr( $atts["venue-count"] ),
													'post_status' => 'publish',
													'post_type' => 'venue',
												);

												/*====== Exclude Venues ======*/
												if( !empty( $atts['exclude-venues'] ) ) {

													$exclude_venues = $atts['exclude-venues'];
													$exclude_venues = explode( ',', $exclude_venues );

												} else {

													$exclude_venues = "";

												}

												if( !empty( $exclude_venues ) ) {

													$venue_extra_query = array(
														'post__not_in' => $exclude_venues,
													);
													$venue_query_arg = wp_parse_args( $venue_query_arg, $venue_extra_query );

												}

												/*====== Include Venues ======*/
												if( !empty( $atts['include-venues'] ) ) {

													$include_venues = $atts['include-venues'];
													$include_venues = explode( ',', $include_venues );

												} else {

													$include_venues = "";

												}

												if( !empty( $include_venues ) ) {

													$venue_extra_query = array(
														'post__in' => $include_venues,
													);
													$venue_query_arg = wp_parse_args( $venue_query_arg, $venue_extra_query );

												}

												/*====== Venue Order ======*/
												if( !empty( $atts["venue-order"] ) ) {

													$venue_extra_query = array(
														'order' => $atts["venue-order"],
													);
													$venue_query_arg = wp_parse_args( $venue_query_arg, $venue_extra_query );

												}

												/*====== Venue Order Type ======*/
												if( empty( $atts["venue-order-type"] ) ) {

													if( $atts["venue-order-type"] == "popular-comment" ) {

														$atts["venue-order-type"] = "comment_count";

													} elseif( $atts["venue-order-type"] == "id" ) {

														$atts["venue-order-type"] = "ID";

													} elseif( $atts["venue-order-type"] == "popular" ) {

														$atts["venue-order-type"] = "comment_count";

													} elseif( $atts["venue-order-type"] == "title" ) {

														$atts["venue-order-type"] = "title";

													} elseif( $atts["venue-order-type"] == "menu_order" ) {

														$atts["venue-order-type"] = "menu_order";

													} elseif( $atts["venue-order-type"] == "rand" ) {

														$atts["venue-order-type"] = "rand";

													} elseif( $atts["venue-order-type"] == "post__in" ) {

														$atts["venue-order-type"] = "post__in";

													} elseif( $atts["venue-order-type"] == "none" ) {

														$atts["venue-order-type"] = "none";

													} else {

														$atts["venue-order-type"] = "date";

													}

												}

												if( !empty( $atts["venue-order-type"] ) ) {

													$venue_extra_query = array(
														'orderby' => $atts["venue-order-type"],
													);
													$venue_query_arg = wp_parse_args( $venue_query_arg, $venue_extra_query );

												}

												$wp_query = new WP_Query( $venue_query_arg );

												if( !empty( $wp_query ) ) {

													if( $wp_query->have_posts() ) {

														while( $wp_query->have_posts() ) {

															$wp_query->the_post();

															$search_venue = "";

															if( $keep_options == "on" ) {

																if( isset( $_GET['event-venue'] ) ) {

																	$search_venue = esc_js( esc_sql( esc_attr( $_GET["event-venue"] ) ) );

																}
															}

															if( $search_venue == get_the_ID() ) {

																$output .= '<option value="' . get_the_ID() . '" selected>' . get_the_title() . '</option>';

															} else {

																$output .= '<option value="' . get_the_ID() . '">' . get_the_title() . '</option>';

															}
															
														}

													}

												}
												wp_reset_postdata();

											$output .= '</select>';
										$output .= '</div>';
									$output .= '</div>';

								}

								if( $atts["speakers"] == "true" ) {

									$output .= '<div class="gt-col">';
										$output .= '<div class="gt-inner">';
											$output .= '<select name="event-speaker" class="gt-select" data-live-search="' . esc_attr( $atts["live-search-select"] ) . '">';
												$output .= '<option value="">' . esc_html__( 'Speaker', 'eventchamp-core' ) . '</option>';

												/*====== Speaker Query ======*/
												$speaker_query_arg = array(
													'posts_per_page' => esc_attr( $atts["speaker-count"] ),
													'post_status' => 'publish',
													'post_type' => 'speaker',
												);

												/*====== Exclude Speakers ======*/
												if( !empty( $atts['exclude-speakers'] ) ) {

													$exclude_speakers = $atts['exclude-speakers'];
													$exclude_speakers = explode( ',', $exclude_speakers );

												} else {

													$exclude_speakers = "";

												}

												if( !empty( $exclude_speakers ) ) {

													$speaker_extra_query = array(
														'post__not_in' => $exclude_speakers,
													);
													$speaker_query_arg = wp_parse_args( $speaker_query_arg, $speaker_extra_query );

												}

												/*====== Include Speakers ======*/
												if( !empty( $atts['include-speakers'] ) ) {

													$include_speakers = $atts['include-speakers'];
													$include_speakers = explode( ',', $include_speakers );

												} else {

													$include_speakers = "";

												}

												if( !empty( $include_speakers ) ) {

													$speaker_extra_query = array(
														'post__in' => $include_speakers,
													);
													$speaker_query_arg = wp_parse_args( $speaker_query_arg, $speaker_extra_query );

												}

												/*====== Speaker Order ======*/
												if( !empty( $atts["speaker-order"] ) ) {

													$speaker_extra_query = array(
														'order' => $atts["speaker-order"],
													);
													$speaker_query_arg = wp_parse_args( $speaker_query_arg, $speaker_extra_query );

												}

												/*====== Speaker Order Type ======*/
												if( empty( $atts["speaker-order-type"] ) ) {

													if( $atts["speaker-order-type"] == "popular-comment" ) {

														$atts["speaker-order-type"] = "comment_count";

													} elseif( $atts["speaker-order-type"] == "id" ) {

														$atts["speaker-order-type"] = "ID";

													} elseif( $atts["speaker-order-type"] == "popular" ) {

														$atts["speaker-order-type"] = "comment_count";

													} elseif( $atts["speaker-order-type"] == "title" ) {

														$atts["speaker-order-type"] = "title";

													} elseif( $atts["speaker-order-type"] == "menu_order" ) {

														$atts["speaker-order-type"] = "menu_order";

													} elseif( $atts["speaker-order-type"] == "rand" ) {

														$atts["speaker-order-type"] = "rand";

													} elseif( $atts["speaker-order-type"] == "post__in" ) {

														$atts["speaker-order-type"] = "post__in";

													} elseif( $atts["speaker-order-type"] == "none" ) {

														$atts["speaker-order-type"] = "none";

													} else {

														$atts["speaker-order-type"] = "date";

													}

												}

												if( !empty( $atts["speaker-order-type"] ) ) {

													$speaker_extra_query = array(
														'orderby' => $atts["speaker-order-type"],
													);
													$speaker_query_arg = wp_parse_args( $speaker_query_arg, $speaker_extra_query );

												}

												$wp_query = new WP_Query( $speaker_query_arg );

												if( !empty( $wp_query ) ) {

													if( $wp_query->have_posts() ) {

														while( $wp_query->have_posts() ) {

															$wp_query->the_post();

															$search_speaker = "";

															if( $keep_options == "on" ) {

																if( isset( $_GET['event-speaker'] ) ) {

																	$search_speaker = esc_js( esc_sql( esc_attr( $_GET["event-speaker"] ) ) );

																}
															}

															if( $search_speaker == get_the_ID() ) {

																$output .= '<option value="' . get_the_ID() . '" selected>' . get_the_title() . '</option>';

															} else {

																$output .= '<option value="' . get_the_ID() . '">' . get_the_title() . '</option>';

															}
															
														}

													}

												}
												wp_reset_postdata();

											$output .= '</select>';
										$output .= '</div>';
									$output .= '</div>';

								}

								if( $atts["organizer"] == "true" ) {

									$output .= '<div class="gt-col">';
										$output .= '<div class="gt-inner">';
											$output .= '<select name="organizer" class="gt-select" data-live-search="' . esc_attr( $atts["live-search-select"] ) . '">';
												$output .= '<option value="">' . esc_html__( 'Organizer', 'eventchamp-core' ) . '</option>';
												$organizer_terms = get_terms(
													array(
														'taxonomy' => 'organizer',
														'order' => $atts["taxonomy-order"],
														'orderby' => $atts["taxonomy-order-type"],
														'hide_empty' => $empty_taxonomies,
														'childless' => $childless,
														'include' => $include_organizers,
														'exclude' => $exclude_organizers,
														'parent' => 0,
													)
												);

												if( ! empty( $organizer_terms ) && ! is_wp_error( $organizer_terms ) ) {

													foreach ( $organizer_terms as $organizer_term ) {

														if( !empty( $organizer_term ) ) {

															if( $atts['hide-children'] == 'false' ) {

																$organizer_sub_terms = get_terms(
																	array(
																		'taxonomy' => 'organizer',
																		'order' => $atts["taxonomy-order"],
																		'orderby' => $atts["taxonomy-order-type"],
																		'hide_empty' => $empty_taxonomies,
																		'childless' => $childless,
																		'exclude' => $exclude_organizers,
																		'parent' => $organizer_term->term_id,
																	)
																);

															} else {

																$organizer_sub_terms = "";

															}

															if( empty( $organizer_sub_terms ) ) {

																$search_organizer = "";

																if( $keep_options == "on" ) {

																	if( isset( $_GET['organizer'] ) ) {

																		$search_organizer = esc_js( esc_sql( esc_attr( $_GET["organizer"] ) ) );

																	}
																}

																if( $search_organizer == $organizer_term->term_id or get_queried_object_id() == $organizer_term->term_id ) {

																	$output .= '<option value="' . esc_attr( $organizer_term->term_id ) . '" selected>' . esc_attr( $organizer_term->name ) . '</option>';

																} else {

																	$output .= '<option value="' . esc_attr( $organizer_term->term_id ) . '">' . esc_attr( $organizer_term->name ) . '</option>';

																}

															}

															if( $atts['hide-children'] == 'false' ) {

																if( ! empty( $organizer_sub_terms ) && ! is_wp_error( $organizer_sub_terms ) ) {

																	$output .= '<optgroup label="' . esc_attr( $organizer_term->name ) . '">';

																		foreach ( $organizer_sub_terms as $organizer_sub_term ) {

																			if( !empty( $organizer_sub_term ) ) {

																				$search_organizer = "";

																				if( $keep_options == "on" ) {

																					if( isset( $_GET['organizer'] ) ) {

																						$search_organizer = esc_js( esc_sql( esc_attr( $_GET["organizer"] ) ) );

																					}
																				}

																				if( $search_organizer == $organizer_term->term_id or get_queried_object_id() == $term_id->term_id ) {

																					$output .= '<option value="' . esc_attr( $organizer_term->term_id ) . '" selected>' . esc_attr( $organizer_term->name ) . '</option>';

																				} else {

																					$output .= '<option value="' . esc_attr( $organizer_term->term_id ) . '">' . esc_attr( $organizer_term->name ) . '</option>';

																				}

																			}

																		}

																	$output .= '</optgroup>';

																}

															}

														}

													}

												}

											$output .= '</select>';
										$output .= '</div>';
									$output .= '</div>';

								}

								if( $atts["status"] == "true" ) {

									$output .= '<div class="gt-col">';
										$output .= '<div class="gt-inner">';
											$output .= '<select name="status" class="gt-select" data-live-search="' . esc_attr( $atts["live-search-select"] ) . '">';
												$output .= '<option value="">' . esc_html__( 'Status', 'eventchamp-core' ) . '</option>';

												if( $atts["upcoming-status"] == "true" ) {

													$search_upcoming_status = "";

													if( $keep_options == "on" ) {

														if( isset( $_GET['status'] ) ) {

															$search_upcoming_status = esc_js( esc_sql( esc_attr( $_GET["status"] ) ) );

														}
													}

													if( $search_upcoming_status == "upcoming" ) {

														$output .= '<option value="upcoming" selected>' . esc_html__( 'Upcoming', 'eventchamp-core' ) . '</option>';

													} else {

														$output .= '<option value="upcoming">' . esc_html__( 'Upcoming', 'eventchamp-core' ) . '</option>';

													}

												}

												if( $atts["showing-status"] == "true" ) {

													$search_showing_status = "";

													if( $keep_options == "on" ) {

														if( isset( $_GET['status'] ) ) {

															$search_showing_status = esc_js( esc_sql( esc_attr( $_GET["status"] ) ) );

														}
													}

													if( $search_showing_status == "showing" ) {

														$output .= '<option value="showing" selected>' . esc_html__( 'Showing', 'eventchamp-core' ) . '</option>';

													} else {

														$output .= '<option value="showing">' . esc_html__( 'Showing', 'eventchamp-core' ) . '</option>';

													}

												}

												if( $atts["expired-status"] == "true" ) {

													$search_expired_status = "";

													if( $keep_options == "on" ) {

														if( isset( $_GET['status'] ) ) {

															$search_expired_status = esc_js( esc_sql( esc_attr( $_GET["status"] ) ) );

														}
													}

													if( $search_expired_status == "expired" ) {

														$output .= '<option value="expired" selected>' . esc_html__( 'Expired', 'eventchamp-core' ) . '</option>';

													} else {

														$output .= '<option value="expired">' . esc_html__( 'Expired', 'eventchamp-core' ) . '</option>';

													}

												}

											$output .= '</select>';
										$output .= '</div>';
									$output .= '</div>';

								}

								if( $atts["startdate"] == "true" ) {

									$output .= '<div class="gt-col">';
										$output .= '<div class="gt-inner">';

											$search_start_date = "";

											if( $keep_options == "on" ) {

												if( isset( $_GET['startdate'] ) ) {

													$search_start_date = esc_js( esc_sql( esc_attr( $_GET["startdate"] ) ) );

												}
											}

											$end_date_placeholder = esc_attr__( 'Start Date', 'eventchamp-core' );

											$output .= '<input type="text" name="startdate" autocomplete="off" class="eventsearchdate-datepicker" placeholder="' . esc_attr( $end_date_placeholder ) . '" value="' . esc_attr( $search_start_date ) . '" />';
										$output .= '</div>';
									$output .= '</div>';

								}

								if( $atts["enddate"] == "true" ) {

									$output .= '<div class="gt-col">';
										$output .= '<div class="gt-inner">';

											$search_end_date = "";

											if( $keep_options == "on" ) {

												if( isset( $_GET['enddate'] ) ) {

													$search_end_date = esc_js( esc_sql( esc_attr( $_GET["enddate"] ) ) );

												}
											}

											$end_date_placeholder = esc_attr__( 'End Date', 'eventchamp-core' );

											$output .= '<input type="text" name="enddate" autocomplete="off" class="eventsearchdate-datepicker" placeholder="' . esc_attr( $end_date_placeholder ) . '" value="' . esc_attr( $search_end_date ) . '" />';

										$output .= '</div>';
									$output .= '</div>';

								}

								if( $atts["tag"] == "true" ) {

									$output .= '<div class="gt-col">';
										$output .= '<div class="gt-inner">';

											$search_tag = "";

											if( $keep_options == "on" ) {

												if( isset( $_GET['tag'] ) ) {

													$search_tag = esc_js( esc_sql( esc_attr( $_GET["tag"] ) ) );

												}
											}

											$tag_placeholder = esc_attr__( 'Enter a tag: art, food', 'eventchamp-core' );

											if( !empty( $atts["custom-tag-text"] ) ) {

												$tag_placeholder = esc_attr( $atts["custom-tag-text"] );

											}

											$output .= '<input type="text"  name="tag" placeholder="' . esc_attr( $tag_placeholder ) . '" value="' . esc_attr( $search_tag ) . '" />';
										$output .= '</div>';
									$output .= '</div>';

								}

								if( $atts["sort"] == "true" ) {

									$output .= '<div class="gt-col">';
										$output .= '<div class="gt-inner">';
											$output .= '<select name="sort" class="gt-select" data-live-search="' . esc_attr( $atts["live-search-select"] ) . '">';

												if( $keep_options == "on" and isset( $_GET['sort'] ) ) {

													$output .= '<option>' . esc_html__( 'Sort by', 'eventchamp-core' ) . '</option>';

													if( $atts["sort-start-date"] == "true" ) {

														$output .= '<option value="start-date" ' . ( esc_js( esc_sql( esc_attr( $_GET["sort"] ) ) ) == 'start-date' ? 'selected' : ''  ) . '>' . esc_html__( 'Start Date', 'eventchamp-core' ) . '</option>';
													}

													if( $atts["sort-end-date"] == "true" ) {

														$output .= '<option value="end-date" ' . ( esc_js( esc_sql( esc_attr( $_GET["sort"] ) ) ) == 'end-date' ? 'selected' : ''  ) . '>' . esc_html__( 'End Date', 'eventchamp-core' ) . '</option>';

													}

													if( $atts["sort-added-date"] == "true" ) {

														$output .= '<option value="added-date" ' . ( esc_js( esc_sql( esc_attr( $_GET["sort"] ) ) ) == 'added-date' ? 'selected' : ''  ) . '>' . esc_html__( 'Added Date', 'eventchamp-core' ) . '</option>';

													}

													if( $atts["sort-name-a-z"] == "true" ) {

														$output .= '<option value="name-az" ' . ( esc_js( esc_sql( esc_attr( $_GET["sort"] ) ) ) == 'name-az' ? 'selected' : ''  ) . '>' . esc_html__( 'Name A > Z', 'eventchamp-core' ) . '</option>';

													}

													if( $atts["sort-name-z-a"] == "true" ) {

														$output .= '<option value="name-za" ' . ( esc_js( esc_sql( esc_attr( $_GET["sort"] ) ) ) == 'name-za' ? 'selected' : ''  ) . '>' . esc_html__( 'Name Z > A', 'eventchamp-core' ) . '</option>';

													}

													if( $atts["sort-price-l-h"] == "true" ) {

														$output .= '<option value="price-l-h" ' . ( esc_js( esc_sql( esc_attr( $_GET["sort"] ) ) ) == 'price-l-h' ? 'selected' : ''  ) . '>' . esc_html__( 'Price: Low to High', 'eventchamp-core' ) . '</option>';

													}

													if( $atts["sort-price-h-l"] == "true" ) {

														$output .= '<option value="price-h-l" ' . ( esc_js( esc_sql( esc_attr( $_GET["sort"] ) ) ) == 'price-h-l' ? 'selected' : ''  ) . '>' . esc_html__( 'Price: High to Low', 'eventchamp-core' ) . '</option>';

													}

												} else {

													$output .= '<option value="">' . esc_html__( 'Sort by', 'eventchamp-core' ) . '</option>';

													if( $atts["sort-start-date"] == "true" ) {

														$output .= '<option value="start-date">' . esc_html__( 'Start Date', 'eventchamp-core' ) . '</option>';

													}

													if( $atts["sort-end-date"] == "true" ) {

														$output .= '<option value="end-date">' . esc_html__( 'End Date', 'eventchamp-core' ) . '</option>';

													}

													if( $atts["sort-added-date"] == "true" ) {

														$output .= '<option value="added-date">' . esc_html__( 'Added Date', 'eventchamp-core' ) . '</option>';

													}

													if( $atts["sort-name-a-z"] == "true" ) {

														$output .= '<option value="name-az">' . esc_html__( 'Name A > Z', 'eventchamp-core' ) . '</option>';

													}

													if( $atts["sort-name-z-a"] == "true" ) {

														$output .= '<option value="name-za">' . esc_html__( 'Name Z > A', 'eventchamp-core' ) . '</option>';

													}

													if( $atts["sort-price-l-h"] == "true" ) {

														$output .= '<option value="price-l-h">' . esc_html__( 'Price: Low to High', 'eventchamp-core' ) . '</option>';

													}

													if( $atts["sort-price-h-l"] == "true" ) {

														$output .= '<option value="price-h-l">' . esc_html__( 'Price: High to Low', 'eventchamp-core' ) . '</option>';

													}

												}

											$output .= '</select>';
										$output .= '</div>';
									$output .= '</div>';

								}

								if( $atts["price-slider"] == "true" ) {

									$output .= '<div class="gt-col">';
										$output .= '<div class="gt-inner">';

											$search_price = "";

											if( $keep_options == "on" ) {

												if( isset( $_GET['price'] ) ) {

													$search_price = esc_js( esc_sql( esc_attr( $_GET["price"] ) ) );

												}

												if( !empty( $search_price ) ) {

													$prices = explode( ';', $search_price );

													$atts["price-slider-from"] = $prices[0];
													$atts["price-slider-to"] = $prices[1];

												}

											}

											$output .= '<input class="gt-range-slider" data-gt-grid="' . esc_attr( $atts["price-slider-grid"] ) . '" data-gt-min="' . esc_attr( $atts["price-slider-min-price"] ) . '" data-gt-max="' . esc_attr( $atts["price-slider-max-price"] ) . '" data-gt-from="' . esc_attr( $atts["price-slider-from"] ) . '" data-gt-to="' . esc_attr( $atts["price-slider-to"] ) . '" data-gt-step="' . esc_attr( $atts["price-slider-step"] ) . '" data-gt-hide-min-max="' . esc_attr( $atts["price-slider-min-max"] ) . '" data-gt-hide-from-to="' . esc_attr( $atts["price-slider-from-to"] ) . '" data-gt-postfix="' . esc_attr( $atts["price-slider-postfix"] ) . '" data-gt-prefix="' . esc_attr( $atts["price-slider-prefix"] ) . '" type="text" name="price" value="' . esc_attr( $search_price ) . '" autocomplete="off" />';
										$output .= '</div>';
									$output .= '</div>';

								}

								$output .= '<div class="gt-col">';
									$output .= '<div class="gt-inner">';
										$output .= '<button type="submit" class="gt-submit">' . esc_html__( 'Search', 'eventchamp-core' ) . '</button>';
									$output .= '</div>';
								$output .= '</div>';
							$output .= '</div>';
						$output .= '</div>';
					$output .= '</form>';

				} else {

					$output .= '<div class="gt-choose-page">';
						$output .= wpautop( esc_html__( 'You need to choose a search result page. You can choose the page from the theme settings page. Navigate to the Theme Options > Events > Event Search Results Page field.', 'eventchamp-core' ) );
					$output .= '</div>';

				}

			$output .= '</div>';
		$output .= '</div>';

		return $output;

	}
	add_shortcode( "eventchamp_event_search", "eventchamp_event_search_output" );

	if( function_exists( 'vc_map' ) ) {

		vc_map(
			array(
				"name" => esc_html__( 'Event Search Tool', 'eventchamp-core' ),
				"base" => "eventchamp_event_search",
				"category" => esc_html__( 'Eventchamp Theme', 'eventchamp-core' ),
				"icon" => get_template_directory_uri() . '/include/assets/img/icons/event-search-tool.jpg',
				"description" => esc_html__( 'A advanced event search tool', 'eventchamp-core' ),
				"params" => array(
					array(
						"type" => "dropdown",
						"param_name" => "style",
						"heading" => esc_html__( 'Style', 'eventchamp-core' ),
						"description" => esc_html__( 'Style 3 for the slider background, style 2 for the image background, style 1 for the color background.', 'eventchamp-core' ),
						"group" => esc_html__( 'Design', 'eventchamp-core' ),
						'admin_label' => true,
						'save_always' => true,
						"value" => array(
							esc_html__( 'Style 1: Color Background', 'eventchamp-core' ) => 'white',
							esc_html__( 'Style 2: Image Background', 'eventchamp-core' ) => 'dark',
							esc_html__( 'Style 3: Slider Background', 'eventchamp-core' ) => 'style-3',
							esc_html__( 'Style 4: Pure', 'eventchamp-core' ) => 'style-4',
							esc_html__( 'Style 5: Dark', 'eventchamp-core' ) => 'style-5',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "column",
						"heading" => esc_html__( 'Column', 'eventchamp-core' ),
						"group" => esc_html__( 'Design', 'eventchamp-core' ),
						'admin_label' => true,
						'save_always' => true,
						"value" => array(
							esc_html__( '1 Column', 'eventchamp-core' ) => '1',
							esc_html__( '2 Column', 'eventchamp-core' ) => '2',
							esc_html__( '3 Column', 'eventchamp-core' ) => '3',
							esc_html__( '4 Column', 'eventchamp-core' ) => '4',
							esc_html__( '5 Column', 'eventchamp-core' ) => '5',
							esc_html__( '6 Column', 'eventchamp-core' ) => '6',
							esc_html__( '7 Column', 'eventchamp-core' ) => '7',
							esc_html__( '8 Column', 'eventchamp-core' ) => '8',
							esc_html__( '9 Column', 'eventchamp-core' ) => '9',
							esc_html__( '10 Column', 'eventchamp-core' ) => '10',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "column-space",
						"heading" => esc_html__( 'Column Space', 'eventchamp-core' ),
						"group" => esc_html__( 'Design', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( '0', 'eventchamp-core' ) => '0',
							esc_html__( '5', 'eventchamp-core' ) => '5',
							esc_html__( '10', 'eventchamp-core' ) => '10',
							esc_html__( '15', 'eventchamp-core' ) => '15',
							esc_html__( '20', 'eventchamp-core' ) => '20',
							esc_html__( '25', 'eventchamp-core' ) => '25',
							esc_html__( '30', 'eventchamp-core' ) => '30',
							esc_html__( '35', 'eventchamp-core' ) => '35',
							esc_html__( '40', 'eventchamp-core' ) => '40',
							esc_html__( '45', 'eventchamp-core' ) => '45',
							esc_html__( '50', 'eventchamp-core' ) => '50',
							esc_html__( '55', 'eventchamp-core' ) => '55',
							esc_html__( '60', 'eventchamp-core' ) => '60',
						),
					),
					array(
						"type" => "attach_image",
						"param_name" => "dark-background",
						"heading" => esc_html__( 'Background Image for the Style 2', 'eventchamp-core' ),
						"description" => esc_html__( 'Upload a background image for the style 2.', 'eventchamp-core' ),
						"group" => esc_html__( 'Design', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "dropdown",
						"param_name" => "live-search-select",
						"heading" => esc_html__( 'Live Search for Selects', 'eventchamp-core' ),
						"group" => esc_html__( 'Fields', 'eventchamp-core' ),
						'admin_label' => true,
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "title",
						"heading" => esc_html__( 'Search Title', 'eventchamp-core' ),
						"group" => esc_html__( 'Fields', 'eventchamp-core' ),
						'admin_label' => true,
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "textfield",
						"param_name" => "custom-title",
						"heading" => esc_html__( 'Custom Search Text', 'eventchamp-core' ),
						"description" => esc_html__( 'Default: Event Search:', 'eventchamp-core' ),
						"group" => esc_html__( 'Fields', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "dropdown",
						"param_name" => "startdate",
						"heading" => esc_html__( 'Data inicial', 'eventchamp-core' ),
						"group" => esc_html__( 'Fields', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "enddate",
						"heading" => esc_html__( 'End Date', 'eventchamp-core' ),
						"group" => esc_html__( 'Fields', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "keyword",
						"heading" => esc_html__( 'Keyword', 'eventchamp-core' ),
						"group" => esc_html__( 'Fields', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "textfield",
						"param_name" => "custom-keyword-text",
						"heading" => esc_html__( 'Custom Keyword Text', 'eventchamp-core' ),
						"description" => esc_html__( 'Default: e.g. event, meetup', 'eventchamp-core' ),
						"group" => esc_html__( 'Fields', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "dropdown",
						"param_name" => "category",
						"heading" => esc_html__( 'Category', 'eventchamp-core' ),
						"group" => esc_html__( 'Fields', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "location",
						"heading" => esc_html__( 'Locations', 'eventchamp-core' ),
						"group" => esc_html__( 'Fields', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "venues",
						"heading" => esc_html__( 'Venues', 'eventchamp-core' ),
						"group" => esc_html__( 'Fields', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "textfield",
						"param_name" => "venue-count",
						"heading" => esc_html__( 'Venue Count', 'eventchamp-core' ),
						"group" => esc_html__( 'Fields', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "include-venues",
						"heading" => esc_html__( 'Include Venues', 'eventchamp-core' ),
						"description" => esc_html__( 'Separate with commas. Example: 1, 2, 3 etc.', 'eventchamp-core' ),
						"group" => esc_html__( 'Fields', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "exclude-venues",
						"heading" => esc_html__( 'Exclude Venues', 'eventchamp-core' ),
						"description" => esc_html__( 'Separate with commas. Example: 1, 2, 3 etc.', 'eventchamp-core' ),
						"group" => esc_html__( 'Fields', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "dropdown",
						"param_name" => "venue-order",
						"heading" => esc_html__( 'Venue Order', 'eventchamp-core' ),
						"group" => esc_html__( 'Fields', 'eventchamp-core' ),
						"save_always" => true,
						"value" => array(
							esc_html__( 'ASC', 'eventchamp-core' ) => 'ASC',
							esc_html__( 'DESC', 'eventchamp-core' ) => 'DESC',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "venue-order-type",
						"heading" => esc_html__( 'Venue Order Type', 'eventchamp-core' ),
						"group" => esc_html__( 'Fields', 'eventchamp-core' ),
						"save_always" => true,
						"value" => array(
							esc_html__( 'Added Date', 'eventchamp-core' ) => 'added-date',
							esc_html__( 'Popular by Comment', 'eventchamp-core' ) => 'popular-comment',
							esc_html__( 'ID', 'eventchamp-core' ) => 'id',
							esc_html__( 'Title', 'eventchamp-core' ) => 'title',
							esc_html__( 'Menu Order', 'eventchamp-core' ) => 'menu_order',
							esc_html__( 'Random', 'eventchamp-core' ) => 'rand',
							esc_html__( 'By Include IDs', 'eventchamp-core' ) => 'post__in',
							esc_html__( 'None', 'eventchamp-core' ) => 'none',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "speakers",
						"heading" => esc_html__( 'Speakers', 'eventchamp-core' ),
						"group" => esc_html__( 'Fields', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "textfield",
						"param_name" => "speaker-count",
						"heading" => esc_html__( 'Speaker Count', 'eventchamp-core' ),
						"group" => esc_html__( 'Fields', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "include-speakers",
						"heading" => esc_html__( 'Include Speakers', 'eventchamp-core' ),
						"description" => esc_html__( 'Separate with commas. Example: 1, 2, 3 etc.', 'eventchamp-core' ),
						"group" => esc_html__( 'Fields', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "exclude-speakers",
						"heading" => esc_html__( 'Exclude Speakers', 'eventchamp-core' ),
						"description" => esc_html__( 'Separate with commas. Example: 1, 2, 3 etc.', 'eventchamp-core' ),
						"group" => esc_html__( 'Fields', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "dropdown",
						"param_name" => "speaker-order",
						"heading" => esc_html__( 'Speaker Order', 'eventchamp-core' ),
						"group" => esc_html__( 'Fields', 'eventchamp-core' ),
						"save_always" => true,
						"value" => array(
							esc_html__( 'ASC', 'eventchamp-core' ) => 'ASC',
							esc_html__( 'DESC', 'eventchamp-core' ) => 'DESC',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "speaker-order-type",
						"heading" => esc_html__( 'Speaker Order Type', 'eventchamp-core' ),
						"group" => esc_html__( 'Fields', 'eventchamp-core' ),
						"save_always" => true,
						"value" => array(
							esc_html__( 'Added Date', 'eventchamp-core' ) => 'added-date',
							esc_html__( 'Popular by Comment', 'eventchamp-core' ) => 'popular-comment',
							esc_html__( 'ID', 'eventchamp-core' ) => 'id',
							esc_html__( 'Title', 'eventchamp-core' ) => 'title',
							esc_html__( 'Menu Order', 'eventchamp-core' ) => 'menu_order',
							esc_html__( 'Random', 'eventchamp-core' ) => 'rand',
							esc_html__( 'By Include IDs', 'eventchamp-core' ) => 'post__in',
							esc_html__( 'None', 'eventchamp-core' ) => 'none',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "organizer",
						"heading" => esc_html__( 'Organizers', 'eventchamp-core' ),
						"group" => esc_html__( 'Fields', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "status",
						"heading" => esc_html__( 'Status', 'eventchamp-core' ),
						"group" => esc_html__( 'Fields', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "upcoming-status",
						"heading" => esc_html__( 'Upcoming for the Status', 'eventchamp-core' ),
						"group" => esc_html__( 'Fields', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "showing-status",
						"heading" => esc_html__( 'Showing for the Status', 'eventchamp-core' ),
						"group" => esc_html__( 'Fields', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "expired-status",
						"heading" => esc_html__( 'Expired for the Status', 'eventchamp-core' ),
						"group" => esc_html__( 'Fields', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "tag",
						"heading" => esc_html__( 'Tag', 'eventchamp-core' ),
						"group" => esc_html__( 'Fields', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "textfield",
						"param_name" => "custom-tag-text",
						"heading" => esc_html__( 'Custom Tag Text', 'eventchamp-core' ),
						"description" => esc_html__( 'Enter a tag: art, food', 'eventchamp-core' ),
						"group" => esc_html__( 'Fields', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "dropdown",
						"param_name" => "sort",
						"heading" => esc_html__( 'Sort Type', 'eventchamp-core' ),
						"group" => esc_html__( 'Fields', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "sort-start-date",
						"heading" => esc_html__( 'Sort Type: Start Date', 'eventchamp-core' ),
						"group" => esc_html__( 'Fields', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "sort-end-date",
						"heading" => esc_html__( 'Sort Type: End Date', 'eventchamp-core' ),
						"group" => esc_html__( 'Fields', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "sort-added-date",
						"heading" => esc_html__( 'Sort Type: Added Date', 'eventchamp-core' ),
						"group" => esc_html__( 'Fields', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "sort-name-a-z",
						"heading" => esc_html__( 'Sort Type: Name A > Z', 'eventchamp-core' ),
						"group" => esc_html__( 'Fields', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "sort-name-z-a",
						"heading" => esc_html__( 'Sort Type: Name Z > A', 'eventchamp-core' ),
						"group" => esc_html__( 'Fields', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "sort-price-l-h",
						"heading" => esc_html__( 'Sort Type: Price Low to High', 'eventchamp-core' ),
						"group" => esc_html__( 'Fields', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "sort-price-h-l",
						"heading" => esc_html__( 'Sort Type: Price High to Low', 'eventchamp-core' ),
						"group" => esc_html__( 'Fields', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "price-slider",
						"heading" => esc_html__( 'Price Slider', 'eventchamp-core' ),
						"group" => esc_html__( 'Fields', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "price-slider-grid",
						"heading" => esc_html__( 'Grid for the Price Slider', 'eventchamp-core' ),
						"group" => esc_html__( 'Fields', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "textfield",
						"param_name" => "price-slider-min-price",
						"heading" => esc_html__( 'Min Price for the Price Slider', 'eventchamp-core' ),
						"description" => esc_html__( 'Default: 0', 'eventchamp-core' ),
						"group" => esc_html__( 'Fields', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "price-slider-max-price",
						"heading" => esc_html__( 'Max Price for the Price Slider', 'eventchamp-core' ),
						"description" => esc_html__( 'Default: 999', 'eventchamp-core' ),
						"group" => esc_html__( 'Fields', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "price-slider-from",
						"heading" => esc_html__( 'From Price for the Price Slider', 'eventchamp-core' ),
						"description" => esc_html__( 'Set start position for left handle (or for single handle). Default: 0', 'eventchamp-core' ),
						"group" => esc_html__( 'Fields', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "price-slider-to",
						"heading" => esc_html__( 'To Price for the Price Slider', 'eventchamp-core' ),
						"description" => esc_html__( 'Set start position for right handle. Default: 299', 'eventchamp-core' ),
						"group" => esc_html__( 'Fields', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "price-slider-step",
						"heading" => esc_html__( 'Step for the Price Slider', 'eventchamp-core' ),
						"description" => esc_html__( 'Set sliders step. Always > 0. Could be fractional. Default: 1', 'eventchamp-core' ),
						"group" => esc_html__( 'Fields', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "dropdown",
						"param_name" => "price-slider-min-max",
						"heading" => esc_html__( 'Hide Min-Max Label for the Price Slider', 'eventchamp-core' ),
						"group" => esc_html__( 'Fields', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "price-slider-from-to",
						"heading" => esc_html__( 'Hide From-To Label for the Price Slider', 'eventchamp-core' ),
						"group" => esc_html__( 'Fields', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "textfield",
						"param_name" => "price-slider-prefix",
						"heading" => esc_html__( 'Prefix for the Price Slider', 'eventchamp-core' ),
						"description" => esc_html__( 'Will be set up right before the number. Example: $100', 'eventchamp-core' ),
						"group" => esc_html__( 'Fields', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "price-slider-postfix",
						"heading" => esc_html__( 'Postfix for the Price Slider', 'eventchamp-core' ),
						"description" => esc_html__( 'Will be set up right after the number. Example: 100k', 'eventchamp-core' ),
						"group" => esc_html__( 'Fields', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "exclude-categories",
						"heading" => esc_html__( 'Exclude Categories', 'eventchamp-core' ),
						"description" => esc_html__( 'Separate with commas. Example: 1, 2, 3 etc.', 'eventchamp-core' ),
						"group" => esc_html__( 'Taxonomies', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "exclude-locations",
						"heading" => esc_html__( 'Exclude Locations', 'eventchamp-core' ),
						"description" => esc_html__( 'Separate with commas. Example: 1, 2, 3 etc.', 'eventchamp-core' ),
						"group" => esc_html__( 'Taxonomies', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "exclude-organizers",
						"heading" => esc_html__( 'Exclude Organizers', 'eventchamp-core' ),
						"description" => esc_html__( 'Separate with commas. Example: 1, 2, 3 etc.', 'eventchamp-core' ),
						"group" => esc_html__( 'Taxonomies', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "include-categories",
						"heading" => esc_html__( 'Include Categories', 'eventchamp-core' ),
						"description" => esc_html__( 'Separate with commas. Example: 1, 2, 3 etc. If you have sub categories, it will work only for parents.', 'eventchamp-core' ),
						"group" => esc_html__( 'Taxonomies', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "include-locations",
						"heading" => esc_html__( 'Include Locations', 'eventchamp-core' ),
						"description" => esc_html__( 'Separate with commas. Example: 1, 2, 3 etc. If you have sub locations, it will work only for parents.', 'eventchamp-core' ),
						"group" => esc_html__( 'Taxonomies', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "include-organizers",
						"heading" => esc_html__( 'Include Organizers', 'eventchamp-core' ),
						"description" => esc_html__( 'Separate with commas. Example: 1, 2, 3 etc. If you have sub organizers, it will work only for parents.', 'eventchamp-core' ),
						"group" => esc_html__( 'Taxonomies', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "dropdown",
						"param_name" => "taxonomy-order",
						"heading" => esc_html__( 'Taxonomy Order', 'eventchamp-core' ),
						"group" => esc_html__( 'Taxonomies', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'ASC', 'eventchamp-core' ) => 'ASC',
							esc_html__( 'DESC', 'eventchamp-core' ) => 'DESC',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "taxonomy-order-type",
						"heading" => esc_html__( 'Taxonomy Order Type', 'eventchamp-core' ),
						"group" => esc_html__( 'Taxonomies', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'Name', 'eventchamp-core' ) => 'name',
							esc_html__( 'Slug', 'eventchamp-core' ) => 'slug',
							esc_html__( 'Term Group', 'eventchamp-core' ) => 'term_group',
							esc_html__( 'Term ID', 'eventchamp-core' ) => 'term_id',
							esc_html__( 'ID', 'eventchamp-core' ) => 'id',
							esc_html__( 'Description', 'eventchamp-core' ) => 'description',
							esc_html__( 'Parent', 'eventchamp-core' ) => 'parent',
							esc_html__( 'Count', 'eventchamp-core' ) => 'count',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "empty-taxonomies",
						"heading" => esc_html__( 'Hide Empty Taxonomies', 'eventchamp-core' ),
						"description" => esc_html__( 'If you choose true option empty taxonomies will be hide.', 'eventchamp-core' ),
						"group" => esc_html__( 'Taxonomies', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "childless",
						"heading" => esc_html__( 'Childless', 'eventchamp-core' ),
						"group" => esc_html__( 'Taxonomies', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "hide-children",
						"heading" => esc_html__( 'Hide Children', 'eventchamp-core' ),
						"group" => esc_html__( 'Taxonomies', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
						),
					),
					array(
						"type" => "attach_images",
						"param_name" => "slider-images",
						"heading" => esc_html__( 'Slider Images', 'eventchamp-core' ),
						"description" => esc_html__( 'You can upload slider images for the style 3.', 'eventchamp-core' ),
						"group" => esc_html__( 'Slider', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "slider-height",
						"heading" => esc_html__( 'Slider Height', 'eventchamp-core' ),
						"description" => esc_html__( 'If you use the style 3, enter a slider height. Example: 600px. If enter blank, it will have full height.', 'eventchamp-core' ),
						"group" => esc_html__( 'Slider', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "dropdown",
						"param_name" => "slider-column",
						"heading" => esc_html__( 'Column', 'eventchamp-core' ),
						"group" => esc_html__( 'Slider', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( '1 Column', 'eventchamp-core' ) => '1',
							esc_html__( '2 Column', 'eventchamp-core' ) => '2',
							esc_html__( '3 Column', 'eventchamp-core' ) => '3',
							esc_html__( '4 Column', 'eventchamp-core' ) => '4',
							esc_html__( '5 Column', 'eventchamp-core' ) => '5',
							esc_html__( '6 Column', 'eventchamp-core' ) => '6',
							esc_html__( '7 Column', 'eventchamp-core' ) => '7',
							esc_html__( '8 Column', 'eventchamp-core' ) => '8',
							esc_html__( '9 Column', 'eventchamp-core' ) => '9',
							esc_html__( '10 Column', 'eventchamp-core' ) => '10',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "slider-space",
						"heading" => esc_html__( 'Column Space', 'eventchamp-core' ),
						"group" => esc_html__( 'Slider', 'eventchamp-core' ),
						"save_always" => true,
						"value" => array(
							esc_html__( '0', 'eventchamp-core' ) => '0',
							esc_html__( '1', 'eventchamp-core' ) => '1',
							esc_html__( '2', 'eventchamp-core' ) => '2',
							esc_html__( '3', 'eventchamp-core' ) => '3',
							esc_html__( '4', 'eventchamp-core' ) => '4',
							esc_html__( '5', 'eventchamp-core' ) => '5',
							esc_html__( '10', 'eventchamp-core' ) => '10',
							esc_html__( '15', 'eventchamp-core' ) => '15',
							esc_html__( '20', 'eventchamp-core' ) => '20',
							esc_html__( '25', 'eventchamp-core' ) => '25',
							esc_html__( '30', 'eventchamp-core' ) => '30',
							esc_html__( '45', 'eventchamp-core' ) => '45',
							esc_html__( '50', 'eventchamp-core' ) => '50',
							esc_html__( '55', 'eventchamp-core' ) => '55',
							esc_html__( '60', 'eventchamp-core' ) => '60',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "slider-autoplay",
						"heading" => esc_html__( 'Slider Autoplay', 'eventchamp-core' ),
						"group" => esc_html__( 'Slider', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "textfield",
						"param_name" => "slider-autoplay-delay",
						"heading" => esc_html__( 'Slider Autoplay Delay', 'eventchamp-core' ),
						"description" => esc_html__( 'Default: 15000', 'eventchamp-core' ),
						"group" => esc_html__( 'Slider', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "dropdown",
						"param_name" => "slider-loop",
						"heading" => esc_html__( 'Slider Loop', 'eventchamp-core' ),
						"group" => esc_html__( 'Slider', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "textfield",
						"param_name" => "slider-slide-speed",
						"heading" => esc_html__( 'Slide Speed', 'eventchamp-core' ),
						"description" => esc_html__( 'Duration of transition between the slides. Default: 1500', 'eventchamp-core' ),
						"group" => esc_html__( 'Slider', 'eventchamp-core' ),
						"save_always" => true,
					),
					array(
						"type" => "dropdown",
						"param_name" => "slider-centered-slides",
						"heading" => esc_html__( 'Centered Slides', 'eventchamp-core' ),
						"description" => esc_html__( 'If you choose true, then active slide will be centered, not always on the left side.', 'eventchamp-core' ),
						"group" => esc_html__( 'Slider', 'eventchamp-core' ),
						"save_always" => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "slider-direction",
						"heading" => esc_html__( 'Slider Direction', 'eventchamp-core' ),
						"group" => esc_html__( 'Slider', 'eventchamp-core' ),
						"save_always" => true,
						"value" => array(
							esc_html__( 'Horizontal', 'eventchamp-core' ) => 'horizontal',
							esc_html__( 'Vertical', 'eventchamp-core' ) => 'vertical',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "slider-effect",
						"heading" => esc_html__( 'Slider Effect', 'eventchamp-core' ),
						"group" => esc_html__( 'Slider', 'eventchamp-core' ),
						"save_always" => true,
						"value" => array(
							esc_html__( 'Slide', 'eventchamp-core' ) => 'slide',
							esc_html__( 'Fade', 'eventchamp-core' ) => 'fade',
							esc_html__( 'Cube', 'eventchamp-core' ) => 'cube',
							esc_html__( 'Coverflow', 'eventchamp-core' ) => 'coverflow',
							esc_html__( 'Flip', 'eventchamp-core' ) => 'flip',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "slider-free-mode",
						"heading" => esc_html__( 'Free Mode', 'eventchamp-core' ),
						"description" => esc_html__( 'If true then slides will not have fixed positions', 'eventchamp-core' ),
						"group" => esc_html__( 'Slider', 'eventchamp-core' ),
						"save_always" => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
				),
			)
		);

	}

}