<?php
/*======
*
* Blog Carousel
*
======*/
if( !function_exists( 'eventchamp_latest_posts_carousel_output' ) ) {

	function eventchamp_latest_posts_carousel_output( $atts, $content = null ) {

		/*====== Atts ======*/
		$atts = shortcode_atts(
			array(
				'postcount' => '',
				'category' => '',
				'postids' => '',
				'excludeposts' => '',
				'posttag' => '',
				'offset' => '',
				'ordertype' => '',
				'sortby' => '',
				'ignore-sticky-posts' => '',
				'style' => '',
				'link' => '',
				'categoryname' => '',
				'author' => 'false',
				'date' => 'false',
				'reading-time' => 'false',
				'comments' => 'false',
				'excerpt' => '',
				'readmore' => '',
				'column' => '',
				'slider-space' => '',
				'slider-autoplay' => '',
				'slider-autoplay-delay' => '',
				'slider-loop' => '',
				'slider-slide-speed' => '',
				'slider-centered-slides' => '',
				'slider-direction"' => '',
				'slider-effect' => '',
				'slider-free-mode' => '',
				'navigation' => '',
			), $atts
		);

		/*====== Column ======*/
		if( empty( $atts["column"] ) ) {

			$atts["column"] = "1";

		}

		/*====== Category Name Status ======*/
		if( $atts['categoryname'] == "true" ) {

			$category_status = "true";

		} else {

			$category_status = "false";

		}

		/*====== Excerpt Status ======*/
		if( $atts['excerpt'] == "true" ) {

			$excerpt_status = "true";

		} else {

			$excerpt_status = "false";

		}

		/*====== Read More Status ======*/
		if( $atts['readmore'] == "true" ) {

			$readmore_status = "true";

		} else {

			$readmore_status = "false";

		}

		/*====== Column Space ======*/
		if( empty( $atts["slider-space"] ) ) {

			$atts["slider-space"] = "30";

		}

		/*====== Slider Autoplay ======*/
		if( empty( $atts["slider-autoplay"] ) ) {

			$atts["slider-autoplay"] = "false";

		}

		/*====== Slider Autoplay Delay ======*/
		if( empty( $atts["slider-autoplay-delay"] ) ) {

			$atts["slider-autoplay-delay"] = "15000";

		}

		/*====== Slider Loop ======*/
		if( empty( $atts["slider-loop"] ) ) {

			$atts["slider-loop"] = "false";

		}

		/*====== Slider Slide Speed ======*/
		if( empty( $atts["slider-slide-speed"] ) ) {

			$atts["slider-slide-speed"] = "1000";

		}

		/*====== Centered Slides ======*/
		if( empty( $atts["slider-centered-slides"] ) ) {

			$atts["slider-centered-slides"] = "false";

		}

		/*====== Slider Direction ======*/
		if( empty( $atts["slider-direction"] ) ) {

			$atts["slider-direction"] = "horizontal";

		}

		/*====== Slider Effect ======*/
		if( empty( $atts["slider-effect"] ) ) {

			$atts["slider-effect"] = "slide";

		}

		/*====== Slider Free Mode ======*/
		if( empty( $atts["slider-free-mode"] ) ) {

			$atts["slider-free-mode"] = "false";

		}

		/*====== Pagination ======*/
		if( empty( $atts["pagination"] ) ) {

			$atts["pagination"] = "false";

		}

		/*====== Main Query ======*/
		$arg = array(
			'post_status' => 'publish',
			'post_type' => 'post',
		);

		/*====== Pagination ======*/
		$paged = is_front_page() ? get_query_var( 'page', 1 ) : get_query_var( 'paged', 1 );

		if( empty( $paged ) ) {

			$paged = 1;

		}

		if( !empty( $paged ) ) {

			$extra_query = array(
				'paged' => $paged,
			);
			$arg = wp_parse_args( $arg, $extra_query );

		}

		/*====== Include Categories ======*/
		if( !empty( $atts['category'] ) ) {

			$category_ids = $atts['category'];
			$include_cats = explode( ',', $category_ids );

		} else {

			$include_cats = "";

		}

		if( !empty( $include_cats ) ) {

			$extra_query = array(
				'cat' => $include_cats,
			);
			$arg = wp_parse_args( $arg, $extra_query );

		}

		/*====== Include Posts ======*/
		if( !empty( $atts['postids'] ) ) {

			$postids = $atts['postids'];
			$include_posts = explode( ',', $postids );

		} else {

			$include_posts = "";

		}

		if( !empty( $include_posts ) ) {

			$extra_query = array(
				'post__in' => $include_posts,
			);
			$arg = wp_parse_args( $arg, $extra_query );

		}

		/*====== Post Count ======*/
		if( !empty( $atts["postcount"] ) ) {

			$extra_query = array(
				'posts_per_page' => $atts["postcount"],
			);
			$arg = wp_parse_args( $arg, $extra_query );

		}

		/*====== Offset ======*/
		if( !empty( $atts["offset"] ) ) {

			$extra_query = array(
				'offset' => $atts["offset"],
			);
			$arg = wp_parse_args( $arg, $extra_query );

		}

		/*====== Post Tag ======*/
		if( !empty( $atts["posttag"] ) ) {

			$extra_query = array(
				'tag' => $atts['posttag'],
			);
			$arg = wp_parse_args( $arg, $extra_query );

		}

		/*====== Exclude Posts ======*/
		$excludeposts = $atts['excludeposts'];

		if( !empty( $excludeposts ) ) {

			$exclude_posts = $excludeposts;
			$exclude_posts = explode( ',', $exclude_posts );

		} else {

			$exclude_posts = array();

		}

		if( !empty( $exclude_posts ) ) {

			$extra_query = array(
				'post__not_in' => $exclude_posts,
			);
			$arg = wp_parse_args( $arg, $extra_query );

		}

		/*====== Order & Order By ======*/
		if( $atts["ordertype"] == "ASC" ) {

			$order = "ASC";

		} else {

			$order = "DESC";

		}

		if( !empty( $order ) ) {

			$extra_query = array(
				'order' => $order,
			);
			$arg = wp_parse_args( $arg, $extra_query );

		}

		if( $atts["sortby"] == "popular-comment" ) {

			$order_by = "comment_count";

		} elseif( $atts["sortby"] == "id" ) {

			$order_by = "ID";

		} elseif( $atts["sortby"] == "popular" ) {

			$order_by = "comment_count";

		} elseif( $atts["sortby"] == "title" ) {

			$order_by = "title";

		} elseif( $atts["sortby"] == "menu_order" ) {

			$order_by = "menu_order";

		} elseif( $atts["sortby"] == "rand" ) {

			$order_by = "rand";

		} elseif( $atts["sortby"] == "none" ) {

			$order_by = "none";

		} else {

			$order_by = "date";

		}

		if( !empty( $order_by ) ) {

			$extra_query = array(
				'orderby' => $order_by,
			);
			$arg = wp_parse_args( $arg, $extra_query );

		}

		/*====== Ignore Sticky Posts ======*/
		if( $atts["ignore-sticky-posts"] == "true" ) {

			$extra_query = array(
				'ignore_sticky_posts' => true,
			);
			$arg = wp_parse_args( $arg, $extra_query );

		} else {

			$extra_query = array(
				'ignore_sticky_posts' => false,
			);
			$arg = wp_parse_args( $arg, $extra_query );

		}

		/*====== HTML Output ======*/
		$output = '';

		$post_query = new WP_Query( $arg );

		if( !empty( $post_query ) ) {

			if( $post_query->have_posts() ) {

				$output .= '<div class="gt-blog-carousel">';
					$output .= '<div class="swiper-container gt-swiper-slider" data-gt-item="' . esc_attr( $atts["column"] ) . '" data-gt-item-space="' . esc_attr( $atts["slider-space"] ) . '" data-gt-loop="' . esc_attr( $atts["slider-loop"] ) . '" data-gt-speed="' . esc_attr( $atts["slider-slide-speed"] ) . '" data-gt-direction="' . esc_attr( $atts["slider-direction"] ) . '" data-gt-effect="' . esc_attr( $atts["slider-effect"] ) . '" data-gt-centered-slides="' . esc_attr( $atts["slider-centered-slides"] ) . '" data-gt-free-mode="' . esc_attr( $atts["slider-free-mode"] ) . '">';
						$output .= '<div class="swiper-wrapper">';

							while( $post_query->have_posts() ) {

								$post_query->the_post();

								if( $atts["slider-autoplay"] == "true" ) {

									$output .= '<div class="swiper-slide" data-swiper-autoplay="' . esc_attr( $atts["slider-autoplay-delay"] ) . '">';

								} else {

									$output .= '<div class="swiper-slide">';

								}

									if( $atts["style"] == "style2" ) {

										$output .= eventchamp_post_list_style_2( $post_id = get_the_ID(), $image = "true", $category = esc_attr( $atts["categoryname"] ), $excerpt = esc_attr( $atts["excerpt"] ), $read_more = esc_attr( $atts["readmore"] ), $author = esc_attr( $atts["author"] ), $date = esc_attr( $atts["date"] ), $reading_time = esc_attr( $atts["reading-time"] ), $comments = esc_attr( $atts["comments"] ) );

									} elseif( $atts["style"] == "style3" ) {

										$output .= eventchamp_post_list_style_3( $post_id = get_the_ID(), $image = "true", $category = esc_attr( $atts["categoryname"] ), $author = esc_attr( $atts["author"] ), $date = esc_attr( $atts["date"] ), $reading_time = esc_attr( $atts["reading-time"] ), $comments = esc_attr( $atts["comments"] ) );

									} elseif( $atts["style"] == "style4" ) {

										$output .= eventchamp_post_list_style_1( $post_id = get_the_ID(), $image = "true", $category = esc_attr( $atts["categoryname"] ), $excerpt = esc_attr( $atts["excerpt"] ), $read_more = esc_attr( $atts["readmore"] ), $author = esc_attr( $atts["author"] ), $date = esc_attr( $atts["date"] ), $reading_time = esc_attr( $atts["reading-time"] ), $comments = esc_attr( $atts["comments"] ) );

									} else {

										$output .= eventchamp_post_list_style_1( $post_id = get_the_ID(), $image = "true", $category = esc_attr( $atts["categoryname"] ), $excerpt = esc_attr( $atts["excerpt"] ), $read_more = esc_attr( $atts["readmore"] ), $author = esc_attr( $atts["author"] ), $date = esc_attr( $atts["date"] ), $reading_time = esc_attr( $atts["reading-time"] ), $comments = esc_attr( $atts["comments"] ) );

									}

								$output .= '</div>';

							}

						$output .= '</div>';
					
						if( $atts['navigation'] == 'true' or !empty( $atts["link"] ) ) {

							$output .= '<div class="gt-pagination">';

								if( $atts['navigation'] == 'true' ) {

									$output .= '<div class="gt-slider-prev">';
										$output .= '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><polyline points="15 18 9 12 15 6"></polyline></svg>';
									$output .= '</div>';

								}

								if( !empty( $atts["link"] ) ) {

									$href = $atts["link"];
									$href = vc_build_link( $href );

									if( !empty( $href["target"] ) ) {

										$target = $href["target"];

									} else {

										$target = "_parent";

									}

									$output .= '<div>';
										$output .= '<a href="' . esc_url( $href["url"] ) . '" target="' . esc_attr( $target ) . '" class="gt-all-button">' . esc_attr( $href["title"] ) . '</a>';
									$output .= '</div>';

								}

								if( $atts['navigation'] == 'true' ) {

									$output .= '<div class="gt-slider-next">';
										$output .= '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><polyline points="9 18 15 12 9 6"></polyline></svg>';
									$output .= '</div>';

								}

							$output .= '</div>';

						}

					$output .= '</div>';
				$output .= '</div>';

			}

		}
		wp_reset_postdata();

		return $output;

	}
	add_shortcode( "eventchamp_latest_posts_carousel", "eventchamp_latest_posts_carousel_output" );

	if( function_exists( 'vc_map' ) ) {

		$post_categories = get_terms( "category" );
		$post_categories_array = array();
		$post_categories_array[esc_html__( 'All Categories', 'eventchamp-core' )] = "-";

		if( !empty( $post_categories ) ) {

			foreach( $post_categories as $post_category ) {

				if( !empty( $post_category ) ) {

				$post_categories_array[$post_category->name] =  $post_category->term_id;

				}

			}

		}

		vc_map(
			array(
				"name" => esc_html__( 'Blog Carousel', 'eventchamp-core' ),
				"base" => "eventchamp_latest_posts_carousel",
				"category" => esc_html__( 'Eventchamp Theme', 'eventchamp-core' ),
				"icon" => get_template_directory_uri() . '/include/assets/img/icons/blog-carousel.jpg',
				"description" => esc_html__( 'List the blog posts with carousel', 'eventchamp-core' ),
				"params" => array(
					array(
						"type" => "textfield",
						"param_name" => "postcount",
						"heading" => esc_html__( 'Post Count', 'eventchamp-core' ),
						"group" => esc_html__( 'General', 'eventchamp-core' ),
						'admin_label' => true,
						'save_always' => true,
					),
					array(
						"type" => "dropdown",
						"param_name" => "category",
						"heading" => esc_html__( 'Category', 'eventchamp-core' ),
						"group" => esc_html__( 'General', 'eventchamp-core' ),
						'admin_label' => true,
						'save_always' => true,
						"value" => $post_categories_array,
					),
					array(
						"type" => "textfield",
						"param_name" => "postids",
						"heading" => esc_html__( 'Include Posts', 'eventchamp-core' ),
						"description" => esc_html__( 'Separate with commas. Example: 1, 2, 3 etc.', 'eventchamp-core' ),
						"group" => esc_html__( 'General', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "excludeposts",
						"heading" => esc_html__( 'Exclude Posts', 'eventchamp-core' ),
						"description" => esc_html__( 'Separate with commas. Example: 1, 2, 3 etc.', 'eventchamp-core' ),
						"group" => esc_html__( 'General', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "posttag",
						"heading" => esc_html__( 'Tag', 'eventchamp-core' ),
						"description" => esc_html__( 'Example: Event', 'eventchamp-core' ),
						"group" => esc_html__( 'General', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "offset",
						"heading" => esc_html__( 'Offset', 'eventchamp-core' ),
						"group" => esc_html__( 'General', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "dropdown",
						"param_name" => "ordertype",
						"heading" => esc_html__( 'Order', 'eventchamp-core' ),
						"group" => esc_html__( 'General', 'eventchamp-core' ),
						"save_always" => true,
						"value" => array(
							esc_html__( 'ASC', 'eventchamp-core' ) => 'ASC',
							esc_html__( 'DESC', 'eventchamp-core' ) => 'DESC',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "sortby",
						"heading" => esc_html__( 'Order Type', 'eventchamp-core' ),
						"group" => esc_html__( 'General', 'eventchamp-core' ),
						"save_always" => true,
						"value" => array(
							esc_html__( 'Added Date', 'eventchamp-core' ) => 'added-date',
							esc_html__( 'Popular by Comment', 'eventchamp-core' ) => 'popular-comment',
							esc_html__( 'ID', 'eventchamp-core' ) => 'id',
							esc_html__( 'Title', 'eventchamp-core' ) => 'title',
							esc_html__( 'Menu Order', 'eventchamp-core' ) => 'menu_order',
							esc_html__( 'Random', 'eventchamp-core' ) => 'rand',
							esc_html__( 'None', 'eventchamp-core' ) => 'none',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "ignore-sticky-posts",
						"heading" => esc_html__( 'Ignore Sticky Posts', 'eventchamp-core' ),
						"group" => esc_html__( 'General', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "style",
						"heading" => esc_html__( 'Style', 'eventchamp-core' ),
						"group" => esc_html__( 'Design', 'eventchamp-core' ),
						'admin_label' => true,
						'save_always' => true,
						"value" => array(
							esc_html__( 'Style 1', 'eventchamp-core' ) => 'style1',
							esc_html__( 'Style 2', 'eventchamp-core' ) => 'style2',
							esc_html__( 'Style 3', 'eventchamp-core' ) => 'style3',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "column",
						"heading" => esc_html__( 'Column', 'eventchamp-core' ),
						"group" => esc_html__( 'Slider', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( '1 Column', 'eventchamp-core' ) => '1',
							esc_html__( '2 Column', 'eventchamp-core' ) => '2',
							esc_html__( '3 Column', 'eventchamp-core' ) => '3',
							esc_html__( '4 Column', 'eventchamp-core' ) => '4',
							esc_html__( '5 Column', 'eventchamp-core' ) => '5',
							esc_html__( '6 Column', 'eventchamp-core' ) => '6',
						),
					),
					array(
						"type" => "vc_link",
						"param_name" => "link",
						"heading" => esc_html__( 'Blog Page Link', 'eventchamp-core' ),
						"group" => esc_html__( 'Design', 'eventchamp-core' ),
					),
					array(
						"type" => "dropdown",
						"param_name" => "categoryname",
						"heading" => esc_html__( 'Category', 'eventchamp-core' ),
						"group" => esc_html__( 'Design', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "author",
						"heading" => esc_html__( 'Author', 'eventchamp-core' ),
						"group" => esc_html__( 'Design', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "date",
						"heading" => esc_html__( 'Date', 'eventchamp-core' ),
						"group" => esc_html__( 'Design', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "reading-time",
						"heading" => esc_html__( 'Reading Time', 'eventchamp-core' ),
						"group" => esc_html__( 'Design', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "comments",
						"heading" => esc_html__( 'Comments', 'eventchamp-core' ),
						"group" => esc_html__( 'Design', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "excerpt",
						"heading" => esc_html__( 'Excerpt', 'eventchamp-core' ),
						"group" => esc_html__( 'Design', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "readmore",
						"heading" => esc_html__( 'Read More', 'eventchamp-core' ),
						"group" => esc_html__( 'Design', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "slider-space",
						"heading" => esc_html__( 'Column Space', 'eventchamp-core' ),
						"group" => esc_html__( 'Slider', 'eventchamp-core' ),
						"save_always" => true,
						"value" => array(
							esc_html__( '0', 'eventchamp-core' ) => '0',
							esc_html__( '1', 'eventchamp-core' ) => '1',
							esc_html__( '2', 'eventchamp-core' ) => '2',
							esc_html__( '3', 'eventchamp-core' ) => '3',
							esc_html__( '4', 'eventchamp-core' ) => '4',
							esc_html__( '5p', 'eventchamp-core' ) => '5',
							esc_html__( '10', 'eventchamp-core' ) => '10',
							esc_html__( '15', 'eventchamp-core' ) => '15',
							esc_html__( '20', 'eventchamp-core' ) => '20',
							esc_html__( '25', 'eventchamp-core' ) => '25',
							esc_html__( '30', 'eventchamp-core' ) => '30',
							esc_html__( '45', 'eventchamp-core' ) => '45',
							esc_html__( '50', 'eventchamp-core' ) => '50',
							esc_html__( '55', 'eventchamp-core' ) => '55',
							esc_html__( '60', 'eventchamp-core' ) => '60',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "slider-autoplay",
						"heading" => esc_html__( 'Slider Autoplay', 'eventchamp-core' ),
						"group" => esc_html__( 'Slider', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "textfield",
						"param_name" => "slider-autoplay-delay",
						"heading" => esc_html__( 'Slider Autoplay Delay', 'eventchamp-core' ),
						"description" => esc_html__( 'Default: 15000', 'eventchamp-core' ),
						"group" => esc_html__( 'Slider', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "dropdown",
						"param_name" => "slider-loop",
						"heading" => esc_html__( 'Slider Loop', 'eventchamp-core' ),
						"group" => esc_html__( 'Slider', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "textfield",
						"param_name" => "slider-slide-speed",
						"heading" => esc_html__( 'Slide Speed', 'eventchamp-core' ),
						"description" => esc_html__( 'Duration of transition between the slides. Default: 1500', 'eventchamp-core' ),
						"group" => esc_html__( 'Slider', 'eventchamp-core' ),
						"save_always" => true,
					),
					array(
						"type" => "dropdown",
						"param_name" => "slider-centered-slides",
						"heading" => esc_html__( 'Centered Slides', 'eventchamp-core' ),
						"description" => esc_html__( 'If you choose true, then active slide will be centered, not always on the left side.', 'eventchamp-core' ),
						"group" => esc_html__( 'Slider', 'eventchamp-core' ),
						"save_always" => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "slider-direction",
						"heading" => esc_html__( 'Slider Direction', 'eventchamp-core' ),
						"group" => esc_html__( 'Slider', 'eventchamp-core' ),
						"save_always" => true,
						"value" => array(
							esc_html__( 'Horizontal', 'eventchamp-core' ) => 'horizontal',
							esc_html__( 'Vertical', 'eventchamp-core' ) => 'vertical',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "slider-effect",
						"heading" => esc_html__( 'Slider Effect', 'eventchamp-core' ),
						"group" => esc_html__( 'Slider', 'eventchamp-core' ),
						"save_always" => true,
						"value" => array(
							esc_html__( 'Slide', 'eventchamp-core' ) => 'slide',
							esc_html__( 'Fade', 'eventchamp-core' ) => 'fade',
							esc_html__( 'Cube', 'eventchamp-core' ) => 'cube',
							esc_html__( 'Coverflow', 'eventchamp-core' ) => 'coverflow',
							esc_html__( 'Flip', 'eventchamp-core' ) => 'flip',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "slider-free-mode",
						"heading" => esc_html__( 'Free Mode', 'eventchamp-core' ),
						"description" => esc_html__( 'If true then slides will not have fixed positions', 'eventchamp-core' ),
						"group" => esc_html__( 'Slider', 'eventchamp-core' ),
						"save_always" => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "navigation",
						"heading" => esc_html__( 'Navigation', 'eventchamp-core' ),
						"group" => esc_html__( 'Slider', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
				),
			)
		);

	}

}