<?php
/*======
*
* Blog Widget
*
======*/
	if( !function_exists( 'eventchamp_latest_posts_register_widgets' ) ) {

		function eventchamp_latest_posts_register_widgets() {

			register_widget( 'eventchamp_latest_posts_widget' );

		}
		add_action( 'widgets_init', 'eventchamp_latest_posts_register_widgets' );

	}



	if( !class_exists( 'eventchamp_latest_posts_widget' ) ) {

		class eventchamp_latest_posts_widget extends WP_Widget {

			function __construct() {

				parent::__construct(
			            'eventchamp_latest_posts_widget',
		        	    esc_html__( 'Eventchamp: Latest Posts', 'eventchamp-core' ),
		 	           array( 'description' => esc_html__( 'A post listing widget', 'eventchamp-core' ), )
				);

			}
			
			function widget( $args, $instance ) {

				echo $args['before_widget'];

					/*====== Title ======*/
					if ( !empty( $instance['latest_posts_widget_title'] ) ) {

						echo '<div class="gt-widget-title">';
							echo '<span>' . esc_attr( $instance['latest_posts_widget_title'] ) . '</span>';
						echo '</div>';

					}

					/*====== Instance ======*/
					if( !empty( $instance ) ) {

						$latest_posts_widget_title = esc_attr( $instance['latest_posts_widget_title'] );
						$latest_posts_widget_category = esc_attr( $instance['latest_posts_widget_category'] );
						$latest_posts_widget_exclude = esc_attr( $instance['latest_posts_widget_exclude'] );
						$latest_posts_widget_offset = esc_attr( $instance['latest_posts_widget_offset'] );
						$latest_posts_widget_post_count = esc_attr( $instance['latest_posts_widget_post_count'] );
						$latest_posts_widget_category_name = esc_attr( $instance['latest_posts_widget_category_name'] );
						$latest_posts_widget_author = esc_attr( $instance['latest_posts_widget_author'] );
						$latest_posts_widget_date = esc_attr( $instance['latest_posts_widget_date'] );
						$latest_posts_widget_reading_time = esc_attr( $instance['latest_posts_widget_reading_time'] );
						$latest_posts_widget_comments = esc_attr( $instance['latest_posts_widget_comments'] );
						$latest_posts_widget_column = esc_attr( $instance['latest_posts_widget_column'] );
						$latest_posts_widget_column_space = esc_attr( $instance['latest_posts_widget_column_space'] );

					}
					
					/*====== Exclude ======*/
					if( !empty( $latest_posts_widget_exclude ) ) {

						$latest_posts_widget_exclude = $latest_posts_widget_exclude;
						$latest_posts_widget_exclude = explode( ',', $latest_posts_widget_exclude );

					}

					/*====== HTML Output ======*/
					echo eventchamp_widget_before();

						echo '<div class="gt-blog-widget">';

							$args_latest_posts = array(
								'post_status' => 'publish',
								'post_type' => 'post',
								'posts_per_page' => $latest_posts_widget_post_count,
								'post__not_in' => $latest_posts_widget_exclude,
								'offset' => $latest_posts_widget_offset,
								'cat' => $latest_posts_widget_category
							);
							$wp_query = new WP_Query( $args_latest_posts );

							if( $wp_query->have_posts() ) {

								echo '<div class="gt-columns gt-column-' . esc_attr( $latest_posts_widget_column ) . ' gt-column-space-' . esc_attr( $latest_posts_widget_column_space ) . '">';

									while ( $wp_query->have_posts() ) {

										$wp_query->the_post();

										echo '<div class="gt-col">';
											echo '<div class="gt-inner">';
												echo eventchamp_post_list_style_3( $post_id = get_the_ID(), $image = "true", $category = esc_attr( $latest_posts_widget_category_name ), $author = esc_attr( $latest_posts_widget_author ), $date = esc_attr( $latest_posts_widget_date ), $reading_time = esc_attr( $latest_posts_widget_reading_time ), $comments = esc_attr( $latest_posts_widget_comments ) );
											echo '</div>';
										echo '</div>';

									}
									wp_reset_postdata();

								echo '</div>';

							}

						echo '</div>';

					echo eventchamp_widget_after();

				echo $args['after_widget'];

			}

			function update( $new_instance, $old_instance ) {

				$instance = $old_instance;
				$instance['latest_posts_widget_title'] = esc_attr( $new_instance['latest_posts_widget_title'] );
				$instance['latest_posts_widget_category'] = esc_attr( $new_instance['latest_posts_widget_category'] );
				$instance['latest_posts_widget_exclude'] = esc_attr( $new_instance['latest_posts_widget_exclude'] );
				$instance['latest_posts_widget_offset'] = esc_attr( $new_instance['latest_posts_widget_offset'] );
				$instance['latest_posts_widget_post_count'] = esc_attr( $new_instance['latest_posts_widget_post_count'] );
				$instance['latest_posts_widget_category_name'] = esc_attr( $new_instance['latest_posts_widget_category_name'] );
				$instance['latest_posts_widget_author'] = esc_attr( $new_instance['latest_posts_widget_author'] );
				$instance['latest_posts_widget_date'] = esc_attr( $new_instance['latest_posts_widget_date'] );
				$instance['latest_posts_widget_reading_time'] = esc_attr( $new_instance['latest_posts_widget_reading_time'] );
				$instance['latest_posts_widget_comments'] = esc_attr( $new_instance['latest_posts_widget_comments'] );
				$instance['latest_posts_widget_column'] = esc_attr( $new_instance['latest_posts_widget_column'] );
				$instance['latest_posts_widget_column_space'] = esc_attr( $new_instance['latest_posts_widget_column_space'] );

				return $instance;

			}

			function form( $instance ) {

				$latest_posts_widget_title = '';
				$latest_posts_widget_category = '';
				$latest_posts_widget_exclude = '';
				$latest_posts_widget_offset = '';
				$latest_posts_widget_post_count = '';
				$latest_posts_widget_category_name = '';
				$latest_posts_widget_author = '';
				$latest_posts_widget_date = '';
				$latest_posts_widget_reading_time = '';
				$latest_posts_widget_comments = '';
				$latest_posts_widget_column = '';
				$latest_posts_widget_column_space = '';

				if( !empty( $instance ) ) {

					$latest_posts_widget_title = esc_attr( $instance['latest_posts_widget_title'] );
					$latest_posts_widget_category = esc_attr( $instance['latest_posts_widget_category'] );
					$latest_posts_widget_exclude = esc_attr( $instance['latest_posts_widget_exclude'] );
					$latest_posts_widget_offset = esc_attr( $instance['latest_posts_widget_offset'] );
					$latest_posts_widget_post_count = esc_attr( $instance['latest_posts_widget_post_count'] );
					$latest_posts_widget_category_name = esc_attr( $instance['latest_posts_widget_category_name'] );
					$latest_posts_widget_author = esc_attr( $instance['latest_posts_widget_author'] );
					$latest_posts_widget_date = esc_attr( $instance['latest_posts_widget_date'] );
					$latest_posts_widget_reading_time = esc_attr( $instance['latest_posts_widget_reading_time'] );
					$latest_posts_widget_comments = esc_attr( $instance['latest_posts_widget_comments'] );
					$latest_posts_widget_column = esc_attr( $instance['latest_posts_widget_column'] );
					$latest_posts_widget_column_space = esc_attr( $instance['latest_posts_widget_column_space'] );

				}

				echo '<p>';
					echo '<label for="' . esc_attr( $this->get_field_id( 'latest_posts_widget_title' ) ) . '">' . esc_html__( 'Widget Title', 'eventchamp-core' ) . '</label>';
					echo '<input class="widefat" id="' . esc_attr( $this->get_field_id( 'latest_posts_widget_title' ) ) . '" name="' . esc_attr( $this->get_field_name( 'latest_posts_widget_title' ) ) . '" type="text" value="' . esc_attr( $latest_posts_widget_title ) . '" />';
				echo '</p>';

				echo '<p>';
					echo '<label for="' . esc_attr( $this->get_field_id( 'latest_posts_widget_post_count' ) ) . '">' . esc_html__( 'Post Count', 'eventchamp-core' ) . '</label>';
					echo '<input class="widefat" id="' . esc_attr( $this->get_field_id( 'latest_posts_widget_post_count' ) ) . '" name="' . esc_attr( $this->get_field_name( 'latest_posts_widget_post_count' ) ) . '" type="text" value="' . esc_attr( $latest_posts_widget_post_count ) . '" />';
				echo '</p>';

				echo '<p>';
					echo '<label for="' . esc_attr( $this->get_field_id( 'latest_posts_widget_category' ) ) . '">' . esc_html__( 'Category', 'eventchamp-core' ) . '</label>';
					echo '<select name="' . esc_attr( $this->get_field_name( 'latest_posts_widget_category' ) ) . '" id="' . esc_attr( $this->get_field_id( 'latest_posts_widget_category' ) ) . '" class="widefat"> ';
						echo '<option value="">' . esc_html__( 'All Categories', 'eventchamp-core' ) . '</option>';

						 $categories = get_categories( 'child_of=0' );

						 if( !empty( $categories ) ) {

							 foreach ( $categories as $category ) {

								if( !empty( $categories ) ) {

									$selected = '';

									if ( $latest_posts_widget_category == $category->cat_ID ) {
										$selected = "selected";
									}

									echo '<option value="' . esc_attr( $category->cat_ID ) . '" ' . esc_attr( $selected ) . '>' . esc_attr( $category->cat_name ) . '</option>';
								}

							 }

						 }

					echo '</select>';
				echo '</p>';

				echo '<p>';
					echo '<label for="' . esc_attr( $this->get_field_id( 'latest_posts_widget_exclude' ) ) . '">' . esc_html__( 'Exclude Posts', 'eventchamp-core' ) . '</label>';
					echo '<input class="widefat" id="' . esc_attr( $this->get_field_id( 'latest_posts_widget_exclude' ) ) . '" name="' . esc_attr( $this->get_field_name( 'latest_posts_widget_exclude' ) ) . '" type="text" value="' . esc_attr( $latest_posts_widget_exclude ) . '" />';
				echo '</p>';

				echo '<p>';
					echo '<label for="' . esc_attr( $this->get_field_id( 'latest_posts_widget_offset' ) ) . '">' . esc_html__( 'Offset', 'eventchamp-core' ) . '</label>';
					echo '<input class="widefat" id="' . esc_attr( $this->get_field_id( 'latest_posts_widget_offset' ) ) . '" name="' . esc_attr( $this->get_field_name( 'latest_posts_widget_offset' ) ) . '" type="text" value="' . esc_attr( $latest_posts_widget_offset ) . '" />';
				echo '</p>';

				echo '<p>';
					echo '<label for="' . esc_attr( $this->get_field_id( 'latest_posts_widget_category_name' ) ) . '">' . esc_html__( 'Category', 'eventchamp-core' ) . '</label>';
					echo '<select name="' . esc_attr( $this->get_field_name( 'latest_posts_widget_category_name' ) ) . '" id="' . esc_attr( $this->get_field_id( 'latest_posts_widget_category_name' ) ) . '" class="widefat"> ';
						echo '<option value="false" ' . ( $latest_posts_widget_category_name == "false" ? 'selected' : '' ) . '>' . esc_html__( 'False', 'eventchamp-core' ) . '</option>';
						echo '<option value="true" ' . ( $latest_posts_widget_category_name == "true" ? 'selected' : '' ) . '>' . esc_html__( 'True', 'eventchamp-core' ) . '</option>';
					echo '</select>';
				echo '</p>';

				echo '<p>';
					echo '<label for="' . esc_attr( $this->get_field_id( 'latest_posts_widget_author' ) ) . '">' . esc_html__( 'Author', 'eventchamp-core' ) . '</label>';
					echo '<select name="' . esc_attr( $this->get_field_name( 'latest_posts_widget_author' ) ) . '" id="' . esc_attr( $this->get_field_id( 'latest_posts_widget_author' ) ) . '" class="widefat"> ';
						echo '<option value="false" ' . ( $latest_posts_widget_author == "false" ? 'selected' : '' ) . '>' . esc_html__( 'False', 'eventchamp-core' ) . '</option>';
						echo '<option value="true" ' . ( $latest_posts_widget_author == "true" ? 'selected' : '' ) . '>' . esc_html__( 'True', 'eventchamp-core' ) . '</option>';
					echo '</select>';
				echo '</p>';

				echo '<p>';
					echo '<label for="' . esc_attr( $this->get_field_id( 'latest_posts_widget_date' ) ) . '">' . esc_html__( 'Date', 'eventchamp-core' ) . '</label>';
					echo '<select name="' . esc_attr( $this->get_field_name( 'latest_posts_widget_date' ) ) . '" id="' . esc_attr( $this->get_field_id( 'latest_posts_widget_date' ) ) . '" class="widefat"> ';
						echo '<option value="false" ' . ( $latest_posts_widget_date == "false" ? 'selected' : '' ) . '>' . esc_html__( 'False', 'eventchamp-core' ) . '</option>';
						echo '<option value="true" ' . ( $latest_posts_widget_date == "true" ? 'selected' : '' ) . '>' . esc_html__( 'True', 'eventchamp-core' ) . '</option>';
					echo '</select>';
				echo '</p>';

				echo '<p>';
					echo '<label for="' . esc_attr( $this->get_field_id( 'latest_posts_widget_reading_time' ) ) . '">' . esc_html__( 'Reading Time', 'eventchamp-core' ) . '</label>';
					echo '<select name="' . esc_attr( $this->get_field_name( 'latest_posts_widget_reading_time' ) ) . '" id="' . esc_attr( $this->get_field_id( 'latest_posts_widget_reading_time' ) ) . '" class="widefat"> ';
						echo '<option value="false" ' . ( $latest_posts_widget_reading_time == "false" ? 'selected' : '' ) . '>' . esc_html__( 'False', 'eventchamp-core' ) . '</option>';
						echo '<option value="true" ' . ( $latest_posts_widget_reading_time == "true" ? 'selected' : '' ) . '>' . esc_html__( 'True', 'eventchamp-core' ) . '</option>';
					echo '</select>';
				echo '</p>';

				echo '<p>';
					echo '<label for="' . esc_attr( $this->get_field_id( 'latest_posts_widget_comments' ) ) . '">' . esc_html__( 'Comments', 'eventchamp-core' ) . '</label>';
					echo '<select name="' . esc_attr( $this->get_field_name( 'latest_posts_widget_comments' ) ) . '" id="' . esc_attr( $this->get_field_id( 'latest_posts_widget_comments' ) ) . '" class="widefat"> ';
						echo '<option value="false" ' . ( $latest_posts_widget_comments == "false" ? 'selected' : '' ) . '>' . esc_html__( 'False', 'eventchamp-core' ) . '</option>';
						echo '<option value="true" ' . ( $latest_posts_widget_comments == "true" ? 'selected' : '' ) . '>' . esc_html__( 'True', 'eventchamp-core' ) . '</option>';
					echo '</select>';
				echo '</p>';

				echo '<p>';
					echo '<label for="' . esc_attr( $this->get_field_id( 'latest_posts_widget_column' ) ) . '">' . esc_html__( 'Column', 'eventchamp-core' ) . '</label>';
					echo '<select name="' . esc_attr( $this->get_field_name( 'latest_posts_widget_column' ) ) . '" id="' . esc_attr( $this->get_field_id( 'latest_posts_widget_column' ) ) . '" class="widefat"> ';
						echo '<option value="1" ' . ( $latest_posts_widget_column == "1" ? 'selected' : '' ) . '>' . esc_html__( '1 Column', 'eventchamp-core' ) . '</option>';
						echo '<option value="2" ' . ( $latest_posts_widget_column == "2" ? 'selected' : '' ) . '>' . esc_html__( '2 Column', 'eventchamp-core' ) . '</option>';
						echo '<option value="3" ' . ( $latest_posts_widget_column == "3" ? 'selected' : '' ) . '>' . esc_html__( '3 Column', 'eventchamp-core' ) . '</option>';
						echo '<option value="4" ' . ( $latest_posts_widget_column == "4" ? 'selected' : '' ) . '>' . esc_html__( '4 Column', 'eventchamp-core' ) . '</option>';
					echo '</select>';
				echo '</p>';

				echo '<p>';
					echo '<label for="' . esc_attr( $this->get_field_id( 'latest_posts_widget_column_space' ) ) . '">' . esc_html__( 'Column Space', 'eventchamp-core' ) . '</label>';
					echo '<select name="' . esc_attr( $this->get_field_name( 'latest_posts_widget_column_space' ) ) . '" id="' . esc_attr( $this->get_field_id( 'latest_posts_widget_column_space' ) ) . '" class="widefat"> ';
						echo '<option value="0" ' . ( $latest_posts_widget_column_space == "0" ? 'selected' : '' ) . '>' . esc_html__( '0', 'eventchamp-core' ) . '</option>';
						echo '<option value="5" ' . ( $latest_posts_widget_column_space == "5" ? 'selected' : '' ) . '>' . esc_html__( '5', 'eventchamp-core' ) . '</option>';
						echo '<option value="10" ' . ( $latest_posts_widget_column_space == "10" ? 'selected' : '' ) . '>' . esc_html__( '10', 'eventchamp-core' ) . '</option>';
						echo '<option value="15" ' . ( $latest_posts_widget_column_space == "15" ? 'selected' : '' ) . '>' . esc_html__( '15', 'eventchamp-core' ) . '</option>';
						echo '<option value="20" ' . ( $latest_posts_widget_column_space == "20" ? 'selected' : '' ) . '>' . esc_html__( '20', 'eventchamp-core' ) . '</option>';
						echo '<option value="25" ' . ( $latest_posts_widget_column_space == "25" ? 'selected' : '' ) . '>' . esc_html__( '25', 'eventchamp-core' ) . '</option>';
						echo '<option value="30" ' . ( $latest_posts_widget_column_space == "30" ? 'selected' : '' ) . '>' . esc_html__( '30', 'eventchamp-core' ) . '</option>';
						echo '<option value="35" ' . ( $latest_posts_widget_column_space == "35" ? 'selected' : '' ) . '>' . esc_html__( '35', 'eventchamp-core' ) . '</option>';
						echo '<option value="40" ' . ( $latest_posts_widget_column_space == "40" ? 'selected' : '' ) . '>' . esc_html__( '40', 'eventchamp-core' ) . '</option>';
						echo '<option value="45" ' . ( $latest_posts_widget_column_space == "45" ? 'selected' : '' ) . '>' . esc_html__( '45', 'eventchamp-core' ) . '</option>';
						echo '<option value="50" ' . ( $latest_posts_widget_column_space == "50" ? 'selected' : '' ) . '>' . esc_html__( '50', 'eventchamp-core' ) . '</option>';
						echo '<option value="55" ' . ( $latest_posts_widget_column_space == "55" ? 'selected' : '' ) . '>' . esc_html__( '55', 'eventchamp-core' ) . '</option>';
						echo '<option value="60" ' . ( $latest_posts_widget_column_space == "60" ? 'selected' : '' ) . '>' . esc_html__( '60', 'eventchamp-core' ) . '</option>';
					echo '</select>';
				echo '</p>';

			}

		}

	}