<?php
/*======
*
* Theme Options
*
======*/
if( class_exists( 'OT_Loader' ) ) {

	if( !function_exists( 'eventchamp_theme_options' ) ) {

		function eventchamp_theme_options() {

			if ( ! function_exists( 'ot_settings_id' ) || ! is_admin() )
			return false;

			$saved_settings = get_option( ot_settings_id(), array() );
			
			$custom_settings = array(
				'contextual_help' => array(
					'content' => array(
						array(
							'id' => 'option_types_help',
							'title' => esc_html__( 'Header Settings', 'eventchamp-core' ),
							'content' => '<p>' . esc_html__( 'Help content goes here!', 'eventchamp-core' ) . '</p>',
						)
					),
					'sidebar' => '<p>' . esc_html__( 'Sidebar content goes here!', 'eventchamp-core' ) . '</p>',
				),
				
				'sections' => array(
					array(
						'title' => '<span class="dashicons dashicons-admin-site"></span>' . esc_html__( 'General', 'eventchamp-core' ),
						'id' => 'general',
					),
					array(
						'title' => '<span class="dashicons dashicons-editor-kitchensink"></span>' . esc_html__( 'Header', 'eventchamp-core' ),
						'id' => 'header',
					),
					array(
						'title' => '<span class="dashicons dashicons-image-rotate-left"></span>' . esc_html__( 'Footer', 'eventchamp-core' ),
						'id' => 'footer',
					),
					array(
						'title' => '<span class="dashicons dashicons-calendar-alt"></span>' . esc_html__( 'Events', 'eventchamp-core' ),
						'id' => 'events',
					),
					array(
						'title' => '<span class="dashicons dashicons-location"></span>' . esc_html__( 'Venues', 'eventchamp-core' ),
						'id' => 'venues',
					),
					array(
						'title' => '<span class="dashicons dashicons-businessperson"></span>' . esc_html__( 'Speakers', 'eventchamp-core' ),
						'id' => 'speakers',
					),
					array(
						'title' => '<span class="dashicons dashicons-admin-page"></span>' . esc_html__( 'Pages', 'eventchamp-core' ),
						'id' => 'pages',
					),
					array(
						'title' => '<span class="dashicons dashicons-archive"></span>' . esc_html__( 'Blog', 'eventchamp-core' ),
						'id' => 'blog',
					),
					array(
						'title' => '<span class="dashicons dashicons-admin-appearance"></span>' . esc_html__( 'Color', 'eventchamp-core' ),
						'id' => 'colors',
					),
					array(
						'title' => '<span class="dashicons dashicons-layout"></span>' . esc_html__( 'Layout', 'eventchamp-core' ),
						'id' => 'layout',
					),
					array(
						'title' => '<span class="dashicons dashicons-heading"></span>' . esc_html__( 'Page Title Bar', 'eventchamp-core' ),
						'id' => 'page-title-bar',
					),
					array(
						'title' => '<span class="dashicons dashicons-admin-users"></span>' . esc_html__( 'User Box', 'eventchamp-core' ),
						'id' => 'user-box',
					),
					array(
						'title' => '<span class="dashicons dashicons-shield"></span>' . esc_html__( 'Cookie Bar', 'eventchamp-core' ),
						'id' => 'cookie-bar',
					),
					array(
						'title' => '<span class="dashicons dashicons-list-view"></span>' . esc_html__( 'Extra', 'eventchamp-core' ),
						'id' => 'extra',
					),
					array(
						'title' => '<span class="dashicons dashicons-share"></span>' . esc_html__( 'Social Media', 'eventchamp-core' ),
						'id' => 'social-media',
					),
					array(
						'title' => '<span class="dashicons dashicons-hammer"></span>' . esc_html__( 'Custom Codes', 'eventchamp-core' ),
						'id' => 'customcodes',
					),
				),

				'settings' => array(
					/*====== General ======*/
					array(
						'type' => 'radio-image',
						'id' => 'event-system',
						'label' => esc_html__( 'Event System', 'eventchamp-core' ),
						'desc' => esc_html__( 'Evenchamp offers its own event system. Also Eventchamp theme can work with other event plugins. In this option you can choose which one to use. Evenchamp\'s own system is provided by default in the theme demo.', 'eventchamp-core' ),
						'section' => 'general',
						'std' => 'eventchamp',
					),

					/*====== Header ======*/
						array(
							'type' => 'tab',
							'id' => 'header-tab-general',
							'label' => esc_html__( 'General', 'eventchamp-core' ),
							'section' => 'header',
						),
							array(
								'type' => 'on-off',
								'id' => 'hide_header',
								'label' => esc_html__( 'Header Status', 'eventchamp-core' ),
								'section' => 'header',
								'std' => 'on',
							),
							array(
								'type' => 'select',
								'id' => 'header_layout_select',
								'label' => esc_html__( 'Header Style', 'eventchamp-core' ),
								'section' => 'header',
								'std' => 'header-style-3',
								'choices' => array(
									array(
										'label' => esc_html__( 'Style 1', 'eventchamp-core' ),
										'value' => 'header-style-1',
									),
									array(
										'label' => esc_html__( 'Style 2', 'eventchamp-core' ),
										'value' => 'header-style-2',
									),
									array(
										'label' => esc_html__( 'Style 3', 'eventchamp-core' ),
										'value' => 'header-style-3',
									),
									array(
										'label' => esc_html__( 'Style 4', 'eventchamp-core' ),
										'value' => 'header-style-4',
									),
									array(
										'label' => esc_html__( 'Style 5', 'eventchamp-core' ),
										'value' => 'header-style-5',
									),
									array(
										'label' => esc_html__( 'Style 6', 'eventchamp-core' ),
										'value' => 'header-style-6',
									),
								),
							),
							array(
								'type' => 'on-off',
								'id' => 'header_fixed',
								'label' => esc_html__( 'Sticky Header', 'eventchamp-core' ),
								'section' => 'header',
								'std' => 'off',
							),
						array(
							'type' => 'tab',
							'id' => 'header-tab-logo',
							'label' => esc_html__( 'Logo', 'eventchamp-core' ),
							'section' => 'header',
						),
							array(
								'type' => 'on-off',
								'id' => 'hide_header_logo',
								'label' => esc_html__( 'Header Logo Status', 'eventchamp-core' ),
								'section' => 'header',
								'std' => 'on',
							),
							array(
								'type' => 'upload',
								'id' => 'eventchamp_logo',
								'label' => esc_html__( 'Logo', 'eventchamp-core' ),
								'section' => 'header',
							),
							array(
								'type' => 'upload',
								'id' => 'eventchamp_logo_alternative',
								'label' => esc_html__( 'Alternative Logo', 'eventchamp-core' ),
								'section' => 'header',
							),
							array(
								'type' => 'measurement',
								'id' => 'logo_height',
								'label' => esc_html__( 'Logo Height', 'eventchamp-core' ),
								'desc' => esc_html__( 'Recommended type px.', 'eventchamp-core' ),
								'section' => 'header',
							),
							array(
								'type' => 'measurement',
								'id' => 'logo_width',
								'label' => esc_html__( 'Logo Width', 'eventchamp-core' ),
								'desc' => esc_html__( 'Recommended type px.', 'eventchamp-core' ),
								'section' => 'header',
							),
							array(
								'type' => 'upload',
								'id' => 'eventchamp_mobile_logo',
								'label' => esc_html__( 'Mobile Logo', 'eventchamp-core' ),
								'section' => 'header',
							),
							array(
								'type' => 'measurement',
								'id' => 'mobile_header_logo_height',
								'label' => esc_html__( 'Mobile Logo Height', 'eventchamp-core' ),
								'desc' => esc_html__( 'Recommended type px.', 'eventchamp-core' ),
								'section' => 'header',
							),
							array(
								'type' => 'measurement',
								'id' => 'mobile_header_logo_width',
								'label' => esc_html__( 'Mobile Logo Width', 'eventchamp-core' ),
								'desc' => esc_html__( 'Recommended type px.', 'eventchamp-core' ),
								'section' => 'header',
							),
							array(
								'type' => 'measurement',
								'id' => 'mobile_menu_logo_height',
								'label' => esc_html__( 'Mobile Menu Logo Height', 'eventchamp-core' ),
								'desc' => esc_html__( 'This is for canvas menu. Recommended type px.', 'eventchamp-core' ),
								'section' => 'header',
							),
							array(
								'type' => 'measurement',
								'id' => 'mobile_menu_logo_width',
								'label' => esc_html__( 'Mobile Menu Logo Width', 'eventchamp-core' ),
								'desc' => esc_html__( 'This is for canvas menu. Recommended type px.', 'eventchamp-core' ),
								'section' => 'header',
							),
						array(
							'type' => 'tab',
							'id' => 'header-tab-content',
							'label' => esc_html__( 'Content', 'eventchamp-core' ),
							'section' => 'header',
						),
							array(
								'type' => 'on-off',
								'id' => 'header_social_media',
								'label' => esc_html__( 'Social Media Links', 'eventchamp-core' ),
								'section' => 'header',
								'std' => 'off',
							),
							array(
								'type' => 'on-off',
								'id' => 'header_cart',
								'label' => esc_html__( 'Cart', 'eventchamp-core' ),
								'section' => 'header',
								'std' => 'off',
							),
							array(
								'type' => 'text',
								'id' => 'header_cart_custom_link',
								'label' => esc_html__( 'Cart Custom Link', 'eventchamp-core' ),
								'desc' => esc_html__( 'If you leave blank it, WooCommerce cart link will added.', 'eventchamp-core' ),
								'section' => 'header',
							),

					/*====== Footer ======*/
						array(
							'type' => 'tab',
							'id' => 'footer-tab-general',
							'label' => esc_html__( 'General', 'eventchamp-core' ),
							'section' => 'footer',
						),
							array(
								'type' => 'on-off',
								'id' => 'hide_footer',
								'label' => esc_html__( 'Footer Status', 'eventchamp-core' ),
								'section' => 'footer',
								'std' => 'on',
							),
							array(
								'type' => 'select',
								'id' => 'default_footer_style',
								'label' => esc_html__( 'Footer Style', 'eventchamp-core' ),
								'section' => 'footer',
								'std' => 'footer-style-1',
								'choices' => array(
									array(
										'label' => esc_html__( 'Style 1', 'eventchamp-core' ),
										'value' => 'footer-style-1',
									),
									array(
										'label' => esc_html__( 'Style 2', 'eventchamp-core' ),
										'value' => 'footer-style-2',
									),
								),
							),
							array(
								'type' => 'page-select',
								'id' => 'page_footer_style_1',
								'label' => esc_html__( 'Footer Page', 'eventchamp-core' ),
								'desc' => esc_html__( 'Footer content will be fetched from this page. You can edit the footer content from this page.', 'eventchamp-core' ),
								'section' => 'footer',
							),
							array(
								'type' => 'text',
								'id' => 'footer_copyright_text',
								'label' => esc_html__( 'Copyright Text', 'eventchamp-core' ),
								'section' => 'footer',
							),
							array(
								'type' => 'background',
								'id' => 'eventchamp_footer_bg_style_1',
								'label' => esc_html__( 'Background for Style 1', 'eventchamp-core' ),
								'section' => 'footer',
							),
							array(
								'type' => 'background',
								'id' => 'eventchamp_footer_bg_style_2',
								'label' => esc_html__( 'Background for Style 2', 'eventchamp-core' ),
								'section' => 'footer',
							),
						array(
							'type' => 'tab',
							'id' => 'footer-tab-logo',
							'label' => esc_html__( 'Logo', 'eventchamp-core' ),
							'section' => 'footer',
						),
							array(
								'type' => 'on-off',
								'id' => 'hide_footer_logo',
								'label' => esc_html__( 'Footer Logo Status', 'eventchamp-core' ),
								'section' => 'footer',
								'std' => 'on',
							),
							array(
								'type' => 'upload',
								'id' => 'eventchamp_footer_logo',
								'label' => esc_html__( 'Logo Upload', 'eventchamp-core' ),
								'section' => 'footer',
							),
							array(
								'type' => 'measurement',
								'id' => 'footer_logo_height',
								'label' => esc_html__( 'Logo Height', 'eventchamp-core' ),
								'desc' => esc_html__( 'Recommended type px.', 'eventchamp-core' ),
								'section' => 'footer',
							),
							array(
								'type' => 'measurement',
								'id' => 'footer_logo_width',
								'label' => esc_html__( 'Logo Width', 'eventchamp-core' ),
								'desc' => esc_html__( ' Recommended type px.', 'eventchamp-core' ),
								'section' => 'footer',
							),

					/*====== Events ======*/
						array(
							'type' => 'tab',
							'id' => 'event-tab-general',
							'label' => esc_html__( 'General', 'eventchamp-core' ),
							'section' => 'events',
						),
							array(
								'type' => 'page-select',
								'id' => 'event_search_result_page',
								'label' => esc_html__( 'Event Search Results Page', 'eventchamp-core' ),
								'desc' => esc_html__( 'You should choose a page for the event search results. An Event Search Results element should be in this page. Also a Search Results page comes with the demo content, you can choose it.', 'eventchamp-core' ),
								'section' => 'events',
							),
							array(
								'label' => esc_html__( 'Keep Search Options', 'eventchamp-core' ),
								'id' => 'event-keep-search-options',
								'type' => 'on-off',
								'desc' => esc_html__( 'If you want to keep event search options after search any events, choose on option.', 'eventchamp-core' ),
								'std' => 'on',
								'section' => 'events',
							),
							array(
								'label' => esc_html__( 'Event Status', 'eventchamp-core' ),
								'id' => 'event-status',
								'type' => 'on-off',
								'desc' => esc_html__( 'If you choose off option, the event status will remove from all elements.', 'eventchamp-core' ),
								'std' => 'on',
								'section' => 'events',
							),
							array(
								'label' => esc_html__( 'Multiple Categories', 'eventchamp-core' ),
								'desc' => esc_html__( 'If any event has more than one event category, the categories will be shown. Otherwise, only one will appear.', 'eventchamp-core' ),
								'id' => 'event_multiple_categories',
								'type' => 'on-off',
								'std' => 'off',
								'section' => 'events',
							),
							array(
								'label' => esc_html__( 'Hide Expired Events', 'eventchamp-core' ),
								'id' => 'event-expired-events-archives',
								'type' => 'on-off',
								'desc' => esc_html__( 'If you choose off, expired events will be hide in the event archives, related events, venue events, speaker events, and blog widget. Page builder items have their own settings. This does not affect them.', 'eventchamp-core' ),
								'std' => 'off',
								'section' => 'events',
							),
							array(
								'label' => esc_html__( 'Out of Stock Label', 'eventchamp-core' ),
								'id' => 'event-out-of-stock-alert',
								'type' => 'on-off',
								'desc' => esc_html__( 'If you choose on, when the defined stock amount of the product is over, the buy button will disappear and this label will appear. It only works on tickets selling with WooCommerce products.', 'eventchamp-core' ),
								'std' => 'on',
								'section' => 'events',
							),
							array(
								'type' => 'radio',
								'id' => 'event-free-events-price',
								'label' => esc_html__( 'Free Events Price', 'eventchamp-core' ),
								'desc' => esc_html__( 'How to do you want to show price of free events?', 'eventchamp-core' ),
								'section' => 'events',
								'std' => 'free',
								'choices' => array(
									array(
										'label' => esc_html__( 'Free', 'eventchamp-core' ),
										'value' => 'free',
									),
									array(
										'label' => esc_html__( '0', 'eventchamp-core' ),
										'value' => '0',
									),
									array(
										'label' => esc_html__( '0 With Currency', 'eventchamp-core' ),
										'value' => '0-currency',
									),
									array(
										'label' => esc_html__( 'Hide Price on the Free Events.', 'eventchamp-core' ),
										'value' => 'hide',
									),
								),
							),
							array(
								'type' => 'radio',
								'id' => 'event-price-currency-position',
								'label' => esc_html__( 'Price Currency Position', 'eventchamp-core' ),
								'desc' => esc_html__( 'If you are using WooCommerce product for the tickets, you can change this setting from WooCommerce settings page.', 'eventchamp-core' ),
								'section' => 'events',
								'std' => 'left',
								'choices' => array(
									array(
										'label' => esc_html__( 'Left', 'eventchamp-core' ),
										'value' => 'left',
									),
									array(
										'label' => esc_html__( 'Right', 'eventchamp-core' ),
										'value' => 'right',
									),
									array(
										'label' => esc_html__( 'Left with Space', 'eventchamp-core' ),
										'value' => 'left-space',
									),
									array(
										'label' => esc_html__( 'Right with Space', 'eventchamp-core' ),
										'value' => 'right-space',
									),
								),
							),
							array(
								'type' => 'text',
								'id' => 'event-price-currency',
								'label' => esc_html__( 'Price Currency', 'eventchamp-core' ),
								'desc' => esc_html__( 'You can enter a currency symbol. This price will show on event listing elements and it uses in the event search system. Example: $. If you are using WooCommerce product for the tickets, you can change this setting from WooCommerce settings page.', 'eventchamp-core' ),
								'section' => 'events',
							),
						array(
							'type' => 'tab',
							'id' => 'event-tab-single',
							'label' => esc_html__( 'Single', 'eventchamp-core' ),
							'section' => 'events',
						),
							array(
								'type' => 'on-off',
								'id' => 'event-like-system',
								'label' => esc_html__( 'Event Like System', 'eventchamp-core' ),
								'desc' => esc_html__( 'If you choose on, the like button will show on the single events.', 'eventchamp-core' ),
								'section' => 'events',
								'std' => 'on',
							),
							array(
								'type' => 'on-off',
								'id' => 'event-favorite-system',
								'label' => esc_html__( 'Event Favorite System', 'eventchamp-core' ),
								'desc' => esc_html__( 'If you choose on, the favorite button will show on the single events.', 'eventchamp-core' ),
								'section' => 'events',
								'std' => 'on',
							),
							array(
								'type' => 'select',
								'id' => 'event-content-listing-type',
								'label' => esc_html__( 'Content Listing Type', 'eventchamp-core' ),
								'section' => 'events',
								'std' => 'tab',
								'choices' => array(
									array(
										'label' => esc_html__( 'Section', 'eventchamp-core' ),
										'value' => 'section',
									),
									array(
										'label' => esc_html__( 'Tab', 'eventchamp-core' ),
										'value' => 'tab',
									),
								),
							),
							array(
								'type' => 'text',
								'id' => 'event_contact_form',
								'label' => esc_html__( 'Contact Form Shortcode', 'eventchamp-core' ),
								'desc' => esc_html__( 'This form will be displayed in the event detail. You can use any contact form plugin. We recommend Contact Form 7 plugin. An example shortcode: [contact-form-7 id="123"]', 'eventchamp-core' ),
								'section' => 'events',
							),
							array(
								'type' => 'on-off',
								'id' => 'event_related_events',
								'label' => esc_html__( 'Related Events', 'eventchamp-core' ),
								'section' => 'events',
								'std' => 'on',
							),
							array(
								'type' => 'numeric-slider',
								'id' => 'event_related_events_count',
								'label' => esc_html__( 'Related Events Count', 'eventchamp-core' ),
								'section' => 'events',
								'std' => '3',
								'min_max_step'=> '1,12,1',
							),
							array(
								'type' => 'select',
								'id' => 'related_events_style',
								'label' => esc_html__( 'Related Events Style', 'eventchamp-core' ),
								'section' => 'events',
								'std' => 'style-3',
								'choices' => array(
									array(
										'label' => esc_html__( 'Style 1', 'eventchamp-core' ),
										'value' => 'style-1',
									),
									array(
										'label' => esc_html__( 'Style 2', 'eventchamp-core' ),
										'value' => 'style-2',
									),
									array(
										'label' => esc_html__( 'Style 3', 'eventchamp-core' ),
										'value' => 'style-3',
									),
								),
							),
							array(
								'type' => 'numeric-slider',
								'id' => 'related-events-column',
								'label' => esc_html__( 'Related Events Column', 'eventchamp-core' ),
								'section' => 'events',
								'std' => '3',
								'min_max_step'=> '1,5,1',
							),
							array(
								'type' => 'select',
								'id' => 'related-events-column-space',
								'label' => esc_html__( 'Related Events Column Space', 'eventchamp-core' ),
								'section' => 'events',
								'std' => '30',
								'choices' => array(
									array(
										'label' => esc_html__( '0', 'eventchamp-core' ),
										'value' => '0',
									),
									array(
										'label' => esc_html__( '5', 'eventchamp-core' ),
										'value' => '5',
									),
									array(
										'label' => esc_html__( '10', 'eventchamp-core' ),
										'value' => '10',
									),
									array(
										'label' => esc_html__( '15', 'eventchamp-core' ),
										'value' => '15',
									),
									array(
										'label' => esc_html__( '20', 'eventchamp-core' ),
										'value' => '20',
									),
									array(
										'label' => esc_html__( '25', 'eventchamp-core' ),
										'value' => '25',
									),
									array(
										'label' => esc_html__( '30', 'eventchamp-core' ),
										'value' => '30',
									),
									array(
										'label' => esc_html__( '35', 'eventchamp-core' ),
										'value' => '35',
									),
									array(
										'label' => esc_html__( '40', 'eventchamp-core' ),
										'value' => '40',
									),
									array(
										'label' => esc_html__( '45', 'eventchamp-core' ),
										'value' => '45',
									),
									array(
										'label' => esc_html__( '50', 'eventchamp-core' ),
										'value' => '50',
									),
									array(
										'label' => esc_html__( '55', 'eventchamp-core' ),
										'value' => '55',
									),
									array(
										'label' => esc_html__( '60', 'eventchamp-core' ),
										'value' => '60',
									),
								),
							),
							array(
								'type' => 'on-off',
								'id' => 'event_comments',
								'label' => esc_html__( 'Comments', 'eventchamp-core' ),
								'section' => 'events',
								'std' => 'on',
							),
							array(
								'type' => 'list-item',
								'id' => 'event-sidebar-buttons',
								'label' => esc_html__( 'Sidebar Buttons', 'eventchamp-core' ),
								'section' => 'events',
								'settings' => array(
									array(
										'type' => 'text',
										'id' => 'event_extra_buttons_link',
										'label' => esc_html__( 'Link URL', 'eventchamp-core' ),
									),
									array(
										'type' => 'radio',
										'id' => 'event_extra_buttons_target',
										'label' => esc_html__( 'Target', 'eventchamp-core' ),
										'std' => '_self',
										'choices' => array(
											array(
												'label' => esc_html__( 'Self', 'eventchamp-core' ),
												'value' => '_self',
											),
											array(
												'label' => esc_html__( 'Blank', 'eventchamp-core' ),
												'value' => '_blank',
											),
										),
									),
								),
							),
							array(
								'type' => 'on-off',
								'id' => 'event-tags',
								'label' => esc_html__( 'Tags', 'eventchamp-core' ),
								'section' => 'events',
								'std' => 'on',
							),
							array(
								'type' => 'radio',
								'id' => 'event-tags-position',
								'label' => esc_html__( 'Tags Position', 'eventchamp-core' ),
								'section' => 'events',
								'std' => 'position-1',
								'choices' => array(
									array(
										'label' => esc_html__( 'Under Content', 'eventchamp-core' ),
										'value' => 'position-1',
									),
									array(
										'label' => esc_html__( 'On Sidebar', 'eventchamp-core' ),
										'value' => 'position-2',
									),
								),
							),
							array(
								'type' => 'select',
								'id' => 'event-tags-style',
								'label' => esc_html__( 'Tags Style', 'eventchamp-core' ),
								'section' => 'events',
								'std' => 'style-1',
								'choices' => array(
									array(
										'label' => esc_html__( 'Style 1', 'eventchamp-core' ),
										'value' => 'style-1',
									),
									array(
										'label' => esc_html__( 'Style 2', 'eventchamp-core' ),
										'value' => 'style-2',
									),
									array(
										'label' => esc_html__( 'Style 3', 'eventchamp-core' ),
										'value' => 'style-3',
									),
									array(
										'label' => esc_html__( 'Style 4', 'eventchamp-core' ),
										'value' => 'style-4',
									),
								),
							),
							array(
								'type' => 'on-off',
								'id' => 'event_social_share',
								'label' => esc_html__( 'Social Sharing', 'eventchamp-core' ),
								'section' => 'events',
								'std' => 'on',
							),
							array(
								'type' => 'text',
								'id' => 'event-social-share-text',
								'label' => esc_html__( 'Social Sharing Title', 'eventchamp-core' ),
								'desc' => esc_html__( 'Default: Share This Event.', 'eventchamp-core' ),
								'section' => 'events',
							),
							array(
								'type' => 'radio',
								'id' => 'event-social-share-position',
								'label' => esc_html__( 'Social Sharing Position', 'eventchamp-core' ),
								'section' => 'events',
								'std' => 'position-1',
								'choices' => array(
									array(
										'label' => esc_html__( 'Under Content', 'eventchamp-core' ),
										'value' => 'position-1',
									),
									array(
										'label' => esc_html__( 'On Sidebar', 'eventchamp-core' ),
										'value' => 'position-2',
									),
								),
							),
							array(
								'type' => 'select',
								'id' => 'event-social-sharing-style',
								'label' => esc_html__( 'Social Sharing Style', 'eventchamp-core' ),
								'section' => 'events',
								'std' => 'style-1',
								'choices' => array(
									array(
										'label' => esc_html__( 'Style 1', 'eventchamp-core' ),
										'value' => 'style-1',
									),
									array(
										'label' => esc_html__( 'Style 2', 'eventchamp-core' ),
										'value' => 'style-2',
									),
									array(
										'label' => esc_html__( 'Style 3', 'eventchamp-core' ),
										'value' => 'style-3',
									),
									array(
										'label' => esc_html__( 'Style 4', 'eventchamp-core' ),
										'value' => 'style-4',
									),
									array(
										'label' => esc_html__( 'Style 5', 'eventchamp-core' ),
										'value' => 'style-5',
									),
									array(
										'label' => esc_html__( 'Style 6', 'eventchamp-core' ),
										'value' => 'style-6',
									),
									array(
										'label' => esc_html__( 'Style 7', 'eventchamp-core' ),
										'value' => 'style-7',
									),
								),
							),
						array(
							'type' => 'tab',
							'id' => 'event-tab-archives',
							'label' => esc_html__( 'Archives', 'eventchamp-core' ),
							'section' => 'events',
						),
							array(
								'type' => 'select',
								'id' => 'event-listing-style',
								'label' => esc_html__( 'Event Listing Style', 'eventchamp-core' ),
								'section' => 'events',
								'std' => 'style-1',
								'choices' => array(
									array(
										'label' => esc_html__( 'Style 1', 'eventchamp-core' ),
										'value' => 'style-1',
									),
									array(
										'label' => esc_html__( 'Style 2', 'eventchamp-core' ),
										'value' => 'style-2',
									),
									array(
										'label' => esc_html__( 'Style 3', 'eventchamp-core' ),
										'value' => 'style-3',
									),
								),
							),
							array(
								'type' => 'numeric-slider',
								'id' => 'event-listing-column',
								'label' => esc_html__( 'Event Listing Column', 'eventchamp-core' ),
								'section' => 'events',
								'std' => '2',
								'min_max_step'=> '1,5,1',
							),
							array(
								'type' => 'select',
								'id' => 'event-listing-column-space',
								'label' => esc_html__( 'Event Listing Column Space', 'eventchamp-core' ),
								'section' => 'events',
								'std' => '30',
								'choices' => array(
									array(
										'label' => esc_html__( '0', 'eventchamp-core' ),
										'value' => '0',
									),
									array(
										'label' => esc_html__( '5', 'eventchamp-core' ),
										'value' => '5',
									),
									array(
										'label' => esc_html__( '10', 'eventchamp-core' ),
										'value' => '10',
									),
									array(
										'label' => esc_html__( '15', 'eventchamp-core' ),
										'value' => '15',
									),
									array(
										'label' => esc_html__( '20', 'eventchamp-core' ),
										'value' => '20',
									),
									array(
										'label' => esc_html__( '25', 'eventchamp-core' ),
										'value' => '25',
									),
									array(
										'label' => esc_html__( '30', 'eventchamp-core' ),
										'value' => '30',
									),
									array(
										'label' => esc_html__( '35', 'eventchamp-core' ),
										'value' => '35',
									),
									array(
										'label' => esc_html__( '40', 'eventchamp-core' ),
										'value' => '40',
									),
									array(
										'label' => esc_html__( '45', 'eventchamp-core' ),
										'value' => '45',
									),
									array(
										'label' => esc_html__( '50', 'eventchamp-core' ),
										'value' => '50',
									),
									array(
										'label' => esc_html__( '55', 'eventchamp-core' ),
										'value' => '55',
									),
									array(
										'label' => esc_html__( '60', 'eventchamp-core' ),
										'value' => '60',
									),
								),
							),
							array(
								'type' => 'radio',
								'id' => 'event-archive-order-type',
								'label' => esc_html__( 'Order Type', 'eventchamp-core' ),
								'section' => 'events',
								'std' => 'start-date',
								'choices' => array(
									array(
										'label' => esc_html__( 'Data inicial', 'eventchamp-core' ),
										'value' => 'start-date',
									),
									array(
										'label' => esc_html__( 'End Date', 'eventchamp-core' ),
										'value' => 'end-date',
									),
									array(
										'label' => esc_html__( 'Added Date', 'eventchamp-core' ),
										'value' => 'added-date',
									),
									array(
										'label' => esc_html__( 'Price: Low to High', 'eventchamp-core' ),
										'value' => 'price-l-h',
									),
									array(
										'label' => esc_html__( 'Price: High to Low', 'eventchamp-core' ),
										'value' => 'price-h-l',
									),
								),
							),
							array(
								'label' => esc_html__( 'Price', 'eventchamp-core' ),
								'id' => 'event-archives-price',
								'description' => esc_html__( 'This setting is for the event archives, related events, venue events, speaker events, and blog widget. Page builder items have their own settings. This does not affect them.', 'eventchamp-core' ),
								'type' => 'on-off',
								'std' => 'on',
								'section' => 'events',
							),
							array(
								'label' => esc_html__( 'Status', 'eventchamp-core' ),
								'id' => 'event-archives-status',
								'description' => esc_html__( 'This setting is for the event archives, related events, venue events, speaker events, and blog widget. Page builder items have their own settings. This does not affect them.', 'eventchamp-core' ),
								'type' => 'on-off',
								'std' => 'on',
								'section' => 'events',
							),
							array(
								'label' => esc_html__( 'Category', 'eventchamp-core' ),
								'id' => 'event-archives-category',
								'description' => esc_html__( 'This setting is for the event archives, related events, venue events, speaker events, and blog widget. Page builder items have their own settings. This does not affect them.', 'eventchamp-core' ),
								'type' => 'on-off',
								'std' => 'on',
								'section' => 'events',
							),
							array(
								'label' => esc_html__( 'Location', 'eventchamp-core' ),
								'description' => esc_html__( 'This setting is for the event archives, related events, venue events, speaker events, and blog widget. Page builder items have their own settings. This does not affect them.', 'eventchamp-core' ),
								'id' => 'event-archives-location',
								'type' => 'on-off',
								'std' => 'on',
								'section' => 'events',
							),
							array(
								'label' => esc_html__( 'Venue', 'eventchamp-core' ),
								'description' => esc_html__( 'This setting is for the event archives, related events, venue events, speaker events, and blog widget. Page builder items have their own settings. This does not affect them.', 'eventchamp-core' ),
								'id' => 'event-archives-venue',
								'type' => 'on-off',
								'std' => 'off',
								'section' => 'events',
							),
							array(
								'label' => esc_html__( 'Organizer', 'eventchamp-core' ),
								'description' => esc_html__( 'This setting is for the event archives, related events, venue events, speaker events, and blog widget. Page builder items have their own settings. This does not affect them.', 'eventchamp-core' ),
								'id' => 'event-archives-organizer',
								'type' => 'on-off',
								'std' => 'off',
								'section' => 'events',
							),
							array(
								'label' => esc_html__( 'Data incial', 'eventchamp-core' ),
								'description' => esc_html__( 'This setting is for the event archives, related events, venue events, speaker events, and blog widget. Page builder items have their own settings. This does not affect them.', 'eventchamp-core' ),
								'id' => 'event-archives-start-date',
								'type' => 'on-off',
								'std' => 'on',
								'section' => 'events',
							),
							array(
								'label' => esc_html__( 'Start Time', 'eventchamp-core' ),
								'description' => esc_html__( 'This setting is for the event archives, related events, venue events, speaker events, and blog widget. Page builder items have their own settings. This does not affect them.', 'eventchamp-core' ),
								'id' => 'event-archives-start-time',
								'type' => 'on-off',
								'std' => 'on',
								'section' => 'events',
							),
							array(
								'label' => esc_html__( 'End Date', 'eventchamp-core' ),
								'description' => esc_html__( 'This setting is for the event archives, related events, venue events, speaker events, and blog widget. Page builder items have their own settings. This does not affect them.', 'eventchamp-core' ),
								'id' => 'event-archives-end-date',
								'type' => 'on-off',
								'std' => 'off',
								'section' => 'events',
							),
							array(
								'label' => esc_html__( 'End Time', 'eventchamp-core' ),
								'description' => esc_html__( 'This setting is for the event archives, related events, venue events, speaker events, and blog widget. Page builder items have their own settings. This does not affect them.', 'eventchamp-core' ),
								'id' => 'event-archives-end-time',
								'type' => 'on-off',
								'std' => 'off',
								'section' => 'events',
							),
							array(
								'label' => esc_html__( 'Ticket Amount', 'eventchamp-core' ),
								'description' => esc_html__( 'This setting is for the event archives, related events, venue events, speaker events, and blog widget. Page builder items have their own settings. This does not affect them.', 'eventchamp-core' ),
								'id' => 'event-archives-ticket-amount',
								'type' => 'on-off',
								'std' => 'off',
								'section' => 'events',
							),
							array(
								'label' => esc_html__( 'Excerpt', 'eventchamp-core' ),
								'description' => esc_html__( 'This setting is for the event archives, related events, venue events, speaker events, and blog widget. Page builder items have their own settings. This does not affect them.', 'eventchamp-core' ),
								'id' => 'event-archives-excerpt',
								'type' => 'on-off',
								'std' => 'on',
								'section' => 'events',
							),
						array(
							'type' => 'tab',
							'id' => 'event-tab-detail-box',
							'label' => esc_html__( 'Detail Box', 'eventchamp-core' ),
							'section' => 'events',
						),
							array(
								'type' => 'on-off',
								'id' => 'event-detail-box-status',
								'label' => esc_html__( 'Detail Box', 'eventchamp-core' ),
								'section' => 'events',
								'std' => 'on',
							),
							array(
								'type' => 'radio',
								'id' => 'event-detail-box-position',
								'label' => esc_html__( 'Detail Box Position', 'eventchamp-core' ),
								'section' => 'events',
								'std' => 'position-2',
								'choices' => array(
									array(
										'label' => esc_html__( 'Under Content', 'eventchamp-core' ),
										'value' => 'position-1',
									),
									array(
										'label' => esc_html__( 'On Sidebar', 'eventchamp-core' ),
										'value' => 'position-2',
									),
								),
							),
							array(
								'type' => 'on-off',
								'id' => 'event-detail-box-countdown',
								'label' => esc_html__( 'Countdown', 'eventchamp-core' ),
								'section' => 'events',
								'std' => 'on',
							),
							array(
								'type' => 'on-off',
								'id' => 'event-detail-box-start',
								'label' => esc_html__( 'Data inicial', 'eventchamp-core' ),
								'section' => 'events',
								'std' => 'on',
							),
							array(
								'type' => 'on-off',
								'id' => 'event-detail-box-start-time',
								'label' => esc_html__( 'Start Time', 'eventchamp-core' ),
								'section' => 'events',
								'std' => 'on',
							),
							array(
								'type' => 'on-off',
								'id' => 'event-detail-box-end',
								'label' => esc_html__( 'End Date', 'eventchamp-core' ),
								'section' => 'events',
								'std' => 'on',
							),
							array(
								'type' => 'on-off',
								'id' => 'event-detail-box-end-time',
								'label' => esc_html__( 'End Time', 'eventchamp-core' ),
								'section' => 'events',
								'std' => 'on',
							),
							array(
								'type' => 'on-off',
								'id' => 'event-detail-repeat-dates',
								'label' => esc_html__( 'Repeat Dates', 'eventchamp-core' ),
								'section' => 'events',
								'std' => 'on',
							),
							array(
								'type' => 'on-off',
								'id' => 'event-detail-box-event-status',
								'label' => esc_html__( 'Event Status', 'eventchamp-core' ),
								'section' => 'events',
								'std' => 'on',
							),
							array(
								'type' => 'on-off',
								'id' => 'event-detail-box-ticket-price-status',
								'label' => esc_html__( 'Ticket Price', 'eventchamp-core' ),
								'section' => 'events',
								'std' => 'off',
							),
							array(
								'type' => 'on-off',
								'id' => 'event-detail-box-location',
								'label' => esc_html__( 'Location', 'eventchamp-core' ),
								'section' => 'events',
								'std' => 'on',
							),
							array(
								'type' => 'on-off',
								'id' => 'event-detail-box-venue',
								'label' => esc_html__( 'Venue', 'eventchamp-core' ),
								'section' => 'events',
								'std' => 'on',
							),
							array(
								'type' => 'on-off',
								'id' => 'event-detail-box-organizer',
								'label' => esc_html__( 'Organizer', 'eventchamp-core' ),
								'section' => 'events',
								'std' => 'on',
							),
							array(
								'type' => 'on-off',
								'id' => 'event-detail-box-category',
								'label' => esc_html__( 'Category', 'eventchamp-core' ),
								'section' => 'events',
								'std' => 'on',
							),
							array(
								'type' => 'on-off',
								'id' => 'event-detail-box-address',
								'label' => esc_html__( 'Address', 'eventchamp-core' ),
								'section' => 'events',
								'std' => 'on',
							),
							array(
								'type' => 'on-off',
								'id' => 'event-detail-box-phone',
								'label' => esc_html__( 'Phone Number', 'eventchamp-core' ),
								'section' => 'events',
								'std' => 'on',
							),
							array(
								'type' => 'on-off',
								'id' => 'event-detail-box-email',
								'label' => esc_html__( 'Email Address', 'eventchamp-core' ),
								'section' => 'events',
								'std' => 'on',
							),
							array(
								'type' => 'on-off',
								'id' => 'event-detail-box-fax',
								'label' => esc_html__( 'Fax Number', 'eventchamp-core' ),
								'section' => 'events',
								'std' => 'on',
							),
							array(
								'type' => 'on-off',
								'id' => 'event-detail-remaining-tickets',
								'label' => esc_html__( 'Remaining Tickets', 'eventchamp-core' ),
								'section' => 'events',
								'std' => 'on',
							),
							array(
								'type' => 'on-off',
								'id' => 'event-detail-box-social',
								'label' => esc_html__( 'Social Links', 'eventchamp-core' ),
								'section' => 'events',
								'std' => 'on',
							),
							array(
								'type' => 'on-off',
								'id' => 'event-detail-box-extra',
								'label' => esc_html__( 'Extra Details', 'eventchamp-core' ),
								'section' => 'events',
								'std' => 'on',
							),
						array(
							'type' => 'tab',
							'id' => 'event-tab-speakers',
							'label' => esc_html__( 'Speakers', 'eventchamp-core' ),
							'section' => 'events',
						),
							array(
								'type' => 'select',
								'id' => 'event-speaker-style',
								'label' => esc_html__( 'Speaker Listing Style', 'eventchamp-core' ),
								'section' => 'events',
								'std' => 'style-3',
								'choices' => array(
									array(
										'label' => esc_html__( 'Style 1', 'eventchamp-core' ),
										'value' => 'style-1',
									),
									array(
										'label' => esc_html__( 'Style 2', 'eventchamp-core' ),
										'value' => 'style-2',
									),
									array(
										'label' => esc_html__( 'Style 3', 'eventchamp-core' ),
										'value' => 'style-3',
									),
									array(
										'label' => esc_html__( 'Style 4', 'eventchamp-core' ),
										'value' => 'style-4',
									),
									array(
										'label' => esc_html__( 'Style 5', 'eventchamp-core' ),
										'value' => 'style-5',
									),
									array(
										'label' => esc_html__( 'Style 6', 'eventchamp-core' ),
										'value' => 'style-6',
									),
									array(
										'label' => esc_html__( 'Style 7', 'eventchamp-core' ),
										'value' => 'style-7',
									),
									array(
										'label' => esc_html__( 'Style 8', 'eventchamp-core' ),
										'value' => 'style-8',
									),
								),
							),
							array(
								'type' => 'select',
								'id' => 'event-speaker-column',
								'label' => esc_html__( 'Speaker Listing Column', 'eventchamp-core' ),
								'section' => 'events',
								'std' => '2',
								'choices' => array(
									array(
										'label' => esc_html__( '1', 'eventchamp-core' ),
										'value' => '1',
									),
									array(
										'label' => esc_html__( '2', 'eventchamp-core' ),
										'value' => '2',
									),
									array(
										'label' => esc_html__( '3', 'eventchamp-core' ),
										'value' => '3',
									),
								),
							),
							array(
								'type' => 'select',
								'id' => 'event-speaker-column-space',
								'label' => esc_html__( 'Speaker Listing Column Space', 'eventchamp-core' ),
								'section' => 'events',
								'std' => '25',
								'choices' => array(
									array(
										'label' => esc_html__( '0', 'eventchamp-core' ),
										'value' => '0',
									),
									array(
										'label' => esc_html__( '5', 'eventchamp-core' ),
										'value' => '5',
									),
									array(
										'label' => esc_html__( '10', 'eventchamp-core' ),
										'value' => '10',
									),
									array(
										'label' => esc_html__( '15', 'eventchamp-core' ),
										'value' => '15',
									),
									array(
										'label' => esc_html__( '20', 'eventchamp-core' ),
										'value' => '20',
									),
									array(
										'label' => esc_html__( '25', 'eventchamp-core' ),
										'value' => '25',
									),
									array(
										'label' => esc_html__( '30', 'eventchamp-core' ),
										'value' => '30',
									),
									array(
										'label' => esc_html__( '35', 'eventchamp-core' ),
										'value' => '35',
									),
									array(
										'label' => esc_html__( '40', 'eventchamp-core' ),
										'value' => '40',
									),
									array(
										'label' => esc_html__( '45', 'eventchamp-core' ),
										'value' => '45',
									),
									array(
										'label' => esc_html__( '50', 'eventchamp-core' ),
										'value' => '50',
									),
									array(
										'label' => esc_html__( '55', 'eventchamp-core' ),
										'value' => '55',
									),
									array(
										'label' => esc_html__( '60', 'eventchamp-core' ),
										'value' => '60',
									),
								),
							),
							array(
								'type' => 'radio',
								'id' => 'event-speaker-photo',
								'label' => esc_html__( 'Speaker Photo', 'eventchamp-core' ),
								'section' => 'events',
								'std' => 'true',
								'choices' => array(
									array(
										'label' => esc_html__( 'True', 'eventchamp-core' ),
										'value' => 'true',
									),
									array(
										'label' => esc_html__( 'False', 'eventchamp-core' ),
										'value' => 'false',
									),
								),
							),
							array(
								'type' => 'radio',
								'id' => 'event-speaker-profession',
								'label' => esc_html__( 'Speaker Profession', 'eventchamp-core' ),
								'section' => 'events',
								'std' => 'true',
								'choices' => array(
									array(
										'label' => esc_html__( 'True', 'eventchamp-core' ),
										'value' => 'true',
									),
									array(
										'label' => esc_html__( 'False', 'eventchamp-core' ),
										'value' => 'false',
									),
								),
							),
							array(
								'type' => 'radio',
								'id' => 'event-speaker-company',
								'label' => esc_html__( 'Speaker Company', 'eventchamp-core' ),
								'section' => 'events',
								'std' => 'true',
								'choices' => array(
									array(
										'label' => esc_html__( 'True', 'eventchamp-core' ),
										'value' => 'true',
									),
									array(
										'label' => esc_html__( 'False', 'eventchamp-core' ),
										'value' => 'false',
									),
								),
							),
							array(
								'type' => 'radio',
								'id' => 'event-speaker-summary',
								'label' => esc_html__( 'Speaker Summary', 'eventchamp-core' ),
								'section' => 'events',
								'std' => 'true',
								'choices' => array(
									array(
										'label' => esc_html__( 'True', 'eventchamp-core' ),
										'value' => 'true',
									),
									array(
										'label' => esc_html__( 'False', 'eventchamp-core' ),
										'value' => 'false',
									),
								),
							),
							array(
								'type' => 'radio',
								'id' => 'event-speaker-social',
								'label' => esc_html__( 'Speaker Social Links', 'eventchamp-core' ),
								'section' => 'events',
								'std' => 'true',
								'choices' => array(
									array(
										'label' => esc_html__( 'True', 'eventchamp-core' ),
										'value' => 'true',
									),
									array(
										'label' => esc_html__( 'False', 'eventchamp-core' ),
										'value' => 'false',
									),
								),
							),
						array(
							'type' => 'tab',
							'id' => 'event-tab-schedule',
							'label' => esc_html__( 'Schedule', 'eventchamp-core' ),
							'section' => 'events',
						),
							array(
								'type' => 'select',
								'id' => 'event-schedule-style',
								'label' => esc_html__( 'Schedule Style', 'eventchamp-core' ),
								'section' => 'events',
								'std' => 'style-1',
								'choices' => array(
									array(
										'label' => esc_html__( 'Style 1', 'eventchamp-core' ),
										'value' => 'style-1',
									),
									array(
										'label' => esc_html__( 'Style 2', 'eventchamp-core' ),
										'value' => 'style-2',
									),
									array(
										'label' => esc_html__( 'Style 3', 'eventchamp-core' ),
										'value' => 'style-3',
									),
									array(
										'label' => esc_html__( 'Style 4', 'eventchamp-core' ),
										'value' => 'style-4',
									),
									array(
										'label' => esc_html__( 'Style 5', 'eventchamp-core' ),
										'value' => 'style-5',
									),
									array(
										'label' => esc_html__( 'Style 6', 'eventchamp-core' ),
										'value' => 'style-6',
									),
									array(
										'label' => esc_html__( 'Style 7', 'eventchamp-core' ),
										'value' => 'style-7',
									),
								),
							),
							array(
								'type' => 'radio',
								'id' => 'event-grouped-schedule',
								'label' => esc_html__( 'Grouped Event Schedule', 'eventchamp-core' ),
								'desc' => esc_html__( 'If you choose true, same dates will grouped by schedule order.', 'eventchamp-core' ),
								'section' => 'events',
								'std' => 'true',
								'choices' => array(
									array(
										'label' => esc_html__( 'True', 'eventchamp-core' ),
										'value' => 'true',
									),
									array(
										'label' => esc_html__( 'False', 'eventchamp-core' ),
										'value' => 'false',
									),
								),
							),
							array(
								'type' => 'on-off',
								'id' => 'event-schedule-collapsed',
								'label' => esc_html__( 'Schedule Items Collapsed for Dropdown', 'eventchamp-core' ),
								'desc' => esc_html__( 'You can choose opening status of the schedule items for the dropdown version. Only for style 1, style 2 and style 3.', 'eventchamp-core' ),
								'section' => 'events',
								'std' => 'off',
							),
							array(
								'type' => 'select',
								'id' => 'schedule_speaker_detail',
								'label' => esc_html__( 'Speaker Info', 'eventchamp-core' ),
								'section' => 'events',
								'std' => 'profession',
								'choices' => array(
									array(
										'label' => esc_html__( 'Profession', 'eventchamp-core' ),
										'value' => 'profession'
									),
									array(
										'label' => esc_html__( 'Company', 'eventchamp-core' ),
										'value' => 'company'
									),
									array(
										'label' => esc_html__( 'Both', 'eventchamp-core' ),
										'value' => 'both'
									),
									array(
										'label' => esc_html__( 'None', 'eventchamp-core' ),
										'value' => 'none'
									),
								),
							),
						array(
							'type' => 'tab',
							'id' => 'event-tab-header',
							'label' => esc_html__( 'Event Header', 'eventchamp-core' ),
							'section' => 'events',
						),
							array(
								'type' => 'select',
								'id' => 'event-header-status',
								'label' => esc_html__( 'Event Header Status', 'eventchamp-core' ),
								'section' => 'events',
								'std' => 'true',
								'choices' => array(
									array(
										'label' => esc_html__( 'Show', 'eventchamp-core' ),
										'value' => 'true',
									),
									array(
										'label' => esc_html__( 'Hide', 'eventchamp-core' ),
										'value' => 'false',
									),
								),
							),
							array(
								'type' => 'select',
								'id' => 'event_header_style',
								'label' => esc_html__( 'Event Header Style', 'eventchamp-core' ),
								'desc' => esc_html__( 'It will be default event header style.', 'eventchamp-core' ),
								'section' => 'events',
								'std' => 'image',
								'choices' => array(
									array(
										'label' => esc_html__( 'Image', 'eventchamp-core' ),
										'value' => 'image',
									),
									array(
										'label' => esc_html__( 'Image Slider', 'eventchamp-core' ),
										'value' => 'image-slider',
									),
									array(
										'label' => esc_html__( 'Image Gallery', 'eventchamp-core' ),
										'value' => 'image-gallery',
									),
									array(
										'label' => esc_html__( 'Video', 'eventchamp-core' ),
										'value' => 'video',
									),
									array(
										'label' => esc_html__( 'Audio', 'eventchamp-core' ),
										'value' => 'audio',
									),
									array(
										'label' => esc_html__( 'Code', 'eventchamp-core' ),
										'value' => 'code',
									),
								),
							),
							array(
								'type' => 'numeric-slider',
								'id' => 'event-header-image-slider-column',
								'label' => esc_html__( 'Image Slider Column for Event Header', 'eventchamp-core' ),
								'desc' => esc_html__( 'Default: 1', 'eventchamp-core' ),
								'section' => 'events',
								'std' => '1',
								'min_max_step'=> '1,5,1',
							),
							array(
								'type' => 'numeric-slider',
								'id' => 'event-header-image-slider-space',
								'label' => esc_html__( 'Image Slider Space for Event Header', 'eventchamp-core' ),
								'desc' => esc_html__( 'Default: 0', 'eventchamp-core' ),
								'section' => 'events',
								'std' => '0',
								'min_max_step'=> '0,50,5',
							),
							array(
								'type' => 'radio',
								'id' => 'event-header-image-slider-loop',
								'label' => esc_html__( 'Image Slider Loop for Event Header', 'eventchamp-core' ),
								'section' => 'events',
								'std' => 'true',
								'choices' => array(
									array(
										'label' => esc_html__( 'True', 'eventchamp-core' ),
										'value' => 'true',
									),
									array(
										'label' => esc_html__( 'False', 'eventchamp-core' ),
										'value' => 'false',
									),
								),
							),
							array(
								'type' => 'radio',
								'id' => 'event-header-image-slider-autoplay',
								'label' => esc_html__( 'Image Slider Autoplay for Event Header', 'eventchamp-core' ),
								'section' => 'events',
								'std' => 'true',
								'choices' => array(
									array(
										'label' => esc_html__( 'True', 'eventchamp-core' ),
										'value' => 'true',
									),
									array(
										'label' => esc_html__( 'False', 'eventchamp-core' ),
										'value' => 'false',
									),
								),
							),
							array(
								'type' => 'text',
								'id' => 'event-header-image-slider-autoplay-delay',
								'label' => esc_html__( 'Image Slider Autoplay Delay for Event Header', 'eventchamp-core' ),
								'desc' => esc_html__( 'Default: 15000', 'eventchamp-core' ),
								'section' => 'events',
							),
							array(
								'type' => 'select',
								'id' => 'event-header-image-slider-direction',
								'label' => esc_html__( 'Image Slider Direction for Event Header', 'eventchamp-core' ),
								'section' => 'events',
								'std' => 'horizontal',
								'choices' => array(
									array(
										'label' => esc_html__( 'Horizontal', 'eventchamp-core' ),
										'value' => 'horizontal',
									),
									array(
										'label' => esc_html__( 'Vertical', 'eventchamp-core' ),
										'value' => 'vertical',
									),
								),
							),
							array(
								'type' => 'select',
								'id' => 'event-header-image-slider-effect',
								'label' => esc_html__( 'Image Slider Effect for Event Header', 'eventchamp-core' ),
								'section' => 'events',
								'std' => 'slide',
								'choices' => array(
									array(
										'label' => esc_html__( 'Slide', 'eventchamp-core' ),
										'value' => 'slide',
									),
									array(
										'label' => esc_html__( 'Fade', 'eventchamp-core' ),
										'value' => 'fade',
									),
									array(
										'label' => esc_html__( 'Cube', 'eventchamp-core' ),
										'value' => 'cube',
									),
									array(
										'label' => esc_html__( 'Flip', 'eventchamp-core' ),
										'value' => 'flip',
									),
								),
							),
							array(
								'type' => 'radio',
								'id' => 'event-header-label-status',
								'label' => esc_html__( 'Show Labels on Event Header', 'eventchamp-core' ),
								'section' => 'events',
								'std' => 'true',
								'choices' => array(
									array(
										'label' => esc_html__( 'Show', 'eventchamp-core' ),
										'value' => 'true',
									),
									array(
										'label' => esc_html__( 'Hide', 'eventchamp-core' ),
										'value' => 'false',
									),
								),
							),
						array(
							'type' => 'tab',
							'id' => 'event-tab-sponsors',
							'label' => esc_html__( 'Sponsors', 'eventchamp-core' ),
							'section' => 'events',
						),
							array(
								'type' => 'radio',
								'id' => 'event-sponsors-status',
								'label' => esc_html__( 'Sponsors Status', 'eventchamp-core' ),
								'section' => 'events',
								'std' => 'true',
								'choices' => array(
									array(
										'label' => esc_html__( 'Show', 'eventchamp-core' ),
										'value' => 'true',
									),
									array(
										'label' => esc_html__( 'Hide', 'eventchamp-core' ),
										'value' => 'false',
									),
								),
							),
							array(
								'type' => 'radio',
								'id' => 'event-sponsors-style',
								'label' => esc_html__( 'Sponsors Style', 'eventchamp-core' ),
								'section' => 'events',
								'std' => 'style-2',
								'choices' => array(
									array(
										'label' => esc_html__( 'Style 1', 'eventchamp-core' ),
										'value' => 'style-1',
									),
									array(
										'label' => esc_html__( 'Style 2', 'eventchamp-core' ),
										'value' => 'style-2',
									),
									array(
										'label' => esc_html__( 'Style 3', 'eventchamp-core' ),
										'value' => 'style-3',
									),
									array(
										'label' => esc_html__( 'Style 4', 'eventchamp-core' ),
										'value' => 'style-4',
									),
									array(
										'label' => esc_html__( 'Style 5', 'eventchamp-core' ),
										'value' => 'style-5',
									),
								),
							),
							array(
								'type' => 'numeric-slider',
								'id' => 'event-sponsors-column',
								'label' => esc_html__( 'Sponsors Column', 'eventchamp-core' ),
								'section' => 'events',
								'std' => '2',
								'min_max_step'=> '1,10,1',
							),
							array(
								'type' => 'select',
								'id' => 'event-sponsors-column-space',
								'label' => esc_html__( 'Sponsors Column Space', 'eventchamp-core' ),
								'section' => 'events',
								'std' => '10',
								'choices' => array(
									array(
										'label' => esc_html__( '0', 'eventchamp-core' ),
										'value' => '0',
									),
									array(
										'label' => esc_html__( '5', 'eventchamp-core' ),
										'value' => '5',
									),
									array(
										'label' => esc_html__( '10', 'eventchamp-core' ),
										'value' => '10',
									),
									array(
										'label' => esc_html__( '15', 'eventchamp-core' ),
										'value' => '15',
									),
									array(
										'label' => esc_html__( '20', 'eventchamp-core' ),
										'value' => '20',
									),
									array(
										'label' => esc_html__( '25', 'eventchamp-core' ),
										'value' => '25',
									),
									array(
										'label' => esc_html__( '30', 'eventchamp-core' ),
										'value' => '30',
									),
									array(
										'label' => esc_html__( '35', 'eventchamp-core' ),
										'value' => '35',
									),
									array(
										'label' => esc_html__( '40', 'eventchamp-core' ),
										'value' => '40',
									),
									array(
										'label' => esc_html__( '45', 'eventchamp-core' ),
										'value' => '45',
									),
									array(
										'label' => esc_html__( '50', 'eventchamp-core' ),
										'value' => '50',
									),
									array(
										'label' => esc_html__( '55', 'eventchamp-core' ),
										'value' => '55',
									),
									array(
										'label' => esc_html__( '60', 'eventchamp-core' ),
										'value' => '60',
									),
								),
							),
						array(
							'type' => 'tab',
							'id' => 'event-tab-tickets',
							'label' => esc_html__( 'Tickets', 'eventchamp-core' ),
							'section' => 'events',
						),
							array(
								'type' => 'select',
								'id' => 'event-ticket-style',
								'label' => esc_html__( 'Ticket Style', 'eventchamp-core' ),
								'section' => 'events',
								'std' => 'style-4',
								'choices' => array(
									array(
										'label' => esc_html__( 'Style 1', 'eventchamp-core' ),
										'value' => 'style-1',
									),
									array(
										'label' => esc_html__( 'Style 2', 'eventchamp-core' ),
										'value' => 'style-2',
									),
									array(
										'label' => esc_html__( 'Style 3', 'eventchamp-core' ),
										'value' => 'style-3',
									),
									array(
										'label' => esc_html__( 'Style 4', 'eventchamp-core' ),
										'value' => 'style-4',
									),
									array(
										'label' => esc_html__( 'Style 5', 'eventchamp-core' ),
										'value' => 'style-5',
									),
									array(
										'label' => esc_html__( 'Style 6', 'eventchamp-core' ),
										'value' => 'style-6',
									),
									array(
										'label' => esc_html__( 'Style 7', 'eventchamp-core' ),
										'value' => 'style-7',
									),
								),
							),
							array(
								'type' => 'select',
								'id' => 'event-ticket-column',
								'label' => esc_html__( 'Ticket Column', 'eventchamp-core' ),
								'section' => 'events',
								'std' => '2',
								'choices' => array(
									array(
										'label' => esc_html__( '1', 'eventchamp-core' ),
										'value' => '1',
									),
									array(
										'label' => esc_html__( '2', 'eventchamp-core' ),
										'value' => '2',
									),
									array(
										'label' => esc_html__( '3', 'eventchamp-core' ),
										'value' => '3',
									),
								),
							),
							array(
								'type' => 'select',
								'id' => 'event-ticket-column-space',
								'label' => esc_html__( 'Ticket Column Space', 'eventchamp-core' ),
								'section' => 'events',
								'std' => '25',
								'choices' => array(
									array(
										'label' => esc_html__( '0', 'eventchamp-core' ),
										'value' => '0',
									),
									array(
										'label' => esc_html__( '5', 'eventchamp-core' ),
										'value' => '5',
									),
									array(
										'label' => esc_html__( '10', 'eventchamp-core' ),
										'value' => '10',
									),
									array(
										'label' => esc_html__( '15', 'eventchamp-core' ),
										'value' => '15',
									),
									array(
										'label' => esc_html__( '20', 'eventchamp-core' ),
										'value' => '20',
									),
									array(
										'label' => esc_html__( '25', 'eventchamp-core' ),
										'value' => '25',
									),
									array(
										'label' => esc_html__( '30', 'eventchamp-core' ),
										'value' => '30',
									),
									array(
										'label' => esc_html__( '35', 'eventchamp-core' ),
										'value' => '35',
									),
									array(
										'label' => esc_html__( '40', 'eventchamp-core' ),
										'value' => '40',
									),
									array(
										'label' => esc_html__( '45', 'eventchamp-core' ),
										'value' => '45',
									),
									array(
										'label' => esc_html__( '50', 'eventchamp-core' ),
										'value' => '50',
									),
									array(
										'label' => esc_html__( '55', 'eventchamp-core' ),
										'value' => '55',
									),
									array(
										'label' => esc_html__( '60', 'eventchamp-core' ),
										'value' => '60',
									),
								),
							),
							array(
								'type' => 'numeric-slider',
								'id' => 'event_ticket_package_column_for_events',
								'label' => esc_html__( 'Event Tickets Column', 'eventchamp-core' ),
								'section' => 'events',
								'std' => '1',
								'min_max_step'=> '1,3,1',
							),
							array(
								'type' => 'radio',
								'id' => 'event-ticket-quantity',
								'label' => esc_html__( 'Quantity', 'eventchamp-core' ),
								'desc' => esc_html__( 'Only for WooCommerce.', 'eventchamp-core' ),
								'section' => 'events',
								'std' => 'true',
								'choices' => array(
									array(
										'label' => esc_html__( 'True', 'eventchamp-core' ),
										'value' => 'true',
									),
									array(
										'label' => esc_html__( 'False', 'eventchamp-core' ),
										'value' => 'false',
									),
								),
							),
							array(
								'type' => 'numeric-slider',
								'id' => 'event-ticket-max-quantity',
								'label' => esc_html__( 'Max Quantity', 'eventchamp-core' ),
								'desc' => esc_html__( 'This feature will show on the ticket purchase table.', 'eventchamp-core' ),
								'section' => 'events',
								'std' => '10',
								'min_max_step'=> '1,9999,1',
							),
							array(
								'type' => 'text',
								'id' => 'event-pricing-table-icon',
								'label' => esc_html__( 'Pricing Table Icon', 'eventchamp-core' ),
								'desc' => esc_html__( 'This icon will be displayed on the feature list on the pricing table. If you enter blank, the icon will not appear. Example: fa-solid fa-circle-check. Icon list: https://goo.gl/vdPEsc', 'eventchamp-core' ),
								'section' => 'events',
							),
						array(
							'type' => 'tab',
							'id' => 'event-tab-media',
							'label' => esc_html__( 'Media', 'eventchamp-core' ),
							'section' => 'events',
						),
							array(
								'type' => 'radio',
								'id' => 'event-photos-status',
								'label' => esc_html__( 'Photos Status', 'eventchamp-core' ),
								'section' => 'events',
								'std' => 'true',
								'choices' => array(
									array(
										'label' => esc_html__( 'Show', 'eventchamp-core' ),
										'value' => 'true',
									),
									array(
										'label' => esc_html__( 'Hide', 'eventchamp-core' ),
										'value' => 'false',
									),
								),
							),
							array(
								'type' => 'select',
								'id' => 'event-photo-column',
								'label' => esc_html__( 'Photos Column', 'eventchamp-core' ),
								'section' => 'events',
								'std' => '3',
								'choices' => array(
									array(
										'label' => esc_html__( '1', 'eventchamp-core' ),
										'value' => '1',
									),
									array(
										'label' => esc_html__( '2', 'eventchamp-core' ),
										'value' => '2',
									),
									array(
										'label' => esc_html__( '3', 'eventchamp-core' ),
										'value' => '3',
									),
									array(
										'label' => esc_html__( '4', 'eventchamp-core' ),
										'value' => '4',
									),
									array(
										'label' => esc_html__( '5', 'eventchamp-core' ),
										'value' => '5',
									),
								),
							),
							array(
								'type' => 'select',
								'id' => 'event-photo-column-space',
								'label' => esc_html__( 'Photos Column Space', 'eventchamp-core' ),
								'section' => 'events',
								'std' => '0',
								'choices' => array(
									array(
										'label' => esc_html__( '0', 'eventchamp-core' ),
										'value' => '0',
									),
									array(
										'label' => esc_html__( '5', 'eventchamp-core' ),
										'value' => '5',
									),
									array(
										'label' => esc_html__( '10', 'eventchamp-core' ),
										'value' => '10',
									),
									array(
										'label' => esc_html__( '15', 'eventchamp-core' ),
										'value' => '15',
									),
									array(
										'label' => esc_html__( '20', 'eventchamp-core' ),
										'value' => '20',
									),
									array(
										'label' => esc_html__( '25', 'eventchamp-core' ),
										'value' => '25',
									),
									array(
										'label' => esc_html__( '30', 'eventchamp-core' ),
										'value' => '30',
									),
									array(
										'label' => esc_html__( '35', 'eventchamp-core' ),
										'value' => '35',
									),
									array(
										'label' => esc_html__( '40', 'eventchamp-core' ),
										'value' => '40',
									),
									array(
										'label' => esc_html__( '45', 'eventchamp-core' ),
										'value' => '45',
									),
									array(
										'label' => esc_html__( '50', 'eventchamp-core' ),
										'value' => '50',
									),
									array(
										'label' => esc_html__( '55', 'eventchamp-core' ),
										'value' => '55',
									),
									array(
										'label' => esc_html__( '60', 'eventchamp-core' ),
										'value' => '60',
									),
								),
							),
						array(
							'type' => 'tab',
							'id' => 'event-tab-map',
							'label' => esc_html__( 'Map', 'eventchamp-core' ),
							'section' => 'events',
						),
							array(
								'type' => 'text',
								'id' => 'event-map-zoom',
								'label' => esc_html__( 'Map Zoom', 'eventchamp-core' ),
								'section' => 'events',
								'std' => '16',
							),
							array(
								'type' => 'select',
								'id' => 'event-map-style',
								'label' => esc_html__( 'Map Style', 'eventchamp-core' ),
								'section' => 'events',
								'std' => '1',
								'choices' => array(
									array(
										'label' => esc_html__( 'Style 1', 'eventchamp-core' ),
										'value' => '1',
									),
									array(
										'label' => esc_html__( 'Style 2', 'eventchamp-core' ),
										'value' => '2',
									),
									array(
										'label' => esc_html__( 'Style 3', 'eventchamp-core' ),
										'value' => '3',
									),
									array(
										'label' => esc_html__( 'Style 4', 'eventchamp-core' ),
										'value' => '4',
									),
									array(
										'label' => esc_html__( 'Style 5', 'eventchamp-core' ),
										'value' => '5',
									),
									array(
										'label' => esc_html__( 'Style 6', 'eventchamp-core' ),
										'value' => '6',
									),
									array(
										'label' => esc_html__( 'Style 7', 'eventchamp-core' ),
										'value' => '7',
									),
									array(
										'label' => esc_html__( 'Style 8', 'eventchamp-core' ),
										'value' => '8',
									),
									array(
										'label' => esc_html__( 'Style 9', 'eventchamp-core' ),
										'value' => '9',
									),
									array(
										'label' => esc_html__( 'Style 10', 'eventchamp-core' ),
										'value' => '10',
									),
									array(
										'label' => esc_html__( 'Style 11', 'eventchamp-core' ),
										'value' => '11',
									),
									array(
										'label' => esc_html__( 'Style 12', 'eventchamp-core' ),
										'value' => '12',
									),
									array(
										'label' => esc_html__( 'Style 13', 'eventchamp-core' ),
										'value' => '13',
									),
									array(
										'label' => esc_html__( 'Style 14', 'eventchamp-core' ),
										'value' => '14',
									),
								),
							),
							array(
								'type' => 'upload',
								'id' => 'event-map-icon',
								'label' => esc_html__( 'Custom Map Marker', 'eventchamp-core' ),
								'desc' => esc_html__( 'If you enter blank, the default icon will be shown.', 'eventchamp-core' ),
								'section' => 'events',
							),
							array(
								'type' => 'radio',
								'id' => 'event-map-type',
								'label' => esc_html__( 'Map Type', 'eventchamp-core' ),
								'section' => 'events',
								'std' => 'true',
								'choices' => array(
									array(
										'label' => esc_html__( 'Show', 'eventchamp-core' ),
										'value' => 'true',
									),
									array(
										'label' => esc_html__( 'Hide', 'eventchamp-core' ),
										'value' => 'false',
									),
								),
							),
							array(
								'type' => 'radio',
								'id' => 'event-map-scale',
								'label' => esc_html__( 'Map Scale', 'eventchamp-core' ),
								'section' => 'events',
								'std' => 'true',
								'choices' => array(
									array(
										'label' => esc_html__( 'Show', 'eventchamp-core' ),
										'value' => 'true',
									),
									array(
										'label' => esc_html__( 'Hide', 'eventchamp-core' ),
										'value' => 'false',
									),
								),
							),
							array(
								'type' => 'radio',
								'id' => 'event-map-zoom-control',
								'label' => esc_html__( 'Map Zoom Control', 'eventchamp-core' ),
								'section' => 'events',
								'std' => 'true',
								'choices' => array(
									array(
										'label' => esc_html__( 'Show', 'eventchamp-core' ),
										'value' => 'true',
									),
									array(
										'label' => esc_html__( 'Hide', 'eventchamp-core' ),
										'value' => 'false',
									),
								),
							),
							array(
								'type' => 'radio',
								'id' => 'event-map-fullscreen',
								'label' => esc_html__( 'Map Fullscreen', 'eventchamp-core' ),
								'section' => 'events',
								'std' => 'true',
								'choices' => array(
									array(
										'label' => esc_html__( 'Show', 'eventchamp-core' ),
										'value' => 'true',
									),
									array(
										'label' => esc_html__( 'Hide', 'eventchamp-core' ),
										'value' => 'false',
									),
								),
							),
							array(
								'type' => 'radio',
								'id' => 'event-map-street',
								'label' => esc_html__( 'Map Streets', 'eventchamp-core' ),
								'section' => 'events',
								'std' => 'true',
								'choices' => array(
									array(
										'label' => esc_html__( 'Show', 'eventchamp-core' ),
										'value' => 'true',
									),
									array(
										'label' => esc_html__( 'Hide', 'eventchamp-core' ),
										'value' => 'false',
									),
								),
							),
						array(
							'type' => 'tab',
							'id' => 'event-tab-add-to-calendars',
							'label' => esc_html__( 'Add to Calendar', 'eventchamp-core' ),
							'section' => 'events',
						),
							array(
								'type' => 'on-off',
								'id' => 'event-add-to-calendar-status',
								'label' => esc_html__( 'Add to Calendar', 'eventchamp-core' ),
								'section' => 'events',
								'std' => 'on',
							),
							array(
								'type' => 'on-off',
								'id' => 'event-add-to-calendar-google',
								'label' => esc_html__( 'Google Calendar', 'eventchamp-core' ),
								'section' => 'events',
								'std' => 'on',
							),
							array(
								'type' => 'on-off',
								'id' => 'event-add-to-calendar-outlook',
								'label' => esc_html__( 'Outlook Calendar', 'eventchamp-core' ),
								'section' => 'events',
								'std' => 'on',
							),
							array(
								'type' => 'on-off',
								'id' => 'event-add-to-calendar-apple',
								'label' => esc_html__( 'Apple Calendar', 'eventchamp-core' ),
								'section' => 'events',
								'std' => 'on',
							),
							array(
								'type' => 'on-off',
								'id' => 'event-add-to-calendar-yahoo',
								'label' => esc_html__( 'Yahoo Calendar', 'eventchamp-core' ),
								'section' => 'events',
								'std' => 'on',
							),
							array(
								'type' => 'on-off',
								'id' => 'event-add-to-calendar-ics',
								'label' => esc_html__( 'ICS Export', 'eventchamp-core' ),
								'section' => 'events',
								'std' => 'on',
							),
						array(
							'type' => 'tab',
							'id' => 'event-tab-layouts',
							'label' => esc_html__( 'Layouts', 'eventchamp-core' ),
							'section' => 'events',
						),
							array(
								'type' => 'radio-image',
								'id' => 'event_sidebar_position',
								'label' => esc_html__( 'Sidebar Position for Event Archive', 'eventchamp-core' ),
								'section' => 'events',
								'std' => 'right',
							),
							array(
								'type' => 'sidebar-select',
								'id' => 'event_sidebar_select',
								'label' => esc_html__( 'Sidebar for Event Archive', 'eventchamp-core' ),
								'section' => 'events',
							),
							array(
								'type' => 'radio-image',
								'id' => 'event_single_sidebar_position',
								'label' => esc_html__( 'Sidebar Position for Event Single', 'eventchamp-core' ),
								'section' => 'events',
								'std' => 'right',
							),
							array(
								'type' => 'sidebar-select',
								'id' => 'event_detail_sidebar_select',
								'label' => esc_html__( 'Sidebar for Event Single', 'eventchamp-core' ),
								'section' => 'events',
							),

					/*====== Venues ======*/
						array(
							'type' => 'tab',
							'id' => 'venue-tab-single',
							'label' => esc_html__( 'Single', 'eventchamp-core' ),
							'section' => 'venues',
						),
							array(
								'type' => 'on-off',
								'id' => 'venue-like-system',
								'label' => esc_html__( 'Venue Like System', 'eventchamp-core' ),
								'desc' => esc_html__( 'If you choose on, the like button will show on the single venues.', 'eventchamp-core' ),
								'section' => 'venues',
								'std' => 'on',
							),
							array(
								'type' => 'on-off',
								'id' => 'venue-favorite-system',
								'label' => esc_html__( 'Venue Favorite System', 'eventchamp-core' ),
								'desc' => esc_html__( 'If you choose on, the favorite button will show on the single venues.', 'eventchamp-core' ),
								'section' => 'venues',
								'std' => 'on',
							),
							array(
								'id' => 'venue_event_list_venue_detail',
								'type' => 'on-off',
								'label' => esc_html__( 'Venue Events', 'eventchamp-core' ),
								'section' => 'venues',
								'std' => 'on',
							),
							array(
								'type' => 'numeric-slider',
								'id' => 'venue_event_list_venue_detail_count',
								'label' => esc_html__( 'Venue Events Count', 'eventchamp-core' ),
								'section' => 'venues',
								'std' => '3',
								'min_max_step'=> '1,50,1',
							),
							array(
								'type' => 'radio',
								'id' => 'venue-events-style',
								'label' => esc_html__( 'Venue Events Style', 'eventchamp-core' ),
								'section' => 'venues',
								'std' => 'style-3',
								'choices' => array(
									array(
										'label' => esc_html__( 'Style 1', 'eventchamp-core' ),
										'value' => 'style-1',
									),
									array(
										'label' => esc_html__( 'Style 2', 'eventchamp-core' ),
										'value' => 'style-2',
									),
									array(
										'label' => esc_html__( 'Style 3', 'eventchamp-core' ),
										'value' => 'style-3',
									),
								),
							),
							array(
								'type' => 'numeric-slider',
								'id' => 'venue-events-column',
								'label' => esc_html__( 'Venue Events Column', 'eventchamp-core' ),
								'section' => 'venues',
								'std' => '3',
								'min_max_step'=> '1,5,1',
							),
							array(
								'type' => 'select',
								'id' => 'venue-events-column-space',
								'label' => esc_html__( 'Venue Events Column Space', 'eventchamp-core' ),
								'section' => 'venues',
								'std' => '30',
								'choices' => array(
									array(
										'label' => esc_html__( '0', 'eventchamp-core' ),
										'value' => '0',
									),
									array(
										'label' => esc_html__( '5', 'eventchamp-core' ),
										'value' => '5',
									),
									array(
										'label' => esc_html__( '10', 'eventchamp-core' ),
										'value' => '10',
									),
									array(
										'label' => esc_html__( '15', 'eventchamp-core' ),
										'value' => '15',
									),
									array(
										'label' => esc_html__( '20', 'eventchamp-core' ),
										'value' => '20',
									),
									array(
										'label' => esc_html__( '25', 'eventchamp-core' ),
										'value' => '25',
									),
									array(
										'label' => esc_html__( '30', 'eventchamp-core' ),
										'value' => '30',
									),
									array(
										'label' => esc_html__( '35', 'eventchamp-core' ),
										'value' => '35',
									),
									array(
										'label' => esc_html__( '40', 'eventchamp-core' ),
										'value' => '40',
									),
									array(
										'label' => esc_html__( '45', 'eventchamp-core' ),
										'value' => '45',
									),
									array(
										'label' => esc_html__( '50', 'eventchamp-core' ),
										'value' => '50',
									),
									array(
										'label' => esc_html__( '55', 'eventchamp-core' ),
										'value' => '55',
									),
									array(
										'label' => esc_html__( '60', 'eventchamp-core' ),
										'value' => '60',
									),
								),
							),
							array(
								'type' => 'on-off',
								'id' => 'venue_related_venues',
								'label' => esc_html__( 'Related Venues', 'eventchamp-core' ),
								'section' => 'venues',
								'std' => 'on',
							),
							array(
								'type' => 'select',
								'id' => 'venue_related_venues_style',
								'label' => esc_html__( 'Related Venues Style', 'eventchamp-core' ),
								'section' => 'venues',
								'std' => 'style-2',
								'choices' => array(
									array(
										'label' => esc_html__( 'Style 1', 'eventchamp-core' ),
										'value' => 'style-1',
									),
									array(
										'label' => esc_html__( 'Style 2', 'eventchamp-core' ),
										'value' => 'style-2',
									),
								),
							),
							array(
								'type' => 'numeric-slider',
								'id' => 'venue_related_venues_count',
								'label' => esc_html__( 'Related Venues Count', 'eventchamp-core' ),
								'section' => 'venues',
								'std' => '3',
								'min_max_step'=> '1,12,1',
							),
							array(
								'type' => 'numeric-slider',
								'id' => 'venue-related-column',
								'label' => esc_html__( 'Related Venues Column', 'eventchamp-core' ),
								'section' => 'venues',
								'std' => '3',
								'min_max_step'=> '1,5,1',
							),
							array(
								'type' => 'select',
								'id' => 'venue-related-column-space',
								'label' => esc_html__( 'Related Venues Column Space', 'eventchamp-core' ),
								'section' => 'venues',
								'std' => '30',
								'choices' => array(
									array(
										'label' => esc_html__( '0', 'eventchamp-core' ),
										'value' => '0',
									),
									array(
										'label' => esc_html__( '5', 'eventchamp-core' ),
										'value' => '5',
									),
									array(
										'label' => esc_html__( '10', 'eventchamp-core' ),
										'value' => '10',
									),
									array(
										'label' => esc_html__( '15', 'eventchamp-core' ),
										'value' => '15',
									),
									array(
										'label' => esc_html__( '20', 'eventchamp-core' ),
										'value' => '20',
									),
									array(
										'label' => esc_html__( '25', 'eventchamp-core' ),
										'value' => '25',
									),
									array(
										'label' => esc_html__( '30', 'eventchamp-core' ),
										'value' => '30',
									),
									array(
										'label' => esc_html__( '35', 'eventchamp-core' ),
										'value' => '35',
									),
									array(
										'label' => esc_html__( '40', 'eventchamp-core' ),
										'value' => '40',
									),
									array(
										'label' => esc_html__( '45', 'eventchamp-core' ),
										'value' => '45',
									),
									array(
										'label' => esc_html__( '50', 'eventchamp-core' ),
										'value' => '50',
									),
									array(
										'label' => esc_html__( '55', 'eventchamp-core' ),
										'value' => '55',
									),
									array(
										'label' => esc_html__( '60', 'eventchamp-core' ),
										'value' => '60',
									),
								),
							),
							array(
								'type' => 'on-off',
								'id' => 'venue-comments',
								'label' => esc_html__( 'Comments', 'eventchamp-core' ),
								'section' => 'venues',
								'std' => 'on',
							),
							array(
								'type' => 'list-item',
								'id' => 'venue-sidebar-buttons',
								'label' => esc_html__( 'Sidebar Buttons', 'eventchamp-core' ),
								'section' => 'venues',
								'settings' => array(
									array(
										'type' => 'text',
										'id' => 'link',
										'label' => esc_html__( 'Link URL', 'eventchamp-core' ),
									),
									array(
										'type' => 'radio',
										'id' => 'target',
										'label' => esc_html__( 'Target', 'eventchamp-core' ),
										'std' => '_self',
										'choices' => array(
											array(
												'label' => esc_html__( 'Self', 'eventchamp-core' ),
												'value' => '_self',
											),
											array(
												'label' => esc_html__( 'Blank', 'eventchamp-core' ),
												'value' => '_blank',
											),
										),
									),
								),
							),
							array(
								'type' => 'on-off',
								'id' => 'venue-tags',
								'label' => esc_html__( 'Venue Tags', 'eventchamp-core' ),
								'section' => 'venues',
								'std' => 'on',
							),
							array(
								'type' => 'radio',
								'id' => 'venue-tags-position',
								'label' => esc_html__( 'Venue Tags Position', 'eventchamp-core' ),
								'section' => 'venues',
								'std' => 'position-1',
								'choices' => array(
									array(
										'label' => esc_html__( 'Under Content', 'eventchamp-core' ),
										'value' => 'position-1',
									),
									array(
										'label' => esc_html__( 'On Sidebar', 'eventchamp-core' ),
										'value' => 'position-2',
									),
								),
							),
							array(
								'type' => 'select',
								'id' => 'venue-tags-style',
								'label' => esc_html__( 'Venue Tags Style', 'eventchamp-core' ),
								'section' => 'venues',
								'std' => 'style-1',
								'choices' => array(
									array(
										'label' => esc_html__( 'Style 1', 'eventchamp-core' ),
										'value' => 'style-1',
									),
									array(
										'label' => esc_html__( 'Style 2', 'eventchamp-core' ),
										'value' => 'style-2',
									),
									array(
										'label' => esc_html__( 'Style 3', 'eventchamp-core' ),
										'value' => 'style-3',
									),
									array(
										'label' => esc_html__( 'Style 4', 'eventchamp-core' ),
										'value' => 'style-4',
									),
								),
							),
							array(
								'type' => 'on-off',
								'id' => 'venue-social-sharing',
								'label' => esc_html__( 'Social Sharing', 'eventchamp-core' ),
								'section' => 'venues',
								'std' => 'on',
							),
							array(
								'type' => 'text',
								'id' => 'venue-social-share-text',
								'label' => esc_html__( 'Social Sharing Title', 'eventchamp-core' ),
								'desc' => esc_html__( 'Default: Share This Venue.', 'eventchamp-core' ),
								'section' => 'venues',
							),
							array(
								'type' => 'radio',
								'id' => 'venue-social-share-position',
								'label' => esc_html__( 'Social Sharing Position', 'eventchamp-core' ),
								'section' => 'venues',
								'std' => 'position-1',
								'choices' => array(
									array(
										'label' => esc_html__( 'Under Content', 'eventchamp-core' ),
										'value' => 'position-1',
									),
									array(
										'label' => esc_html__( 'On Sidebar', 'eventchamp-core' ),
										'value' => 'position-2',
									),
								),
							),
							array(
								'type' => 'select',
								'id' => 'venue-social-sharing-style',
								'label' => esc_html__( 'Social Sharing Style', 'eventchamp-core' ),
								'section' => 'venues',
								'std' => 'style-1',
								'choices' => array(
									array(
										'label' => esc_html__( 'Style 1', 'eventchamp-core' ),
										'value' => 'style-1',
									),
									array(
										'label' => esc_html__( 'Style 2', 'eventchamp-core' ),
										'value' => 'style-2',
									),
									array(
										'label' => esc_html__( 'Style 3', 'eventchamp-core' ),
										'value' => 'style-3',
									),
									array(
										'label' => esc_html__( 'Style 4', 'eventchamp-core' ),
										'value' => 'style-4',
									),
									array(
										'label' => esc_html__( 'Style 5', 'eventchamp-core' ),
										'value' => 'style-5',
									),
									array(
										'label' => esc_html__( 'Style 6', 'eventchamp-core' ),
										'value' => 'style-6',
									),
									array(
										'label' => esc_html__( 'Style 7', 'eventchamp-core' ),
										'value' => 'style-7',
									),
								),
							),
						array(
							'type' => 'tab',
							'id' => 'venue-tab-archives',
							'label' => esc_html__( 'Archives', 'eventchamp-core' ),
							'section' => 'venues',
						),
							array(
								'type' => 'select',
								'id' => 'venue-listing-style',
								'label' => esc_html__( 'Venue Listing Style', 'eventchamp-core' ),
								'section' => 'venues',
								'std' => 'style-2',
								'choices' => array(
									array(
										'label' => esc_html__( 'Style 1', 'eventchamp-core' ),
										'value' => 'style-1',
									),
									array(
										'label' => esc_html__( 'Style 2', 'eventchamp-core' ),
										'value' => 'style-2',
									),
								),
							),
							array(
								'type' => 'numeric-slider',
								'id' => 'venue-listing-column',
								'label' => esc_html__( 'Venue Listing Column', 'eventchamp-core' ),
								'section' => 'venues',
								'std' => '2',
								'min_max_step'=> '1,5,1',
							),
							array(
								'type' => 'select',
								'id' => 'venue-speaker-column-space',
								'label' => esc_html__( 'Venue Listing Column Space', 'eventchamp-core' ),
								'section' => 'venues',
								'std' => '30',
								'choices' => array(
									array(
										'label' => esc_html__( '0', 'eventchamp-core' ),
										'value' => '0',
									),
									array(
										'label' => esc_html__( '5', 'eventchamp-core' ),
										'value' => '5',
									),
									array(
										'label' => esc_html__( '10', 'eventchamp-core' ),
										'value' => '10',
									),
									array(
										'label' => esc_html__( '15', 'eventchamp-core' ),
										'value' => '15',
									),
									array(
										'label' => esc_html__( '20', 'eventchamp-core' ),
										'value' => '20',
									),
									array(
										'label' => esc_html__( '25', 'eventchamp-core' ),
										'value' => '25',
									),
									array(
										'label' => esc_html__( '30', 'eventchamp-core' ),
										'value' => '30',
									),
									array(
										'label' => esc_html__( '35', 'eventchamp-core' ),
										'value' => '35',
									),
									array(
										'label' => esc_html__( '40', 'eventchamp-core' ),
										'value' => '40',
									),
									array(
										'label' => esc_html__( '45', 'eventchamp-core' ),
										'value' => '45',
									),
									array(
										'label' => esc_html__( '50', 'eventchamp-core' ),
										'value' => '50',
									),
									array(
										'label' => esc_html__( '55', 'eventchamp-core' ),
										'value' => '55',
									),
									array(
										'label' => esc_html__( '60', 'eventchamp-core' ),
										'value' => '60',
									),
								),
							),
							array(
								'type' => 'on-off',
								'id' => 'venue-archives-category',
								'label' => esc_html__( 'Category', 'eventchamp-core' ),
								'section' => 'venues',
								'std' => 'off',
							),
							array(
								'type' => 'on-off',
								'id' => 'venue-archives-location',
								'label' => esc_html__( 'Location', 'eventchamp-core' ),
								'section' => 'venues',
								'std' => 'on',
							),
							array(
								'type' => 'on-off',
								'id' => 'venue-archives-excerpt',
								'label' => esc_html__( 'Excerpt', 'eventchamp-core' ),
								'section' => 'venues',
								'std' => 'on',
							),
						array(
							'type' => 'tab',
							'id' => 'venue-tab-header',
							'label' => esc_html__( 'Venue Header', 'eventchamp-core' ),
							'section' => 'venues',
						),
							array(
								'type' => 'radio',
								'id' => 'venue-header-status',
								'label' => esc_html__( 'Venue Header Status', 'eventchamp-core' ),
								'section' => 'venues',
								'std' => 'true',
								'choices' => array(
									array(
										'label' => esc_html__( 'Show', 'eventchamp-core' ),
										'value' => 'true',
									),
									array(
										'label' => esc_html__( 'Hide', 'eventchamp-core' ),
										'value' => 'false',
									),
								),
							),
							array(
								'type' => 'select',
								'id' => 'venue_header_style',
								'label' => esc_html__( 'Venue Header Style', 'eventchamp-core' ),
								'section' => 'venues',
								'std' => 'image',
								'choices' => array(
									array(
										'label' => esc_html__( 'Image', 'eventchamp-core' ),
										'value' => 'image',
									),
									array(
										'label' => esc_html__( 'Image Slider', 'eventchamp-core' ),
										'value' => 'image-slider',
									),
									array(
										'label' => esc_html__( 'Image Gallery', 'eventchamp-core' ),
										'value' => 'image-gallery',
									),
									array(
										'label' => esc_html__( 'Video', 'eventchamp-core' ),
										'value' => 'video',
									),
									array(
										'label' => esc_html__( 'Audio', 'eventchamp-core' ),
										'value' => 'audio',
									),
									array(
										'label' => esc_html__( 'Code', 'eventchamp-core' ),
										'value' => 'code',
									),
								),
							),
							array(
								'type' => 'numeric-slider',
								'id' => 'venue-header-image-slider-column',
								'label' => esc_html__( 'Image Slider Column', 'eventchamp-core' ),
								'desc' => esc_html__( 'Default: 1', 'eventchamp-core' ),
								'section' => 'venues',
								'std' => '1',
								'min_max_step'=> '1,5,1',
							),
							array(
								'type' => 'numeric-slider',
								'id' => 'venue-header-image-slider-space',
								'label' => esc_html__( 'Image Slider Space', 'eventchamp-core' ),
								'desc' => esc_html__( 'Default: 0', 'eventchamp-core' ),
								'section' => 'venues',
								'std' => '0',
								'min_max_step'=> '0,50,5',
							),
							array(
								'type' => 'radio',
								'id' => 'venue-header-image-slider-loop',
								'label' => esc_html__( 'Image Slider Loop', 'eventchamp-core' ),
								'section' => 'venues',
								'std' => 'true',
								'choices' => array(
									array(
										'label' => esc_html__( 'True', 'eventchamp-core' ),
										'value' => 'true',
									),
									array(
										'label' => esc_html__( 'False', 'eventchamp-core' ),
										'value' => 'false',
									),
								),
							),
							array(
								'type' => 'radio',
								'id' => 'venue-header-image-slider-autoplay',
								'label' => esc_html__( 'Image Slider Autoplay', 'eventchamp-core' ),
								'section' => 'venues',
								'std' => 'true',
								'choices' => array(
									array(
										'label' => esc_html__( 'True', 'eventchamp-core' ),
										'value' => 'true',
									),
									array(
										'label' => esc_html__( 'False', 'eventchamp-core' ),
										'value' => 'false',
									),
								),
							),
							array(
								'type' => 'text',
								'id' => 'venue-header-image-slider-autoplay-delay',
								'label' => esc_html__( 'Image Slider Autoplay Delay', 'eventchamp-core' ),
								'desc' => esc_html__( 'Default: 15000', 'eventchamp-core' ),
								'section' => 'venues',
							),
							array(
								'type' => 'select',
								'id' => 'venue-header-image-slider-direction',
								'label' => esc_html__( 'Image Slider Direction', 'eventchamp-core' ),
								'section' => 'venues',
								'std' => 'horizontal',
								'choices' => array(
									array(
										'label' => esc_html__( 'Horizontal', 'eventchamp-core' ),
										'value' => 'horizontal',
									),
									array(
										'label' => esc_html__( 'Vertical', 'eventchamp-core' ),
										'value' => 'vertical',
									),
								),
							),
							array(
								'type' => 'select',
								'id' => 'venue-header-image-slider-effect',
								'label' => esc_html__( 'Image Slider Effect', 'eventchamp-core' ),
								'section' => 'venues',
								'std' => 'slide',
								'choices' => array(
									array(
										'label' => esc_html__( 'Slide', 'eventchamp-core' ),
										'value' => 'slide',
									),
									array(
										'label' => esc_html__( 'Fade', 'eventchamp-core' ),
										'value' => 'fade',
									),
									array(
										'label' => esc_html__( 'Cube', 'eventchamp-core' ),
										'value' => 'cube',
									),
									array(
										'label' => esc_html__( 'Flip', 'eventchamp-core' ),
										'value' => 'flip',
									),
								),
							),
						array(
							'type' => 'tab',
							'id' => 'venue-tab-detail-box',
							'label' => esc_html__( 'Detail Box', 'eventchamp-core' ),
							'section' => 'venues',
						),
							array(
								'type' => 'on-off',
								'id' => 'venue-detail-box-status',
								'label' => esc_html__( 'Detail Box', 'eventchamp-core' ),
								'section' => 'venues',
								'std' => 'on',
							),
							array(
								'type' => 'radio',
								'id' => 'venue-detail-box-position',
								'label' => esc_html__( 'Detail Box Position', 'eventchamp-core' ),
								'section' => 'venues',
								'std' => 'position-2',
								'choices' => array(
									array(
										'label' => esc_html__( 'Under Content', 'eventchamp-core' ),
										'value' => 'position-1',
									),
									array(
										'label' => esc_html__( 'On Sidebar', 'eventchamp-core' ),
										'value' => 'position-2',
									),
								),
							),
							array(
								'type' => 'on-off',
								'id' => 'venue-detail-box-location',
								'label' => esc_html__( 'Location', 'eventchamp-core' ),
								'section' => 'venues',
								'std' => 'on',
							),
							array(
								'type' => 'on-off',
								'id' => 'venue-detail-box-category',
								'label' => esc_html__( 'Category', 'eventchamp-core' ),
								'section' => 'venues',
								'std' => 'on',
							),
							array(
								'type' => 'on-off',
								'id' => 'venue-detail-box-address',
								'label' => esc_html__( 'Address', 'eventchamp-core' ),
								'section' => 'venues',
								'std' => 'on',
							),
							array(
								'type' => 'on-off',
								'id' => 'venue-detail-box-phone',
								'label' => esc_html__( 'Phone Number', 'eventchamp-core' ),
								'section' => 'venues',
								'std' => 'on',
							),
							array(
								'type' => 'on-off',
								'id' => 'venue-detail-box-email',
								'label' => esc_html__( 'Email Address', 'eventchamp-core' ),
								'section' => 'venues',
								'std' => 'on',
							),
							array(
								'type' => 'on-off',
								'id' => 'venue-detail-box-website',
								'label' => esc_html__( 'Website', 'eventchamp-core' ),
								'section' => 'venues',
								'std' => 'on',
							),
							array(
								'type' => 'on-off',
								'id' => 'venue-detail-box-fax',
								'label' => esc_html__( 'Fax Number', 'eventchamp-core' ),
								'section' => 'venues',
								'std' => 'on',
							),
							array(
								'type' => 'on-off',
								'id' => 'venue-detail-box-social',
								'label' => esc_html__( 'Social Links', 'eventchamp-core' ),
								'section' => 'venues',
								'std' => 'on',
							),
							array(
								'type' => 'on-off',
								'id' => 'venue-detail-box-extra',
								'label' => esc_html__( 'Extra Details', 'eventchamp-core' ),
								'section' => 'venues',
								'std' => 'on',
							),
							array(
								'type' => 'on-off',
								'id' => 'venue-detail-box-working-hours',
								'label' => esc_html__( 'Working Hours', 'eventchamp-core' ),
								'section' => 'venues',
								'std' => 'on',
							),
						array(
							'type' => 'tab',
							'id' => 'venue-tab-media',
							'label' => esc_html__( 'Media', 'eventchamp-core' ),
							'section' => 'venues',
						),
								array(
									'type' => 'radio',
									'id' => 'venue-photos-status',
									'label' => esc_html__( 'Photos Status', 'eventchamp-core' ),
									'section' => 'venues',
									'std' => 'true',
									'choices' => array(
										array(
											'label' => esc_html__( 'Show', 'eventchamp-core' ),
											'value' => 'true',
										),
										array(
											'label' => esc_html__( 'Hide', 'eventchamp-core' ),
											'value' => 'false',
										),
									),
								),
								array(
									'type' => 'select',
									'id' => 'venue-photo-column',
									'label' => esc_html__( 'Photo Column', 'eventchamp-core' ),
									'section' => 'venues',
									'std' => '3',
									'choices' => array(
										array(
											'label' => esc_html__( '1', 'eventchamp-core' ),
											'value' => '1',
										),
										array(
											'label' => esc_html__( '2', 'eventchamp-core' ),
											'value' => '2',
										),
										array(
											'label' => esc_html__( '3', 'eventchamp-core' ),
											'value' => '3',
										),
										array(
											'label' => esc_html__( '4', 'eventchamp-core' ),
											'value' => '4',
										),
										array(
											'label' => esc_html__( '5', 'eventchamp-core' ),
											'value' => '5',
										),
									),
								),
								array(
									'type' => 'select',
									'id' => 'venue-photo-column-space',
									'label' => esc_html__( 'Photo Column Space', 'eventchamp-core' ),
									'section' => 'venues',
									'std' => '0',
									'choices' => array(
										array(
											'label' => esc_html__( '0', 'eventchamp-core' ),
											'value' => '0',
										),
										array(
											'label' => esc_html__( '5', 'eventchamp-core' ),
											'value' => '5',
										),
										array(
											'label' => esc_html__( '10', 'eventchamp-core' ),
											'value' => '10',
										),
										array(
											'label' => esc_html__( '15', 'eventchamp-core' ),
											'value' => '15',
										),
										array(
											'label' => esc_html__( '20', 'eventchamp-core' ),
											'value' => '20',
										),
										array(
											'label' => esc_html__( '25', 'eventchamp-core' ),
											'value' => '25',
										),
										array(
											'label' => esc_html__( '30', 'eventchamp-core' ),
											'value' => '30',
										),
										array(
											'label' => esc_html__( '35', 'eventchamp-core' ),
											'value' => '35',
										),
										array(
											'label' => esc_html__( '40', 'eventchamp-core' ),
											'value' => '40',
										),
										array(
											'label' => esc_html__( '45', 'eventchamp-core' ),
											'value' => '45',
										),
										array(
											'label' => esc_html__( '50', 'eventchamp-core' ),
											'value' => '50',
										),
										array(
											'label' => esc_html__( '55', 'eventchamp-core' ),
											'value' => '55',
										),
										array(
											'label' => esc_html__( '60', 'eventchamp-core' ),
											'value' => '60',
										),
									),
								),
						array(
							'type' => 'tab',
							'id' => 'venue-tab-map',
							'label' => esc_html__( 'Map', 'eventchamp-core' ),
							'section' => 'venues',
						),
							array(
								'type' => 'on-off',
								'id' => 'venue-map-status',
								'label' => esc_html__( 'Venue Map', 'eventchamp-core' ),
								'section' => 'venues',
								'std' => 'on',
							),
							array(
								'type' => 'radio',
								'id' => 'venue-map-position',
								'label' => esc_html__( 'Venue Map Position', 'eventchamp-core' ),
								'section' => 'venues',
								'std' => 'position-2',
								'choices' => array(
									array(
										'label' => esc_html__( 'Under Content', 'eventchamp-core' ),
										'value' => 'position-1',
									),
									array(
										'label' => esc_html__( 'On Sidebar', 'eventchamp-core' ),
										'value' => 'position-2',
									),
								),
							),
							array(
								'type' => 'text',
								'id' => 'venue-map-zoom',
								'label' => esc_html__( 'Map Zoom', 'eventchamp-core' ),
								'section' => 'venues',
								'std' => '16',
							),
							array(
								'type' => 'select',
								'id' => 'venue-map-style',
								'label' => esc_html__( 'Map Style', 'eventchamp-core' ),
								'section' => 'venues',
								'std' => '1',
								'choices' => array(
									array(
										'label' => esc_html__( 'Style 1', 'eventchamp-core' ),
										'value' => '1',
									),
									array(
										'label' => esc_html__( 'Style 2', 'eventchamp-core' ),
										'value' => '2',
									),
									array(
										'label' => esc_html__( 'Style 3', 'eventchamp-core' ),
										'value' => '3',
									),
									array(
										'label' => esc_html__( 'Style 4', 'eventchamp-core' ),
										'value' => '4',
									),
									array(
										'label' => esc_html__( 'Style 5', 'eventchamp-core' ),
										'value' => '5',
									),
									array(
										'label' => esc_html__( 'Style 6', 'eventchamp-core' ),
										'value' => '6',
									),
									array(
										'label' => esc_html__( 'Style 7', 'eventchamp-core' ),
										'value' => '7',
									),
									array(
										'label' => esc_html__( 'Style 8', 'eventchamp-core' ),
										'value' => '8',
									),
									array(
										'label' => esc_html__( 'Style 9', 'eventchamp-core' ),
										'value' => '9',
									),
									array(
										'label' => esc_html__( 'Style 10', 'eventchamp-core' ),
										'value' => '10',
									),
									array(
										'label' => esc_html__( 'Style 11', 'eventchamp-core' ),
										'value' => '11',
									),
									array(
										'label' => esc_html__( 'Style 12', 'eventchamp-core' ),
										'value' => '12',
									),
									array(
										'label' => esc_html__( 'Style 13', 'eventchamp-core' ),
										'value' => '13',
									),
									array(
										'label' => esc_html__( 'Style 14', 'eventchamp-core' ),
										'value' => '14',
									),
								),
							),
							array(
								'type' => 'upload',
								'id' => 'venue-map-icon',
								'label' => esc_html__( 'Custom Map Marker', 'eventchamp-core' ),
								'desc' => esc_html__( 'If you enter blank, the default icon will be shown.', 'eventchamp-core' ),
								'section' => 'venues',
							),
							array(
								'type' => 'radio',
								'id' => 'venue-map-type',
								'label' => esc_html__( 'Map Type', 'eventchamp-core' ),
								'section' => 'venues',
								'std' => 'true',
								'choices' => array(
									array(
										'label' => esc_html__( 'Show', 'eventchamp-core' ),
										'value' => 'true',
									),
									array(
										'label' => esc_html__( 'Hide', 'eventchamp-core' ),
										'value' => 'false',
									),
								),
							),
							array(
								'type' => 'radio',
								'id' => 'venue-map-scale',
								'label' => esc_html__( 'Map Scale', 'eventchamp-core' ),
								'section' => 'venues',
								'std' => 'true',
								'choices' => array(
									array(
										'label' => esc_html__( 'Show', 'eventchamp-core' ),
										'value' => 'true',
									),
									array(
										'label' => esc_html__( 'Hide', 'eventchamp-core' ),
										'value' => 'false',
									),
								),
							),
							array(
								'type' => 'radio',
								'id' => 'venue-map-zoom-control',
								'label' => esc_html__( 'Map Zoom Control', 'eventchamp-core' ),
								'section' => 'venues',
								'std' => 'true',
								'choices' => array(
									array(
										'label' => esc_html__( 'Show', 'eventchamp-core' ),
										'value' => 'true',
									),
									array(
										'label' => esc_html__( 'Hide', 'eventchamp-core' ),
										'value' => 'false',
									),
								),
							),
							array(
								'type' => 'radio',
								'id' => 'venue-map-fullscreen',
								'label' => esc_html__( 'Map Fullscreen', 'eventchamp-core' ),
								'section' => 'venues',
								'std' => 'true',
								'choices' => array(
									array(
										'label' => esc_html__( 'Show', 'eventchamp-core' ),
										'value' => 'true',
									),
									array(
										'label' => esc_html__( 'Hide', 'eventchamp-core' ),
										'value' => 'false',
									),
								),
							),
							array(
								'type' => 'radio',
								'id' => 'venue-map-street',
								'label' => esc_html__( 'Map Streets', 'eventchamp-core' ),
								'section' => 'venues',
								'std' => 'true',
								'choices' => array(
									array(
										'label' => esc_html__( 'Show', 'eventchamp-core' ),
										'value' => 'true',
									),
									array(
										'label' => esc_html__( 'Hide', 'eventchamp-core' ),
										'value' => 'false',
									),
								),
							),
						array(
							'type' => 'tab',
							'id' => 'venue-tab-layouts',
							'label' => esc_html__( 'Layouts', 'eventchamp-core' ),
							'section' => 'venues',
						),
							array(
								'type' => 'radio-image',
								'id' => 'venue_sidebar_position',
								'label' => esc_html__( 'Sidebar Position for Venue Archive', 'eventchamp-core' ),
								'section' => 'venues',
								'std' => 'right',
							),
							array(
								'type' => 'sidebar-select',
								'id' => 'venue_sidebar_select',
								'label' => esc_html__( 'Sidebar for Venue Archive', 'eventchamp-core' ),
								'section' => 'venues',
							),
							array(
								'type' => 'radio-image',
								'id' => 'venue_single_sidebar_position',
								'label' => esc_html__( 'Sidebar Position for Venue Single', 'eventchamp-core' ),
								'section' => 'venues',
								'std' => 'right',
							),
							array(
								'type' => 'sidebar-select',
								'id' => 'venue_detail_sidebar_select',
								'label' => esc_html__( 'Sidebar for Venue Single', 'eventchamp-core' ),
								'section' => 'venues',
							),

					/*====== Speakers ======*/
						array(
							'type' => 'tab',
							'id' => 'speaker-tab-single',
							'label' => esc_html__( 'Single', 'eventchamp-core' ),
							'section' => 'speakers',
						),
							array(
								'type' => 'on-off',
								'id' => 'speaker-like-system',
								'label' => esc_html__( 'Speaker Like System', 'eventchamp-core' ),
								'desc' => esc_html__( 'If you choose on, the like button will show on the single speakers.', 'eventchamp-core' ),
								'section' => 'speakers',
								'std' => 'on',
							),
							array(
								'type' => 'on-off',
								'id' => 'speaker-favorite-system',
								'label' => esc_html__( 'Speaker Favorite System', 'eventchamp-core' ),
								'desc' => esc_html__( 'If you choose on, the favorite button will show on the single speakers.', 'eventchamp-core' ),
								'section' => 'speakers',
								'std' => 'on',
							),
							array(
								'id' => 'speaker-events',
								'type' => 'on-off',
								'label' => esc_html__( 'Speaker Events', 'eventchamp-core' ),
								'section' => 'speakers',
								'std' => 'on',
							),
							array(
								'type' => 'numeric-slider',
								'id' => 'speaker-events-count',
								'label' => esc_html__( 'Event Count for Speaker Events', 'eventchamp-core' ),
								'section' => 'speakers',
								'std' => '9',
								'min_max_step'=> '1,999,1',
							),
							array(
								'type' => 'select',
								'id' => 'speaker-events-style',
								'label' => esc_html__( 'Speaker Events Style', 'eventchamp-core' ),
								'section' => 'speakers',
								'std' => 'style-3',
								'choices' => array(
									array(
										'label' => esc_html__( 'Style 1', 'eventchamp-core' ),
										'value' => 'style-1',
									),
									array(
										'label' => esc_html__( 'Style 2', 'eventchamp-core' ),
										'value' => 'style-2',
									),
									array(
										'label' => esc_html__( 'Style 3', 'eventchamp-core' ),
										'value' => 'style-3',
									),
								),
							),
							array(
								'type' => 'on-off',
								'id' => 'speaker-related-speakers',
								'label' => esc_html__( 'Related Speakers', 'eventchamp-core' ),
								'section' => 'speakers',
								'std' => 'on',
							),
							array(
								'type' => 'numeric-slider',
								'id' => 'speaker-related-speakers-count',
								'label' => esc_html__( 'Related Speakers Count', 'eventchamp-core' ),
								'section' => 'speakers',
								'std' => '3',
								'min_max_step'=> '1,12,1',
							),
							array(
								'type' => 'select',
								'id' => 'speaker-related-speakers-style',
								'label' => esc_html__( 'Related Speakers Style', 'eventchamp-core' ),
								'section' => 'speakers',
								'std' => 'style-3',
								'choices' => array(
									array(
										'label' => esc_html__( 'Style 1', 'eventchamp-core' ),
										'value' => 'style-1',
									),
									array(
										'label' => esc_html__( 'Style 2', 'eventchamp-core' ),
										'value' => 'style-2',
									),
									array(
										'label' => esc_html__( 'Style 3', 'eventchamp-core' ),
										'value' => 'style-3',
									),
									array(
										'label' => esc_html__( 'Style 4', 'eventchamp-core' ),
										'value' => 'style-4',
									),
									array(
										'label' => esc_html__( 'Style 5', 'eventchamp-core' ),
										'value' => 'style-5',
									),
									array(
										'label' => esc_html__( 'Style 6', 'eventchamp-core' ),
										'value' => 'style-6',
									),
									array(
										'label' => esc_html__( 'Style 7', 'eventchamp-core' ),
										'value' => 'style-7',
									),
									array(
										'label' => esc_html__( 'Style 8', 'eventchamp-core' ),
										'value' => 'style-8',
									),
								),
							),
							array(
								'type' => 'numeric-slider',
								'id' => 'speaker-related-column',
								'label' => esc_html__( 'Related Speakers Column', 'eventchamp-core' ),
								'section' => 'speakers',
								'std' => '3',
								'min_max_step'=> '1,5,1',
							),
							array(
								'type' => 'select',
								'id' => 'speaker-related-column-space',
								'label' => esc_html__( 'Related Speakers Column Space', 'eventchamp-core' ),
								'section' => 'speakers',
								'std' => '30',
								'choices' => array(
									array(
										'label' => esc_html__( '0', 'eventchamp-core' ),
										'value' => '0',
									),
									array(
										'label' => esc_html__( '5', 'eventchamp-core' ),
										'value' => '5',
									),
									array(
										'label' => esc_html__( '10', 'eventchamp-core' ),
										'value' => '10',
									),
									array(
										'label' => esc_html__( '15', 'eventchamp-core' ),
										'value' => '15',
									),
									array(
										'label' => esc_html__( '20', 'eventchamp-core' ),
										'value' => '20',
									),
									array(
										'label' => esc_html__( '25', 'eventchamp-core' ),
										'value' => '25',
									),
									array(
										'label' => esc_html__( '30', 'eventchamp-core' ),
										'value' => '30',
									),
									array(
										'label' => esc_html__( '35', 'eventchamp-core' ),
										'value' => '35',
									),
									array(
										'label' => esc_html__( '40', 'eventchamp-core' ),
										'value' => '40',
									),
									array(
										'label' => esc_html__( '45', 'eventchamp-core' ),
										'value' => '45',
									),
									array(
										'label' => esc_html__( '50', 'eventchamp-core' ),
										'value' => '50',
									),
									array(
										'label' => esc_html__( '55', 'eventchamp-core' ),
										'value' => '55',
									),
									array(
										'label' => esc_html__( '60', 'eventchamp-core' ),
										'value' => '60',
									),
								),
							),
							array(
								'type' => 'on-off',
								'id' => 'speaker-comments',
								'label' => esc_html__( 'Comments', 'eventchamp-core' ),
								'section' => 'speakers',
								'std' => 'on',
							),
							array(
								'type' => 'list-item',
								'id' => 'speaker-sidebar-buttons',
								'label' => esc_html__( 'Sidebar Buttons', 'eventchamp-core' ),
								'section' => 'speakers',
								'settings' => array(
									array(
										'type' => 'text',
										'id' => 'link',
										'label' => esc_html__( 'Link URL', 'eventchamp-core' ),
									),
									array(
										'type' => 'radio',
										'id' => 'target',
										'label' => esc_html__( 'Target', 'eventchamp-core' ),
										'std' => '_self',
										'choices' => array(
											array(
												'label' => esc_html__( 'Self', 'eventchamp-core' ),
												'value' => '_self',
											),
											array(
												'label' => esc_html__( 'Blank', 'eventchamp-core' ),
												'value' => '_blank',
											),
										),
									),
								),
							),
							array(
								'type' => 'on-off',
								'id' => 'speaker-tags',
								'label' => esc_html__( 'Tags', 'eventchamp-core' ),
								'section' => 'speakers',
								'std' => 'on',
							),
							array(
								'type' => 'radio',
								'id' => 'speaker-tags-position',
								'label' => esc_html__( 'Tags Position', 'eventchamp-core' ),
								'section' => 'speakers',
								'std' => 'position-1',
								'choices' => array(
									array(
										'label' => esc_html__( 'Under Content', 'eventchamp-core' ),
										'value' => 'position-1',
									),
									array(
										'label' => esc_html__( 'On Sidebar', 'eventchamp-core' ),
										'value' => 'position-2',
									),
								),
							),
							array(
								'type' => 'select',
								'id' => 'speaker-tags-style',
								'label' => esc_html__( 'Tags Style', 'eventchamp-core' ),
								'section' => 'speakers',
								'std' => 'style-1',
								'choices' => array(
									array(
										'label' => esc_html__( 'Style 1', 'eventchamp-core' ),
										'value' => 'style-1',
									),
									array(
										'label' => esc_html__( 'Style 2', 'eventchamp-core' ),
										'value' => 'style-2',
									),
									array(
										'label' => esc_html__( 'Style 3', 'eventchamp-core' ),
										'value' => 'style-3',
									),
									array(
										'label' => esc_html__( 'Style 4', 'eventchamp-core' ),
										'value' => 'style-4',
									),
								),
							),
							array(
								'type' => 'on-off',
								'id' => 'speaker-social-sharing',
								'label' => esc_html__( 'Social Sharing', 'eventchamp-core' ),
								'section' => 'speakers',
								'std' => 'on',
							),
							array(
								'type' => 'text',
								'id' => 'speaker-social-share-text',
								'label' => esc_html__( 'Social Sharing Title', 'eventchamp-core' ),
								'desc' => esc_html__( 'Default: Share This Speaker.', 'eventchamp-core' ),
								'section' => 'speakers',
							),
							array(
								'type' => 'radio',
								'id' => 'speaker-social-share-position',
								'label' => esc_html__( 'Social Sharing Position', 'eventchamp-core' ),
								'section' => 'speakers',
								'std' => 'position-1',
								'choices' => array(
									array(
										'label' => esc_html__( 'Under Content', 'eventchamp-core' ),
										'value' => 'position-1',
									),
									array(
										'label' => esc_html__( 'On Sidebar', 'eventchamp-core' ),
										'value' => 'position-2',
									),
								),
							),
							array(
								'type' => 'select',
								'id' => 'speaker-social-sharing-style',
								'label' => esc_html__( 'Social Sharing Style', 'eventchamp-core' ),
								'section' => 'speakers',
								'std' => 'style-1',
								'choices' => array(
									array(
										'label' => esc_html__( 'Style 1', 'eventchamp-core' ),
										'value' => 'style-1',
									),
									array(
										'label' => esc_html__( 'Style 2', 'eventchamp-core' ),
										'value' => 'style-2',
									),
									array(
										'label' => esc_html__( 'Style 3', 'eventchamp-core' ),
										'value' => 'style-3',
									),
									array(
										'label' => esc_html__( 'Style 4', 'eventchamp-core' ),
										'value' => 'style-4',
									),
									array(
										'label' => esc_html__( 'Style 5', 'eventchamp-core' ),
										'value' => 'style-5',
									),
									array(
										'label' => esc_html__( 'Style 6', 'eventchamp-core' ),
										'value' => 'style-6',
									),
									array(
										'label' => esc_html__( 'Style 7', 'eventchamp-core' ),
										'value' => 'style-7',
									),
								),
							),
						array(
							'type' => 'tab',
							'id' => 'speaker-tab-archives',
							'label' => esc_html__( 'Archives', 'eventchamp-core' ),
							'section' => 'speakers',
						),
							array(
								'type' => 'select',
								'id' => 'speaker-listing-style',
								'label' => esc_html__( 'Speaker Listing Style', 'eventchamp-core' ),
								'section' => 'speakers',
								'std' => 'style-3',
								'choices' => array(
									array(
										'label' => esc_html__( 'Style 1', 'eventchamp-core' ),
										'value' => 'style-1',
									),
									array(
										'label' => esc_html__( 'Style 2', 'eventchamp-core' ),
										'value' => 'style-2',
									),
									array(
										'label' => esc_html__( 'Style 3', 'eventchamp-core' ),
										'value' => 'style-3',
									),
									array(
										'label' => esc_html__( 'Style 4', 'eventchamp-core' ),
										'value' => 'style-4',
									),
									array(
										'label' => esc_html__( 'Style 5', 'eventchamp-core' ),
										'value' => 'style-5',
									),
									array(
										'label' => esc_html__( 'Style 6', 'eventchamp-core' ),
										'value' => 'style-6',
									),
									array(
										'label' => esc_html__( 'Style 7', 'eventchamp-core' ),
										'value' => 'style-7',
									),
									array(
										'label' => esc_html__( 'Style 8', 'eventchamp-core' ),
										'value' => 'style-8',
									),
								),
							),
							array(
								'type' => 'numeric-slider',
								'id' => 'speaker-listing-column',
								'label' => esc_html__( 'Speaker Listing Column', 'eventchamp-core' ),
								'section' => 'speakers',
								'std' => '2',
								'min_max_step'=> '1,5,1',
							),
							array(
								'type' => 'select',
								'id' => 'speaker-speaker-column-space',
								'label' => esc_html__( 'Speaker Listing Column Space', 'eventchamp-core' ),
								'section' => 'speakers',
								'std' => '30',
								'choices' => array(
									array(
										'label' => esc_html__( '0', 'eventchamp-core' ),
										'value' => '0',
									),
									array(
										'label' => esc_html__( '5', 'eventchamp-core' ),
										'value' => '5',
									),
									array(
										'label' => esc_html__( '10', 'eventchamp-core' ),
										'value' => '10',
									),
									array(
										'label' => esc_html__( '15', 'eventchamp-core' ),
										'value' => '15',
									),
									array(
										'label' => esc_html__( '20', 'eventchamp-core' ),
										'value' => '20',
									),
									array(
										'label' => esc_html__( '25', 'eventchamp-core' ),
										'value' => '25',
									),
									array(
										'label' => esc_html__( '30', 'eventchamp-core' ),
										'value' => '30',
									),
									array(
										'label' => esc_html__( '35', 'eventchamp-core' ),
										'value' => '35',
									),
									array(
										'label' => esc_html__( '40', 'eventchamp-core' ),
										'value' => '40',
									),
									array(
										'label' => esc_html__( '45', 'eventchamp-core' ),
										'value' => '45',
									),
									array(
										'label' => esc_html__( '50', 'eventchamp-core' ),
										'value' => '50',
									),
									array(
										'label' => esc_html__( '55', 'eventchamp-core' ),
										'value' => '55',
									),
									array(
										'label' => esc_html__( '60', 'eventchamp-core' ),
										'value' => '60',
									),
								),
							),
							array(
								'type' => 'on-off',
								'id' => 'speaker-archives-profession',
								'label' => esc_html__( 'Profession', 'eventchamp-core' ),
								'section' => 'speakers',
								'std' => 'on',
							),
							array(
								'type' => 'on-off',
								'id' => 'speaker-archives-company',
								'label' => esc_html__( 'Company', 'eventchamp-core' ),
								'section' => 'speakers',
								'std' => 'off',
							),
							array(
								'type' => 'on-off',
								'id' => 'speaker-archives-short-bio',
								'label' => esc_html__( 'Short Biography', 'eventchamp-core' ),
								'section' => 'speakers',
								'std' => 'on',
							),
							array(
								'type' => 'on-off',
								'id' => 'speaker-archives-social-links',
								'label' => esc_html__( 'Social Links', 'eventchamp-core' ),
								'section' => 'speakers',
								'std' => 'on',
							),
						array(
							'type' => 'tab',
							'id' => 'speaker-tab-header',
							'label' => esc_html__( 'Speaker Header', 'eventchamp-core' ),
							'section' => 'speakers',
						),
							array(
								'type' => 'radio',
								'id' => 'speaker-header-status',
								'label' => esc_html__( 'Speaker Header Status', 'eventchamp-core' ),
								'section' => 'speakers',
								'std' => 'true',
								'choices' => array(
									array(
										'label' => esc_html__( 'Show', 'eventchamp-core' ),
										'value' => 'true',
									),
									array(
										'label' => esc_html__( 'Hide', 'eventchamp-core' ),
										'value' => 'false',
									),
								),
							),
							array(
								'type' => 'select',
								'id' => 'speaker-header-style',
								'label' => esc_html__( 'Speaker Header Style', 'eventchamp-core' ),
								'desc' => esc_html__( 'It will be default speaker header style.', 'eventchamp-core' ),
								'section' => 'speakers',
								'std' => 'image',
								'choices' => array(
									array(
										'label' => esc_html__( 'Image', 'eventchamp-core' ),
										'value' => 'image',
									),
									array(
										'label' => esc_html__( 'Image Slider', 'eventchamp-core' ),
										'value' => 'image-slider',
									),
									array(
										'label' => esc_html__( 'Image Gallery', 'eventchamp-core' ),
										'value' => 'image-gallery',
									),
									array(
										'label' => esc_html__( 'Video', 'eventchamp-core' ),
										'value' => 'video',
									),
									array(
										'label' => esc_html__( 'Audio', 'eventchamp-core' ),
										'value' => 'audio',
									),
									array(
										'label' => esc_html__( 'Code', 'eventchamp-core' ),
										'value' => 'code',
									),
								),
							),
							array(
								'type' => 'numeric-slider',
								'id' => 'speaker-header-image-slider-column',
								'label' => esc_html__( 'Image Slider Column', 'eventchamp-core' ),
								'desc' => esc_html__( 'Default: 1', 'eventchamp-core' ),
								'section' => 'speakers',
								'std' => '1',
								'min_max_step'=> '1,5,1',
							),
							array(
								'type' => 'numeric-slider',
								'id' => 'speaker-header-image-slider-space',
								'label' => esc_html__( 'Image Slider Space', 'eventchamp-core' ),
								'desc' => esc_html__( 'Default: 0', 'eventchamp-core' ),
								'section' => 'speakers',
								'std' => '0',
								'min_max_step'=> '0,50,5',
							),
							array(
								'type' => 'radio',
								'id' => 'speaker-header-image-slider-loop',
								'label' => esc_html__( 'Image Slider Loop', 'eventchamp-core' ),
								'section' => 'speakers',
								'std' => 'true',
								'choices' => array(
									array(
										'label' => esc_html__( 'True', 'eventchamp-core' ),
										'value' => 'true',
									),
									array(
										'label' => esc_html__( 'False', 'eventchamp-core' ),
										'value' => 'false',
									),
								),
							),
							array(
								'type' => 'radio',
								'id' => 'speaker-header-image-slider-autoplay',
								'label' => esc_html__( 'Image Slider Autoplay', 'eventchamp-core' ),
								'section' => 'speakers',
								'std' => 'true',
								'choices' => array(
									array(
										'label' => esc_html__( 'True', 'eventchamp-core' ),
										'value' => 'true',
									),
									array(
										'label' => esc_html__( 'False', 'eventchamp-core' ),
										'value' => 'false',
									),
								),
							),
							array(
								'type' => 'text',
								'id' => 'speaker-header-image-slider-autoplay-delay',
								'label' => esc_html__( 'Image Slider Autoplay Delay', 'eventchamp-core' ),
								'desc' => esc_html__( 'Default: 15000', 'eventchamp-core' ),
								'section' => 'speakers',
							),
							array(
								'type' => 'select',
								'id' => 'speaker-header-image-slider-direction',
								'label' => esc_html__( 'Image Slider Direction', 'eventchamp-core' ),
								'section' => 'speakers',
								'std' => 'horizontal',
								'choices' => array(
									array(
										'label' => esc_html__( 'Horizontal', 'eventchamp-core' ),
										'value' => 'horizontal',
									),
									array(
										'label' => esc_html__( 'Vertical', 'eventchamp-core' ),
										'value' => 'vertical',
									),
								),
							),
							array(
								'type' => 'select',
								'id' => 'speaker-header-image-slider-effect',
								'label' => esc_html__( 'Image Slider Effect', 'eventchamp-core' ),
								'section' => 'speakers',
								'std' => 'slide',
								'choices' => array(
									array(
										'label' => esc_html__( 'Slide', 'eventchamp-core' ),
										'value' => 'slide',
									),
									array(
										'label' => esc_html__( 'Fade', 'eventchamp-core' ),
										'value' => 'fade',
									),
									array(
										'label' => esc_html__( 'Cube', 'eventchamp-core' ),
										'value' => 'cube',
									),
									array(
										'label' => esc_html__( 'Flip', 'eventchamp-core' ),
										'value' => 'flip',
									),
								),
							),
						
						array(
							'type' => 'tab',
							'id' => 'speaker-tab-detail-box',
							'label' => esc_html__( 'Detail Box', 'eventchamp-core' ),
							'section' => 'speakers',
						),
							array(
								'type' => 'on-off',
								'id' => 'speaker-detail-box-status',
								'label' => esc_html__( 'Detail Box', 'eventchamp-core' ),
								'section' => 'speakers',
								'std' => 'on',
							),
							array(
								'type' => 'radio',
								'id' => 'speaker-detail-box-position',
								'label' => esc_html__( 'Detail Box Position', 'eventchamp-core' ),
								'section' => 'speakers',
								'std' => 'position-2',
								'choices' => array(
									array(
										'label' => esc_html__( 'Under Content', 'eventchamp-core' ),
										'value' => 'position-1',
									),
									array(
										'label' => esc_html__( 'On Sidebar', 'eventchamp-core' ),
										'value' => 'position-2',
									),
								),
							),
							array(
								'type' => 'on-off',
								'id' => 'speaker-detail-box-category',
								'label' => esc_html__( 'Category', 'eventchamp-core' ),
								'section' => 'speakers',
								'std' => 'on',
							),
							array(
								'type' => 'on-off',
								'id' => 'speaker-detail-box-location',
								'label' => esc_html__( 'Location', 'eventchamp-core' ),
								'section' => 'speakers',
								'std' => 'on',
							),
							array(
								'type' => 'on-off',
								'id' => 'speaker-detail-box-address',
								'label' => esc_html__( 'Address', 'eventchamp-core' ),
								'section' => 'speakers',
								'std' => 'on',
							),
							array(
								'type' => 'on-off',
								'id' => 'speaker-detail-box-phone',
								'label' => esc_html__( 'Phone', 'eventchamp-core' ),
								'section' => 'speakers',
								'std' => 'on',
							),
							array(
								'type' => 'on-off',
								'id' => 'speaker-detail-box-email',
								'label' => esc_html__( 'Email', 'eventchamp-core' ),
								'section' => 'speakers',
								'std' => 'on',
							),
							array(
								'type' => 'on-off',
								'id' => 'speaker-detail-box-website',
								'label' => esc_html__( 'Website', 'eventchamp-core' ),
								'section' => 'speakers',
								'std' => 'on',
							),
							array(
								'type' => 'on-off',
								'id' => 'speaker-detail-box-social',
								'label' => esc_html__( 'Social Links', 'eventchamp-core' ),
								'section' => 'speakers',
								'std' => 'on',
							),
							array(
								'type' => 'on-off',
								'id' => 'speaker-detail-box-extra',
								'label' => esc_html__( 'Extra Details', 'eventchamp-core' ),
								'section' => 'speakers',
								'std' => 'on',
							),array(
							'type' => 'tab',
							'id' => 'speaker-tab-media',
							'label' => esc_html__( 'Media', 'eventchamp-core' ),
							'section' => 'speakers',
						),
								array(
									'type' => 'radio',
									'id' => 'speaker-photos-status',
									'label' => esc_html__( 'Photos Status', 'eventchamp-core' ),
									'section' => 'speakers',
									'std' => 'true',
									'choices' => array(
										array(
											'label' => esc_html__( 'Show', 'eventchamp-core' ),
											'value' => 'true',
										),
										array(
											'label' => esc_html__( 'Hide', 'eventchamp-core' ),
											'value' => 'false',
										),
									),
								),
								array(
									'type' => 'select',
									'id' => 'speaker-photo-column',
									'label' => esc_html__( 'Photo Column', 'eventchamp-core' ),
									'section' => 'speakers',
									'std' => '3',
									'choices' => array(
										array(
											'label' => esc_html__( '1', 'eventchamp-core' ),
											'value' => '1',
										),
										array(
											'label' => esc_html__( '2', 'eventchamp-core' ),
											'value' => '2',
										),
										array(
											'label' => esc_html__( '3', 'eventchamp-core' ),
											'value' => '3',
										),
										array(
											'label' => esc_html__( '4', 'eventchamp-core' ),
											'value' => '4',
										),
										array(
											'label' => esc_html__( '5', 'eventchamp-core' ),
											'value' => '5',
										),
									),
								),
								array(
									'type' => 'select',
									'id' => 'speaker-photo-column-space',
									'label' => esc_html__( 'Photo Column Space', 'eventchamp-core' ),
									'section' => 'speakers',
									'std' => '0',
									'choices' => array(
										array(
											'label' => esc_html__( '0', 'eventchamp-core' ),
											'value' => '0',
										),
										array(
											'label' => esc_html__( '5', 'eventchamp-core' ),
											'value' => '5',
										),
										array(
											'label' => esc_html__( '10', 'eventchamp-core' ),
											'value' => '10',
										),
										array(
											'label' => esc_html__( '15', 'eventchamp-core' ),
											'value' => '15',
										),
										array(
											'label' => esc_html__( '20', 'eventchamp-core' ),
											'value' => '20',
										),
										array(
											'label' => esc_html__( '25', 'eventchamp-core' ),
											'value' => '25',
										),
										array(
											'label' => esc_html__( '30', 'eventchamp-core' ),
											'value' => '30',
										),
										array(
											'label' => esc_html__( '35', 'eventchamp-core' ),
											'value' => '35',
										),
										array(
											'label' => esc_html__( '40', 'eventchamp-core' ),
											'value' => '40',
										),
										array(
											'label' => esc_html__( '45', 'eventchamp-core' ),
											'value' => '45',
										),
										array(
											'label' => esc_html__( '50', 'eventchamp-core' ),
											'value' => '50',
										),
										array(
											'label' => esc_html__( '55', 'eventchamp-core' ),
											'value' => '55',
										),
										array(
											'label' => esc_html__( '60', 'eventchamp-core' ),
											'value' => '60',
										),
									),
								),
						array(
							'type' => 'tab',
							'id' => 'speaker-tab-layouts',
							'label' => esc_html__( 'Layouts', 'eventchamp-core' ),
							'section' => 'speakers',
						),
							array(
								'type' => 'radio-image',
								'id' => 'speaker_sidebar_position',
								'label' => esc_html__( 'Sidebar Position for Speaker Archive', 'eventchamp-core' ),
								'std' => 'right',
								'section' => 'speakers',
							),
							array(
								'type' => 'sidebar-select',
								'id' => 'speaker_sidebar_select',
								'label' => esc_html__( 'Sidebar for Speaker Archive', 'eventchamp-core' ),
								'section' => 'speakers',
							),
							array(
								'type' => 'radio-image',
								'id' => 'speaker_single_sidebar_position',
								'label' => esc_html__( 'Sidebar Position for Speaker Single', 'eventchamp-core' ),
								'section' => 'speakers',
								'std' => 'right',
							),
							array(
								'type' => 'sidebar-select',
								'id' => 'speaker_detail_sidebar_select',
								'label' => esc_html__( 'Sidebar for Speaker Single', 'eventchamp-core' ),
								'section' => 'speakers',
							),

					/*====== Pages ======*/
						array(
							'type' => 'tab',
							'id' => 'page-tab-general',
							'label' => esc_html__( 'General', 'eventchamp-core' ),
							'section' => 'pages',
						),
							array(
								'type' => 'on-off',
								'id' => 'page_comment_area',
								'label' => esc_html__( 'Comments', 'eventchamp-core' ),
								'section' => 'pages',
								'std' => 'on',
							),
						array(
							'type' => 'tab',
							'id' => 'page-tab-header',
							'label' => esc_html__( 'Page Header', 'eventchamp-core' ),
							'section' => 'pages',
						),
							array(
								'type' => 'radio',
								'id' => 'page-header-status',
								'label' => esc_html__( 'Page Header Status', 'eventchamp-core' ),
								'section' => 'pages',
								'std' => 'true',
								'choices' => array(
									array(
										'label' => esc_html__( 'Show', 'eventchamp-core' ),
										'value' => 'true',
									),
									array(
										'label' => esc_html__( 'Hide', 'eventchamp-core' ),
										'value' => 'false',
									),
								),
							),
							array(
								'type' => 'select',
								'id' => 'page-header-style',
								'label' => esc_html__( 'Page Header Style', 'eventchamp-core' ),
								'desc' => esc_html__( 'It will be default page header style.', 'eventchamp-core' ),
								'section' => 'pages',
								'std' => 'image',
								'choices' => array(
									array(
										'label' => esc_html__( 'Image', 'eventchamp-core' ),
										'value' => 'image',
									),
									array(
										'label' => esc_html__( 'Image Slider', 'eventchamp-core' ),
										'value' => 'image-slider',
									),
									array(
										'label' => esc_html__( 'Image Gallery', 'eventchamp-core' ),
										'value' => 'image-gallery',
									),
									array(
										'label' => esc_html__( 'Video', 'eventchamp-core' ),
										'value' => 'video',
									),
									array(
										'label' => esc_html__( 'Audio', 'eventchamp-core' ),
										'value' => 'audio',
									),
									array(
										'label' => esc_html__( 'Code', 'eventchamp-core' ),
										'value' => 'code',
									),
								),
							),
							array(
								'type' => 'numeric-slider',
								'id' => 'page-header-image-slider-column',
								'label' => esc_html__( 'Image Slider Column', 'eventchamp-core' ),
								'desc' => esc_html__( 'Default: 1', 'eventchamp-core' ),
								'section' => 'pages',
								'std' => '1',
								'min_max_step'=> '1,5,1',
							),
							array(
								'type' => 'numeric-slider',
								'id' => 'page-header-image-slider-space',
								'label' => esc_html__( 'Image Slider Space', 'eventchamp-core' ),
								'desc' => esc_html__( 'Default: 0', 'eventchamp-core' ),
								'section' => 'pages',
								'std' => '0',
								'min_max_step'=> '0,50,5',
							),
							array(
								'type' => 'radio',
								'id' => 'page-header-image-slider-loop',
								'label' => esc_html__( 'Image Slider Loop', 'eventchamp-core' ),
								'section' => 'pages',
								'std' => 'true',
								'choices' => array(
									array(
										'label' => esc_html__( 'True', 'eventchamp-core' ),
										'value' => 'true',
									),
									array(
										'label' => esc_html__( 'False', 'eventchamp-core' ),
										'value' => 'false',
									),
								),
							),
							array(
								'type' => 'radio',
								'id' => 'page-header-image-slider-autoplay',
								'label' => esc_html__( 'Image Slider Autoplay', 'eventchamp-core' ),
								'section' => 'pages',
								'std' => 'true',
								'choices' => array(
									array(
										'label' => esc_html__( 'True', 'eventchamp-core' ),
										'value' => 'true',
									),
									array(
										'label' => esc_html__( 'False', 'eventchamp-core' ),
										'value' => 'false',
									),
								),
							),
							array(
								'type' => 'text',
								'id' => 'page-header-image-slider-autoplay-delay',
								'label' => esc_html__( 'Image Slider Autoplay Delay', 'eventchamp-core' ),
								'desc' => esc_html__( 'Default: 15000', 'eventchamp-core' ),
								'section' => 'pages',
							),
							array(
								'type' => 'select',
								'id' => 'page-header-image-slider-direction',
								'label' => esc_html__( 'Image Slider Direction', 'eventchamp-core' ),
								'section' => 'pages',
								'std' => 'horizontal',
								'choices' => array(
									array(
										'label' => esc_html__( 'Horizontal', 'eventchamp-core' ),
										'value' => 'horizontal',
									),
									array(
										'label' => esc_html__( 'Vertical', 'eventchamp-core' ),
										'value' => 'vertical',
									),
								),
							),
							array(
								'type' => 'select',
								'id' => 'page-header-image-slider-effect',
								'label' => esc_html__( 'Image Slider Effect', 'eventchamp-core' ),
								'section' => 'pages',
								'std' => 'slide',
								'choices' => array(
									array(
										'label' => esc_html__( 'Slide', 'eventchamp-core' ),
										'value' => 'slide',
									),
									array(
										'label' => esc_html__( 'Fade', 'eventchamp-core' ),
										'value' => 'fade',
									),
									array(
										'label' => esc_html__( 'Cube', 'eventchamp-core' ),
										'value' => 'cube',
									),
									array(
										'label' => esc_html__( 'Flip', 'eventchamp-core' ),
										'value' => 'flip',
									),
								),
							),
						array(
							'type' => 'tab',
							'id' => 'page-tab-layouts',
							'label' => esc_html__( 'Layouts', 'eventchamp-core' ),
							'section' => 'pages',
						),
							array(
								'type' => 'radio-image',
								'id' => 'page_sidebar_position',
								'label'	=> esc_html__( 'Sidebar Position', 'eventchamp-core' ),
								'section' => 'pages',
								'std' => 'nosidebar',
							),
							array(
								'type' => 'sidebar-select',
								'id' => 'page_sidebar_select',
								'label' => esc_html__( 'Sidebar', 'eventchamp-core' ),
								'section' => 'pages',
							),

					/*====== Blog ======*/
						array(
							'type' => 'tab',
							'id' => 'blog-tab-post',
							'label' => esc_html__( 'Post', 'eventchamp-core' ),
							'section' => 'blog',
						),
							array(
								'type' => 'on-off',
								'id' => 'post_post_navigation',
								'label' => esc_html__( 'Post Navigation', 'eventchamp-core' ),
								'section' => 'blog',
								'std' => 'on',
							),
							array(
								'type' => 'on-off',
								'id' => 'post_related_posts',
								'label' => esc_html__( 'Related Posts', 'eventchamp-core' ),
								'section' => 'blog',
								'std' => 'on',
							),
							array(
								'type' => 'numeric-slider',
								'id' => 'post_related_posts_count',
								'label' => esc_html__( 'Related Posts Count', 'eventchamp-core' ),
								'section' => 'blog',
								'std' => '2',
								'min_max_step'=> '1,12,1',
							),
							array(
								'type' => 'numeric-slider',
								'id' => 'post_related_posts_column',
								'label' => esc_html__( 'Related Posts Column', 'eventchamp-core' ),
								'section' => 'blog',
								'std' => '2',
								'min_max_step'=> '1,5,1',
							),
							array(
								'type' => 'select',
								'id' => 'post_related_posts_column_space',
								'label' => esc_html__( 'Related Posts Column Space', 'eventchamp-core' ),
								'section' => 'blog',
								'std' => '30',
								'choices' => array(
									array(
										'label' => esc_html__( '0', 'eventchamp-core' ),
										'value' => '0',
									),
									array(
										'label' => esc_html__( '5', 'eventchamp-core' ),
										'value' => '5',
									),
									array(
										'label' => esc_html__( '10', 'eventchamp-core' ),
										'value' => '10',
									),
									array(
										'label' => esc_html__( '15', 'eventchamp-core' ),
										'value' => '15',
									),
									array(
										'label' => esc_html__( '20', 'eventchamp-core' ),
										'value' => '20',
									),
									array(
										'label' => esc_html__( '25', 'eventchamp-core' ),
										'value' => '25',
									),
									array(
										'label' => esc_html__( '30', 'eventchamp-core' ),
										'value' => '30',
									),
									array(
										'label' => esc_html__( '35', 'eventchamp-core' ),
										'value' => '35',
									),
									array(
										'label' => esc_html__( '40', 'eventchamp-core' ),
										'value' => '40',
									),
									array(
										'label' => esc_html__( '45', 'eventchamp-core' ),
										'value' => '45',
									),
									array(
										'label' => esc_html__( '50', 'eventchamp-core' ),
										'value' => '50',
									),
									array(
										'label' => esc_html__( '55', 'eventchamp-core' ),
										'value' => '55',
									),
									array(
										'label' => esc_html__( '60', 'eventchamp-core' ),
										'value' => '60',
									),
								),
							),
							array(
								'type' => 'on-off',
								'id' => 'post_author_biography',
								'label' => esc_html__( 'Author Biography', 'eventchamp-core' ),
								'section' => 'blog',
								'std' => 'on',
							),
							array(
								'type' => 'on-off',
								'id' => 'post_post_comment_area',
								'label' => esc_html__( 'Comments', 'eventchamp-core' ),
								'section' => 'blog',
								'std' => 'on',
							),
							array(
								'type' => 'on-off',
								'id' => 'post_post_tags',
								'label' => esc_html__( 'Tags', 'eventchamp-core' ),
								'section' => 'blog',
								'std' => 'on',
							),
							array(
								'type' => 'select',
								'id' => 'post-tags-style',
								'label' => esc_html__( 'Tags Style', 'eventchamp-core' ),
								'section' => 'blog',
								'std' => 'style-1',
								'choices' => array(
									array(
										'label' => esc_html__( 'Style 1', 'eventchamp-core' ),
										'value' => 'style-1',
									),
									array(
										'label' => esc_html__( 'Style 2', 'eventchamp-core' ),
										'value' => 'style-2',
									),
									array(
										'label' => esc_html__( 'Style 3', 'eventchamp-core' ),
										'value' => 'style-3',
									),
									array(
										'label' => esc_html__( 'Style 4', 'eventchamp-core' ),
										'value' => 'style-4',
									),
								),
							),
							array(
								'type' => 'on-off',
								'id' => 'post_post_share_buttons',
								'label' => esc_html__( 'Social Sharing', 'eventchamp-core' ),
								'section' => 'blog',
								'std' => 'on',
							),
							array(
								'type' => 'text',
								'id' => 'post-social-share-text',
								'label' => esc_html__( 'Social Sharing Title', 'eventchamp-core' ),
								'desc' => esc_html__( 'Default: Share This Post.', 'eventchamp-core' ),
								'section' => 'blog',
							),
							array(
								'type' => 'select',
								'id' => 'post-social-sharing-style',
								'label' => esc_html__( 'Social Sharing Style', 'eventchamp-core' ),
								'section' => 'blog',
								'std' => 'style-1',
								'choices' => array(
									array(
										'label' => esc_html__( 'Style 1', 'eventchamp-core' ),
										'value' => 'style-1',
									),
									array(
										'label' => esc_html__( 'Style 2', 'eventchamp-core' ),
										'value' => 'style-2',
									),
									array(
										'label' => esc_html__( 'Style 3', 'eventchamp-core' ),
										'value' => 'style-3',
									),
									array(
										'label' => esc_html__( 'Style 4', 'eventchamp-core' ),
										'value' => 'style-4',
									),
									array(
										'label' => esc_html__( 'Style 5', 'eventchamp-core' ),
										'value' => 'style-5',
									),
									array(
										'label' => esc_html__( 'Style 6', 'eventchamp-core' ),
										'value' => 'style-6',
									),
									array(
										'label' => esc_html__( 'Style 7', 'eventchamp-core' ),
										'value' => 'style-7',
									),
								),
							),
						array(
							'type' => 'tab',
							'id' => 'post-tab-header',
							'label' => esc_html__( 'Post Header', 'eventchamp-core' ),
							'section' => 'blog',
						),
							array(
								'type' => 'radio',
								'id' => 'post-header-status',
								'label' => esc_html__( 'Post Header Status', 'eventchamp-core' ),
								'section' => 'blog',
								'std' => 'true',
								'choices' => array(
									array(
										'label' => esc_html__( 'Show', 'eventchamp-core' ),
										'value' => 'true',
									),
									array(
										'label' => esc_html__( 'Hide', 'eventchamp-core' ),
										'value' => 'false',
									),
								),
							),
							array(
								'type' => 'select',
								'id' => 'post-header-style',
								'label' => esc_html__( 'Post Header Style', 'eventchamp-core' ),
								'section' => 'blog',
								'std' => 'image',
								'choices' => array(
									array(
										'label' => esc_html__( 'Image', 'eventchamp-core' ),
										'value' => 'image',
									),
									array(
										'label' => esc_html__( 'Image Slider', 'eventchamp-core' ),
										'value' => 'image-slider',
									),
									array(
										'label' => esc_html__( 'Image Gallery', 'eventchamp-core' ),
										'value' => 'image-gallery',
									),
									array(
										'label' => esc_html__( 'Video', 'eventchamp-core' ),
										'value' => 'video',
									),
									array(
										'label' => esc_html__( 'Audio', 'eventchamp-core' ),
										'value' => 'audio',
									),
									array(
										'label' => esc_html__( 'Code', 'eventchamp-core' ),
										'value' => 'code',
									),
								),
							),
							array(
								'type' => 'numeric-slider',
								'id' => 'post-header-image-slider-column',
								'label' => esc_html__( 'Image Slider Column', 'eventchamp-core' ),
								'desc' => esc_html__( 'Default: 1', 'eventchamp-core' ),
								'section' => 'blog',
								'std' => '1',
								'min_max_step'=> '1,5,1',
							),
							array(
								'type' => 'numeric-slider',
								'id' => 'post-header-image-slider-space',
								'label' => esc_html__( 'Image Slider Space', 'eventchamp-core' ),
								'desc' => esc_html__( 'Default: 0', 'eventchamp-core' ),
								'section' => 'blog',
								'std' => '0',
								'min_max_step'=> '0,50,5',
							),
							array(
								'type' => 'radio',
								'id' => 'post-header-image-slider-loop',
								'label' => esc_html__( 'Image Slider Loop', 'eventchamp-core' ),
								'section' => 'blog',
								'std' => 'true',
								'choices' => array(
									array(
										'label' => esc_html__( 'True', 'eventchamp-core' ),
										'value' => 'true',
									),
									array(
										'label' => esc_html__( 'False', 'eventchamp-core' ),
										'value' => 'false',
									),
								),
							),
							array(
								'type' => 'radio',
								'id' => 'post-header-image-slider-autoplay',
								'label' => esc_html__( 'Image Slider Autoplay', 'eventchamp-core' ),
								'section' => 'blog',
								'std' => 'true',
								'choices' => array(
									array(
										'label' => esc_html__( 'True', 'eventchamp-core' ),
										'value' => 'true',
									),
									array(
										'label' => esc_html__( 'False', 'eventchamp-core' ),
										'value' => 'false',
									),
								),
							),
							array(
								'type' => 'text',
								'id' => 'post-header-image-slider-autoplay-delay',
								'label' => esc_html__( 'Image Slider Autoplay Delay', 'eventchamp-core' ),
								'desc' => esc_html__( 'Default: 15000', 'eventchamp-core' ),
								'section' => 'blog',
							),
							array(
								'type' => 'select',
								'id' => 'post-header-image-slider-direction',
								'label' => esc_html__( 'Image Slider Direction', 'eventchamp-core' ),
								'section' => 'blog',
								'std' => 'horizontal',
								'choices' => array(
									array(
										'label' => esc_html__( 'Horizontal', 'eventchamp-core' ),
										'value' => 'horizontal',
									),
									array(
										'label' => esc_html__( 'Vertical', 'eventchamp-core' ),
										'value' => 'vertical',
									),
								),
							),
							array(
								'type' => 'select',
								'id' => 'post-header-image-slider-effect',
								'label' => esc_html__( 'Image Slider Effect', 'eventchamp-core' ),
								'section' => 'blog',
								'std' => 'slide',
								'choices' => array(
									array(
										'label' => esc_html__( 'Slide', 'eventchamp-core' ),
										'value' => 'slide',
									),
									array(
										'label' => esc_html__( 'Fade', 'eventchamp-core' ),
										'value' => 'fade',
									),
									array(
										'label' => esc_html__( 'Cube', 'eventchamp-core' ),
										'value' => 'cube',
									),
									array(
										'label' => esc_html__( 'Flip', 'eventchamp-core' ),
										'value' => 'flip',
									),
								),
							),
						array(
							'type' => 'tab',
							'id' => 'post-tab-layouts',
							'label' => esc_html__( 'Post Layout', 'eventchamp-core' ),
							'section' => 'blog',
						),
							array(
								'type' => 'radio-image',
								'id' => 'post_sidebar_position',
								'label' => esc_html__( 'Sidebar Position', 'eventchamp-core' ),
								'section' => 'blog',
								'std' => 'right',
							),
							array(
								'type' => 'sidebar-select',
								'id' => 'post_sidebar_select',
								'label' => esc_html__( 'Sidebar', 'eventchamp-core' ),
								'section' => 'blog',
							),
						array(
							'type' => 'tab',
							'id' => 'blog-tab-categories',
							'label' => esc_html__( 'Archives', 'eventchamp-core' ),
							'section' => 'blog',
						),
							array(
								'type' => 'on-off',
								'id' => 'blog-archives-category',
								'label' => esc_html__( 'Category', 'eventchamp-core' ),
								'std' => 'on',
								'section' => 'blog',
							),
							array(
								'type' => 'on-off',
								'id' => 'blog-archives-author',
								'label' => esc_html__( 'Author', 'eventchamp-core' ),
								'std' => 'on',
								'section' => 'blog',
							),
							array(
								'type' => 'on-off',
								'id' => 'blog-archives-date',
								'label' => esc_html__( 'Date', 'eventchamp-core' ),
								'std' => 'on',
								'section' => 'blog',
							),
							array(
								'type' => 'on-off',
								'id' => 'blog-archives-reading-time',
								'label' => esc_html__( 'Reading Time', 'eventchamp-core' ),
								'std' => 'on',
								'section' => 'blog',
							),
							array(
								'type' => 'on-off',
								'id' => 'blog-archives-comments',
								'label' => esc_html__( 'Comments', 'eventchamp-core' ),
								'std' => 'off',
								'section' => 'blog',
							),
							array(
								'type' => 'on-off',
								'id' => 'blog-archives-excerpt',
								'label' => esc_html__( 'Excerpt', 'eventchamp-core' ),
								'std' => 'on',
								'section' => 'blog',
							),
							array(
								'type' => 'on-off',
								'id' => 'blog-archives-read-more',
								'label' => esc_html__( 'Read More', 'eventchamp-core' ),
								'std' => 'on',
								'section' => 'blog',
							),
							array(
								'type' => 'select',
								'id' => 'blog-archives-column-space',
								'label' => esc_html__( 'Post Listing Column Space', 'eventchamp-core' ),
								'section' => 'blog',
								'std' => '30',
								'choices' => array(
									array(
										'label' => esc_html__( '0', 'eventchamp-core' ),
										'value' => '0',
									),
									array(
										'label' => esc_html__( '5', 'eventchamp-core' ),
										'value' => '5',
									),
									array(
										'label' => esc_html__( '10', 'eventchamp-core' ),
										'value' => '10',
									),
									array(
										'label' => esc_html__( '15', 'eventchamp-core' ),
										'value' => '15',
									),
									array(
										'label' => esc_html__( '20', 'eventchamp-core' ),
										'value' => '20',
									),
									array(
										'label' => esc_html__( '25', 'eventchamp-core' ),
										'value' => '25',
									),
									array(
										'label' => esc_html__( '30', 'eventchamp-core' ),
										'value' => '30',
									),
									array(
										'label' => esc_html__( '35', 'eventchamp-core' ),
										'value' => '35',
									),
									array(
										'label' => esc_html__( '40', 'eventchamp-core' ),
										'value' => '40',
									),
									array(
										'label' => esc_html__( '45', 'eventchamp-core' ),
										'value' => '45',
									),
									array(
										'label' => esc_html__( '50', 'eventchamp-core' ),
										'value' => '50',
									),
									array(
										'label' => esc_html__( '55', 'eventchamp-core' ),
										'value' => '55',
									),
									array(
										'label' => esc_html__( '60', 'eventchamp-core' ),
										'value' => '60',
									),
								),
							),
							array(
								'type' => 'radio-image',
								'id' => 'category_sidebar_position',
								'label' => esc_html__( 'Sidebar Position for Categories', 'eventchamp-core' ),
								'section' => 'blog',
								'std' => 'right',
							),
							array(
								'type' => 'sidebar_select_category',
								'id' => 'sidebar_select',
								'label' => esc_html__( 'Sidebar for Categories', 'eventchamp-core' ),
								'section' => 'blog',
							),
							array(
								'type' => 'radio-image',
								'id' => 'blog_category_post_list_style',
								'label' => esc_html__( 'Post Style for Categories', 'eventchamp-core' ),
								'section' => 'blog',
								'std' => 'style1',
							),
							array(
								'type' => 'radio-image',
								'id' => 'tag_sidebar_position',
								'label' => esc_html__( 'Sidebar Position for Tags', 'eventchamp-core' ),
								'section' => 'blog',
								'std' => 'right',
							),
							array(
								'type' => 'sidebar-select',
								'id' => 'tag_sidebar_select',
								'label' => esc_html__( 'Sidebar for Tags', 'eventchamp-core' ),
								'section' => 'blog',
							),
							array(
								'type' => 'radio-image',
								'id' => 'tag_tag_post_list_style',
								'label' => esc_html__( 'Post Style for Tags', 'eventchamp-core' ),
								'section' => 'blog',
								'std' => 'style1',
							),
							array(
								'type' => 'radio-image',
								'id' => 'search_sidebar_position',
								'label' => esc_html__( 'Sidebar Position for Search', 'eventchamp-core' ),
								'section' => 'blog',
								'std' => 'right',
							),
							array(
								'type' => 'sidebar-select',
								'id' => 'search_sidebar_select',
								'label' => esc_html__( 'Sidebar for Search', 'eventchamp-core' ),
								'section' => 'blog',
							),
							array(
								'type' => 'radio-image',
								'id' => 'search_search_post_list_style',
								'label' => esc_html__( 'Post Style for Search', 'eventchamp-core' ),
								'section' => 'blog',
								'std' => 'style1',
							),
							array(
								'type' => 'radio-image',
								'id' => 'archive_sidebar_position',
								'label' => esc_html__( 'Sidebar Position for Archives', 'eventchamp-core' ),
								'section' => 'blog',
								'std' => 'right',
							),
							array(
								'type' => 'sidebar-select',
								'id' => 'archive_sidebar_select',
								'label' => esc_html__( 'Sidebar for Archives', 'eventchamp-core' ),
								'section' => 'blog',
							),
							array(
								'type' => 'radio-image',
								'id' => 'archive_archive_post_list_style',
								'label' => esc_html__( 'Post Style for Archives', 'eventchamp-core' ),
								'section' => 'blog',
								'std' => 'style1',
							),
						array(
							'type' => 'tab',
							'id' => 'blog-tab-attachments',
							'label' => esc_html__( 'Attachments', 'eventchamp-core' ),
							'section' => 'blog',
						),
							array(
								'type' => 'on-off',
								'id' => 'attachment_comment_area',
								'label' => esc_html__( 'Comments', 'eventchamp-core' ),
								'section' => 'blog',
								'std' => 'on',
							),
							array(
								'type' => 'radio-image',
								'id' => 'attachment_sidebar_position',
								'label' => esc_html__( 'Sidebar Position', 'eventchamp-core' ),
								'section' => 'blog',
								'std' => 'nosidebar',
							),
							array(
								'type' => 'sidebar-select',
								'id' => 'attachment_sidebar_select',
								'label' => esc_html__( 'Sidebar', 'eventchamp-core' ),
								'section' => 'blog',
							),

					/*====== Color ======*/
						array(
							'type' => 'tab',
							'id' => 'color-tab-general',
							'label' => esc_html__( 'General', 'eventchamp-core' ),
							'section' => 'colors',
						),
							array(
								'type' => 'on-off',
								'id' => 'dark-skin',
								'label' => esc_html__( 'Dark Skin', 'eventchamp-core' ),
								'section' => 'colors',
								'std' => 'off',
							),
							array(
								'type' => 'colorpicker',
								'id' => 'theme_main_color',
								'label' => esc_html__( 'Primary Color', 'eventchamp-core' ),
								'desc' => esc_html__( 'By setting a color here, all of your elements will use this color instead of default yellow color.', 'eventchamp-core' ),
								'std' => '#ffbb00',
								'section' => 'colors',
							),
							array(
								'type' => 'colorpicker',
								'id' => 'theme_alternative_color',
								'label' => esc_html__( 'Secondary Color', 'eventchamp-core' ),
								'desc' => esc_html__( 'By setting a color here, all of your elements will use this color instead of default purple color.', 'eventchamp-core' ),
								'std' => '#6600ff',
								'section' => 'colors',
							),
							array(
								'type' => 'background',
								'id' => 'body_background',
								'label' => esc_html__( 'Body Background ', 'eventchamp-core' ),
								'section' => 'colors',
							),
							array(
								'type' => 'background',
								'id' => 'wrapper_background',
								'label' => esc_html__( 'Wrapper Background', 'eventchamp-core' ),
								'section' => 'colors',
							),
							array(
								'type' => 'colorpicker',
								'id' => 'box_layouts_bg',
								'label' => esc_html__( 'Box Layout Background', 'eventchamp-core' ),
								'section' => 'colors',
							),
							array(
								'type' => 'css',
								'id' => 'theme_gradient',
								'label' => esc_html__( 'Gradient Background', 'eventchamp-core' ),
								'desc' => sprintf( esc_html__( 'This gradient background is used in some theme elements. For example on the info box. You can create a gradient background via online tools and enter the code in this field. You can use %s website for the gradient generator.', 'luxe-core' ), '<a target="_blank" href="' . esc_url( 'https://cssgradient.io/' ) . '">' . esc_html__( 'cssgradient.io', 'eventchamp-core' ) . '</a>' ),
								'section' => 'colors',
							),
							array(
								'type' => 'colorpicker',
								'id' => 'link_color',
								'label' => esc_html__( 'Link Color', 'eventchamp-core' ),
								'section' => 'colors',
							),
							array(
								'type' => 'colorpicker',
								'id' => 'link_hover_color',
								'label' => esc_html__( 'Link Hover Color', 'eventchamp-core' ),
								'section' => 'colors',
							),
							array(
								'type' => 'colorpicker',
								'id' => 'heading_color',
								'label' => esc_html__( 'Heading Color', 'eventchamp-core' ),
								'desc' => esc_html__( 'This setting for H1, H2, H3, H4, H5 and H6 tags.', 'eventchamp-core' ),
								'section' => 'colors',
							),
						array(
							'type' => 'tab',
							'id' => 'color-tab-footer',
							'label' => esc_html__( 'Footer', 'eventchamp-core' ),
							'section' => 'colors',
						),
							array(
								'type' => 'colorpicker',
								'id' => 'footer_style_1_background',
								'label' => esc_html__( 'Background Color for Style 1', 'eventchamp-core' ),
								'section' => 'colors'
							),
							array(
								'type' => 'colorpicker',
								'id' => 'footer_style_1_text_color',
								'label' => esc_html__( 'Text Color for Style 1', 'eventchamp-core' ),
								'section' => 'colors',
							),
							array(
								'type' => 'colorpicker',
								'id' => 'footer_style_1_link_color',
								'label' => esc_html__( 'Link Color for Style 1', 'eventchamp-core' ),
								'section' => 'colors',
							),
							array(
								'type' => 'colorpicker',
								'id' => 'footer_style_1_link_hover_color',
								'label' => esc_html__( 'Link Hover Color for Style 1', 'eventchamp-core' ),
								'section' => 'colors',
							),
							array(
								'type' => 'colorpicker',
								'id' => 'footer_style_1_copyright_text_color',
								'label' => esc_html__( 'Copyright Color for Style 1', 'eventchamp-core' ),
								'section' => 'colors',
							),
							array(
								'type' => 'colorpicker',
								'id' => 'footer_style_2_background',
								'label' => esc_html__( 'Background Color for Style 2', 'eventchamp-core' ),
								'section' => 'colors'
							),
							array(
								'type' => 'colorpicker',
								'id' => 'footer_style_2_text_color',
								'label' => esc_html__( 'Text Color for Style 2', 'eventchamp-core' ),
								'section' => 'colors',
							),
							array(
								'type' => 'colorpicker',
								'id' => 'footer_style_2_link_color',
								'label' => esc_html__( 'Link Color for Style 2', 'eventchamp-core' ),
								'section' => 'colors',
							),
							array(
								'type' => 'colorpicker',
								'id' => 'footer_style_2_link_hover_color',
								'label' => esc_html__( 'Link Hover Color for Style 2', 'eventchamp-core' ),
								'section' => 'colors',
							),
							array(
								'type' => 'colorpicker',
								'id' => 'footer_style_2_copyright_text_color',
								'label' => esc_html__( 'Copyright Color for Style 2', 'eventchamp-core' ),
								'section' => 'colors',
							),
						array(
							'type' => 'tab',
							'id' => 'color-tab-header',
							'label' => esc_html__( 'Header', 'eventchamp-core' ),
							'section' => 'colors',
						),
							array(
								'type' => 'background',
								'id' => 'header_style_1_background_color',
								'label' => esc_html__( 'Background for Style 1', 'eventchamp-core' ),
								'section' => 'colors',
							),
							array(
								'type' => 'colorpicker',
								'id' => 'header_style_1_link_color',
								'label' => esc_html__( 'Link Color for Style 1', 'eventchamp-core' ),
								'section' => 'colors',
							),
							array(
								'type' => 'colorpicker',
								'id' => 'header_style_1_link_hover_color',
								'label' => esc_html__( 'Link Hover Color for Style 1', 'eventchamp-core' ),
								'section' => 'colors',
							),
							array(
								'type' => 'colorpicker',
								'id' => 'header_style_1_social_links_color',
								'label' => esc_html__( 'Social Links Color for Style 1', 'eventchamp-core' ),
								'section' => 'colors',
							),
							array(
								'type' => 'colorpicker',
								'id' => 'header_style_1_social_links_hover_color',
								'label' => esc_html__( 'Social Links Hover Color for Style 1', 'eventchamp-core' ),
								'section' => 'colors',
							),
							array(
								'type' => 'background',
								'id' => 'header_style_2_background_color',
								'label' => esc_html__( 'Background for Style 2', 'eventchamp-core' ),
								'section' => 'colors',
							),
							array(
								'type' => 'colorpicker',
								'id' => 'header_style_2_link_color',
								'label' => esc_html__( 'Link Color for Style 2', 'eventchamp-core' ),
								'section' => 'colors',
							),
							array(
								'type' => 'colorpicker',
								'id' => 'header_style_2_link_hover_color',
								'label' => esc_html__( 'Link Hover Color for Style 2', 'eventchamp-core' ),
								'section' => 'colors',
							),
							array(
								'type' => 'colorpicker',
								'id' => 'header_style_2_social_links_color',
								'label' => esc_html__( 'Social Links Color for Style 2', 'eventchamp-core' ),
								'section' => 'colors',
							),
							array(
								'type' => 'colorpicker',
								'id' => 'header_style_2_social_links_hover_color',
								'label' => esc_html__( 'Social Links Hover Color for Style 2', 'eventchamp-core' ),
								'section' => 'colors',
							),
							array(
								'type' => 'background',
								'id' => 'header_style_3_background_color',
								'label' => esc_html__( 'Background for Style 3', 'eventchamp-core' ),
								'section' => 'colors',
							),
							array(
								'type' => 'colorpicker',
								'id' => 'header_style_3_link_color',
								'label' => esc_html__( 'Link Color for Style 3', 'eventchamp-core' ),
								'section' => 'colors',
							),
							array(
								'type' => 'colorpicker',
								'id' => 'header_style_3_link_hover_color',
								'label' => esc_html__( 'Link Hover Color for Style 3', 'eventchamp-core' ),
								'section' => 'colors',
							),
							array(
								'type' => 'colorpicker',
								'id' => 'header_style_3_social_links_color',
								'label' => esc_html__( 'Social Links Color for Style 3', 'eventchamp-core' ),
								'section' => 'colors',
							),
							array(
								'type' => 'colorpicker',
								'id' => 'header_style_3_social_links_hover_color',
								'label' => esc_html__( 'Social Links Hover Color for Style 3', 'eventchamp-core' ),
								'section' => 'colors',
							),
							array(
								'type' => 'background',
								'id' => 'header_style_4_background_color',
								'label' => esc_html__( 'Background for Style 4', 'eventchamp-core' ),
								'section' => 'colors',
							),
							array(
								'type' => 'colorpicker',
								'id' => 'header_style_4_link_color',
								'label' => esc_html__( 'Link Color for Style 4', 'eventchamp-core' ),
								'section' => 'colors',
							),
							array(
								'type' => 'colorpicker',
								'id' => 'header_style_4_link_hover_color',
								'label' => esc_html__( 'Link Hover Color for Style 4', 'eventchamp-core' ),
								'section' => 'colors',
							),
							array(
								'type' => 'colorpicker',
								'id' => 'header_style_4_social_links_color',
								'label' => esc_html__( 'Social Links Color for Style 4', 'eventchamp-core' ),
								'section' => 'colors',
							),
							array(
								'type' => 'colorpicker',
								'id' => 'header_style_4_social_links_hover_color',
								'label' => esc_html__( 'Social Links Hover Color for Hder Style 4', 'eventchamp-core' ),
								'section' => 'colors',
							),
							array(
								'type' => 'background',
								'id' => 'header_style_5_background_color',
								'label' => esc_html__( 'Background for Style 5', 'eventchamp-core' ),
								'section' => 'colors',
							),
							array(
								'type' => 'colorpicker',
								'id' => 'header_style_5_link_color',
								'label' => esc_html__( 'Link Color for Style 5', 'eventchamp-core' ),
								'section' => 'colors',
							),
							array(
								'type' => 'colorpicker',
								'id' => 'header_style_5_link_hover_color',
								'label' => esc_html__( 'Link Hover Color for Style 5', 'eventchamp-core' ),
								'section' => 'colors',
							),
							array(
								'type' => 'colorpicker',
								'id' => 'header_style_5_social_links_color',
								'label' => esc_html__( 'Social Links Color for Style 5', 'eventchamp-core' ),
								'section' => 'colors',
							),
							array(
								'type' => 'colorpicker',
								'id' => 'header_style_5_social_links_hover_color',
								'label' => esc_html__( 'Social Links Hover Color for Style 5', 'eventchamp-core' ),
								'section' => 'colors',
							),
							array(
								'type' => 'background',
								'id' => 'header_style_6_background_color',
								'label' => esc_html__( 'Background for Style 6', 'eventchamp-core' ),
								'section' => 'colors',
							),
							array(
								'type' => 'colorpicker',
								'id' => 'header_style_6_link_color',
								'label' => esc_html__( 'Link Color for Style 6', 'eventchamp-core' ),
								'section' => 'colors',
							),
							array(
								'type' => 'colorpicker',
								'id' => 'header_style_6_link_hover_color',
								'label' => esc_html__( 'Link Hover Color for Style 6', 'eventchamp-core' ),
								'section' => 'colors',
							),
							array(
								'type' => 'colorpicker',
								'id' => 'header_style_6_social_links_color',
								'label' => esc_html__( 'Social Links Color for Style 6', 'eventchamp-core' ),
								'section' => 'colors',
							),
							array(
								'type' => 'colorpicker',
								'id' => 'header_style_6_social_links_hover_color',
								'label' => esc_html__( 'Social Links Hover Color for Style 6', 'eventchamp-core' ),
								'section' => 'colors',
							),
							array(
								'type' => 'background',
								'id' => 'sticky_header_background',
								'label' => esc_html__( 'Background for Sticky Header', 'eventchamp-core' ),
								'section' => 'colors',
							),
							array(
								'type' => 'colorpicker',
								'id' => 'sticky_header_link_color',
								'label' => esc_html__( 'Link Color for Sticky Header', 'eventchamp-core' ),
								'section' => 'colors',
							),
							array(
								'type' => 'colorpicker',
								'id' => 'sticky_header_link_hover_color',
								'label' => esc_html__( 'Link Hover Color for Sticky Header', 'eventchamp-core' ),
								'section' => 'colors',
							),
							array(
								'type' => 'colorpicker',
								'id' => 'sticky_header_social_links_color',
								'label' => esc_html__( 'Social Links Color for Sticky Header', 'eventchamp-core' ),
								'section' => 'colors',
							),
							array(
								'type' => 'colorpicker',
								'id' => 'sticky_header_social_links_hover_color',
								'label' => esc_html__( 'Social Links Hover Color for Sticky Header', 'eventchamp-core' ),
								'section' => 'colors',
							),
						array(
							'type' => 'tab',
							'id' => 'color-tab-form',
							'label' => esc_html__( 'Form', 'eventchamp-core' ),
							'section' => 'colors',
						),
							array(
								'type' => 'colorpicker',
								'id' => 'input_border_color',
								'label' => esc_html__( 'Input Border Color', 'eventchamp-core' ),
								'section' => 'colors',
							),
							array(
								'type' => 'colorpicker',
								'id' => 'input_background_color',
								'label' => esc_html__( 'Input Background Color', 'eventchamp-core' ),
								'section' => 'colors',
							),
							array(
								'type' => 'colorpicker',
								'id' => 'input_text_color',
								'label' => esc_html__( 'Input Text Color', 'eventchamp-core' ),
								'section' => 'colors',
							),
							array(
								'type' => 'colorpicker',
								'id' => 'input_placeholder_color',
								'label' => esc_html__( 'Input Placeholder Color', 'eventchamp-core' ),
								'section' => 'colors',
							),
							array(
								'type' => 'colorpicker',
								'id' => 'button_background_color',
								'label' => esc_html__( 'Button Background Color', 'eventchamp-core' ),
								'section' => 'colors',
							),
							array(
								'type' => 'colorpicker',
								'id' => 'button_text_color',
								'label' => esc_html__( 'Button Text Color', 'eventchamp-core' ),
								'section' => 'colors',
							),
							array(
								'type' => 'colorpicker',
								'id' => 'button_hover_background_color',
								'label' => esc_html__( 'Button Hover Background Color', 'eventchamp-core' ),
								'section' => 'colors',
							),
							array(
								'type' => 'colorpicker',
								'id' => 'button_hover_text_color',
								'label' => esc_html__( 'Button Hover Text Color', 'eventchamp-core' ),
								'section' => 'colors',
							),
						array(
							'type' => 'tab',
							'id' => 'color-tab-widgets',
							'label' => esc_html__( 'Widgets', 'eventchamp-core' ),
							'section' => 'colors',
						),
							array(
								'type' => 'colorpicker',
								'id' => 'sidebar_widget_background_color',
								'label' => esc_html__( 'Widgets Background Color', 'eventchamp-core' ),
								'section' => 'colors',
							),
							array(
								'type' => 'colorpicker',
								'id' => 'sidebar_widget_title_color',
								'label' => esc_html__( 'Widgets Title Color', 'eventchamp-core' ),
								'section' => 'colors',
							),
							array(
								'type' => 'colorpicker',
								'id' => 'sidebar_widget_title_border_color',
								'label' => esc_html__( 'Widgets Title Border Color', 'eventchamp-core' ),
								'section' => 'colors',
							),

					/*====== Layout ======*/
						array(
							'type' => 'on-off',
							'id' => 'eventchamp_boxed',
							'label' => esc_html__( 'Boxed Wrapper', 'eventchamp-core' ),
							'section' => 'layout',
							'std' => 'off',
						),
						array(
							'type' => 'on-off',
							'id' => 'eventchamp_box_layout',
							'label' => esc_html__( 'Box Layout', 'eventchamp-core' ),
							'desc' => esc_html__( 'If you do not want to use the box layout, choose off.', 'eventchamp-core' ),
							'section' => 'layout',
							'std' => 'on',
						),
						array(
							'type' => 'on-off',
							'id' => 'eventchamp-responsive',
							'label' => esc_html__( 'Responsive', 'eventchamp-core' ),
							'section' => 'layout',
							'std' => 'on',
						),
						array(
							'type' => 'on-off',
							'id' => 'sticky-sidebar',
							'label' => esc_html__( 'Sticky Sidebar', 'eventchamp-core' ),
							'section' => 'layout',
							'std' => 'off',
						),
						array(
							'type' => 'radio-image',
							'id' => 'sidebar_position',
							'label' => esc_html__( 'Default Sidebar Position', 'eventchamp-core' ),
							'section' => 'layout',
							'std' => 'right',
						),
						array(
							'type' => 'list-item',
							'id' => 'custom_sidebars',
							'label' => esc_html__( 'Create Sidebar', 'eventchamp-core' ),
							'section' => 'layout',
							'settings' => array(
								array(
									'type' => 'text',
									'id' => 'id',
									'label' => esc_html__( 'Sidebar ID', 'eventchamp-core' ),
									'desc' => esc_html__( 'Please write a lowercase and unique id, with no spaces. Example: new-sidebar', 'eventchamp-core' ),
								)
							)
						),

					/*====== Page Title Bar ======*/
						array(
							'type' => 'on-off',
							'id' => 'page_title_bar',
							'label' => esc_html__( 'Page Title Bar', 'eventchamp-core' ),
							'section' => 'page-title-bar',
							'std' => 'on',
						),
						array(
							'type' => 'on-off',
							'id' => 'page_title_bar_breadcrumbs',
							'label' => esc_html__( 'Breadcrumbs', 'eventchamp-core' ),
							'section' => 'page-title-bar',
							'std' => 'on',
						),
						array(
							'type' => 'background',
							'id' => 'page_title_background',
							'label' => esc_html__( 'Background', 'eventchamp-core' ),
							'desc' => esc_html__( 'Recommended background image size: 1920x350', 'eventchamp-core' ),
							'section' => 'page-title-bar',
						),
						array(
							'type' => 'numeric-slider',
							'id' => 'page_title_background_opacity',
							'label' => esc_html__( 'Background Opacity', 'eventchamp-core' ),
							'desc' => esc_html__( 'Default: 0.25', 'eventchamp-core' ),
							'section' => 'page-title-bar',
							'min_max_step'=> '0,1,0.01',
							'std' => '0.25'
						),
						array(
							'type' => 'text',
							'id' => 'page_title_bar_top_padding',
							'label' => esc_html__( 'Top Padding', 'eventchamp-core' ),
							'desc' => esc_html__( 'Example: 150px', 'eventchamp-core' ),
							'section' => 'page-title-bar',
						),
						array(
							'type' => 'text',
							'id' => 'page_title_bar_bottom_padding',
							'label' => esc_html__( 'Bottom Padding', 'eventchamp-core' ),
							'desc' => esc_html__( 'Example: 150px', 'eventchamp-core' ),
							'section' => 'page-title-bar',
						),

					/*====== User Box ======*/
						array(
							'type' => 'tab',
							'id' => 'user-box-tab-general',
							'label' => esc_html__( 'General', 'eventchamp-core' ),
							'section' => 'user-box',
						),
							array(
								'type' => 'on-off',
								'id' => 'header_user_box',
								'label' => esc_html__( 'User Box', 'eventchamp-core' ),
								'section' => 'user-box',
								'std' => 'on',
							),
							array(
								'type' => 'on-off',
								'id' => 'header_user_box_register_notice',
								'label' => esc_html__( 'Sign Up Notice', 'eventchamp-core' ),
								'section' => 'user-box',
								'std' => 'on'
							),
							array(
								'type' => 'textarea',
								'id' => 'header_user_box_register_notice_text',
								'label' => esc_html__( 'Sign Up Notice Text', 'eventchamp-core' ),
								'desc' => esc_html__( 'If you enter any text, default text will be hide.', 'eventchamp-core' ),
								'section' => 'user-box',
							),
							array(
								'type' => 'page-select',
								'id' => 'page_terms_and_conditions',
								'label' => esc_html__( 'Terms and Conditions Page', 'eventchamp-core' ),
								'section' => 'user-box',
							),
							array(
								'type' => 'page-select',
								'id' => 'page_privacy_policy',
								'label' => esc_html__( 'Privacy Policy Page', 'eventchamp-core' ),
								'section' => 'user-box',
							),
							array(
								'type' => 'on-off',
								'id' => 'eventchamp_social_login',
								'label' => esc_html__( 'Social Login', 'eventchamp-core' ),
								'section' => 'user-box',
								'std' => 'off',
							),
							array(
								'type' => 'text',
								'id' => 'eventchamp_social_login_shortcode',
								'label' => esc_html__( 'Social Login Shortcode', 'eventchamp-core' ),
								'desc' => esc_html__( 'Enter the shortcode of the social login plugin you are using. You can use/install any WordPress social login plugin for this.', 'eventchamp-core' ),
								'section' => 'user-box',
								'condition' => 'eventchamp_social_login:is(on)',
							),
						array(
							'type' => 'tab',
							'id' => 'user-box-tab-buttons-links',
							'label' => esc_html__( 'Buttons & Links', 'eventchamp-core' ),
							'section' => 'user-box',
						),
							array(
								'type' => 'on-off',
								'id' => 'header_user_box_login_button',
								'label' => esc_html__( 'Login Button', 'eventchamp-core' ),
								'section' => 'user-box',
								'std' => 'on',
							),
							array(
								'type' => 'text',
								'id' => 'header_user_box_custom_login',
								'label' => esc_html__( 'Custom Login Link', 'eventchamp-core' ),
								'desc' => esc_html__( 'If you enter blank, the default WordPress login page opens by default.', 'eventchamp-core' ),
								'section' => 'user-box',
							),
							array(
								'type' => 'on-off',
								'id' => 'header_user_box_register_button',
								'label' => esc_html__( 'Register Button', 'eventchamp-core' ),
								'section' => 'user-box',
								'std' => 'on',
							),
							array(
								'type' => 'text',
								'id' => 'header_user_box_custom_register',
								'label' => esc_html__( 'Custom Register Link', 'eventchamp-core' ),
								'desc' => esc_html__( 'If you enter blank, the default WordPress register page opens by default.', 'eventchamp-core' ),
								'section' => 'user-box',
							),
							array(
								'type' => 'on-off',
								'id' => 'header_user_box_reset_password_button',
								'label' => esc_html__( 'Reset Password Button', 'eventchamp-core' ),
								'section' => 'user-box',
								'std' => 'on',
							),
							array(
								'type' => 'text',
								'id' => 'header_user_box_custom_password',
								'label' => esc_html__( 'Custom Reset Password Link', 'eventchamp-core' ),
								'desc' => esc_html__( 'If you enter blank, the default WordPress reset password page opens by default.', 'eventchamp-core' ),
								'section' => 'user-box',
							),
							array(
								'type' => 'on-off',
								'id' => 'header_user_box_profile_button',
								'label' => esc_html__( 'Profile Button', 'eventchamp-core' ),
								'section' => 'user-box',
								'std' => 'on',
							),
							array(
								'type' => 'text',
								'id' => 'header_user_box_custom_profile',
								'label' => esc_html__( 'Custom Profile Link', 'eventchamp-core' ),
								'desc' => esc_html__( 'If you enter blank, the default WordPress profile page opens by default.', 'eventchamp-core' ),
								'section' => 'user-box',
							),
							array(
								'type' => 'on-off',
								'id' => 'header_user_box_my_tickets_button',
								'label' => esc_html__( 'My Tickets Button', 'eventchamp-core' ),
								'section' => 'user-box',
								'std' => 'on',
							),
							array(
								'type' => 'text',
								'id' => 'header_user_box_custom_tickets',
								'label' => esc_html__( 'Custom My Tickets Link', 'eventchamp-core' ),
								'desc' => esc_html__( 'If you enter blank, the WooCommerce order page opens by default.', 'eventchamp-core' ),
								'section' => 'user-box',
							),
							array(
								'type' => 'on-off',
								'id' => 'header_user_box_logout_button',
								'label' => esc_html__( 'Log Out Button', 'eventchamp-core' ),
								'section' => 'user-box',
								'std' => 'on',
							),
							array(
								'type' => 'text',
								'id' => 'header_user_box_custom_logout',
								'label' => esc_html__( 'Custom Log Out Link', 'eventchamp-core' ),
								'section' => 'user-box',
							),
							array(
								'type' => 'select',
								'id' => 'header_custom_user_box_position',
								'label' => esc_html__( 'Custom User Box Position', 'eventchamp-core' ),
								'section' => 'user-box',
								'std' => 'before-log-out',
								'choices' => array(
									array(
										'label' => esc_html__( 'Before the Log Out / Before the Register', 'eventchamp-core' ),
										'value' => 'before-log-out',
									),
									array(
										'label' => esc_html__( 'After the Profile / After the Login', 'eventchamp-core' ),
										'value' => 'after-profile',
									),
									array(
										'label' => esc_html__( 'Before Available Links', 'eventchamp-core' ),
										'value' => 'before-content',
									),
									array(
										'label' => esc_html__( 'After Available Links', 'eventchamp-core' ),
										'value' => 'after-content',
									),
								),
							),
							array(
								'type' => 'list-item',
								'id' => 'header_user_box_custom_links',
								'label' => esc_html__( 'Custom User Box Links', 'eventchamp-core' ),
								'section' => 'user-box',
								'settings' => array(
									array(
										'type' => 'text',
										'id' => 'link',
										'label' => esc_html__( 'Link', 'eventchamp-core' ),
									),
									array(
										'type' => 'on-off',
										'id' => 'only-members',
										'label' => esc_html__( 'Only for Members', 'eventchamp-core' ),
										'std' => 'off',
									),
									array(
										'type' => 'radio',
										'id' => 'target',
										'label' => esc_html__( 'Target', 'eventchamp-core' ),
										'std' => '_self',
										'choices' => array(
											array(
												'label' => esc_html__( 'Self', 'eventchamp-core' ),
												'value' => '_self',
											),
											array(
												'label' => esc_html__( 'Blank', 'eventchamp-core' ),
												'value' => '_blank',
											),
										),
									),
								)
							),
						array(
							'type' => 'tab',
							'id' => 'user-box-tab-language-switcher',
							'label' => esc_html__( 'Language Switcher', 'eventchamp-core' ),
							'section' => 'user-box',
						),
							array(
								'type' => 'on-off',
								'id' => 'header_user_box_language',
								'label' => esc_html__( 'Language Switcher', 'eventchamp-core' ),
								'section' => 'user-box',
								'std' => 'on',
							),
							array(
								'type' => 'select',
								'id' => 'header_user_box_language_position',
								'label' => esc_html__( 'Language Switcher Position', 'eventchamp-core' ),
								'section' => 'user-box',
								'std' => 'before-log-out',
								'choices' => array(
									array(
										'label' => esc_html__( 'Before the Log Out', 'eventchamp-core' ),
										'value' => 'before-log-out',
									),
									array(
										'label' => esc_html__( 'After the Profile', 'eventchamp-core' ),
										'value' => 'after-profile',
									),
									array(
										'label' => esc_html__( 'Before Available Links', 'eventchamp-core' ),
										'value' => 'before-content',
									),
									array(
										'label' => esc_html__( 'After Available Links', 'eventchamp-core' ),
										'value' => 'after-content',
									),
								),
							),
							array(
								'type' => 'on-off',
								'id' => 'header_user_box_language_flag',
								'label' => esc_html__( 'Flag on the Language Switcher', 'eventchamp-core' ),
								'section' => 'user-box',
								'std' => 'off',
							),
							array(
								'type' => 'on-off',
								'id' => 'header_user_box_language_flag_dropdown',
								'label' => esc_html__( 'Flag on the Language Switcher Dropdown', 'eventchamp-core' ),
								'section' => 'user-box',
								'std' => 'on',
							),
							array(
								'type' => 'select',
								'id' => 'header_user_box_language_name_type',
								'label' => esc_html__( 'Language Switcher Name Type', 'eventchamp-core' ),
								'section' => 'user-box',
								'std' => 'full-name',
								'choices' => array(
									array(
										'label' => esc_html__( 'Full Name', 'eventchamp-core' ),
										'value' => 'full-name',
									),
									array(
										'label' => esc_html__( 'Short Name', 'eventchamp-core' ),
										'value' => 'short-name',
									),
								),
							),

					/*====== Cookie Bar ======*/
						array(
							'type' => 'on-off',
							'id' => 'cookie-bar',
							'label' => esc_html__( 'Cookie Bar', 'eventchamp-core' ),
							'section' => 'cookie-bar',
							'std' => 'on',
						),
						array(
							'type' => 'select',
							'id' => 'cookie-bar-style',
							'label' => esc_html__( 'Cookie Bar Style', 'eventchamp-core' ),
							'section' => 'cookie-bar',
							'std' => 'style-1',
							'choices' => array(
								array(
									'label' => esc_html__( 'Style 1', 'eventchamp-core' ),
									'value' => 'style-1'
								),
								array(
									'label' => esc_html__( 'Style 2', 'eventchamp-core' ),
									'value' => 'style-2'
								),
								array(
									'label' => esc_html__( 'Style 3', 'eventchamp-core' ),
									'value' => 'style-3'
								),
								array(
									'label' => esc_html__( 'Style 4', 'eventchamp-core' ),
									'value' => 'style-4'
								),
							),
						),
						array(
							'type' => 'textarea',
							'id' => 'cookie-bar-text',
							'label' => esc_html__( 'Cookie Bar Description Text', 'eventchamp-core' ),
							'section' => 'cookie-bar',
						),
						array(
							'type' => 'text',
							'id' => 'cookie-bar-button-text',
							'label' => esc_html__( 'Cookie Bar Button Text', 'eventchamp-core' ),
							'desc' => esc_html__( 'Default: I Accept', 'eventchamp-core' ),
							'section' => 'cookie-bar',
						),
						array(
							'type' => 'text',
							'id' => 'cookie-bar-time',
							'label' => esc_html__( 'Cookie Bar Time', 'eventchamp-core' ),
							'desc' => esc_html__( 'This time is a day. Default: 15', 'eventchamp-core' ),
							'section' => 'cookie-bar',
						),

					/*====== Extra ======*/
						array(
							'type' => 'tab',
							'id' => 'extra-miscellaneous',
							'label' => esc_html__( 'Miscellaneous', 'eventchamp-core' ),
							'section' => 'extra',
						),
							array(
								'type' => 'on-off',
								'id' => 'rtl',
								'label' => esc_html__( 'RTL', 'eventchamp-core' ),
								'section' => 'extra',
								'std' => 'off',
							),
							array(
								'type' => 'text',
								'id' => 'googlemapapi',
								'label' => esc_html__( 'Google Maps API', 'eventchamp-core' ),
								'section' => 'extra',
							),
							array(
								'type' => 'on-off',
								'id' => 'lazy-load',
								'label' => esc_html__( 'Lazy Load', 'eventchamp-core' ),
								'desc' => esc_html__( 'LazyLoad is a lightweight (2.4 kB) and flexible script that speeds up your web application by deferring the loading of your below-the-fold images, videos and iframes to when they will enter the viewport.', 'eventchamp-core' ) . sprintf( esc_html__( 'Using the %s library.', 'luxe-core' ), '<a target="_blank" href="' . esc_url( 'https://github.com/verlok/vanilla-lazyload' ) . '">' . esc_html__( 'verlok/vanilla-lazyload', 'eventchamp-core' ) . '</a>' ),
								'section' => 'extra',
								'std' => 'off',
							),
							array(
								'type' => 'on-off',
								'id' => 'instantclick',
								'label' => esc_html__( 'InstantClick', 'eventchamp-core' ),
								'desc' => esc_html__( 'InstantClick is a JavaScript library that dramatically speeds up your website, making navigation effectively instant in most cases. Before visitors click on a link, they hover over that link. Between these two events, 200 ms to 300 ms usually pass by (test yourself here). InstantClick makes use of that time to preload the page, so that the page is already there when you click.', 'eventchamp-core' ),
								'section' => 'extra',
								'std' => 'off',
							),
							array(
								'type' => 'radio',
								'id' => 'pagination-style',
								'label' => esc_html__( 'Pagination Style', 'eventchamp-core' ),
								'section' => 'extra',
								'std' => '1',
								'choices' => array(
									array(
										'label' => esc_html__( 'Next and Previous Links', 'eventchamp-core' ),
										'value' => '1'
									),
									array(
										'label' => esc_html__( 'Number Links', 'eventchamp-core' ),
										'value' => '2'
									),
								),
							),
							array(
								'type' => 'numeric-slider',
								'id' => 'event-excerpt-length',
								'label' => esc_html__( 'Excerpt Length', 'eventchamp-core' ),
								'section' => 'extra',
								'std' => '40',
								'min_max_step'=> '1,500,1',
							),
						array(
							'type' => 'tab',
							'id' => 'extra-datepicker',
							'label' => esc_html__( 'Datepicker', 'eventchamp-core' ),
							'section' => 'extra',
						),
							array(
								'label' => esc_html__( 'Date Format', 'eventchamp-core' ),
								'id' => 'datepicker_date_format',
								'type' => 'text',
								'std' => 'MM dd, yy',
								'desc' => esc_html__( 'Default: MM dd, yy. Date formats: https://goo.gl/jU7msW', 'eventchamp-core' ),
								'section' => 'extra',
							),
							array(
								'label' => esc_html__( 'Other Months', 'eventchamp-core' ),
								'id' => 'datepicker_other_months',
								'type' => 'on-off',
								'std' => 'on',
								'section' => 'extra',
							),
							array(
								'label' => esc_html__( 'Apply Button', 'eventchamp-core' ),
								'id' => 'datepicker_apply_button',
								'type' => 'on-off',
								'std' => 'on',
								'section' => 'extra',
							),
							array(
								'type' => 'select',
								'id' => 'datepicker_first_day',
								'label' => esc_html__( 'First Day', 'eventchamp-core' ),
								'desc' => esc_html__( 'Sunday is 0, Monday is 1, etc.', 'eventchamp-core' ),
								'section' => 'extra',
								'std' => '1',
								'choices' => array(
									array(
										'label' => '0',
										'value' => '0'
									),
									array(
										'label' => '1',
										'value' => '1'
									),
									array(
										'label' => '2',
										'value' => '2'
									),
									array(
										'label' => '3',
										'value' => '3'
									),
									array(
										'label' => '4',
										'value' => '4'
									),
									array(
										'label' => '5',
										'value' => '5'
									),
									array(
										'label' => '6',
										'value' => '6'
									),
									array(
										'label' => '7',
										'value' => '7'
									),
								),
							),
							array(
								'type' => 'select',
								'id' => 'datepicker_duration',
								'label' => esc_html__( 'Duration', 'eventchamp-core' ),
								'section' => 'extra',
								'std' => 'normal',
								'choices' => array(
									array(
										'label' => esc_html__( 'Slow', 'eventchamp-core' ),
										'value' => 'slow',
									),
									array(
										'label' => esc_html__( 'Normal', 'eventchamp-core' ),
										'value' => 'normal',
									),
									array(
										'label' => esc_html__( 'Fast', 'eventchamp-core' ),
										'value' => 'fast',
									),
								),
							),
						array(
							'type' => 'tab',
							'id' => 'extra-fancybox',
							'label' => esc_html__( 'Fancybox', 'eventchamp-core' ),
							'section' => 'extra',
						),
							array(
								'type' => 'on-off',
								'id' => 'fancybox',
								'label' => esc_html__( 'Fancybox', 'eventchamp-core' ),
								'section' => 'extra',
								'std' => 'on',
							),
							array(
								'type' => 'radio',
								'id' => 'fancybox-loop',
								'label' => esc_html__( 'Loop', 'eventchamp-core' ),
								'section' => 'extra',
								'std' => 'true',
								'choices' => array(
									array(
										'label' => esc_html__( 'True', 'eventchamp-core' ),
										'value' => 'true',
									),
									array(
										'label' => esc_html__( 'False', 'eventchamp-core' ),
										'value' => 'false',
									),
								),
							),
							array(
								'type' => 'radio',
								'id' => 'fancybox-keyboard-control',
								'label' => esc_html__( 'Keyboard Control', 'eventchamp-core' ),
								'section' => 'extra',
								'std' => 'true',
								'choices' => array(
									array(
										'label' => esc_html__( 'True', 'eventchamp-core' ),
										'value' => 'true',
									),
									array(
										'label' => esc_html__( 'False', 'eventchamp-core' ),
										'value' => 'false',
									),
								),
							),
							array(
								'type' => 'radio',
								'id' => 'fancybox-infobar',
								'label' => esc_html__( 'Infobar', 'eventchamp-core' ),
								'section' => 'extra',
								'std' => 'true',
								'choices' => array(
									array(
										'label' => esc_html__( 'True', 'eventchamp-core' ),
										'value' => 'true',
									),
									array(
										'label' => esc_html__( 'False', 'eventchamp-core' ),
										'value' => 'false',
									),
								),
							),
							array(
								'type' => 'select',
								'id' => 'fancybox-animation-effect',
								'label' => esc_html__( 'Animation Effect', 'eventchamp-core' ),
								'section' => 'extra',
								'std' => 'fade',
								'choices' => array(
									array(
										'label' => esc_html__( 'False', 'eventchamp-core' ),
										'value' => 'false',
									),
									array(
										'label' => esc_html__( 'Zoom', 'eventchamp-core' ),
										'value' => 'zoom',
									),
									array(
										'label' => esc_html__( 'Fade', 'eventchamp-core' ),
										'value' => 'fade',
									),
									array(
										'label' => esc_html__( 'Zoom in Out', 'eventchamp-core' ),
										'value' => 'zoom-in-out',
									),
								),
							),
							array(
								'type' => 'numeric-slider',
								'id' => 'fancybox-animation-duration',
								'label' => esc_html__( 'Animation Duration', 'eventchamp-core' ),
								'section' => 'extra',
								'std' => '366',
								'min_max_step'=> '1,100000,1',
							),
							array(
								'type' => 'select',
								'id' => 'fancybox-transition-effect',
								'label' => esc_html__( 'Transition Effect', 'eventchamp-core' ),
								'section' => 'extra',
								'std' => 'fade',
								'choices' => array(
									array(
										'label' => esc_html__( 'False', 'eventchamp-core' ),
										'value' => 'false',
									),
									array(
										'label' => esc_html__( 'Fade', 'eventchamp-core' ),
										'value' => 'fade',
									),
									array(
										'label' => esc_html__( 'Slide', 'eventchamp-core' ),
										'value' => 'slide',
									),
									array(
										'label' => esc_html__( 'Circular', 'eventchamp-core' ),
										'value' => 'circular',
									),
									array(
										'label' => esc_html__( 'Tube', 'eventchamp-core' ),
										'value' => 'tube',
									),
									array(
										'label' => esc_html__( 'Zoom in Out', 'eventchamp-core' ),
										'value' => 'zoom-in-out',
									),
									array(
										'label' => esc_html__( 'Rotate', 'eventchamp-core' ),
										'value' => 'rotate',
									),
								),
							),
							array(
								'type' => 'numeric-slider',
								'id' => 'fancybox-transition-duration',
								'label' => esc_html__( 'Transition Duration', 'eventchamp-core' ),
								'section' => 'extra',
								'std' => '366',
								'min_max_step'=> '1,100000,1',
							),
							array(
								'type' => 'on-off',
								'id' => 'fancybox-zoom-button',
								'label' => esc_html__( 'Zoom Button', 'eventchamp-core' ),
								'section' => 'extra',
								'std' => 'on',
							),
							array(
								'type' => 'on-off',
								'id' => 'fancybox-social-sharing-button',
								'label' => esc_html__( 'Social Sharing Button', 'eventchamp-core' ),
								'section' => 'extra',
								'std' => 'on',
							),
							array(
								'type' => 'on-off',
								'id' => 'fancybox-slideshow-button',
								'label' => esc_html__( 'Slideshow Button', 'eventchamp-core' ),
								'section' => 'extra',
								'std' => 'on',
							),
							array(
								'type' => 'radio',
								'id' => 'fancybox-slideshow-auto-start',
								'label' => esc_html__( 'Slideshow Auto Start', 'eventchamp-core' ),
								'section' => 'extra',
								'std' => 'true',
								'choices' => array(
									array(
										'label' => esc_html__( 'True', 'eventchamp-core' ),
										'value' => 'true',
									),
									array(
										'label' => esc_html__( 'False', 'eventchamp-core' ),
										'value' => 'false',
									),
								),
							),
							array(
								'type' => 'numeric-slider',
								'id' => 'fancybox-slideshow-speed',
								'label' => esc_html__( 'Slideshow Speed', 'eventchamp-core' ),
								'section' => 'extra',
								'std' => '3000',
								'min_max_step'=> '1,100000,1',
							),
							array(
								'type' => 'on-off',
								'id' => 'fancybox-fullscreen-button',
								'label' => esc_html__( 'Fullscreen Button', 'eventchamp-core' ),
								'section' => 'extra',
								'std' => 'on',
							),
							array(
								'type' => 'on-off',
								'id' => 'fancybox-download-button',
								'label' => esc_html__( 'Download Button', 'eventchamp-core' ),
								'section' => 'extra',
								'std' => 'on',
							),
							array(
								'type' => 'on-off',
								'id' => 'fancybox-thumbs-button',
								'label' => esc_html__( 'Thumbs Button', 'eventchamp-core' ),
								'section' => 'extra',
								'std' => 'on',
							),
							array(
								'type' => 'radio',
								'id' => 'fancybox-thumbs-auto-start',
								'label' => esc_html__( 'Thumbs Auto Start', 'eventchamp-core' ),
								'section' => 'extra',
								'std' => 'true',
								'choices' => array(
									array(
										'label' => esc_html__( 'True', 'eventchamp-core' ),
										'value' => 'true',
									),
									array(
										'label' => esc_html__( 'False', 'eventchamp-core' ),
										'value' => 'false',
									),
								),
							),
							array(
								'type' => 'on-off',
								'id' => 'fancybox-close-button',
								'label' => esc_html__( 'Close Button', 'eventchamp-core' ),
								'section' => 'extra',
								'std' => 'on',
							),
						array(
							'type' => 'tab',
							'id' => 'extra-flex-menu',
							'label' => esc_html__( 'Flex Menu', 'eventchamp-core' ),
							'section' => 'extra',
						),
							array(
								'type' => 'on-off',
								'id' => 'flex-menu-categorized-events',
								'label' => esc_html__( 'Categorized Contents', 'eventchamp-core' ),
								'description' => esc_html__( 'For elements of the categorized events, speakers and venues.', 'eventchamp-core' ),
								'section' => 'extra',
								'std' => 'on',
							),
							array(
								'type' => 'on-off',
								'id' => 'flex-menu-single-events',
								'label' => esc_html__( 'Event Tabs', 'eventchamp-core' ),
								'section' => 'extra',
								'std' => 'on',
							),
							array(
								'type' => 'on-off',
								'id' => 'flex-menu-schedule',
								'label' => esc_html__( 'Event Schedules', 'eventchamp-core' ),
								'section' => 'extra',
								'std' => 'on',
							),
						array(
							'type' => 'tab',
							'id' => 'extra-post-type-taxonomies',
							'label' => esc_html__( 'Post Types & Taxonomies', 'eventchamp-core' ),
							'section' => 'extra',
						),
							array(
								'type' => 'list-item',
								'id' => 'custom-post-types',
								'label' => esc_html__( 'Custom Post Types', 'eventchamp-core' ),
								'section' => 'extra',
								'settings' => array(
									array(
										'type' => 'text',
										'id' => 'name',
										'label' => esc_html__( 'Post Type Name', 'eventchamp-core' ),
										'desc' => esc_html__( 'Example: Events', 'eventchamp-core' ),
									),
									array(
										'type' => 'text',
										'id' => 'singular-name',
										'label' => esc_html__( 'Post Type Singular Name', 'eventchamp-core' ),
										'desc' => esc_html__( 'Example: Event', 'eventchamp-core' ),
									),
									array(
										'type' => 'text',
										'id' => 'slug',
										'label' => esc_html__( 'Post Type Slug', 'eventchamp-core' ),
										'desc' => esc_html__( 'Use lowercase. Example: event', 'eventchamp-core' ),
									),
									array(
										'type' => 'text',
										'id' => 'description',
										'label' => esc_html__( 'Post Type Description', 'eventchamp-core' ),
									),
									array(
										'type' => 'text',
										'id' => 'position',
										'label' => esc_html__( 'Post Type Menu Position', 'eventchamp-core' ),
										'desc' => esc_html__( 'Example: 20', 'eventchamp-core' ),
									),
									array(
										'type' => 'text',
										'id' => 'icon',
										'label' => esc_html__( 'Post Type Icon', 'eventchamp-core' ),
										'desc' => esc_html__( 'Example: dashicons-calendar-alt. You can find the icon from this link: https://developer.wordpress.org/resource/dashicons/', 'eventchamp-core' ),
									),
								),
							),
							array(
								'type' => 'list-item',
								'id' => 'custom-taxonomies',
								'label' => esc_html__( 'Custom Taxonomies', 'eventchamp-core' ),
								'section' => 'extra',
								'settings' => array(
									array(
										'type' => 'select',
										'id' => 'post-type',
										'label' => esc_html__( 'Post Type', 'eventchamp-core' ),
										'choices' => eventchamp_get_post_types_settings(),
									),
									array(
										'type' => 'text',
										'id' => 'name',
										'label' => esc_html__( 'Taxonomy Name', 'eventchamp-core' ),
										'desc' => esc_html__( 'Example: Categories', 'eventchamp-core' ),
									),
									array(
										'type' => 'text',
										'id' => 'singular-name',
										'label' => esc_html__( 'Taxonomy Singular Name', 'eventchamp-core' ),
										'desc' => esc_html__( 'Example: Category', 'eventchamp-core' ),
									),
									array(
										'type' => 'text',
										'id' => 'slug',
										'label' => esc_html__( 'Taxonomy Slug', 'eventchamp-core' ),
										'desc' => esc_html__( 'Example: category', 'eventchamp-core' ),
									),
									array(
										'type' => 'text',
										'id' => 'description',
										'label' => esc_html__( 'Taxonomy Description', 'eventchamp-core' ),
									),
								),
							),
						array(
							'type' => 'tab',
							'id' => 'extra-loader',
							'label' => esc_html__( 'Loader', 'eventchamp-core' ),
							'section' => 'extra',
						),
							array(
								'type' => 'on-off',
								'id' => 'eventchamp_loader',
								'label' => esc_html__( 'Loader Status', 'eventchamp-core' ),
								'section' => 'extra',
								'std' => 'off',
							),
							array(
								'type' => 'select',
								'id' => 'loader_style',
								'label' => esc_html__( 'Loader Style', 'eventchamp-core' ),
								'section' => 'extra',
								'std' => 'style1',
								'choices' => array(
									array(
										'label' => esc_html__( 'Style 1', 'eventchamp-core' ),
										'value' => 'style1'
									),
									array(
										'label' => esc_html__( 'Style 2', 'eventchamp-core' ),
										'value' => 'style2'
									),
									array(
										'label' => esc_html__( 'Style 3', 'eventchamp-core' ),
										'value' => 'style3'
									),
									array(
										'label' => esc_html__( 'Style 4', 'eventchamp-core' ),
										'value' => 'style4'
									),
								),
							),
						array(
							'type' => 'tab',
							'id' => 'extra-password-protected',
							'label' => esc_html__( 'Password Protected', 'eventchamp-core' ),
							'section' => 'extra',
						),
							array(
								'type' => 'text',
								'id' => 'password-protected-title',
								'label' => esc_html__( 'Password Protected Title', 'eventchamp-core' ),
								'section' => 'extra',
							),
							array(
								'type' => 'text',
								'id' => 'password-protected-text',
								'label' => esc_html__( 'Password Protected Text', 'eventchamp-core' ),
								'section' => 'extra',
							),

					/*====== Social Media ======*/
						array(
							'type' => 'tab',
							'id' => 'social-media-links',
							'label' => esc_html__( 'Social Links', 'eventchamp-core' ),
							'section' => 'social-media',
						),
							array(
								'type' => 'list-item',
								'id' => 'social-links',
								'label' => esc_html__( 'Social Links', 'eventchamp-core' ),
								'section' => 'social-media',
								'settings' => array(
									array(
										'type' => 'select',
										'id' => 'icon',
										'label' => esc_html__( 'Icon', 'eventchamp-core' ),
										'choices' => eventchamp_social_media_sites_array(),
									),
									array(
										'type' => 'text',
										'id' => 'url',
										'label' => esc_html__( 'Link URL', 'eventchamp-core' ),
									),
									array(
										'type' => 'radio',
										'id' => 'target',
										'label' => esc_html__( 'Target', 'eventchamp-core' ),
										'std' => '_blank',
										'choices' => array(
											array(
												'label' => esc_html__( 'Blank', 'eventchamp-core' ),
												'value' => '_blank'
											),
											array(
												'label' => esc_html__( 'Self', 'eventchamp-core' ),
												'value' => '_self'
											),
										),
									),
								),
							),
						array(
							'type' => 'tab',
							'id' => 'social-media-sharing',
							'label' => esc_html__( 'Social Sharing', 'eventchamp-core' ),
							'section' => 'social-media',
						),
							array(
								'type' => 'on-off',
								'id' => 'social_share_facebook',
								'label' => esc_html__( 'Facebook', 'eventchamp-core' ),
								'section' => 'social-media',
								'std' => 'on',
							),
							array(
								'type' => 'on-off',
								'id' => 'social_share_twitter',
								'label' => esc_html__( 'Twitter', 'eventchamp-core' ),
								'section' => 'social-media',
								'std' => 'on',
							),
							array(
								'type' => 'on-off',
								'id' => 'social_share_googleplus',
								'label' => esc_html__( 'Google+', 'eventchamp-core' ),
								'section' => 'social-media',
								'std' => 'off',
							),
							array(
								'type' => 'on-off',
								'id' => 'social_share_linkedin',
								'label' => esc_html__( 'LinkedIn', 'eventchamp-core' ),
								'section' => 'social-media',
								'std' => 'on',
							),
							array(
								'type' => 'on-off',
								'id' => 'social_share_whatsapp',
								'label' => esc_html__( 'WhatsApp', 'eventchamp-core' ),
								'section' => 'social-media',
								'std' => 'on',
							),
							array(
								'type' => 'on-off',
								'id' => 'social_share_pinterest',
								'label' => esc_html__( 'Pinterest', 'eventchamp-core' ),
								'section' => 'social-media',
								'std' => 'off',
							),
							array(
								'type' => 'on-off',
								'id' => 'social_share_reddit',
								'label' => esc_html__( 'Reddit', 'eventchamp-core' ),
								'section' => 'social-media',
								'std' => 'off',
							),
							array(
								'type' => 'on-off',
								'id' => 'social_share_delicious',
								'label' => esc_html__( 'Delicious', 'eventchamp-core' ),
								'section' => 'social-media',
								'std' => 'off',
							),
							array(
								'label' => esc_html__( 'VKontakte', 'eventchamp-core' ),
								'id' => 'social_share_vk',
								'type' => 'on-off',
								'std' => 'off',
								'section' => 'social-media',
							),
							array(
								'label' => esc_html__( 'Tumblr', 'eventchamp-core' ),
								'id' => 'social_share_tumblr',
								'type' => 'on-off',
								'section' => 'social-media',
								'std' => 'off',
							),
							array(
								'label' => esc_html__( 'Email', 'eventchamp-core' ),
								'id' => 'social_share_email',
								'type' => 'on-off',
								'section' => 'social-media',
								'std' => 'on',
							),

					/*====== Custom Codes ======*/
						array(
							'type' => 'css',
							'id' => 'custom_css',
							'label' => esc_html__( 'Custom CSS Codes', 'eventchamp-core' ),
							'section' => 'customcodes',
						),
						array(
							'type' => 'javascript',
							'id' => 'custom_js',
							'label' => esc_html__( 'Custom JavaScript Codes', 'eventchamp-core' ),
							'section' => 'customcodes',
						),
				),
			);

			$custom_settings = apply_filters( ot_settings_id() . '_args', $custom_settings );

			if ( $saved_settings !== $custom_settings ) {

				update_option( ot_settings_id(), $custom_settings );

			}
			
			global $ot_has_eventchamp_theme_options;

			$ot_has_eventchamp_theme_options = true;

		}
		add_action( 'init', 'eventchamp_theme_options' );

	}

}