<?php

class MySettingsPage
{
    /**
     * Guarda o valor das nossas opções
     */
    private $options;

    /**
     * Iniciar plugin
     */
    public function __construct()
    {
        add_action( 'admin_menu', array( $this, 'add_plugin_page' ) );
        add_action( 'admin_init', array( $this, 'page_init' ) );
    }

    /**
     * Adicionar menu
     */
    public function add_plugin_page()
    {
        // This page will be under "Settings"
        add_menu_page(
            'Settings Admin', 
            'InterMap Settings', 
            'manage_options', 
            'my-setting-admin', 
            array( $this, 'create_admin_page' )
        );
    }

    /**
     * HTML do menu
     */
    public function create_admin_page()
    {
        // Pega as opção armazenadas
        $this->options = get_option( 'my_option_name' );
        ?>
        <div class="wrap">
            <h2>InterMap Settings</h2>           
            <form method="post" action="options.php">
                <?php
                // Imprime todos nossos settings
                settings_fields( 'my_option_group' );   
                do_settings_sections( 'my-setting-admin' );
                submit_button(); 
                ?>
            </form>
        </div>
        <?php
    }

    /**
     * Registrar e adicionar opções
     */
    public function page_init()
    {        
        register_setting(
            'my_option_group', // Option group
            'my_option_name', // Option name
            array( $this, 'sanitize' ) // Sanitize
        );

        add_settings_section(
            'setting_section_id', // ID
            'Página para edição das URLs Regionais', // Title
            array( $this, 'print_section_info' ), // Callback
            'my-setting-admin' // Page
        );  

        add_settings_field(
            'urlba', // ID
            'URL BA', // Title 
            array( $this, 'urlba_callback' ), // Callback
            'my-setting-admin', // Page
            'setting_section_id' // Section           
        );      

        add_settings_field(
            'urlrj', 
            'URL RJ', 
            array( $this, 'urlrj_callback' ), 
            'my-setting-admin', 
            'setting_section_id'
        );   

        add_settings_field(
            'urlsp', 
            'URL SP', 
            array( $this, 'urlsp_callback' ), 
            'my-setting-admin', 
            'setting_section_id'
        );  

        add_settings_field(
            'urlgo', 
            'URL GO', 
            array( $this, 'urlgo_callback' ), 
            'my-setting-admin', 
            'setting_section_id'
        );

        add_settings_field(
            'urlro', 
            'URL RO', 
            array( $this, 'urlro_callback' ), 
            'my-setting-admin', 
            'setting_section_id'
        );

        add_settings_field(
            'urlse', 
            'URL SE', 
            array( $this, 'urlse_callback' ), 
            'my-setting-admin', 
            'setting_section_id'
        );

        add_settings_field(
            'urlap', 
            'URL AP', 
            array( $this, 'urlap_callback' ), 
            'my-setting-admin', 
            'setting_section_id'
        );  

        add_settings_field(
            'urlpb', 
            'URL PB', 
            array( $this, 'urlpb_callback' ), 
            'my-setting-admin', 
            'setting_section_id'
        );

        add_settings_field(
            'urlmt', 
            'URL MT', 
            array( $this, 'urlmt_callback' ), 
            'my-setting-admin', 
            'setting_section_id'
        );

         add_settings_field(
            'urldf', 
            'URL DF', 
            array( $this, 'urldf_callback' ), 
            'my-setting-admin', 
            'setting_section_id'
        );

        add_settings_field(
            'urlrs', 
            'URL RS', 
            array( $this, 'urlrs_callback' ), 
            'my-setting-admin', 
            'setting_section_id'
        );

        add_settings_field(
            'urlce', 
            'URL CE', 
            array( $this, 'urlce_callback' ), 
            'my-setting-admin', 
            'setting_section_id'
        ); 

        add_settings_field(
            'urlmg', 
            'URL MG', 
            array( $this, 'urlmg_callback' ), 
            'my-setting-admin', 
            'setting_section_id'
        );

        add_settings_field(
            'urlpi', 
            'URL PI', 
            array( $this, 'urlpi_callback' ), 
            'my-setting-admin', 
            'setting_section_id'
        );

        add_settings_field(
            'urlrn', 
            'URL RN', 
            array( $this, 'urlrn_callback' ), 
            'my-setting-admin', 
            'setting_section_id'
        );  

        add_settings_field(
            'urlma', 
            'URL MA', 
            array( $this, 'urlma_callback' ), 
            'my-setting-admin', 
            'setting_section_id'
        );

        add_settings_field(
            'urlpa', 
            'URL PA', 
            array( $this, 'urlpa_callback' ), 
            'my-setting-admin', 
            'setting_section_id'
        );

        add_settings_field(
            'urlpe', 
            'URL PE', 
            array( $this, 'urlpe_callback' ), 
            'my-setting-admin', 
            'setting_section_id'
        );      
    }

    /**
     * Sanitizar cada opção conforme necessário
     *
     * @param array $input Contém todas nossas opções como chaves da array (array keys)
     */
    public function sanitize( $input )
    {
        $new_input = array();
        if( isset( $input['urlba'] ) )
            $new_input['urlba'] = sanitize_url( $input['urlba'] );

        if( isset( $input['urlrj'] ) )
            $new_input['urlrj'] = sanitize_text_field( $input['urlrj'] );

        if( isset( $input['urlsp'] ) )
            $new_input['urlsp'] = sanitize_text_field( $input['urlsp'] );

        if( isset( $input['urlgo'] ) )
            $new_input['urlgo'] = sanitize_text_field( $input['urlgo'] );

        if( isset( $input['urlro'] ) )
            $new_input['urlro'] = sanitize_text_field( $input['urlro'] );

        if( isset( $input['urlse'] ) )
            $new_input['urlse'] = sanitize_text_field( $input['urlse'] );

        if( isset( $input['urlap'] ) )
            $new_input['urlap'] = sanitize_text_field( $input['urlap'] );

        if( isset( $input['urlpb'] ) )
            $new_input['urlpb'] = sanitize_text_field( $input['urlpb'] );

        if( isset( $input['urlmt'] ) )
            $new_input['urlmt'] = sanitize_text_field( $input['urlmt'] );

        if( isset( $input['urldf'] ) )
            $new_input['urldf'] = sanitize_text_field( $input['urldf'] );

        if( isset( $input['urlrs'] ) )
            $new_input['urlrs'] = sanitize_text_field( $input['urlrs'] );

        if( isset( $input['urlce'] ) )
            $new_input['urlce'] = sanitize_text_field( $input['urlce'] );

        if( isset( $input['urlmg'] ) )
            $new_input['urlmg'] = sanitize_text_field( $input['urlmg'] );

        if( isset( $input['urlpi'] ) )
            $new_input['urlpi'] = sanitize_text_field( $input['urlpi'] );

        if( isset( $input['urlrn'] ) )
            $new_input['urlrn'] = sanitize_text_field( $input['urlrn'] );

        if( isset( $input['urlma'] ) )
            $new_input['urlma'] = sanitize_text_field( $input['urlma'] );

        if( isset( $input['urlpa'] ) )
            $new_input['urlpa'] = sanitize_text_field( $input['urlpa'] );

        if( isset( $input['urlpe'] ) )
            $new_input['urlpe'] = sanitize_text_field( $input['urlpe'] );

        return $new_input;
    }

    /** 
     * Imprimir o texto Section
     */
    public function print_section_info()
    {
        print 'Insira as devidas URLs:';
    }

    /** 
     * Imprime a opção "urlba"
     */
    public function urlba_callback()
    {
        printf(
            '<input type="text" id="urlba" name="my_option_name[urlba]" value="%s" />',
            isset( $this->options['urlba'] ) ? esc_attr( $this->options['urlba']) : ''
        );
    }

    /** 
     * Imprime a opção "urlrj"
     */
    public function urlrj_callback()
    {
        printf(
            '<input type="text" id="urlrj" name="my_option_name[urlrj]" value="%s" />',
            isset( $this->options['urlrj'] ) ? esc_attr( $this->options['urlrj']) : ''
        );
    }

    /** 
     * Imprime a opção "urlsp"
     */
    public function urlsp_callback()
    {
        printf(
            '<input type="text" id="urlsp" name="my_option_name[urlsp]" value="%s" />',
            isset( $this->options['urlsp'] ) ? esc_attr( $this->options['urlsp']) : ''
        );
    }

    /** 
     * Imprime a opção "urlgo"
     */
    public function urlgo_callback()
    {
        printf(
            '<input type="text" id="urlgo" name="my_option_name[urlgo]" value="%s" />',
            isset( $this->options['urlgo'] ) ? esc_attr( $this->options['urlgo']) : ''
        );
    }

    /** 
     * Imprime a opção "urlro"
     */
    public function urlro_callback()
    {
        printf(
            '<input type="text" id="urlro" name="my_option_name[urlro]" value="%s" />',
            isset( $this->options['urlro'] ) ? esc_attr( $this->options['urlro']) : ''
        );
    }

     /** 
     * Imprime a opção "urlse"
     */
    public function urlse_callback()
    {
        printf(
            '<input type="text" id="urlse" name="my_option_name[urlse]" value="%s" />',
            isset( $this->options['urlse'] ) ? esc_attr( $this->options['urlse']) : ''
        );
    }

     /** 
     * Imprime a opção "urlap"
     */
    public function urlap_callback()
    {
        printf(
            '<input type="text" id="urlap" name="my_option_name[urlap]" value="%s" />',
            isset( $this->options['urlap'] ) ? esc_attr( $this->options['urlap']) : ''
        );
    }

    /** 
     * Imprime a opção "urlpb"
     */
    public function urlpb_callback()
    {
        printf(
            '<input type="text" id="urlpb" name="my_option_name[urlpb]" value="%s" />',
            isset( $this->options['urlpb'] ) ? esc_attr( $this->options['urlpb']) : ''
        );
    }

    /** 
     * Imprime a opção "urlmt"
     */
    public function urlmt_callback()
    {
        printf(
            '<input type="text" id="urlmt" name="my_option_name[urlmt]" value="%s" />',
            isset( $this->options['urlmt'] ) ? esc_attr( $this->options['urlmt']) : ''
        );
    }

    /** 
     * Imprime a opção "urldf"
     */
    public function urldf_callback()
    {
        printf(
            '<input type="text" id="urldf" name="my_option_name[urldf]" value="%s" />',
            isset( $this->options['urldf'] ) ? esc_attr( $this->options['urldf']) : ''
        );
    }

    /** 
     * Imprime a opção "urlrs"
     */
    public function urlrs_callback()
    {
        printf(
            '<input type="text" id="urlrs" name="my_option_name[urlrs]" value="%s" />',
            isset( $this->options['urlrs'] ) ? esc_attr( $this->options['urlrs']) : ''
        );
    }

    /** 
     * Imprime a opção "urlce"
     */
    public function urlce_callback()
    {
        printf(
            '<input type="text" id="urlce" name="my_option_name[urlce]" value="%s" />',
            isset( $this->options['urlce'] ) ? esc_attr( $this->options['urlce']) : ''
        );
    }

    /** 
     * Imprime a opção "urlmg"
     */
    public function urlmg_callback()
    {
        printf(
            '<input type="text" id="urlmg" name="my_option_name[urlmg]" value="%s" />',
            isset( $this->options['urlmg'] ) ? esc_attr( $this->options['urlmg']) : ''
        );
    }

     /** 
     * Imprime a opção "urlpi"
     */
    public function urlpi_callback()
    {
        printf(
            '<input type="text" id="urlpi" name="my_option_name[urlpi]" value="%s" />',
            isset( $this->options['urlpi'] ) ? esc_attr( $this->options['urlpi']) : ''
        );
    }

    /** 
     * Imprime a opção "urlrn"
     */
    public function urlrn_callback()
    {
        printf(
            '<input type="text" id="urlrn" name="my_option_name[urlrn]" value="%s" />',
            isset( $this->options['urlrn'] ) ? esc_attr( $this->options['urlrn']) : ''
        );
    }

    /** 
     * Imprime a opção "urlma"
     */
    public function urlma_callback()
    {
        printf(
            '<input type="text" id="urlma" name="my_option_name[urlma]" value="%s" />',
            isset( $this->options['urlma'] ) ? esc_attr( $this->options['urlma']) : ''
        );
    }

    /** 
     * Imprime a opção "urlpa"
     */
    public function urlpa_callback()
    {
        printf(
            '<input type="text" id="urlpa" name="my_option_name[urlpa]" value="%s" />',
            isset( $this->options['urlpa'] ) ? esc_attr( $this->options['urlpa']) : ''
        );
    }

    /** 
     * Imprime a opção "urlpe"
     */
    public function urlpe_callback()
    {
        printf(
            '<input type="text" id="urlpe" name="my_option_name[urlpe]" value="%s" />',
            isset( $this->options['urlpe'] ) ? esc_attr( $this->options['urlpe']) : ''
        );
    }


}




// Executar somente se estivermos na área administrativa (is_admin)
if( is_admin() )
    $my_settings_page = new MySettingsPage();